/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuJoyList;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuResolutionList;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTextField;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Witchaven.Factory.WHMenuHandler;
import ru.m210projects.Witchaven.Fonts.MenuFont;
import ru.m210projects.Witchaven.Menu.MenuInterfaceSet;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Screens.MenuScreen;
import ru.m210projects.Witchaven.WHSND;

public class WH2MenuHandler
extends WHMenuHandler {
    public WH2MenuHandler(BuildGame app) {
        super(app);
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.getScreen() instanceof MenuScreen || this.app.pMenu.getCurrentMenu() instanceof MenuRendererSettings || this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            int tile = 500;
            float kv = (float)Engine.tilesizx[tile] / (float)Engine.tilesizy[tile];
            float kt = (float)Engine.xdim / (float)Engine.ydim;
            float scale = kv >= kt ? (float)(Engine.ydim + 1) / (float)Engine.tilesizy[tile] : (float)(Engine.xdim + 1) / (float)Engine.tilesizx[tile];
            this.engine.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 0, 25, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        if (this.mMenuHistory[0] != null) {
            MenuItem item = this.mMenuHistory[0].m_pItems[this.mMenuHistory[0].m_nFocus];
            if (item instanceof MenuButton) {
                if (item.align == 1) {
                    int scale = 32768;
                    int py = item.y;
                    int yoff = 5;
                    int posx = 160;
                    this.engine.rotatesprite(posx << 16, py + yoff << 16, scale, 0, 9336, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else {
                    int scale = 8192;
                    int px = item.x;
                    int py = item.y;
                    int xoff = -10;
                    int yoff = 3;
                    this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, Names.HELMET, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
            } else if (item instanceof MenuSwitch || item instanceof MenuSlider || item instanceof MenuConteiner || item instanceof MenuTextField) {
                int scale = 8192;
                int px = item.x;
                int py = item.y;
                int xoff = -10;
                int yoff = 3;
                this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, Names.HELMET, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            } else if (item instanceof MenuVariants) {
                int scale = 16384;
                int px = item.x;
                int py = item.y;
                int xoff = 0;
                int yoff = 16;
                this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, Names.HELMET, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            } else if (item instanceof MenuList) {
                if (item instanceof MenuJoyList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (list.l_nMin < this.app.pCfg.joymap.length && focus >= this.app.pCfg.joymap.length) {
                        ++focus;
                    }
                    if (focus != -1 && focus >= list.l_nMin && focus < list.l_nMin + list.nListItems) {
                        int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                        int scale = 8192;
                        int xoff = -11;
                        int yoff = 2;
                        this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, Names.HELMET, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    }
                } else if (item instanceof MenuKeyboardList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus != -1 && focus >= list.l_nMin && focus < list.l_nMin + list.nListItems) {
                        int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                        int scale = 8192;
                        int xoff = -11;
                        int yoff = 2;
                        this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, Names.HELMET, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    }
                } else if (item instanceof MenuResolutionList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus != -1 && focus >= list.l_nMin && focus < list.l_nMin + list.nListItems) {
                        int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                        int scale = 8192;
                        int xoff = 0;
                        int yoff = 2;
                        this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, Names.HELMET, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    }
                }
            }
        }
        this.mMenuDraw();
    }

    @Override
    public int getShade(MenuItem item) {
        if (item != null && item.getClass().getSuperclass().equals(MenuSlider.class) && !item.isEnabled()) {
            return -127;
        }
        if (item != null && item.isFocused()) {
            return 16 - (Engine.totalclock & 0x3F);
        }
        return 0;
    }

    @Override
    public int getPal(BuildFont font, MenuItem item) {
        if (item != null) {
            if (item.isFocused()) {
                if (item instanceof MenuButton && item.align == 1) {
                    if (!item.isEnabled()) {
                        return 6;
                    }
                    return 8;
                }
                return 7;
            }
            if (!item.isEnabled()) {
                return 6;
            }
            if (font != null && font.getClass().equals(MenuFont.class)) {
                return item.pal;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(65536L, Engine.ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.gMouseCursorSize, 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        this.engine.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        if (this.mCount > 1) {
            int shade = 4 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
            this.engine.rotatesprite(0, Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, Engine.tilesizx[9216] - 1, 16), Engine.ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        int size = Pragmas.mulscale(Engine.tilesizx[9216], zoom, 16);
        int bx = 0;
        int by = Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16);
        return mx >= bx && mx < bx + size && my >= by && my < by + size;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case UP: 
            case DW: 
            case LEFT: 
            case RIGHT: 
            case ENTER: 
            case MCHANGE: 
            case Open: 
            case Close: {
                WHSND.SND_Sound(59);
                break;
            }
        }
    }

    @Override
    public void mPostDraw(MenuItem item) {
    }
}

