/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AIBAT {
    public static AISTATE batSleep;
    public static AISTATE batIdle;
    public static AISTATE batSearch;
    public static AISTATE batChase;
    public static AISTATE batTurn;
    public static AISTATE batUp;
    public static AISTATE batDown;
    public static AISTATE batRecoil;
    public static AISTATE batGoto;
    public static AISTATE batBite;
    public static AISTATE batThinkMove;
    public static AISTATE batThinkIdle;
    public static AISTATE batDodgeUp;
    public static AISTATE batDodgeDown;

    public static void Init() {
        batSleep = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myThinkTarget(sprite, xsprite);
            }
        };
        batIdle = new AISTATE(AISTATEFUNC.Type.idle, 6, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myThinkTarget(sprite, xsprite);
            }
        };
        batChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, batIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.thinkChase(sprite, xsprite);
            }
        };
        batThinkMove = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.thinkMove(sprite, xsprite);
            }
        };
        batGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 6, null, 600, false, true, true, batIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.thinkGoto(sprite, xsprite);
            }
        };
        batBite = new AISTATE(AISTATEFUNC.Type.attack, 7, new CALLPROC(){

            @Override
            public void run(int i) {
                AIBAT.BiteCallback(i);
            }
        }, 60, false, false, false, batThinkMove);
        batRecoil = new AISTATE(AISTATEFUNC.Type.recoil, 5, null, 0, false, false, false, batChase);
        batSearch = new AISTATE(AISTATEFUNC.Type.search, 6, null, 120, false, true, true, batIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.thinkSearch(sprite, xsprite);
            }
        };
        batUp = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, batChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myMoveUp(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.thinkChase(sprite, xsprite);
            }
        };
        batDown = new AISTATE(AISTATEFUNC.Type.other, 6, null, 60, false, true, true, batChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myMoveDown(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.thinkChase(sprite, xsprite);
            }
        };
        batTurn = new AISTATE(AISTATEFUNC.Type.other, 6, null, 60, false, true, false, batChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }
        };
        batThinkIdle = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.thinkIdle(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myMoveForward(sprite, xsprite);
            }
        };
        batDodgeUp = new AISTATE(AISTATEFUNC.Type.other, 6, null, 120, false, true, false, batChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myDodgeUp(sprite, xsprite);
            }
        };
        batDodgeDown = new AISTATE(AISTATEFUNC.Type.other, 6, null, 120, false, true, false, batChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBAT.myDodgeDown(sprite, xsprite);
            }
        };
    }

    private static void BiteCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        if (pXSprite.target < 0 || pXSprite.target >= Globals.kMaxSprites) {
            Main.game.dassert("pXSprite.target >= 0 && pXSprite.target < kMaxSprites");
        }
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        int eyeAboveZ = DudeInfo.dudeInfo[pSprite.lotag - 200].eyeHeight * pSprite.yrepeat << 2;
        int z1 = 0;
        if (pXSprite.target != -1 && Actor.IsDudeSprite(pTarget)) {
            z1 = DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight * pTarget.yrepeat << 2;
        }
        int dz = z1 - eyeAboveZ;
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 6);
    }

    private static void thinkIdle(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.z - pXSprite.targetZ >= 4096) {
            Ai.aiSetTarget(pXSprite, pSprite.x, pSprite.y, Engine.sector[pSprite.sectnum].ceilingz);
        } else {
            Ai.aiActive[pSprite.xvel] = 0;
            pSprite.hitag = 0;
            Ai.aiNewState(pSprite, pXSprite, batSleep);
        }
    }

    private static void myThinkTarget(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (Ai.aiActive[pSprite.xvel] != 0) {
            if (Ai.aiThinkTime[pSprite.xvel] >= 10) {
                Ai.aiThinkTime[pSprite.xvel] = 0;
                pXSprite.goalAng += 256;
                Vector3 kSprite = Trigger.ksprite[pSprite.xvel];
                Ai.aiSetTarget(pXSprite, (int)kSprite.x, (int)kSprite.y, (int)kSprite.z);
                Ai.aiNewState(pSprite, pXSprite, batTurn);
                return;
            }
            short s = pSprite.xvel;
            Ai.aiThinkTime[s] = Ai.aiThinkTime[s] + 1;
        }
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pPlayer.pXsprite.health != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int eyeAboveZ;
                int x = pPlayer.pSprite.x;
                int y = pPlayer.pSprite.y;
                int z = pPlayer.pSprite.z;
                short nSector = pPlayer.pSprite.sectnum;
                int dx = x - pSprite.x;
                int dy = y - pSprite.y;
                int dist = (int)Main.engine.qdist(dx, dy);
                if ((dist <= pDudeInfo.seeDist || dist <= pDudeInfo.hearDist) && Main.engine.cansee(x, y, z, nSector, pSprite.x, pSprite.y, pSprite.z - (eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2), pSprite.sectnum)) {
                    short nAngle = Main.engine.getangle(dx, dy);
                    int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
                    if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                        Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                    if (dist < pDudeInfo.hearDist) {
                        Ai.aiSetTarget(pXSprite, x, y, z);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    private static void myMoveForward(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.target == -1) {
            pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (Gameutils.Random(64) >= 32 || Main.engine.qdist(dx, dy) > 512L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            vel = pXSprite.target == -1 ? (vel += (long)fvel) : (vel += (long)(fvel >> 1));
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
        }
    }

    private static void myMoveUp(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            pSprite.ang = (short)(pSprite.ang + 512 & 0x7FF);
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(8192) || Main.engine.qdist(dx, dy) > 512L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
            Actor.sprZVel[pSprite.xvel] = -185685L;
        }
    }

    private static void myMoveDown(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            pXSprite.goalAng = (short)(pSprite.ang + 512 & 0x7FF);
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(768) || Main.engine.qdist(dx, dy) > 512L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
            Actor.sprZVel[pSprite.xvel] = 279620L;
        }
    }

    public static void myDodgeUp(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        long sin = Trig.Sin(pSprite.ang);
        long cos = Trig.Cos(pSprite.ang);
        long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
        long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
        svel = pXSprite.dodgeDir > 0 ? (svel += (long)pDudeInfo.sideSpeed) : (svel -= (long)pDudeInfo.sideSpeed);
        Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
        Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
        Actor.sprZVel[pSprite.xvel] = -338602L;
    }

    public static void myDodgeDown(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (pXSprite.dodgeDir == 0) {
            return;
        }
        long sin = Trig.Sin(pSprite.ang);
        long cos = Trig.Cos(pSprite.ang);
        long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
        long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
        svel = pXSprite.dodgeDir > 0 ? (svel += (long)pDudeInfo.sideSpeed) : (svel -= (long)pDudeInfo.sideSpeed);
        Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
        Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
        Actor.sprZVel[pSprite.xvel] = 279620L;
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        AIBAT.myThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
        }
        AIBAT.myThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, batGoto);
            return;
        }
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (pXSprite.target < 0 || pXSprite.target >= Globals.kMaxSprites) {
            Main.game.dassert("pXSprite.target >= 0 && pXSprite.target < kMaxSprites");
        }
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            Gameutils.GetSpriteExtents(pSprite);
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum)) {
                if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.target);
                    int floorz = Main.engine.getflorzofslope(pSprite.sectnum, pSprite.x, pSprite.y);
                    if (Pragmas.klabs(losAngle) < 85) {
                        int targetZ = pDudeInfo.eyeHeight * pTarget.yrepeat << 2;
                        if (targetZ - eyeAboveZ < 8192 && dist < 512) {
                            Ai.aiNewState(pSprite, pXSprite, batBite);
                            return;
                        }
                        if ((targetZ - eyeAboveZ > 20480 || floorz - Gameutils.extents_zBot > 20480) && dist < 5120 && dist > 2048) {
                            Ai.aiNewState(pSprite, pXSprite, batDown);
                            return;
                        }
                        if (targetZ - eyeAboveZ < 12288 || floorz - Gameutils.extents_zBot < 12288) {
                            Ai.aiNewState(pSprite, pXSprite, batUp);
                            return;
                        }
                    }
                    return;
                }
            } else {
                Ai.aiNewState(pSprite, pXSprite, batUp);
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, batThinkIdle);
        pXSprite.target = -1;
    }

    private static void thinkMove(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (pXSprite.target < 0 || pXSprite.target >= Globals.kMaxSprites) {
            Main.game.dassert("pXSprite.target >= 0 && pXSprite.target < kMaxSprites");
        }
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            int dz = (pDudeInfo.eyeHeight * pTarget.yrepeat << 2) - eyeAboveZ;
            Gameutils.GetSpriteExtents(pSprite);
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum)) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                if (Pragmas.klabs(losAngle) < 85) {
                    if (dist < 5120 && dist > 2048) {
                        if (dz < 8192) {
                            Ai.aiNewState(pSprite, pXSprite, batDodgeUp);
                            return;
                        }
                        if (dz > 24576) {
                            Ai.aiNewState(pSprite, pXSprite, batDodgeDown);
                            return;
                        }
                    }
                    if (dist < 6144 && dist > 3072) {
                        if (dz < 12288) {
                            Ai.aiNewState(pSprite, pXSprite, batDodgeUp);
                            return;
                        }
                        if (dz > 20480) {
                            Ai.aiNewState(pSprite, pXSprite, batDodgeDown);
                            return;
                        }
                    }
                    if ((dist < 512 || dist > 5120) && dz < 8192) {
                        Ai.aiNewState(pSprite, pXSprite, batDodgeUp);
                        return;
                    }
                }
                if (dz <= 16384) {
                    Ai.aiNewState(pSprite, pXSprite, batDodgeUp);
                } else {
                    Ai.aiNewState(pSprite, pXSprite, batDodgeDown);
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, batGoto);
        pXSprite.target = -1;
    }
}

