/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.WeaponAim;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AICERBERUS {
    public static final int C1 = 0;
    public static final int C2 = 1;
    public static AISTATE[] cerberusIdle = new AISTATE[2];
    public static AISTATE[] cerberusSearch = new AISTATE[2];
    public static AISTATE[] cerberusTurn = new AISTATE[2];
    public static AISTATE[] cerberusGoto = new AISTATE[2];
    public static AISTATE[] cerberusChase = new AISTATE[2];
    public static AISTATE[] cerberusBurn = new AISTATE[2];
    public static AISTATE[] cerberusFire = new AISTATE[2];
    public static AISTATE[] cerberusHack = new AISTATE[2];
    public static AISTATE[] cerberusRecoil = new AISTATE[2];
    public static AISTATE cerberusRTesla;
    private static WeaponAim gFireData;

    static {
        gFireData = new WeaponAim(65536, 65536, 256, 85, 0x1AAAAA);
    }

    public static void Init() {
        int i = 0;
        while (i <= 1) {
            AICERBERUS.cerberusIdle[i] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

                @Override
                public void think(SPRITE sprite, XSPRITE xsprite) {
                    AICERBERUS.myThinkTarget(sprite, xsprite);
                }
            };
            ++i;
        }
        i = 0;
        while (i <= 1) {
            AICERBERUS.cerberusSearch[i] = new AISTATE(AISTATEFUNC.Type.search, 7, null, 1800, false, true, true, cerberusIdle[i]){

                @Override
                public void move(SPRITE sprite, XSPRITE xsprite) {
                    Ai.aiMoveForward(sprite, xsprite);
                }

                @Override
                public void think(SPRITE sprite, XSPRITE xsprite) {
                    AICERBERUS.thinkSearch(sprite, xsprite);
                }
            };
            ++i;
        }
        i = 0;
        while (i <= 1) {
            AICERBERUS.cerberusChase[i] = new AISTATE(AISTATEFUNC.Type.other, 7, null, 0, false, true, true, null){

                @Override
                public void move(SPRITE sprite, XSPRITE xsprite) {
                    Ai.aiMoveForward(sprite, xsprite);
                }

                @Override
                public void think(SPRITE sprite, XSPRITE xsprite) {
                    AICERBERUS.thinkChase(sprite, xsprite);
                }
            };
            ++i;
        }
        i = 0;
        while (i <= 1) {
            AICERBERUS.cerberusRecoil[i] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, true, true, cerberusSearch[i]);
            ++i;
        }
        cerberusRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, true, true, cerberusSearch[0]);
        i = 0;
        while (i <= 1) {
            AICERBERUS.cerberusGoto[i] = new AISTATE(AISTATEFUNC.Type.tgoto, 7, null, 600, false, true, true, cerberusIdle[i]){

                @Override
                public void move(SPRITE sprite, XSPRITE xsprite) {
                    Ai.aiMoveForward(sprite, xsprite);
                }

                @Override
                public void think(SPRITE sprite, XSPRITE xsprite) {
                    AICERBERUS.thinkGoto(sprite, xsprite);
                }
            };
            ++i;
        }
        i = 0;
        while (i <= 1) {
            AICERBERUS.cerberusHack[i] = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

                @Override
                public void run(int nXSprite) {
                    AICERBERUS.BiteCallback(nXSprite);
                }
            }, 60, false, false, false, cerberusChase[i]);
            ++i;
        }
        i = 0;
        while (i <= 1) {
            AICERBERUS.cerberusFire[i] = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

                @Override
                public void run(int nXSprite) {
                    AICERBERUS.FireCallback(nXSprite);
                }
            }, 60, false, false, false, cerberusChase[i]);
            ++i;
        }
        i = 0;
        while (i <= 1) {
            AICERBERUS.cerberusBurn[i] = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

                @Override
                public void run(int nXSprite) {
                    AICERBERUS.BurnCallback(nXSprite);
                }
            }, 60, false, false, false, cerberusChase[i]);
            ++i;
        }
        i = 0;
        while (i <= 1) {
            AICERBERUS.cerberusTurn[i] = new AISTATE(AISTATEFUNC.Type.other, 7, null, 120, false, true, false, cerberusChase[i]){

                @Override
                public void move(SPRITE sprite, XSPRITE xsprite) {
                    Ai.aiMoveTurn(sprite, xsprite);
                }
            };
            ++i;
        }
    }

    private static void BurnCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat;
        int x = pSprite.x;
        int y = pSprite.y;
        int ax = Trig.Cos(pSprite.ang) >> 16;
        int ay = Trig.Sin(pSprite.ang) >> 16;
        int az = Ai.gDudeSlope[nXIndex];
        int aox = ax;
        int aoy = ay;
        int closest = Integer.MAX_VALUE;
        short nDude = Engine.headspritestat[6];
        while (nDude >= 0) {
            SPRITE pDude = Engine.sprite[nDude];
            if (pDude != pSprite && (pDude.hitag & 8) != 0) {
                int tx = pDude.x;
                int ty = pDude.y;
                int tz = pDude.z;
                int dist = (int)Main.engine.qdist(tx - x, ty - y);
                if (dist != 0 && dist <= 10240) {
                    short ang;
                    int dy;
                    int dx;
                    int dist2;
                    if (AICERBERUS.gFireData.kSeeker != 0) {
                        int k = (dist << 12) / AICERBERUS.gFireData.kSeeker;
                        tx = (int)((long)tx + ((long)k * Actor.sprXVel[nDude] >> 12));
                        ty = (int)((long)ty + ((long)k * Actor.sprYVel[nDude] >> 12));
                        tz = (int)((long)tz + ((long)k * Actor.sprZVel[nDude] >> 8));
                    }
                    int z1 = Pragmas.mulscale(dist, Ai.gDudeSlope[nXIndex], 10) + eyeAboveZ;
                    int z2 = Pragmas.mulscale(9460L, dist, 10);
                    Gameutils.GetSpriteExtents(pDude);
                    if (z1 - z2 <= Gameutils.extents_zBot && z1 + z2 >= Gameutils.extents_zTop && (dist2 = Main.engine.ksqrt(((dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.ang), 30) + x) - tx >> 4) * (dx - tx >> 4) + ((dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.ang), 30) + y) - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) < closest && Pragmas.klabs(((ang = Main.engine.getangle(tx - x, ty - y)) - pSprite.ang + 1024 & 0x7FF) - 1024) <= AICERBERUS.gFireData.kDudeAngle) {
                        int dz = tz - (DudeInfo.dudeInfo[pDude.lotag - 200].aimHeight * pDude.yrepeat << 2) - eyeAboveZ;
                        if (Main.engine.cansee(x, y, eyeAboveZ, pSprite.sectnum, tx, ty, tz, pDude.sectnum)) {
                            closest = dist2;
                            ax = Trig.Cos(ang) >> 16;
                            ay = Trig.Sin(ang) >> 16;
                            az = Pragmas.divscale(dz, dist, 10);
                        } else {
                            az = dz;
                        }
                    }
                }
            }
            nDude = Engine.nextspritestat[nDude];
        }
        if (pSprite.lotag == 227) {
            Actor.actFireMissile(pSprite, 350, -100, ax, ay, -az, 308);
            Actor.actFireMissile(pSprite, -350, 0, aox, aoy, 0, 308);
        } else {
            Actor.actFireMissile(pSprite, 350, -100, ax, ay, -az, 308);
        }
    }

    private static void FireCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat;
        int x = pSprite.x;
        int y = pSprite.y;
        int ax = Trig.Cos(pSprite.ang) >> 16;
        int ay = Trig.Sin(pSprite.ang) >> 16;
        int az = Ai.gDudeSlope[nXIndex];
        int closest = Integer.MAX_VALUE;
        short nDude = Engine.headspritestat[6];
        while (nDude >= 0) {
            SPRITE pDude = Engine.sprite[nDude];
            if (pDude != pSprite && (pDude.hitag & 8) != 0) {
                int tx = pDude.x;
                int ty = pDude.y;
                int tz = pDude.z;
                int dist = (int)Main.engine.qdist(tx - x, ty - y);
                if (dist != 0 && dist <= 10240) {
                    short ang;
                    int dy;
                    int dx;
                    int dist2;
                    if (AICERBERUS.gFireData.kSeeker != 0) {
                        int k = (dist << 12) / AICERBERUS.gFireData.kSeeker;
                        tx = (int)((long)tx + ((long)k * Actor.sprXVel[nDude] >> 12));
                        ty = (int)((long)ty + ((long)k * Actor.sprYVel[nDude] >> 12));
                        tz = (int)((long)tz + ((long)k * Actor.sprZVel[nDude] >> 8));
                    }
                    int z1 = Pragmas.mulscale(dist, Ai.gDudeSlope[nXIndex], 10) + eyeAboveZ;
                    int z2 = Pragmas.mulscale(9460L, dist, 10);
                    Gameutils.GetSpriteExtents(pDude);
                    if (z1 - z2 <= Gameutils.extents_zBot && z1 + z2 >= Gameutils.extents_zTop && (dist2 = Main.engine.ksqrt(((dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.ang), 30) + x) - tx >> 4) * (dx - tx >> 4) + ((dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.ang), 30) + y) - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) < closest && Pragmas.klabs(((ang = Main.engine.getangle(tx - x, ty - y)) - pSprite.ang + 1024 & 0x7FF) - 1024) <= AICERBERUS.gFireData.kDudeAngle) {
                        int dz = pDude.z - pSprite.z;
                        if (Main.engine.cansee(x, y, eyeAboveZ, pSprite.sectnum, tx, ty, tz, pDude.sectnum)) {
                            closest = dist2;
                            ax = Trig.Cos(ang) >> 16;
                            ay = Trig.Sin(ang) >> 16;
                            az = Pragmas.divscale(dz, dist, 10);
                        } else {
                            az = dz;
                        }
                    }
                }
            }
            nDude = Engine.nextspritestat[nDude];
        }
        if (pSprite.lotag == 227) {
            Actor.actFireMissile(pSprite, -350, 0, ax, ay, az, 313);
            Actor.actFireMissile(pSprite, 350, -100, ax, ay, az, 313);
        } else {
            Actor.actFireMissile(pSprite, 350, -100, ax, ay, az, 313);
        }
    }

    private static void BiteCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        int dz = pTarget.z - pSprite.z;
        Actor.actFireVector(pSprite, 350, -100, dx, dy, dz, 14);
        Actor.actFireVector(pSprite, -350, 0, dx, dy, dz, 14);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 14);
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void myThinkTarget(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (Ai.aiActive[pSprite.xvel] != 0) {
            if (Ai.aiThinkTime[pSprite.xvel] >= 10) {
                pXSprite.goalAng += 256;
                Vector3 kSprite = Trigger.ksprite[pSprite.xvel];
                Ai.aiSetTarget(pXSprite, (int)kSprite.x, (int)kSprite.y, (int)kSprite.z);
                if (pSprite.lotag == 227) {
                    Ai.aiNewState(pSprite, pXSprite, cerberusTurn[0]);
                } else {
                    Ai.aiNewState(pSprite, pXSprite, cerberusTurn[1]);
                }
                return;
            }
            short s = pSprite.xvel;
            Ai.aiThinkTime[s] = Ai.aiThinkTime[s] + 1;
        }
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pPlayer.pXsprite.health != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int eyeAboveZ;
                int x = pPlayer.pSprite.x;
                int y = pPlayer.pSprite.y;
                int z = pPlayer.pSprite.z;
                short nSector = pPlayer.pSprite.sectnum;
                int dx = x - pSprite.x;
                int dy = y - pSprite.y;
                int dist = (int)Main.engine.qdist(dx, dy);
                if ((dist <= pDudeInfo.seeDist || dist <= pDudeInfo.hearDist) && Main.engine.cansee(x, y, z, nSector, pSprite.x, pSprite.y, pSprite.z - (eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2), pSprite.sectnum)) {
                    short nAngle = Main.engine.getangle(dx, dy);
                    int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
                    if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                        Ai.aiThinkTime[pSprite.xvel] = 0;
                        Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                    if (dist < pDudeInfo.hearDist) {
                        Ai.aiThinkTime[pSprite.xvel] = 0;
                        Ai.aiSetTarget(pXSprite, x, y, z);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            if (pSprite.lotag == 227) {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[0]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[1]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            if (pSprite.lotag == 227) {
                Ai.aiNewState(pSprite, pXSprite, cerberusGoto[0]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, cerberusGoto[1]);
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            if (pSprite.lotag == 227) {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[0]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[1]);
            }
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            if (pSprite.lotag == 227) {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[0]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[1]);
            }
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                if (dist < 2816 && dist > 1280 && Pragmas.klabs(losAngle) < 85) {
                    if (pSprite.lotag == 227) {
                        Ai.aiNewState(pSprite, pXSprite, cerberusBurn[0]);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, cerberusBurn[1]);
                    }
                    return;
                }
                if (dist < 6912 && dist > 3328 && Pragmas.klabs(losAngle) < 85) {
                    if (pSprite.lotag == 227) {
                        Ai.aiNewState(pSprite, pXSprite, cerberusFire[0]);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, cerberusFire[1]);
                    }
                    return;
                }
                if (dist < 512 && Pragmas.klabs(losAngle) < 85) {
                    int hitType = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                    if (hitType == 0 || hitType == 4 || hitType == 3 && (Engine.sprite[Engine.pHitInfo.hitsprite].lotag == pSprite.lotag || Engine.sprite[Engine.pHitInfo.hitsprite].lotag == 211)) {
                        return;
                    }
                    if (pSprite.lotag == 227) {
                        Ai.aiNewState(pSprite, pXSprite, cerberusHack[0]);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, cerberusHack[1]);
                    }
                }
                return;
            }
        }
        if (pSprite.lotag == 227) {
            Ai.aiNewState(pSprite, pXSprite, cerberusGoto[0]);
        } else {
            Ai.aiNewState(pSprite, pXSprite, cerberusGoto[1]);
        }
        pXSprite.target = -1;
    }
}

