/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AISPID {
    public static AISTATE spidIdle;
    public static AISTATE spidSearch;
    public static AISTATE spidChase;
    public static AISTATE spidDodge;
    public static AISTATE spidRecoil;
    public static AISTATE spidGoto;
    public static AISTATE spidBite;
    public static AISTATE spidJump;
    public static AISTATE spidSpawn;

    public static void Init() {
        spidIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        spidChase = new AISTATE(AISTATEFUNC.Type.other, 7, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AISPID.thinkChase(sprite, xsprite);
            }
        };
        spidDodge = new AISTATE(AISTATEFUNC.Type.other, 7, null, 90, false, true, false, spidChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        spidGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 7, null, 600, false, true, true, spidIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AISPID.thinkGoto(sprite, xsprite);
            }
        };
        spidSearch = new AISTATE(AISTATEFUNC.Type.search, 7, null, 1800, false, true, true, spidIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AISPID.thinkSearch(sprite, xsprite);
            }
        };
        spidBite = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AISPID.BiteCallback(nXSprite);
            }
        }, 60, false, false, false, spidChase);
        spidJump = new AISTATE(AISTATEFUNC.Type.other, 8, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AISPID.JumpCallback(nXSprite);
            }
        }, 60, false, true, false, spidChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }
        };
        spidSpawn = new AISTATE(AISTATEFUNC.Type.other, 0, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AISPID.SpawnCallback(nXSprite);
            }
        }, 60, false, false, false, spidIdle);
    }

    private static void SpawnCallback(int nXIndex) {
        int losAngle;
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        SPRITE pSpawned = null;
        if (Gameutils.IsPlayerSprite(pTarget) && Ai.aiThinkTime[nSprite] < 10 && Pragmas.klabs(losAngle = pSprite.ang - nAngle) <= pDudeInfo.periphery) {
            if (dist < 6656 && dist > 5120) {
                pSpawned = Actor.actSpawnDude(pSprite, 214, pSprite.clipdist);
            } else if (dist < 3072 || dist < 5120 && dist > 3072) {
                pSpawned = Actor.actSpawnDude(pSprite, 213, pSprite.clipdist);
            }
        }
        if (pSpawned != null) {
            int n = nSprite;
            Ai.aiThinkTime[n] = Ai.aiThinkTime[n] + 1;
            pSpawned.owner = (short)nSprite;
            ++LEVELS.totalKills;
        }
    }

    private static void JumpCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        int dz = 0;
        dx += Gameutils.BiRandom(200);
        dy += Gameutils.BiRandom(200);
        dz += Gameutils.BiRandom(200);
        if (Gameutils.IsPlayerSprite(pTarget) && (pSprite.lotag == 213 || pSprite.lotag == 215)) {
            Actor.sprXVel[pSprite.xvel] = dx << 16;
            Actor.sprYVel[pSprite.xvel] = dy << 16;
            Actor.sprZVel[pSprite.xvel] = (dz += pTarget.z - pSprite.z) << 16;
        }
    }

    private static void spidAttack(XSPRITE pXDude, int add, int max) {
        SPRITE pDude;
        if (pXDude == null) {
            Main.game.dassert("pXDude != null");
        }
        if (Gameutils.IsPlayerSprite(pDude = Engine.sprite[pXDude.reference])) {
            PLAYER pPlayer = Globals.gPlayer[pDude.lotag - 231];
            pPlayer.blindEffect = Gameutils.ClipHigh(pPlayer.blindEffect + (add << 4), max << 4);
        }
    }

    private static void BiteCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        int dz = 0;
        dz += Gameutils.BiRandom(2000);
        if (Gameutils.IsPlayerSprite(pTarget) && Gameutils.HitScan(pSprite, pSprite.z, dx += Gameutils.BiRandom(2000), dy += Gameutils.BiRandom(2000), 0, Engine.pHitInfo, 0x1000040, 0) == 3 && Gameutils.IsPlayerSprite(Engine.sprite[Engine.pHitInfo.hitsprite])) {
            PLAYER pPlayer = Globals.gPlayer[Engine.sprite[Engine.pHitInfo.hitsprite].lotag - 231];
            switch (pSprite.lotag) {
                case 213: {
                    Actor.actFireVector(pSprite, 0, 0, dx, dy, pTarget.z - pSprite.z + dz, 17);
                    if (pPlayer.godMode || PLAYER.powerupCheck(pPlayer, 14) > 0 || !Gameutils.Chance(8192)) break;
                    PLAYER.powerupActivate(pPlayer, 28);
                    break;
                }
                case 214: {
                    Actor.actFireVector(pSprite, 0, 0, dx, dy, pTarget.z - pSprite.z + dz, 17);
                    if (!Gameutils.Chance(10240)) break;
                    AISPID.spidAttack(DB.xsprite[pTarget.extra], 4, 16);
                    break;
                }
                case 215: {
                    Actor.actFireVector(pSprite, 0, 0, dx, dy, pTarget.z - pSprite.z + dz, 17);
                    AISPID.spidAttack(DB.xsprite[pTarget.extra], 8, 16);
                    break;
                }
                case 216: {
                    Actor.actFireVector(pSprite, 0, 0, dx, dy, pTarget.z - pSprite.z + dz, 17);
                    Actor.actFireVector(pSprite, 0, 0, Gameutils.BiRandom(8192) + dx, Gameutils.BiRandom(8192) + dy, Gameutils.BiRandom(8192) + (pTarget.z - pSprite.z + dz), 17);
                    AISPID.spidAttack(DB.xsprite[pTarget.extra], 8, 16);
                }
            }
        }
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, spidSearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, spidGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, spidSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, spidSearch);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                switch (pSprite.lotag) {
                    case 214: {
                        if (dist >= 921 || Pragmas.klabs(losAngle) >= 85) break;
                        Ai.aiNewState(pSprite, pXSprite, spidBite);
                        break;
                    }
                    case 213: 
                    case 215: {
                        if (dist > 921 && dist < 1843) {
                            if (Pragmas.klabs(losAngle) >= 85) break;
                            Ai.aiNewState(pSprite, pXSprite, spidJump);
                            break;
                        }
                        if (dist >= 921 || Pragmas.klabs(losAngle) >= 85) break;
                        Ai.aiNewState(pSprite, pXSprite, spidBite);
                        break;
                    }
                    case 216: {
                        if (dist > 921 && dist < 1843 && Pragmas.klabs(losAngle) < 85) {
                            Ai.aiNewState(pSprite, pXSprite, spidJump);
                            break;
                        }
                        if (!Gameutils.Chance(16384)) break;
                        Ai.aiNewState(pSprite, pXSprite, spidSpawn);
                    }
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, spidGoto);
        pXSprite.target = -1;
    }
}

