/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.ScreenAdapter;
import java.util.Arrays;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.LOADSAVE;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DataResource;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class DB {
    public static final String kBloodMapExt = "MAP";
    public static final String kBloodMapSig = "BLM\u001a";
    public static final int kBloodMapVersion6 = 1536;
    public static final int kBloodMapVersion7 = 1792;
    public static final int kMajorVersionMask = 65280;
    public static final int kMinorVersionMask = 255;
    public static final int kFreeHead = 0;
    public static final byte[] crypt = new byte[]{77, 97, 116, 116};
    public static final int key = LittleEndian.getInt(crypt);
    public static final int kMaxXSprites = 2048;
    public static final int kMaxXWalls = 512;
    public static final int kMaxXSectors = 512;
    public static XSPRITE[] xsprite = new XSPRITE[2048];
    public static XWALL[] xwall = new XWALL[512];
    public static XSECTOR[] xsector = new XSECTOR[512];
    public static int[] nextXSprite = new int[2048];
    public static int[] nextXWall = new int[512];
    public static int[] nextXSector = new int[512];
    public static final int kMaxBusyValue = 65536;
    public static final int kFluxMask = 65535;
    public static int gMapRev;
    public static int gSongId;
    public static int gSkyCount;
    public static int gVisibility;
    public static final int kPathMarker = 15;
    public static final int kDudeSpawn = 18;
    public static final int kEarthQuake = 19;
    public static final int kSwitchBase = 20;
    public static final int kSwitchToggle = 20;
    public static final int kSwitchMomentary = 21;
    public static final int kSwitchCombination = 22;
    public static final int kSwitchPadlock = 23;
    public static final int kSwitchMax = 24;
    public static final int kGDXTypeBase = 24;
    public static final int kGDXCustomDudeSpawn = 24;
    public static final int kGDXRandomTX = 25;
    public static final int kGDXSequentialTX = 26;
    public static final int kGDXSeqSpawner = 27;
    public static final int kGDXObjPropertiesChanger = 28;
    public static final int kGDXObjPicnumChanger = 29;
    public static final int kGDXObjSizeChanger = 31;
    public static final int kGDXDudeTargetChanger = 33;
    public static final int kGDXSectorFXChanger = 34;
    public static final int kGDXObjDataChanger = 35;
    public static final int kGDXSpriteDamager = 36;
    public static final int kGDXObjDataAccumulator = 37;
    public static final int kGDXEffectSpawner = 38;
    public static final int kGDXWindGenerator = 39;
    public static final int kDudeBase = 200;
    public static final int kDudeTommyCultist = 201;
    public static final int kDudeShotgunCultist = 202;
    public static final int kDudeAxeZombie = 203;
    public static final int kDudeButcher = 204;
    public static final int kDudeEarthZombie = 205;
    public static final int kDudeFleshGargoyle = 206;
    public static final int kDudeStoneGargoyle = 207;
    public static final int kDudeFleshStatue = 208;
    public static final int kDudeStoneStatue = 209;
    public static final int kDudePhantasm = 210;
    public static final int kDudeHound = 211;
    public static final int kDudeHand = 212;
    public static final int kDudeBrownSpider = 213;
    public static final int kDudeRedSpider = 214;
    public static final int kDudeBlackSpider = 215;
    public static final int kDudeMotherSpider = 216;
    public static final int kDudeGillBeast = 217;
    public static final int kDudeEel = 218;
    public static final int kDudeBat = 219;
    public static final int kDudeRat = 220;
    public static final int kDudeGreenPod = 221;
    public static final int kDudeGreenTentacle = 222;
    public static final int kDudeFirePod = 223;
    public static final int kDudeFireTentacle = 224;
    public static final int kDudeMotherPod = 225;
    public static final int kDudeMotherTentacle = 226;
    public static final int kDudeCerberus = 227;
    public static final int kDudeCerberus2 = 228;
    public static final int kDudeTchernobog = 229;
    public static final int kDudeFanaticProne = 230;
    public static final int kDudePlayer1 = 231;
    public static final int kDudePlayer8 = 238;
    public static final int kDudeBurning = 239;
    public static final int kDudeCultistBurning = 240;
    public static final int kDudeAxeZombieBurning = 241;
    public static final int kDudeBloatedButcherBurning = 242;
    public static final int kDudeSleepZombie = 244;
    public static final int kDudeInnocent = 245;
    public static final int kDudeCultistProne = 246;
    public static final int kDudeTeslaCultist = 247;
    public static final int kDudeDynamiteCultist = 248;
    public static final int kDudeBeastCultist = 249;
    public static final int kDudeTinyCaleb = 250;
    public static final int kDudeTheBeast = 251;
    public static final int kDudeTinyCalebburning = 252;
    public static final int kDudeTheBeastburning = 253;
    public static final int kGDXDudeUniversalCultist = 254;
    public static final int kGDXGenDudeBurning = 255;
    public static final int kDudeMax = 256;
    public static final String[] kDudeName;
    public static final int kMissileBase = 300;
    public static final int kMissileButcherKnife = 300;
    public static final int kMissileFlare = 301;
    public static final int kMissileAltTesla = 302;
    public static final int kMissileStarburstFlare = 303;
    public static final int kMissileSprayFlame = 304;
    public static final int kMissileFireball = 305;
    public static final int kMissileTesla = 306;
    public static final int kMissileEctoSkull = 307;
    public static final int kMissileHoundFire = 308;
    public static final int kMissileGreenPuke = 309;
    public static final int kMissileRedPuke = 310;
    public static final int kMissileBone = 311;
    public static final int kMissileNapalm = 312;
    public static final int kMissileTchernobog = 313;
    public static final int kMissileTchernobog2 = 314;
    public static final int kMissileLifeLeech = 315;
    public static final int kMissileAltLeech1 = 316;
    public static final int kMissileAltLeech2 = 317;
    public static final int kMissileMax = 318;
    public static short[] nStatSize;
    public static final int kThingBase = 400;
    public static final int kThingTNTBarrel = 400;
    public static final int kThingTNTProx = 401;
    public static final int kThingTNTRem = 402;
    public static final int kThingBlueVase = 403;
    public static final int kThingBrownVase = 404;
    public static final int kThingCrateFace = 405;
    public static final int kThingClearGlass = 406;
    public static final int kThingFluorescent = 407;
    public static final int kThingWallCrack = 408;
    public static final int kThingWoodBeam = 409;
    public static final int kThingWeb = 410;
    public static final int kThingMetalGrate1 = 411;
    public static final int kThingFlammableTree = 412;
    public static final int kThingMachineGun = 413;
    public static final int kThingFallingRock = 414;
    public static final int kThingPail = 415;
    public static final int kThingGibObject = 416;
    public static final int kThingExplodeObject = 417;
    public static final int kThingTNTStick = 418;
    public static final int kThingTNTBundle = 419;
    public static final int kThingSprayBundle = 420;
    public static final int kThingBoneClub = 421;
    public static final int kThingWaterDrip = 423;
    public static final int kThingBloodDrip = 424;
    public static final int kThingGibSmall = 425;
    public static final int kThingGib = 426;
    public static final int kThingZombieHead = 427;
    public static final int kThingAltNapalm = 428;
    public static final int kThingPodFire = 429;
    public static final int kThingPodGreen = 430;
    public static final int kThingLifeLeech = 431;
    public static final int kGDXThingTNTProx = 433;
    public static final int kGDXThingThrowableRock = 434;
    public static final int kGDXThingCustomDudeLifeLeech = 435;
    public static final int kThingMax = 436;
    public static final int kThingFlameTrap = 452;
    public static final int kTrapSawBlade = 454;
    public static final int kTrapPoweredZap = 456;
    public static final int kThingHiddenExploder = 459;
    public static final int kWallGlass = 511;
    public static final int kGenTrigger = 700;
    public static final int kGenWaterDrip = 701;
    public static final int kGenBloodDrip = 702;
    public static final int kGenFireball = 703;
    public static final int kGenEctoSkull = 704;
    public static final int kGenDart = 705;
    public static final int kGenBubble = 706;
    public static final int kGenMultiBubble = 707;
    public static final int kGenSFX = 708;
    public static final int kGenSectorSFX = 709;
    public static final int kGenAmbientSFX = 710;
    public static final int kGenPlayerSFX = 711;
    public static final int kSectorBase = 600;
    public static final int kSectorZMotion = 600;
    public static final int kSectorZSprite = 602;
    public static final int kSectorWarp = 603;
    public static final int kSectorTeleport = 604;
    public static final int kSectorPath = 612;
    public static final int kSectorRotateStep = 613;
    public static final int kSectorSlideMarked = 614;
    public static final int kSectorRotateMarked = 615;
    public static final int kSectorSlide = 616;
    public static final int kSectorRotate = 617;
    public static final int kSectorDamage = 618;
    public static final int kSectorCounter = 619;
    public static final int kSectorMax = 620;
    public static final int kWeaponItemBase = 40;
    public static final int kWeaponLifeLeech = 50;
    public static final int kWeaponItemMax = 51;
    public static final int kAmmoItemBase = 60;
    public static final int kAmmoItemRandom = 80;
    public static final int kAmmoItemMax = 81;
    public static final int kItemBase = 100;
    public static final int kItemKey1 = 100;
    public static final int kItemKey2 = 101;
    public static final int kItemKey3 = 102;
    public static final int kItemKey4 = 103;
    public static final int kItemKey5 = 104;
    public static final int kItemKey6 = 105;
    public static final int kItemKey7 = 106;
    public static final int kItemDoctorBag = 107;
    public static final int kItemMedPouch = 108;
    public static final int kItemLifeEssence = 109;
    public static final int kItemLifeSeed = 110;
    public static final int kItemPotion1 = 111;
    public static final int kItemFeatherFall = 112;
    public static final int kItemLtdInvisibility = 113;
    public static final int kItemInvulnerability = 114;
    public static final int kItemJumpBoots = 115;
    public static final int kItemRavenFlight = 116;
    public static final int kItemGunsAkimbo = 117;
    public static final int kItemDivingSuit = 118;
    public static final int kItemGasMask = 119;
    public static final int kItemClone = 120;
    public static final int kItemCrystalBall = 121;
    public static final int kItemDecoy = 122;
    public static final int kItemDoppleganger = 123;
    public static final int kItemReflectiveShots = 124;
    public static final int kItemBeastVision = 125;
    public static final int kItemShadowCloak = 126;
    public static final int kItemShroomRage = 127;
    public static final int kItemShroomDelirium = 128;
    public static final int kItemShroomGrow = 129;
    public static final int kItemShroomShrink = 130;
    public static final int kItemDeathMask = 131;
    public static final int kItemWineGoblet = 132;
    public static final int kItemWineBottle = 133;
    public static final int kItemSkullGrail = 134;
    public static final int kItemSilverGrail = 135;
    public static final int kItemTome = 136;
    public static final int kItemBlackChest = 137;
    public static final int kItemWoodenChest = 138;
    public static final int kItemAsbestosArmor = 139;
    public static final int kArmorItemBase = 140;
    public static final int kItemBasicArmor = 140;
    public static final int kItemBodyArmor = 141;
    public static final int kItemFireArmor = 142;
    public static final int kItemSpiritArmor = 143;
    public static final int kItemSuperArmor = 144;
    public static final int kItemBlueTeamBase = 145;
    public static final int kItemRedTeamBase = 146;
    public static final int kItemBlueFlag = 147;
    public static final int kItemRedFlag = 148;
    public static final int kItemJetpack = 149;
    public static final int kItemMax = 149;
    public static final int kMaxItemTypes = 49;
    public static final int kMaxPowerUps = 49;
    public static final int kRespawnNever = 0;
    public static final int kRespawnOptional = 1;
    public static final int kRespawnAlways = 2;
    public static final int kRespawnPermanent = 3;
    public static final String[] gItemText;
    public static final String[] gWeaponText;
    public static final String[] gAmmoText;
    private static short[] gHealthInfo;
    private static PLAYER[] gPlayerInfo;
    public static final short kMaxProximitySprites = 128;
    public static final short kMaxSightSprites = 128;
    public static short[] gProxySpritesList;
    public static short gProxySpritesCount;
    public static byte gBadProxSprites;
    public static byte gMaxBadProxySprites;
    public static short[] gSightSpritesList;
    public static short gSightSpritesCount;
    public static byte gBadSightSprites;
    public static byte gMaxBadSightSprites;

    static {
        kDudeName = new String[]{"kDudeBase", "Tommy Cultist", "Shotgun Cultist", "Axe Zombie", "Butcher", "Earth Zombie", "Flesh Gargoyle", "Stone Gargoyle", "Flesh Statue", "Stone Statue", "Phantasm", "Hound", "Hand", "Brown Spider", "Red Spider", "Black Spider", "Mother Spider", "Gill Beast", "Eel", "Bat", "Rat", "Green Pod", "Green Tentacle", "Fire Pod", "Fire Tentacle", "Mother Pod", "Mother Tentacle", "Cerberus", "Cerberus", "Tchernobo", "Fanatic Prone", "Player1", "Player2", "Player3", "Player4", "Player5", "Player6", "Player7", "Player8", "Burning", "Cultist Burning", "Axe Zombie Burning", "Bloated Butcher Burning", "<Reserved>", "Sleep Zombie", "Innocent", "CultistProne", "Tesla Cultist", "Dynamite Cultist", "Beast Cultist", "Tiny Caleb", "The Beast", "Tiny Calebburning", "The Beastburning", "GDX Custom dude", "GDX Custom burning dude", "kDudeMax"};
        nStatSize = new short[1025];
        gItemText = new String[]{"Skull Key", "Eye Key", "Fire Key", "Dagger Key", "Spider Key", "Moon Key", "Key 7", "Doctor's Bag", "Medicine Pouch", "Life Essence", "Life Seed", "Red Potion", "Feather Fall", "Limited Invisibility", "INVULNERABILITY", "Boots of Jumping", "Raven Flight", "Guns Akimbo", "Diving Suit", "Gas mask", "Clone", "Crystal Ball", "Decoy", "Doppleganger", "Reflective shots", "Beast Vision", "ShadowCloak", "Rage shroom", "Delirium Shroom", "Grow shroom", "Shrink shroom", "Death mask", "Wine Goblet", "Wine Bottle", "Skull Grail", "Silver Grail", "Tome", "Black Chest", "Wooden Chest", "Asbestos Armor", "Basic Armor", "Body Armor", "Fire Armor", "Spirit Armor", "Super Armor", "Blue Team Base", "Red Team Base", "Blue Flag", "Red Flag", "Level map"};
        gWeaponText = new String[]{"RANDOM", "Sawed-off", "Tommy Gun", "Flare Pistol", "Voodoo Doll", "Tesla Cannon", "Napalm Launcher", "Pitchfork", "Spray Can", "Dynamite", "Life Leech"};
        gAmmoText = new String[]{"Spray can", "Bundle of TNT*", "Bundle of TNT", "Case of TNT", "Proximity Detonator", "Remote Detonator", "Trapped Soul", "4 shotgun shells", "Box of shotgun shells", "A few bullets", "Voodoo Doll", "OBSOLETE", "Full drum of bullets", "Tesla Charge", "OBSOLETE", "OBSOLETE", "Flares", "OBSOLETE", "OBSOLETE", "Gasoline Can"};
        gHealthInfo = new short[8];
        gPlayerInfo = new PLAYER[8];
        gProxySpritesList = new short[128];
        gSightSpritesList = new short[128];
    }

    public static boolean prepareboard(ScreenAdapter screen) {
        short[] cursectnum;
        short[] ang;
        int[] posz;
        int[] posy;
        int[] posx;
        block52: {
            Console.Println("debug: start prepareboard()", Console.OSDTEXT_BLUE);
            Screen.scrReset();
            View.PaletteView = 0;
            Screen.scrSetPalette(View.PaletteView);
            View.gViewMode = 3;
            View.gViewPos = 0;
            View.resetQuotes();
            Actor.gNoEnemies = 0;
            SOUND.sndStopAllSounds();
            SeqHandling.seqKillAll();
            if ((Globals.pGameInfo.uGameFlags & 1) != 0) {
                short j = Mmulti.connecthead;
                while (j >= 0) {
                    if (gPlayerInfo[j] == null) {
                        DB.gPlayerInfo[j] = new PLAYER();
                    }
                    gPlayerInfo[j].copy(Globals.gPlayer[j]);
                    DB.gPlayerInfo[j].pSprite = Globals.gPlayer[j].pSprite;
                    DB.gHealthInfo[j] = (short)Globals.gPlayer[j].pXsprite.health;
                    j = Mmulti.connectpoint2[j];
                }
            }
            int i = 0;
            while (i < 2048) {
                if (xsprite[i] != null) {
                    xsprite[i].free();
                }
                ++i;
            }
            i = 0;
            while (i < Globals.kMaxSprites) {
                if (Engine.sprite[i] != null) {
                    Engine.sprite[i].reset((byte)0);
                }
                ++i;
            }
            Arrays.fill(Actor.sprXVel, 0L);
            Arrays.fill(Actor.sprYVel, 0L);
            Arrays.fill(Actor.sprZVel, 0L);
            posx = new int[1];
            posy = new int[1];
            posz = new int[1];
            ang = new short[1];
            cursectnum = new short[1];
            DB.dbLoadMap(Globals.pGameInfo.zLevelName, posx, posy, posz, ang, cursectnum);
            if (!Globals.kGameCrash) break block52;
            Main.game.EndGame();
            return false;
        }
        try {
            Gameutils.sRandom(Globals.pGameInfo.uMapCRC);
            Engine.automapping = 1;
            LEVELS.levelResetKills();
            LEVELS.levelResetSecrets();
            int i = 0;
            while (i < 128) {
                DB.gProxySpritesList[i] = -1;
                i = (short)(i + 1);
            }
            i = 0;
            while (i < 128) {
                DB.gSightSpritesList[i] = -1;
                i = (short)(i + 1);
            }
            gProxySpritesCount = 0;
            gBadProxSprites = 0;
            gSightSpritesCount = 0;
            gBadSightSprites = 0;
            i = 0;
            while (i < Globals.kMaxSprites) {
                SPRITE pSprite = Engine.sprite[i];
                if (pSprite.statnum != 1024 && pSprite.extra > 0) {
                    XSPRITE pXSprite = xsprite[pSprite.extra];
                    if ((1 << Globals.pGameInfo.nEnemyQuantity & pXSprite.lSkill) != 0 || pXSprite.lS && Globals.pGameInfo.nGameType == 0 || pXSprite.lB && Globals.pGameInfo.nGameType == 2 || pXSprite.lT && Globals.pGameInfo.nGameType == 3 || pXSprite.lC && Globals.pGameInfo.nGameType == 1) {
                        DB.deletesprite((short)i);
                    } else if (!DEMO.IsOriginalDemo()) {
                        if (Engine.sprite[i].lotag == 33) {
                            DB.InsertSpriteStat((short)i, (short)20);
                        }
                        if (pXSprite.Proximity && gProxySpritesCount < 128) {
                            switch (pSprite.statnum) {
                                case 4: 
                                case 6: {
                                    if (!pXSprite.Sight || !pXSprite.DudeLockout) break;
                                    pXSprite.Proximity = false;
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 3: 
                                case 5: 
                                case 7: 
                                case 9: 
                                case 10: 
                                case 13: 
                                case 14: 
                                case 16: 
                                case 1024: {
                                    break;
                                }
                                default: {
                                    if (pXSprite.Sight && pXSprite.DudeLockout) {
                                        pXSprite.Proximity = false;
                                        break;
                                    }
                                    short s = gProxySpritesCount;
                                    gProxySpritesCount = (short)(s + 1);
                                    DB.gProxySpritesList[s] = pSprite.xvel;
                                    gMaxBadProxySprites = (byte)(gProxySpritesCount >> 2);
                                    if (gMaxBadProxySprites <= 0) {
                                        gMaxBadProxySprites = 1;
                                    }
                                    if (gProxySpritesCount != 128) break;
                                    String msg = "Max (128) additional Proximity sprites reached!\n";
                                    msg = String.valueOf(msg) + "Please change your trigger system or stick with thing types (400 - 435), because\n";
                                    msg = String.valueOf(msg) + "additional non-thing sprites with this flag only after this limit will not trigger anything.";
                                    Main.game.GameWarning(msg);
                                }
                            }
                        }
                        if (pXSprite.Sight && gSightSpritesCount < 128) {
                            switch (pSprite.statnum) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 5: 
                                case 7: 
                                case 9: 
                                case 10: 
                                case 13: 
                                case 14: 
                                case 16: 
                                case 1024: {
                                    break;
                                }
                                default: {
                                    short s = gSightSpritesCount;
                                    gSightSpritesCount = (short)(s + 1);
                                    DB.gSightSpritesList[s] = pSprite.xvel;
                                    gMaxBadSightSprites = (byte)(gSightSpritesCount >> 2);
                                    if (gMaxBadSightSprites <= 0) {
                                        gMaxBadSightSprites = 1;
                                    }
                                    if (gSightSpritesCount != 128) break;
                                    Main.game.GameWarning("Max (128) Sight sprites reached!");
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            Screen.scrLoadPLUs();
            int z = posz[0];
            if (cursectnum[0] != -1) {
                z = Main.engine.getflorzofslope(cursectnum[0], posx[0], posy[0]);
            }
            int i2 = 0;
            while (i2 < 8) {
                Warp.gStartZone[i2] = new ZONE();
                Warp.gStartZone[i2].x = posx[0];
                Warp.gStartZone[i2].y = posy[0];
                Warp.gStartZone[i2].z = z;
                Warp.gStartZone[i2].sector = cursectnum[0];
                Warp.gStartZone[i2].angle = ang[0];
                if (i2 <= 4) {
                    Warp.gStartZoneTeam1[i2] = new ZONE();
                    Warp.gStartZoneTeam1[i2].x = posx[0];
                    Warp.gStartZoneTeam1[i2].y = posy[0];
                    Warp.gStartZoneTeam1[i2].z = z;
                    Warp.gStartZoneTeam1[i2].sector = cursectnum[0];
                    Warp.gStartZoneTeam1[i2].angle = ang[0];
                    Warp.gStartZoneTeam2[i2] = new ZONE();
                    Warp.gStartZoneTeam2[i2].x = posx[0];
                    Warp.gStartZoneTeam2[i2].y = posy[0];
                    Warp.gStartZoneTeam2[i2].z = z;
                    Warp.gStartZoneTeam2[i2].sector = cursectnum[0];
                    Warp.gStartZoneTeam2[i2].angle = ang[0];
                }
                ++i2;
            }
            SECTORFX.InitSectorFX();
            Warp.InitPlayerStartZones();
            Actor.actInit(false, screen == Main.gDemoScreen || Main.cfg.gVanilla);
            EVENT.evInit(screen == Main.gDemoScreen || Main.cfg.gVanilla);
            if (Globals.pGameInfo.nFragLimit != 0) {
                Arrays.fill(Globals.nTeamCount, 0);
                Arrays.fill(Globals.nTeamClock, 0);
            }
            short j = Mmulti.connecthead;
            while (j >= 0) {
                if ((Globals.pGameInfo.uGameFlags & 1) == 0 || Globals.pGameInfo.nGameType > 1) {
                    if (Mmulti.numplayers == 1) {
                        Main.game.net.gProfile[j].autoaim = Main.cfg.gAutoAim;
                        Main.game.net.gProfile[j].slopetilt = Main.cfg.gSlopeTilt;
                        Main.game.net.gProfile[j].skill = (byte)Globals.pGameInfo.nDifficulty;
                    }
                    PLAYER.playerInit(j, false);
                }
                PLAYER.playerReset(j);
                if (Globals.pGameInfo.nFragLimit != 0) {
                    Globals.gPlayer[j].fragCount = 0;
                    Arrays.fill(Globals.gPlayer[j].fragInfo, 0);
                }
                j = Mmulti.connectpoint2[j];
            }
            if (Globals.kFakeMultiplayer) {
                i2 = 1;
                while (i2 < Globals.nFakePlayers) {
                    if ((Globals.pGameInfo.uGameFlags & 1) == 0 || Globals.pGameInfo.nGameType > 1) {
                        PLAYER.playerInit(i2, false);
                    }
                    PLAYER.playerReset(i2);
                    ++i2;
                }
            }
            if ((Globals.pGameInfo.uGameFlags & 1) != 0) {
                j = Mmulti.connecthead;
                while (j >= 0) {
                    PLAYER pPlayer = Globals.gPlayer[j];
                    pPlayer.pXsprite.health = gHealthInfo[j];
                    pPlayer.pWeaponQAV = DB.gPlayerInfo[j].pWeaponQAV;
                    pPlayer.currentWeapon = DB.gPlayerInfo[j].currentWeapon;
                    pPlayer.weaponState = DB.gPlayerInfo[j].weaponState;
                    pPlayer.weaponAmmo = DB.gPlayerInfo[j].weaponAmmo;
                    pPlayer.weaponCallback = DB.gPlayerInfo[j].weaponCallback;
                    pPlayer.fLoopQAV = DB.gPlayerInfo[j].fLoopQAV;
                    pPlayer.weaponTimer = DB.gPlayerInfo[j].weaponTimer;
                    pPlayer.updateWeapon = DB.gPlayerInfo[j].updateWeapon;
                    pPlayer.LastWeapon = DB.gPlayerInfo[j].LastWeapon;
                    int i3 = 0;
                    while (i3 < 49) {
                        int nPowerUp = i3 + 100;
                        if (Main.cfg.gVanilla || nPowerUp != 114 && nPowerUp != 119 && nPowerUp != 139 && nPowerUp != 112 && nPowerUp != 113 && nPowerUp != 116 && nPowerUp != 120 && nPowerUp != 122 && nPowerUp != 123 && nPowerUp != 124 && nPowerUp != 126 && nPowerUp != 127 && nPowerUp != 128 && nPowerUp != 129 && nPowerUp != 130 && nPowerUp != 131 && nPowerUp != 117) {
                            pPlayer.powerUpTimer[i3] = DB.gPlayerInfo[j].powerUpTimer[i3];
                        }
                        ++i3;
                    }
                    if (!Main.cfg.gVanilla && pPlayer.currentWeapon == 3) {
                        pPlayer.weaponState = Globals.gInfiniteAmmo || pPlayer.ammoCount[2] > 1 ? 3 : 2;
                    }
                    if (Globals.pGameInfo.nGameType == 0 && Globals.pGameInfo.nPitchforkOnly) {
                        i3 = 0;
                        while (i3 < 14) {
                            pPlayer.weaponMode[i3] = 0;
                            ++i3;
                        }
                        pPlayer.hasWeapon[1] = true;
                        pPlayer.LastWeapon = 0;
                        pPlayer.currentWeapon = 0;
                        pPlayer.weaponCallback = -1;
                        pPlayer.pInput.newWeapon = 1;
                        i3 = 0;
                        while (i3 < 14) {
                            pPlayer.weaponOrder[0][i3] = Weapon.defaultOrder[i3];
                            pPlayer.weaponOrder[1][i3] = Weapon.defaultOrder[i3];
                            ++i3;
                        }
                        i3 = 0;
                        while (i3 < 12) {
                            pPlayer.ammoCount[i3] = 0;
                            ++i3;
                        }
                        pPlayer.weaponTimer = 0;
                        pPlayer.weaponState = 0;
                        pPlayer.pWeaponQAV = -1;
                        pPlayer.fLoopQAV = false;
                    }
                    j = Mmulti.connectpoint2[j];
                }
            }
            Globals.pGameInfo.uGameFlags &= 0xFFFFFFFC;
            if (Globals.SplitScreen) {
                DB.InsertPlayer();
            }
            Mirror.InitMirrors();
            BuildGdx.audio.getSound().setReverb(false, 0.0f);
            Globals.gFrame = 0;
            Globals.gFrameClock = 0;
            if (screen != Main.gDemoScreen) {
                View.gViewIndex = Mmulti.myconnectindex;
            }
            Trigger.trInit();
            SOUND.ambPrepare();
            SOUND.sndPlayMusic();
            Console.Println("debug: end prepareboard()", Console.OSDTEXT_BLUE);
            return !Globals.kGameCrash;
        }
        catch (Exception e) {
            Main.game.ThrowError(" in prepareboard(): " + (e.getMessage() == null ? "" : e.getMessage()) + " \r\n", e);
            return false;
        }
    }

    public static void dbLoadMap(String mapname, int[] posx, int[] posy, int[] posz, short[] angle, short[] nSector) {
        Resource bb;
        Arrays.fill(Engine.show2dsector, (byte)0);
        Arrays.fill(Engine.show2dsprite, (byte)0);
        Arrays.fill(Engine.show2dwall, (byte)0);
        int index = Strhandler.toLowerCase(mapname).indexOf(".map");
        if (index == -1) {
            mapname = String.valueOf(mapname) + ".map";
        }
        if ((bb = BuildGdx.cache.open(mapname, 0)) == null) {
            Main.game.GameMessage("Error opening map file " + Compat.Path.Game.getPath() + mapname);
            return;
        }
        String signature = bb.readString(4);
        if (signature == null || !signature.equals(kBloodMapSig)) {
            Main.game.GameMessage("Wrong signature! Perhaps not a Blood map or map file corrupted: " + signature + " != " + kBloodMapSig);
            return;
        }
        short version = bb.readShort();
        boolean crypted = false;
        if ((version & 0xFF00) != 1536) {
            if ((version & 0xFF00) == 1792) {
                crypted = true;
            } else {
                Main.game.GameMessage("Map file is wrong version 0x" + Integer.toHexString(version & 0xFF00));
                return;
            }
        }
        byte[] header = new byte[37];
        bb.read(header);
        if (crypted) {
            DB.decryptBuffer(header, header.length, key);
        }
        posx[0] = LittleEndian.getInt(header, 0);
        posy[0] = LittleEndian.getInt(header, 4);
        posz[0] = LittleEndian.getInt(header, 8);
        angle[0] = LittleEndian.getShort(header, 12);
        nSector[0] = LittleEndian.getShort(header, 14);
        Engine.pskybits = LittleEndian.getShort(header, 16);
        gVisibility = Engine.visibility = LittleEndian.getInt(header, 18);
        gSongId = LittleEndian.getInt(header, 22);
        Engine.parallaxtype = header[26];
        gMapRev = LittleEndian.getInt(header, 27);
        Engine.numsectors = LittleEndian.getShort(header, 31);
        Engine.numwalls = LittleEndian.getShort(header, 33);
        Engine.numsprites = LittleEndian.getShort(header, 35);
        if (Engine.numsectors == 0) {
            Main.game.GameMessage("Empty map! Numsectors == 0");
            return;
        }
        DB.dbInit();
        byte[] buf = new byte[128];
        int xspr = 56;
        int xwal = 24;
        int xsec = 60;
        if (crypted) {
            bb.read(buf);
            DB.decryptBuffer(buf, buf.length, Engine.numwalls);
            xspr = LittleEndian.getInt(buf, 64);
            xwal = LittleEndian.getInt(buf, 68);
            xsec = LittleEndian.getInt(buf, 72);
        }
        gSkyCount = 1 << Engine.pskybits;
        buf = new byte[gSkyCount * 2];
        bb.read(buf);
        if (crypted) {
            DB.decryptBuffer(buf, buf.length, buf.length);
        }
        int a = 0;
        while (a < buf.length) {
            Engine.pskyoff[a / 2] = LittleEndian.getShort(buf, a);
            a += 2;
        }
        Arrays.fill(Engine.zeropskyoff, (short)0);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        long dec = gMapRev * 40;
        byte[] sectorReader = new byte[40];
        LEVELS.autoTotalSecrets = 0;
        buf = new byte[xsec];
        int i = 0;
        while (i < Engine.numsectors) {
            SECTOR sec;
            bb.read(sectorReader);
            if (crypted) {
                DB.decryptBuffer(sectorReader, sectorReader.length, dec);
            }
            Engine.sector[i] = sec = new SECTOR(sectorReader);
            if (sec.extra > 0) {
                bb.read(buf);
                xsector[DB.dbInsertXSector(i)].init(buf);
                DB.xsector[sec.extra].reference = i;
                DB.xsector[sec.extra].busy = DB.xsector[sec.extra].state << 16;
                if (DB.xsector[sec.extra].txID == 2 && DB.xsector[sec.extra].command == 64) {
                    ++LEVELS.autoTotalSecrets;
                }
            }
            ++i;
        }
        dec |= (long)key;
        byte[] wallReader = new byte[32];
        buf = new byte[xwal];
        int i2 = 0;
        while (i2 < Engine.numwalls) {
            WALL wal;
            bb.read(wallReader);
            if (crypted) {
                DB.decryptBuffer(wallReader, wallReader.length, dec);
            }
            Engine.wall[i2] = wal = new WALL(wallReader);
            if (wal.extra > 0) {
                bb.read(buf);
                xwall[DB.dbInsertXWall(i2)].init(buf);
                DB.xwall[Engine.wall[i2].extra].reference = i2;
                DB.xwall[Engine.wall[i2].extra].busy = DB.xwall[Engine.wall[i2].extra].state << 16;
                if (DB.xwall[wal.extra].txID == 2 && DB.xwall[wal.extra].command == 64) {
                    ++LEVELS.autoTotalSecrets;
                }
            }
            ++i2;
        }
        DB.initspritelists();
        dec = gMapRev * 44 | key;
        byte[] spriteReader = new byte[44];
        buf = new byte[xspr];
        int i3 = 0;
        while (i3 < Engine.numsprites) {
            DB.RemoveSpriteStat(i3);
            bb.read(spriteReader);
            if (crypted) {
                DB.decryptBuffer(spriteReader, spriteReader.length, dec);
            }
            Engine.sprite[i3].buildSprite(new DataResource(spriteReader));
            if (!ru.m210projects.Build.Gameutils.isValidSector(Engine.sprite[i3].sectnum) || !ru.m210projects.Build.Gameutils.isValidStat(Engine.sprite[i3].statnum)) {
                Console.Println("ERROR: Sprite " + i3 + " has an invalid flags", Console.OSDTEXT_RED);
                if (Engine.sprite[i3].extra > 0) {
                    bb.seek(xspr, Resource.Whence.Current);
                }
            } else {
                DB.InsertSpriteSect((short)i3, Engine.sprite[i3].sectnum);
                DB.InsertSpriteStat((short)i3, Engine.sprite[i3].statnum);
                Engine.sprite[i3].xvel = (short)i3;
                if (Engine.sprite[i3].extra > 0) {
                    bb.read(buf);
                    int nXSprite = DB.dbInsertXSprite(i3);
                    if (nXSprite <= 0) {
                        return;
                    }
                    XSPRITE pXSprite = xsprite[nXSprite];
                    pXSprite.init(buf);
                    pXSprite.reference = i3;
                    pXSprite.busy = pXSprite.state << 16;
                    if (pXSprite.txID == 2 && pXSprite.command == 64 && (1 << Globals.pGameInfo.nEnemyQuantity & pXSprite.lSkill) == 0 && (!pXSprite.lS && Globals.pGameInfo.nGameType == 0 || !pXSprite.lB && Globals.pGameInfo.nGameType == 2 || !pXSprite.lT && Globals.pGameInfo.nGameType == 3 || !pXSprite.lC && Globals.pGameInfo.nGameType == 1)) {
                        ++LEVELS.autoTotalSecrets;
                    }
                }
                if ((Engine.sprite[i3].cstat & 0x30) == 48) {
                    Console.Println("ERROR: Sprite " + i3 + " has an invalid rotate", Console.OSDTEXT_YELLOW);
                    Engine.sprite[i3].cstat = (short)(Engine.sprite[i3].cstat & 0xFFFFFFCF);
                }
            }
            ++i3;
        }
        int mappos = bb.position();
        Globals.pGameInfo.uMapCRC = (long)bb.readInt().intValue() & 0xFFFFFFFFL;
        byte[] mapcrc = new byte[mappos];
        bb.seek(0L, Resource.Whence.Set);
        bb.read(mapcrc);
        bb.close();
        if (Globals.pGameInfo.uMapCRC != CRC32.getChecksum(mapcrc)) {
            Main.game.GameMessage("File does not match CRC");
            return;
        }
        DB.PropagateMarkerReferences();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void PropagateMarkerReferences() {
        int nSprite = Engine.headspritestat[10];
        while (nSprite != -1) {
            int j;
            block7: {
                j = Engine.nextspritestat[nSprite];
                switch (Engine.sprite[nSprite].lotag) {
                    case 8: {
                        short nXSector;
                        short nSector = Engine.sprite[nSprite].owner;
                        if (nSector < 0 || nSector >= Engine.numsectors || (nXSector = Engine.sector[nSector].extra) <= 0 || nXSector >= 512) break;
                        DB.xsector[nXSector].marker0 = nSprite;
                        break block7;
                    }
                    case 3: {
                        short nXSector;
                        short nSector = Engine.sprite[nSprite].owner;
                        if (nSector < 0 || nSector >= Engine.numsectors || (nXSector = Engine.sector[nSector].extra) <= 0 || nXSector >= 512) break;
                        DB.xsector[nXSector].marker0 = nSprite;
                        break block7;
                    }
                    case 4: {
                        short nXSector;
                        short nSector = Engine.sprite[nSprite].owner;
                        if (nSector < 0 || nSector >= Engine.numsectors || (nXSector = Engine.sector[nSector].extra) <= 0 || nXSector >= 512) break;
                        DB.xsector[nXSector].marker1 = nSprite;
                        break block7;
                    }
                    case 5: {
                        short nXSector;
                        short nSector = Engine.sprite[nSprite].owner;
                        if (nSector < 0 || nSector >= Engine.numsectors || (nXSector = Engine.sector[nSector].extra) <= 0 || nXSector >= 512) break;
                        DB.xsector[nXSector].marker0 = nSprite;
                        break block7;
                    }
                }
                System.out.println("Deleting invalid marker sprite");
                DB.deletesprite((short)nSprite);
            }
            nSprite = j;
        }
    }

    public static int dbInsertXSprite(int nSprite) {
        int nXSprite = DB.RemoveFree(nextXSprite);
        if (nXSprite <= 0) {
            if (!Globals.kGameCrash) {
                Main.game.GameMessage("Out of free XSprites");
            }
            Main.game.EndGame();
            return 0;
        }
        xsprite[nXSprite].free();
        Engine.sprite[nSprite].extra = (short)nXSprite;
        DB.xsprite[nXSprite].reference = nSprite;
        return nXSprite;
    }

    public static void dbDeleteXSprite(int nXSprite) {
        if (DB.xsprite[nXSprite].reference < 0) {
            Main.game.dassert("xsprite[nXSprite].reference >= 0");
        }
        if (Engine.sprite[DB.xsprite[nXSprite].reference].extra != nXSprite) {
            Main.game.dassert("sprite[xsprite[nXSprite].reference].extra == nXSprite");
        }
        DB.InsertFree(nextXSprite, nXSprite);
        Engine.sprite[DB.xsprite[nXSprite].reference].extra = (short)-1;
        DB.xsprite[nXSprite].reference = -1;
    }

    public static int dbInsertXWall(int nWall) {
        int nXWall = DB.RemoveFree(nextXWall);
        if (nXWall == 0) {
            System.err.println("Out of free XWalls");
        }
        xwall[nXWall].free();
        Engine.wall[nWall].extra = (short)nXWall;
        DB.xwall[nXWall].reference = nWall;
        return nXWall;
    }

    public static void dbDeleteXWall(int nXWall) {
        if (DB.xwall[nXWall].reference < 0) {
            Main.game.dassert("xwall[nXWall].reference >= 0");
        }
        DB.InsertFree(nextXWall, nXWall);
        Engine.wall[DB.xwall[nXWall].reference].extra = (short)-1;
        DB.xwall[nXWall].reference = -1;
    }

    public static int dbInsertXSector(int nSector) {
        int nXSector = DB.RemoveFree(nextXSector);
        if (nXSector == 0) {
            System.err.println("Out of free XSectors");
        }
        xsector[nXSector].free();
        Engine.sector[nSector].extra = (short)nXSector;
        DB.xsector[nXSector].reference = nSector;
        return nXSector;
    }

    public static void dbDeleteXSector(int nXSector) {
        if (DB.xsector[nXSector].reference < 0) {
            Main.game.dassert("xsector[nXSector].reference >= 0");
        }
        DB.InsertFree(nextXSector, nXSector);
        Engine.sector[DB.xsector[nXSector].reference].extra = (short)-1;
        DB.xsector[nXSector].reference = -1;
    }

    public static void InsertFree(int[] next, int n) {
        next[n] = next[0];
        next[0] = n;
    }

    public static void InsertSpriteSect(short nSprite, short nSector) {
        short nOldHead;
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        if (nSector < 0 || nSector >= Globals.kMaxSectors) {
            Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
        }
        if ((nOldHead = Engine.headspritesect[nSector]) >= 0) {
            Engine.prevspritesect[nSprite] = Engine.prevspritesect[nOldHead];
            Engine.nextspritesect[nSprite] = -1;
            Engine.nextspritesect[Engine.prevspritesect[nOldHead]] = nSprite;
            Engine.prevspritesect[nOldHead] = nSprite;
        } else {
            Engine.prevspritesect[nSprite] = nSprite;
            Engine.nextspritesect[nSprite] = -1;
            Engine.headspritesect[nSector] = nSprite;
        }
        Engine.sprite[nSprite].sectnum = nSector;
    }

    public static void InsertSpriteStat(short nSprite, short nStat) {
        short nHead;
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        if (!ru.m210projects.Build.Gameutils.isValidStat(nStat)) {
            Main.game.dassert("nStat >= 0 && nStat <= kMaxStatus: " + nStat);
        }
        if ((nHead = Engine.headspritestat[nStat]) >= 0) {
            Engine.nextspritestat[nSprite] = -1;
            Engine.prevspritestat[nSprite] = Engine.prevspritestat[nHead];
            Engine.nextspritestat[Engine.prevspritestat[nHead]] = nSprite;
            Engine.prevspritestat[nHead] = nSprite;
        } else {
            Engine.prevspritestat[nSprite] = nSprite;
            Engine.nextspritestat[nSprite] = -1;
            Engine.headspritestat[nStat] = nSprite;
        }
        Engine.sprite[nSprite].statnum = nStat;
        short s = nStat;
        nStatSize[s] = (short)(nStatSize[s] + 1);
    }

    public static void RemoveSpriteSect(int nSprite) {
        short nSector;
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        if ((nSector = Engine.sprite[nSprite].sectnum) < 0 || nSector >= Globals.kMaxSectors) {
            Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
        }
        if (Engine.nextspritesect[nSprite] >= 0) {
            Engine.prevspritesect[Engine.nextspritesect[nSprite]] = Engine.prevspritesect[nSprite];
        } else {
            if (nSector == -1) {
                Console.Println("RemoveSpriteSect() nSector == -1 crash: " + Engine.sprite[nSprite], Console.OSDTEXT_RED);
                if (Engine.sprite[nSprite] != null) {
                    SPRITE pSprite = Engine.sprite[nSprite];
                    Console.LogPrint("pSprite " + pSprite);
                    if (pSprite.extra > 0) {
                        Console.LogPrint("pSprite " + xsprite[pSprite.extra]);
                    }
                }
            } else if (Engine.headspritesect[nSector] == -1 && Engine.sprite[nSprite] != null) {
                FileResource res;
                SPRITE pSprite = Engine.sprite[nSprite];
                Console.LogPrint("pSprite " + pSprite);
                if (pSprite.extra > 0) {
                    Console.LogPrint("pSprite " + xsprite[pSprite.extra]);
                }
                if (LOADSAVE.lastload != null && !LOADSAVE.lastload.isEmpty() && (res = BuildGdx.compat.open(LOADSAVE.lastload, Compat.Path.User, FileResource.Mode.Read)) != null) {
                    Console.LogPrint("-savedata-\n");
                    Console.LogData(res.getBytes());
                    Console.LogPrint("\n-end savedata-\n");
                    res.close();
                }
            }
            Engine.prevspritesect[Engine.headspritesect[nSector]] = Engine.prevspritesect[nSprite];
        }
        if (Engine.headspritesect[nSector] != nSprite) {
            Engine.nextspritesect[Engine.prevspritesect[nSprite]] = Engine.nextspritesect[nSprite];
        } else {
            Engine.headspritesect[nSector] = Engine.nextspritesect[nSprite];
        }
        Engine.sprite[nSprite].sectnum = (short)-1;
    }

    public static void RemoveSpriteStat(int nSprite) {
        short nStat;
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        if ((nStat = Engine.sprite[nSprite].statnum) < 0 || nStat > 1024) {
            Main.game.dassert("nStat >= 0 && nStat <= kMaxStatus");
        }
        if (Engine.nextspritestat[nSprite] >= 0) {
            Engine.prevspritestat[Engine.nextspritestat[nSprite]] = Engine.prevspritestat[nSprite];
        } else {
            Engine.prevspritestat[Engine.headspritestat[nStat]] = Engine.prevspritestat[nSprite];
        }
        if (Engine.headspritestat[nStat] != nSprite) {
            Engine.nextspritestat[Engine.prevspritestat[nSprite]] = Engine.nextspritestat[nSprite];
        } else {
            Engine.headspritestat[nStat] = Engine.nextspritestat[nSprite];
        }
        Engine.sprite[nSprite].statnum = (short)-1;
        short s = nStat;
        nStatSize[s] = (short)(nStatSize[s] - 1);
    }

    public static void dbInit() {
        int i = 0;
        while (i < 8) {
            if (Warp.gStartZone[i] == null) {
                Warp.gStartZone[i] = new ZONE();
            } else {
                Warp.gStartZone[i].clear();
            }
            ++i;
        }
        i = 0;
        while (i < 2048) {
            if (xsprite[i] == null) {
                DB.xsprite[i] = new XSPRITE();
            } else {
                xsprite[i].free();
            }
            ++i;
        }
        i = 0;
        while (i < 512) {
            if (xwall[i] == null) {
                DB.xwall[i] = new XWALL();
            } else {
                xwall[i].free();
            }
            ++i;
        }
        i = 0;
        while (i < 512) {
            if (xsector[i] == null) {
                DB.xsector[i] = new XSECTOR();
            } else {
                xsector[i].free();
            }
            ++i;
        }
        DB.InitFreeList(nextXSprite, 2048);
        i = 1;
        while (i < 2048) {
            DB.xsprite[i].reference = -1;
            ++i;
        }
        DB.InitFreeList(nextXWall, 512);
        i = 1;
        while (i < 512) {
            DB.xwall[i].reference = -1;
            ++i;
        }
        DB.InitFreeList(nextXSector, 512);
        i = 1;
        while (i < 512) {
            DB.xsector[i].reference = -1;
            ++i;
        }
        DB.initspritelists();
        i = 0;
        while (i < Globals.kMaxSprites) {
            Engine.sprite[i].cstat = (short)128;
            ++i;
        }
    }

    public static void InitFreeList(int[] xlist, int xlistSize) {
        int i = 1;
        while (i < xlistSize) {
            xlist[i] = i - 1;
            ++i;
        }
        xlist[0] = xlistSize - 1;
    }

    public static int RemoveFree(int[] next) {
        int n = next[0];
        next[0] = next[n];
        return n;
    }

    public static byte[] decryptBuffer(byte[] buffer, int size, long key) {
        int i = 0;
        while (i < size) {
            int n = i;
            buffer[n] = (byte)((long)buffer[n] ^ key + (long)i);
            ++i;
        }
        return buffer;
    }

    public static void initspritelists() {
        short i = 0;
        while (i <= Globals.kMaxSectors) {
            Engine.headspritesect[i] = -1;
            i = (short)(i + 1);
        }
        i = 0;
        while (i <= 1024) {
            Engine.headspritestat[i] = -1;
            DB.nStatSize[i] = 0;
            i = (short)(i + 1);
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            if (Engine.sprite[i] == null) {
                Engine.sprite[i] = new SPRITE();
            } else {
                Engine.sprite[i].reset((byte)0);
            }
            Engine.sprite[i].sectnum = (short)-1;
            Engine.sprite[i].xvel = (short)-1;
            DB.InsertSpriteStat(i, (short)1024);
            i = (short)(i + 1);
        }
        Engine.spritesortcnt = 0;
    }

    public static void deletesprite(short nSprite) {
        if (Engine.sprite[nSprite].statnum == 1024 && Engine.sprite[nSprite].sectnum == -1) {
            return;
        }
        if (Engine.sprite[nSprite].extra > 0) {
            DB.dbDeleteXSprite(Engine.sprite[nSprite].extra);
        }
        if (Engine.sprite[nSprite].statnum < 0 || Engine.sprite[nSprite].statnum >= 1024) {
            Console.Println("deletesprite() statnum game.dassert: " + Engine.sprite[nSprite], Console.OSDTEXT_RED);
            Main.game.dassert("sprite[nSprite].statnum >= 0 && sprite[nSprite].statnum < kMaxStatus");
        }
        DB.RemoveSpriteStat(nSprite);
        if (Engine.sprite[nSprite].sectnum < 0 || Engine.sprite[nSprite].sectnum >= Globals.kMaxSectors) {
            Main.game.dassert("sprite[nSprite].sectnum >= 0 && sprite[nSprite].sectnum < kMaxSectors");
        }
        DB.RemoveSpriteSect(nSprite);
        DB.InsertSpriteStat(nSprite, (short)1024);
    }

    public static short insertsprite(short nSector, short nStatus) {
        short nSprite;
        if (Engine.numsprites >= Globals.kMaxSprites) {
            Main.game.dassert("numsprites < kMaxSprites ");
        }
        if ((nSprite = Engine.headspritestat[1024]) < 0) {
            nSprite = Engine.headspritestat[1];
            while ((Engine.sprite[nSprite].hitag & 0x20) != 0 && nSprite != -1) {
                nSprite = Engine.nextspritestat[nSprite];
            }
            if (nSprite == -1) {
                return -1;
            }
            Actor.actDeleteEffect(nSprite);
        }
        if (nSprite >= 0) {
            DB.RemoveSpriteStat(nSprite);
            Engine.sprite[nSprite].reset((byte)0);
            DB.InsertSpriteStat(nSprite, nStatus);
            DB.InsertSpriteSect(nSprite, nSector);
            Engine.sprite[nSprite].cstat = (short)128;
            Engine.sprite[nSprite].clipdist = 32;
            Engine.sprite[nSprite].xrepeat = (short)64;
            Engine.sprite[nSprite].yrepeat = (short)64;
            Engine.sprite[nSprite].owner = (short)-1;
            Engine.sprite[nSprite].extra = (short)-1;
            Engine.sprite[nSprite].xvel = nSprite;
            Actor.sprXVel[nSprite] = 0L;
            Actor.sprYVel[nSprite] = 0L;
            Actor.sprZVel[nSprite] = 0L;
        }
        return nSprite;
    }

    public static short setSprite(int spritenum, long newx, long newy, long newz) {
        Engine.sprite[spritenum].x = (int)newx;
        Engine.sprite[spritenum].y = (int)newy;
        Engine.sprite[spritenum].z = (int)newz;
        short tempsectnum = Main.engine.updatesector((int)newx, (int)newy, Engine.sprite[spritenum].sectnum);
        if (tempsectnum < 0) {
            return -1;
        }
        if (tempsectnum != Engine.sprite[spritenum].sectnum) {
            DB.changespritesect((short)spritenum, tempsectnum);
        }
        return 0;
    }

    public static short changespritesect(short nSprite, short nSector) {
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        if (nSector < 0 || nSector >= Globals.kMaxSectors) {
            Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
        }
        if (Engine.sprite[nSprite].statnum < 0 || Engine.sprite[nSprite].statnum >= 1024) {
            Main.game.dassert("sprite[nSprite].statnum >= 0 && sprite[nSprite].statnum < kMaxStatus");
        }
        if (Engine.sprite[nSprite].sectnum < 0 || Engine.sprite[nSprite].sectnum >= Globals.kMaxSectors) {
            Main.game.dassert("sprite[nSprite].sectnum >= 0 && sprite[nSprite].sectnum < kMaxSectors");
        }
        DB.RemoveSpriteSect(nSprite);
        DB.InsertSpriteSect(nSprite, nSector);
        return 0;
    }

    public static short changespritestat(short nSprite, short nStatus) {
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        if (nStatus < 0 || nStatus > 1024) {
            Main.game.dassert("nStatus >= 0 && nStatus <= kMaxStatus");
        }
        if (Engine.sprite[nSprite].statnum < 0 || Engine.sprite[nSprite].statnum >= 1024) {
            Main.game.dassert("sprite[nSprite].statnum >= 0 && sprite[nSprite].statnum < kMaxStatus");
        }
        if (Engine.sprite[nSprite].sectnum < 0 || Engine.sprite[nSprite].sectnum >= Globals.kMaxSectors) {
            Main.game.dassert("sprite[nSprite].sectnum >= 0 && sprite[nSprite].sectnum < kMaxSectors");
        }
        DB.RemoveSpriteStat(nSprite);
        DB.InsertSpriteStat(nSprite, nStatus);
        return 0;
    }

    public static void InsertPlayer() {
        if (Mmulti.numplayers < 8) {
            Mmulti.connectpoint2[Mmulti.numplayers - 1] = Mmulti.numplayers;
            Mmulti.connectpoint2[Mmulti.numplayers] = -1;
            Main.game.pNet.gNetFifoHead[Mmulti.numplayers] = Main.game.pNet.gNetFifoHead[0];
            PLAYER.playerInit(Mmulti.numplayers, false);
            PLAYER.playerReset(Mmulti.numplayers);
            Globals.gPlayer[Mmulti.numplayers].pDudeInfo = DudeInfo.dudeInfo[Globals.gPlayer[Mmulti.numplayers].pSprite.lotag - 200];
            Globals.gPlayer[Mmulti.numplayers].pSprite = Engine.sprite[Globals.gPlayer[Mmulti.numplayers].nSprite];
            Globals.gPlayer[Mmulti.numplayers].pXsprite = xsprite[Globals.gPlayer[Mmulti.numplayers].pSprite.extra];
            View.gViewIndex = Mmulti.numplayers;
            Globals.gMe = Globals.gPlayer[View.gViewIndex];
            Mmulti.numplayers = (short)(Mmulti.numplayers + 1);
        }
    }

    public static void DeletePlayer() {
        if (Mmulti.numplayers > 1) {
            Mmulti.numplayers = (short)(Mmulti.numplayers - 1);
            Mmulti.connectpoint2[Mmulti.numplayers - 1] = -1;
            DB.deletesprite((short)Globals.gPlayer[Mmulti.numplayers].nSprite);
            if (View.gViewIndex >= Mmulti.numplayers) {
                View.gViewIndex = 0;
                Globals.gMe = Globals.gPlayer[View.gViewIndex];
            }
        }
    }
}

