/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import java.util.Arrays;
import ru.m210projects.Blood.Factory.BloodTextureManager;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Render.GLFog;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Settings.GLSettings;

public class BloodPolymost
extends Polymost {
    private int[] sprites = new int[16];

    public BloodPolymost(Engine engine) {
        super(engine);
        this.orpho.initmap(24, 24, 0, false, false, false);
        this.globalfog = new GLFog(){

            @Override
            public void calc() {
                if (this.combvis == 0.0f) {
                    this.start = 2.9E30f;
                    this.end = 3.0E30f;
                } else if (this.shade >= Engine.numshades - 1) {
                    this.start = -1.0f;
                    this.end = 0.001f;
                } else {
                    this.start = this.shade > 0 ? 0.0f : (float)(-(this.FOGDISTCONST * this.shade)) / this.combvis;
                    this.end = (float)(this.FOGDISTCONST * (Engine.numshades - 1 - this.shade)) / this.combvis;
                }
                this.color[0] = (float)Engine.palookupfog[this.pal][0] / 63.0f;
                this.color[1] = (float)Engine.palookupfog[this.pal][1] / 63.0f;
                this.color[2] = (float)Engine.palookupfog[this.pal][2] / 63.0f;
                this.color[3] = 1.0f;
                if (!(this.pal != 1 || GLInfo.multisample != 0 && GLSettings.usePaletteShader.get().booleanValue())) {
                    this.start = 0.0f;
                    if (this.end > 2.0f) {
                        this.end = 2.0f;
                    }
                }
                if (this.manager.getShader() != null) {
                    this.manager.getShader().setFogParams(true, this.start, this.end, this.color);
                }
                BuildGdx.gl.glFogfv(2918, this.color, 0);
                BuildGdx.gl.glFogf(2915, this.start);
                BuildGdx.gl.glFogf(2916, this.end);
            }
        };
        this.globalfog.setFogScale(64);
    }

    @Override
    public void drawoverheadmap(int cposx, int cposy, int czoom, short cang) {
        Arrays.fill(this.sprites, -1);
        short i = Mmulti.connecthead;
        while (i >= 0) {
            this.sprites[i] = Globals.gPlayer[i].nSprite;
            i = Mmulti.connectpoint2[i];
        }
        this.orpho.setmapsettings(Globals.gFullMap, Globals.pGameInfo.nGameType == 1, Globals.gMapScrollMode, View.gViewIndex, this.sprites);
        this.orpho.drawoverheadmap(cposx, cposy, czoom, cang);
    }

    @Override
    protected void calc_and_apply_fog(int shade, int vis, int pal) {
        if (!this.textureCache.isUseShader(this.globalpicnum)) {
            if (this.rendering == Polymost.Rendering.Sprite && Engine.globalpal == 5 && Engine.globalshade == 127) {
                shade = 0;
            }
            if (Engine.globalpal == 1 || pal == 1) {
                if (this.rendering == Polymost.Rendering.Model) {
                    shade = this.tspriteptr[Polymost.Rendering.Model.getIndex()].shade;
                    if (shade > 0) {
                        shade = Gameutils.BClipRange((int)(2.8f * (float)shade), 32, 52);
                    }
                } else {
                    shade = 0;
                }
            }
        }
        super.calc_and_apply_fog(shade, vis, pal);
    }

    @Override
    public TextureManager newTextureManager(Engine engine) {
        return new BloodTextureManager(engine);
    }
}

