/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.TextureHandle.IndexedTileData;
import ru.m210projects.Build.Render.TextureHandle.PixmapTileData;
import ru.m210projects.Build.Render.TextureHandle.RGBTileData;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;

public class BloodTextureManager
extends TextureManager {
    private GLTile dummy;
    private final float[] pal1_color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public BloodTextureManager(Engine engine) {
        super(engine);
    }

    @Override
    public Color getshadefactor(int shade, int method) {
        if (Polymost.Rendering.Skybox.getIndex() != 0 && Engine.globalpal == 1 && GLInfo.multisample != 0) {
            this.bindBloodPalette(shade);
            return super.getshadefactor(0, 0);
        }
        Color c = super.getshadefactor(shade, method);
        if (Engine.globalpal == 1) {
            c.b = 1.0f;
            c.g = 1.0f;
            c.r = 1.0f;
        }
        return c;
    }

    protected void bindDummyTexture() {
        if (this.dummy == null) {
            this.dummy = new GLTile(new DummyTileData(1, 1), 1, false);
        }
        this.bind(this.dummy);
    }

    @Override
    public void uninit() {
        if (this.dummy != null) {
            this.dummy.delete();
        }
        this.dummy = null;
        super.uninit();
    }

    public void bindBloodPalette(int shade) {
        BuildGdx.gl.glActiveTexture(++this.texunits);
        BuildGdx.gl.glEnable(3553);
        this.bindDummyTexture();
        this.pal1_color[3] = (float)(Engine.numshades - shade) / (float)Engine.numshades + 0.1f;
        BuildGdx.gl.glTexEnvfv(8960, 8705, this.pal1_color, 0);
        BuildGdx.gl.glTexEnvf(8960, 8704, 34160.0f);
        BuildGdx.gl.glTexEnvf(8960, 34161, 34165.0f);
        BuildGdx.gl.glTexEnvf(8960, 34176, 34168.0f);
        BuildGdx.gl.glTexEnvf(8960, 34192, 768.0f);
        BuildGdx.gl.glTexEnvf(8960, 34177, 34166.0f);
        BuildGdx.gl.glTexEnvf(8960, 34193, 768.0f);
        BuildGdx.gl.glTexEnvf(8960, 34178, 34166.0f);
        BuildGdx.gl.glTexEnvf(8960, 34194, 770.0f);
    }

    @Override
    protected TileData loadPic(Hicreplctyp hicr, int dapicnum, int dapalnum, boolean clamping, boolean alpha, int skybox) {
        int expand;
        block4: {
            String fn;
            byte[] data;
            expand = 3;
            if (hicr != null && (data = BuildGdx.cache.getBytes(fn = this.checkResource(hicr, dapicnum, skybox), 0)) != null) {
                try {
                    return new PixmapTileData(new Pixmap(data, 0, data.length), clamping, expand);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (skybox == 0) break block4;
                    return null;
                }
            }
        }
        if (this.shader != null) {
            return new IndexedTileData(this.engine.getTile(dapicnum), clamping, alpha, expand);
        }
        return new RGBTileData(this.engine.getTile(dapicnum), dapalnum, clamping, alpha, expand){

            @Override
            protected int getColor(int dacol, int dapal, boolean alphaMode) {
                if (alphaMode && (dacol &= 0xFF) == 255) {
                    return Engine.curpalette.getRGBA(0, (byte)0);
                }
                if (dacol >= Engine.palookup[dapal].length) {
                    return 0;
                }
                if (dapal == 1) {
                    int shade = Math.min(Math.max(Engine.globalshade, 0), Engine.numshades - 1);
                    dacol = Engine.palookup[dapal][dacol + (shade << 8)] & 0xFF;
                } else {
                    dacol = Engine.palookup[dapal][dacol] & 0xFF;
                }
                return Engine.curpalette.getRGBA(dacol, (byte)-1);
            }
        };
    }
}

