/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;

public class Fire {
    private final short kSize = (short)128;
    private final int kSeedLines = 3;
    private final int kPorchLines = 4;
    private final int kSeedBuffers = 16;
    private final int kPicFire = 2342;
    private final int fireSize = 128;
    private byte[] FrameBuffer;
    private byte[][] SeedBuffer = new byte[16][128];
    private byte[] CoolTable = new byte[1024];
    private final int gDamping = 7;
    private byte[] gCLU;
    private int gFireClock;

    public Fire() throws Exception {
        Console.Println("Initializing dynamic fire");
        BloodTile pic = Main.engine.getTile(2342);
        if (128 != pic.getWidth() && pic.getWidth() != 0 || 128 != pic.getHeight() && pic.getHeight() != 0) {
            throw new Exception("Fire tile size(#2342) is wrong!");
        }
        this.FrameBuffer = new byte[17280];
        this.BuildCoolTable();
        this.InitSeedBuffers();
        this.gCLU = BuildGdx.cache.getBytes("RFIRE.CLU", 0);
        if (this.gCLU == null) {
            throw new Exception("RFIRE.CLU not found");
        }
        int i = 0;
        while (i < 50) {
            this.update();
            ++i;
        }
    }

    public int getPicture() {
        return 2342;
    }

    private void InitSeedBuffers() {
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 128) {
                byte c;
                this.SeedBuffer[i][j + 0] = c = (byte)Gameutils.bRandom();
                this.SeedBuffer[i][j + 1] = c;
                j += 2;
            }
            ++i;
        }
    }

    public void process() {
        if (Engine.totalclock < this.gFireClock || this.gFireClock + 2 < Engine.totalclock) {
            if ((Engine.gotpic[292] & 0x40) != 0) {
                this.update();
            }
            this.gFireClock = Engine.totalclock;
        }
    }

    private void BuildCoolTable() {
        int i = 0;
        while (i < 1024) {
            this.CoolTable[i] = (byte)Gameutils.ClipLow((i - 7) / 4, 0);
            ++i;
        }
    }

    private void update() {
        int nSeed = Gameutils.vRandom() & 0xF;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 128) {
                this.FrameBuffer[(132 + i) * 128 + j] = this.SeedBuffer[nSeed][j];
                ++j;
            }
            ++i;
        }
        this.CellularFrame(this.FrameBuffer, 128, 132);
        byte[] FireData = Main.engine.loadtile(2342);
        if (FireData == null) {
            FireData = new byte[16384];
            BloodTile pic = Main.engine.getTile(2342);
            pic.setWidth(128).setHeight(128);
        }
        this.UpdateTile(this.gCLU, FireData);
    }

    private void CellularFrame(byte[] buff, int cols, int rows) {
        int idx = 0;
        int o = 0;
        int size = rows * cols;
        int pos = 0;
        while (true) {
            int k = 0;
            while (k < 3) {
                o = cols + pos - 1;
                idx = (buff[o + 0] & 0xFF) + (buff[o + 1] & 0xFF) + (buff[o + 2] & 0xFF) + (buff[o + cols + 1] & 0xFF);
                if ((buff[o + cols + 1] & 0xFF) > 96) break;
                buff[pos] = this.CoolTable[idx];
                if (++pos >= size) {
                    return;
                }
                ++k;
            }
            if ((buff[o + cols + 1] & 0xFF) <= 96) continue;
            idx = (idx + (buff[o + cols] & 0xFF) + (buff[o + cols + 1] & 0xFF) + (buff[o + cols + 2] & 0xFF) + (buff[o + cols * 2 + 1] & 0xFF)) / 2;
            buff[pos] = this.CoolTable[idx];
            if (++pos >= size) {
                return;
            }
            o = cols + pos - 1;
            idx = (buff[o + 0] & 0xFF) + (buff[o + 1] & 0xFF) + (buff[o + 2] & 0xFF) + (buff[o + cols + 1] & 0xFF);
            if ((buff[o + cols + 1] & 0xFF) > 96) {
                idx = (idx + (buff[o + cols] & 0xFF) + (buff[o + cols + 1] & 0xFF) + (buff[o + cols + 2] & 0xFF) + (buff[o + cols * 2 + 1] & 0xFF)) / 2;
            }
            buff[pos] = this.CoolTable[idx];
            if (++pos >= size) break;
        }
    }

    private void UpdateTile(byte[] pCLU, byte[] pTile) {
        int k = 0;
        int i = 0;
        while (i < 128) {
            int j = 0;
            while (j < 128) {
                pTile[i + j * 128] = pCLU[this.FrameBuffer[k] & 0xFF];
                ++k;
                ++j;
            }
            ++i;
        }
        Main.engine.invalidatetile(2342, -1, -1);
    }
}

