/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuCorruptGame;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.PriorityQueue.BPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.JPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.PriorityItem;
import ru.m210projects.Blood.RXBUCKET;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.BitHandler;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.LSInfo;
import ru.m210projects.Blood.Types.SafeLoader;
import ru.m210projects.Blood.Types.Seq.CeilingInst;
import ru.m210projects.Blood.Types.Seq.FloorInst;
import ru.m210projects.Blood.Types.Seq.MaskedWallInst;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.SpriteInst;
import ru.m210projects.Blood.Types.Seq.WallInst;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.WALL;

public class LOADSAVE {
    private static SafeLoader loader = new SafeLoader();
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static LSInfo lsInf;
    public static int quickslot;
    public static String lastload;
    public static final String savsign = "BLUD";
    public static final int gdxSave = 300;
    public static final int currentGdxSave = 302;
    public static final int SAVEHEADER = 10;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 16;
    public static final int SAVELEVELINFO = 9;
    public static final int SAVESCREENSHOTSIZE = 64000;
    public static final int SAVEINFO = 43;
    public static final int SAVEGDXDATA = 128;
    public static final char[] filenum;

    static {
        lsInf = new LSInfo();
        quickslot = 0;
        filenum = new char[4];
    }

    public static void FindSaves() {
        FileResource fil = null;
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.User).getFiles().values()) {
            if (!file.getExtension().equals("sav")) continue;
            String name = file.getFile().getName();
            fil = BuildGdx.compat.open(file);
            if (fil == null) continue;
            String signature = fil.readString(4);
            if (signature == null) {
                fil.close();
                continue;
            }
            short nVersion = 0;
            if (signature.equals(savsign)) {
                nVersion = fil.readShort();
                if (nVersion >= 300) {
                    fil.seek(10L, Resource.Whence.Set);
                } else {
                    fil.seek(328L, Resource.Whence.Set);
                }
            } else {
                fil.seek(318L, Resource.Whence.Set);
            }
            long time = 0L;
            if (nVersion >= 301) {
                time = fil.readLong();
            } else {
                String num = name.replaceAll("[^0-9]", "");
                if (!num.isEmpty()) {
                    time = Long.parseLong(num);
                }
            }
            String savname = fil.readString(16).trim();
            Main.game.pSavemgr.add(savname, time, file.getName());
            fil.close();
        }
        Main.game.pSavemgr.sort();
    }

    public static String makeNum(int num) {
        LOADSAVE.filenum[3] = (char)(num % 10 + 48);
        LOADSAVE.filenum[2] = (char)(num / 10 % 10 + 48);
        LOADSAVE.filenum[1] = (char)(num / 100 % 10 + 48);
        LOADSAVE.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static void MapSave(FileResource fil) {
        int mapversion = 7;
        fil.writeInt(mapversion);
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeShort(0);
        fil.writeShort(0);
        fil.writeShort(Engine.numsectors);
        ByteBuffer buffer = ByteBuffer.allocate(Engine.numsectors * 40);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < Engine.numsectors) {
            if (Engine.sector[i] != null) {
                buffer.putShort(Engine.sector[i].wallptr);
                buffer.putShort(Engine.sector[i].wallnum);
                buffer.putInt(Engine.sector[i].ceilingz);
                buffer.putInt(Engine.sector[i].floorz);
                buffer.putShort(Engine.sector[i].ceilingstat);
                buffer.putShort(Engine.sector[i].floorstat);
                buffer.putShort(Engine.sector[i].ceilingpicnum);
                buffer.putShort(Engine.sector[i].ceilingheinum);
                buffer.put(Engine.sector[i].ceilingshade);
                buffer.put((byte)Engine.sector[i].ceilingpal);
                buffer.put((byte)Engine.sector[i].ceilingxpanning);
                buffer.put((byte)Engine.sector[i].ceilingypanning);
                buffer.putShort(Engine.sector[i].floorpicnum);
                buffer.putShort(Engine.sector[i].floorheinum);
                buffer.put(Engine.sector[i].floorshade);
                buffer.put((byte)Engine.sector[i].floorpal);
                buffer.put((byte)Engine.sector[i].floorxpanning);
                buffer.put((byte)Engine.sector[i].floorypanning);
                buffer.put((byte)Engine.sector[i].visibility);
                buffer.put((byte)Engine.sector[i].filler);
                buffer.putShort(Engine.sector[i].lotag);
                buffer.putShort(Engine.sector[i].hitag);
                buffer.putShort(Engine.sector[i].extra);
            }
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.numwalls);
        buffer = ByteBuffer.allocate(Engine.numwalls * 32);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Engine.numwalls) {
            if (Engine.wall[i] != null) {
                buffer.putInt(Engine.wall[i].x);
                buffer.putInt(Engine.wall[i].y);
                buffer.putShort(Engine.wall[i].point2);
                buffer.putShort(Engine.wall[i].nextwall);
                buffer.putShort(Engine.wall[i].nextsector);
                buffer.putShort(Engine.wall[i].cstat);
                buffer.putShort(Engine.wall[i].picnum);
                buffer.putShort(Engine.wall[i].overpicnum);
                buffer.put(Engine.wall[i].shade);
                buffer.put((byte)Engine.wall[i].pal);
                buffer.put((byte)Engine.wall[i].xrepeat);
                buffer.put((byte)Engine.wall[i].yrepeat);
                buffer.put((byte)Engine.wall[i].xpanning);
                buffer.put((byte)Engine.wall[i].ypanning);
                buffer.putShort(Engine.wall[i].lotag);
                buffer.putShort(Engine.wall[i].hitag);
                buffer.putShort(Engine.wall[i].extra);
            }
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        int pos = fil.position();
        fil.writeShort(0);
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 44);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int spritenum = 0;
        int i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            if (Engine.sprite[i2].statnum != 1024) {
                buffer.putInt(Engine.sprite[i2].x);
                buffer.putInt(Engine.sprite[i2].y);
                buffer.putInt(Engine.sprite[i2].z);
                buffer.putShort(Engine.sprite[i2].cstat);
                buffer.putShort(Engine.sprite[i2].picnum);
                buffer.put(Engine.sprite[i2].shade);
                buffer.put((byte)Engine.sprite[i2].pal);
                buffer.put((byte)Engine.sprite[i2].clipdist);
                buffer.put((byte)Engine.sprite[i2].detail);
                buffer.put((byte)Engine.sprite[i2].xrepeat);
                buffer.put((byte)Engine.sprite[i2].yrepeat);
                buffer.put((byte)Engine.sprite[i2].xoffset);
                buffer.put((byte)Engine.sprite[i2].yoffset);
                buffer.putShort(Engine.sprite[i2].sectnum);
                buffer.putShort(Engine.sprite[i2].statnum);
                buffer.putShort(Engine.sprite[i2].ang);
                buffer.putShort(Engine.sprite[i2].owner);
                buffer.putShort(Engine.sprite[i2].xvel);
                buffer.putShort(Engine.sprite[i2].yvel);
                buffer.putShort(Engine.sprite[i2].zvel);
                buffer.putShort(Engine.sprite[i2].lotag);
                buffer.putShort(Engine.sprite[i2].hitag);
                buffer.putShort(Engine.sprite[i2].extra);
                ++spritenum;
            }
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.seek(pos, Resource.Whence.Set);
        fil.writeShort(spritenum);
        fil.close();
    }

    public static int savegame(String savename, String filename) {
        File file = BuildGdx.compat.checkFile(filename, Compat.Path.User);
        if (file != null && !file.delete()) {
            View.viewSetMessage("Game not saved. Access denied!", -1);
            return -1;
        }
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Write);
        if (fil != null) {
            long time = Main.game.date.getCurrentDate();
            LOADSAVE.save(fil, savename, time);
            Main.game.pSavemgr.add(savename, time, filename);
            lastload = filename;
            View.viewSetMessage("Game saved", -1);
            return 0;
        }
        View.viewSetMessage("Game not saved. Access denied!", -1);
        return -1;
    }

    private static void save(FileResource fil, String savename, long time) {
        LOADSAVE.SaveVersion(fil, 302);
        LOADSAVE.SaveInfo(fil, savename, time);
        LOADSAVE.SaveGDXBlock(fil);
        LOADSAVE.MySave110(fil, savename, 0);
        LOADSAVE.DudesSave(fil);
        fil.writeByte(Globals.cheatsOn ? 1 : 0);
        LOADSAVE.WarpSave(fil);
        LOADSAVE.MirrorSave(fil);
        LOADSAVE.SeqSave(fil);
        LOADSAVE.EventSave(fil);
        LOADSAVE.TriggersSave(fil);
        LOADSAVE.PlayersSave(fil, 277);
        LOADSAVE.ActorsSave(fil);
        LOADSAVE.GameInfoSave(fil, savename, 0);
        LOADSAVE.StatsSave(fil);
        LOADSAVE.ScreenSave(fil);
        fil.close();
        System.gc();
    }

    public static void SaveInfo(FileResource fil, String savename, long time) {
        byte[] buf = new byte[8];
        LittleEndian.putLong(buf, 0, time);
        fil.writeBytes(buf, 8);
        fil.writeBytes(savename.toCharArray(), 16);
        fil.writeByte(Globals.pGameInfo.nDifficulty);
        fil.writeInt(Globals.pGameInfo.nEpisode);
        fil.writeInt(Globals.pGameInfo.nLevel);
        LOADSAVE.SaveScreenshot(fil);
        LOADSAVE.SaveUserEpisodeInfo(fil);
    }

    public static void SaveGDXBlock(FileResource fil) {
        ByteBuffer buffer = ByteBuffer.allocate(128);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)Globals.pGameInfo.nEnemyDamage);
        buffer.put((byte)Globals.pGameInfo.nEnemyQuantity);
        buffer.put((byte)Globals.pGameInfo.nDifficulty);
        buffer.put((byte)(Globals.pGameInfo.nPitchforkOnly ? 1 : 0));
        buffer.put((byte)(Globals.gInfiniteAmmo ? 1 : 0));
        fil.writeBytes(buffer.array(), 128);
    }

    public static void SaveUserEpisodeInfo(FileResource fil) {
        fil.writeByte(Main.mUserFlag == Main.UserFlag.Addon ? 1 : 0);
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            if (LEVELS.currentEpisode != null && LEVELS.currentEpisode.filename != null) {
                String dir = LEVELS.currentEpisode.getDirectory().getRelativePath();
                String filename = LEVELS.currentEpisode.filename;
                if (dir != null && !dir.isEmpty()) {
                    filename = String.valueOf(dir) + File.separator + filename;
                }
                fil.writeBytes(filename.toCharArray(), 144);
            } else {
                fil.writeBytes(new byte[144], 144);
            }
        }
    }

    public static void SaveScreenshot(FileResource fil) {
        fil.writeBytes(Main.gGameScreen.captBuffer, 64000);
        Main.gGameScreen.captBuffer = null;
    }

    public static void SaveVersion(FileResource fil, int nVersion) {
        fil.writeBytes(savsign.toCharArray(), 4);
        fil.writeShort(nVersion);
        fil.writeInt(4);
    }

    public static void MySave110(FileResource fil, String pName, int nSaveGameSlot) {
        int kMaxTiles = 6144;
        fil.writeByte(Globals.pGameInfo.nGameType);
        fil.writeByte(Globals.pGameInfo.nDifficulty);
        fil.writeInt(Globals.pGameInfo.nEpisode);
        fil.writeInt(Globals.pGameInfo.nLevel);
        fil.writeBytes(Globals.pGameInfo.zLevelName.toCharArray(), 144);
        if (Globals.pGameInfo.zLevelSong != null) {
            fil.writeBytes(Globals.pGameInfo.zLevelSong.toCharArray(), 144);
        } else {
            fil.writeBytes(new byte[144], 144);
        }
        fil.writeInt(Globals.pGameInfo.nTrackNumber);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeShort(nSaveGameSlot);
        fil.writeInt(0);
        fil.writeInt((int)Globals.pGameInfo.uMapCRC);
        fil.writeByte(Globals.pGameInfo.nMonsterSettings);
        fil.writeInt(Globals.pGameInfo.uGameFlags);
        fil.writeInt(Globals.pGameInfo.uNetGameFlags);
        fil.writeByte(Globals.pGameInfo.nWeaponSettings);
        fil.writeByte(Globals.pGameInfo.nItemSettings);
        fil.writeByte(Globals.pGameInfo.nRespawnSettings);
        fil.writeByte(Globals.pGameInfo.nTeamSettings);
        fil.writeInt(Globals.pGameInfo.nMonsterRespawnTime);
        fil.writeInt(Globals.pGameInfo.nWeaponRespawnTime);
        fil.writeInt(Globals.pGameInfo.nItemRespawnTime);
        fil.writeInt(Globals.pGameInfo.nSpecialRespawnTime);
        fil.writeShort(Engine.numsectors);
        fil.writeShort(Engine.numwalls);
        fil.writeInt(Engine.numsprites);
        ByteBuffer buffer = ByteBuffer.allocate(Engine.numsectors * 40);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < Engine.numsectors) {
            if (Engine.sector[i] != null) {
                buffer.putShort(Engine.sector[i].wallptr);
                buffer.putShort(Engine.sector[i].wallnum);
                buffer.putInt(Engine.sector[i].ceilingz);
                buffer.putInt(Engine.sector[i].floorz);
                buffer.putShort(Engine.sector[i].ceilingstat);
                buffer.putShort(Engine.sector[i].floorstat);
                buffer.putShort(Engine.sector[i].ceilingpicnum);
                buffer.putShort(Engine.sector[i].ceilingheinum);
                buffer.put(Engine.sector[i].ceilingshade);
                buffer.put((byte)Engine.sector[i].ceilingpal);
                buffer.put((byte)Engine.sector[i].ceilingxpanning);
                buffer.put((byte)Engine.sector[i].ceilingypanning);
                buffer.putShort(Engine.sector[i].floorpicnum);
                buffer.putShort(Engine.sector[i].floorheinum);
                buffer.put(Engine.sector[i].floorshade);
                buffer.put((byte)Engine.sector[i].floorpal);
                buffer.put((byte)Engine.sector[i].floorxpanning);
                buffer.put((byte)Engine.sector[i].floorypanning);
                buffer.put((byte)Engine.sector[i].visibility);
                buffer.put((byte)Engine.sector[i].filler);
                buffer.putShort(Engine.sector[i].lotag);
                buffer.putShort(Engine.sector[i].hitag);
                buffer.putShort(Engine.sector[i].extra);
            }
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Engine.numwalls * 32);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Engine.numwalls) {
            if (Engine.wall[i] != null) {
                buffer.putInt(Engine.wall[i].x);
                buffer.putInt(Engine.wall[i].y);
                buffer.putShort(Engine.wall[i].point2);
                buffer.putShort(Engine.wall[i].nextwall);
                buffer.putShort(Engine.wall[i].nextsector);
                buffer.putShort(Engine.wall[i].cstat);
                buffer.putShort(Engine.wall[i].picnum);
                buffer.putShort(Engine.wall[i].overpicnum);
                buffer.put(Engine.wall[i].shade);
                buffer.put((byte)Engine.wall[i].pal);
                buffer.put((byte)Engine.wall[i].xrepeat);
                buffer.put((byte)Engine.wall[i].yrepeat);
                buffer.put((byte)Engine.wall[i].xpanning);
                buffer.put((byte)Engine.wall[i].ypanning);
                buffer.putShort(Engine.wall[i].lotag);
                buffer.putShort(Engine.wall[i].hitag);
                buffer.putShort(Engine.wall[i].extra);
            }
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 44);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Globals.kMaxSprites) {
            buffer.putInt(Engine.sprite[i].x);
            buffer.putInt(Engine.sprite[i].y);
            buffer.putInt(Engine.sprite[i].z);
            buffer.putShort(Engine.sprite[i].cstat);
            buffer.putShort(Engine.sprite[i].picnum);
            buffer.put(Engine.sprite[i].shade);
            buffer.put((byte)Engine.sprite[i].pal);
            buffer.put((byte)Engine.sprite[i].clipdist);
            buffer.put((byte)Engine.sprite[i].detail);
            buffer.put((byte)Engine.sprite[i].xrepeat);
            buffer.put((byte)Engine.sprite[i].yrepeat);
            buffer.put((byte)Engine.sprite[i].xoffset);
            buffer.put((byte)Engine.sprite[i].yoffset);
            buffer.putShort(Engine.sprite[i].sectnum);
            buffer.putShort(Engine.sprite[i].statnum);
            buffer.putShort(Engine.sprite[i].ang);
            buffer.putShort(Engine.sprite[i].owner);
            buffer.putShort(Engine.sprite[i].xvel);
            buffer.putShort(Engine.sprite[i].yvel);
            buffer.putShort(Engine.sprite[i].zvel);
            buffer.putShort(Engine.sprite[i].lotag);
            buffer.putShort(Engine.sprite[i].hitag);
            buffer.putShort(Engine.sprite[i].extra);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(Gameutils.bseed);
        fil.writeByte(0);
        fil.writeByte(Engine.showinvisibility ? 1 : 0);
        fil.writeInt(0);
        fil.writeInt(Engine.parallaxyscale);
        fil.writeInt(Engine.visibility);
        fil.writeInt(Engine.parallaxvisibility);
        buffer = ByteBuffer.allocate(512);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < 256) {
            buffer.putShort(Engine.pskyoff[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.pskybits);
        buffer = ByteBuffer.allocate((Globals.kMaxSectors + 1) * 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i <= Globals.kMaxSectors) {
            buffer.putShort(Engine.headspritesect[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i <= 1024) {
            buffer.putShort(Engine.headspritestat[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Globals.kMaxSprites) {
            buffer.putShort(Engine.prevspritesect[i]);
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            buffer.putShort(Engine.prevspritestat[i]);
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            buffer.putShort(Engine.nextspritesect[i]);
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            buffer.putShort(Engine.nextspritestat[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeBytes(Engine.show2dsector, Engine.show2dsector.length);
        fil.writeBytes(Engine.show2dwall, 1024);
        fil.writeBytes(Engine.show2dsprite, Engine.show2dsprite.length);
        fil.writeByte(Engine.automapping);
        fil.writeBytes(Engine.gotpic, kMaxTiles + 7 >> 3);
        fil.writeBytes(Engine.gotsector, Engine.gotsector.length);
        fil.writeInt(Globals.gFrameClock);
        fil.writeInt(Globals.gTicks);
        fil.writeInt(Globals.gFrame);
        fil.writeInt(Engine.totalclock);
        fil.writeByte(Main.game.gPaused ? 1 : 0);
        fil.writeByte(0);
        buffer = ByteBuffer.allocate(Engine.numwalls * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Engine.numwalls) {
            buffer.putInt((int)Trigger.kwall[i].x);
            buffer.putInt((int)Trigger.kwall[i].y);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Engine.numsprites * 12);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Engine.numsprites) {
            buffer.putInt((int)Trigger.ksprite[i].x);
            buffer.putInt((int)Trigger.ksprite[i].y);
            buffer.putInt((int)Trigger.ksprite[i].z);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Engine.numsectors * 16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Engine.numsectors) {
            buffer.putInt(Trigger.secFloorZ[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.numsectors) {
            buffer.putInt(Trigger.secCeilZ[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.numsectors) {
            buffer.putInt((int)Actor.floorVel[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.numsectors) {
            buffer.putInt((int)Actor.ceilingVel[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.pHitInfo.hitsect);
        fil.writeShort(Engine.pHitInfo.hitwall);
        fil.writeShort(Engine.pHitInfo.hitsprite);
        fil.writeInt(Engine.pHitInfo.hitx);
        fil.writeInt(Engine.pHitInfo.hity);
        fil.writeInt(Engine.pHitInfo.hitz);
        fil.writeByte(Main.mUserFlag == Main.UserFlag.UserMap ? 1 : 0);
        fil.writeByte(1);
        fil.writeByte(1);
        buffer = ByteBuffer.allocate(128);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        String copyright = "Copyright 1997 Monolith Productions.";
        buffer.put(copyright.getBytes());
        fil.writeBytes(buffer.array(), 128);
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i2 = 0;
        while (i2 <= 1024) {
            buffer.putShort(DB.nStatSize[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(4096);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < 2048) {
            buffer.putShort((short)DB.nextXSprite[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < 512) {
            buffer.putShort((short)DB.nextXWall[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < 512) {
            buffer.putShort((short)DB.nextXSector[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        byte[] data = new byte[Globals.kMaxSprites * 56];
        int nXSprite = 0;
        int i3 = 0;
        while (i3 < Globals.kMaxSprites) {
            if (Engine.sprite[i3].statnum < 1024 && Engine.sprite[i3].extra > 0) {
                BitHandler.bput(data, 0 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].reference, 0, 13);
                BitHandler.bput(data, 1 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].state, 6, 6);
                BitHandler.bput(data, 1 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].busy, 7, 23);
                BitHandler.bput(data, 4 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].txID, 0, 9);
                BitHandler.bput(data, 5 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].rxID, 2, 11);
                BitHandler.bput(data, 6 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].command, 4, 11);
                BitHandler.bput(data, 7 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].triggerOn ? 1 : 0, 4, 4);
                BitHandler.bput(data, 7 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].triggerOff ? 1 : 0, 5, 5);
                BitHandler.bput(data, 7 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].wave, 6, 7);
                BitHandler.bput(data, 8 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].busyTime, 0, 11);
                BitHandler.bput(data, 9 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].waitTime, 4, 15);
                BitHandler.bput(data, 11 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].restState, 0, 0);
                BitHandler.bput(data, 11 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Interrutable ? 1 : 0, 1, 1);
                BitHandler.bput(data, 11 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].respawnPending, 4, 6);
                BitHandler.bput(data, 11 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].lT ? 1 : 0, 7, 7);
                BitHandler.bput(data, 12 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].dropMsg, 0, 7);
                BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Decoupled ? 1 : 0, 0, 0);
                BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].triggerOnce ? 1 : 0, 1, 1);
                BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].isTriggered ? 1 : 0, 2, 2);
                BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].key, 3, 5);
                BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Push ? 1 : 0, 6, 6);
                BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Vector ? 1 : 0, 7, 7);
                BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Impact ? 1 : 0, 0, 0);
                BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Pickup ? 1 : 0, 1, 1);
                BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Touch ? 1 : 0, 2, 2);
                BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Sight ? 1 : 0, 3, 3);
                BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Proximity ? 1 : 0, 4, 4);
                BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].l1, 7, 7);
                BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].l2, 0, 0);
                BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].l3, 1, 1);
                BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].l4, 2, 2);
                BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].l5, 3, 3);
                BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].lS ? 1 : 0, 4, 4);
                BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].lB ? 1 : 0, 5, 5);
                BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].lC ? 1 : 0, 6, 6);
                BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].DudeLockout ? 1 : 0, 7, 7);
                BitHandler.bput(data, 16 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].data1, 0, 15);
                BitHandler.bput(data, 18 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].data2, 0, 15);
                BitHandler.bput(data, 20 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].data3, 0, 15);
                BitHandler.bput(data, 22 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].goalAng, 0, 10);
                BitHandler.bput(data, 23 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].dodgeDir, 3, 4);
                BitHandler.bput(data, 23 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].Locked, 5, 5);
                BitHandler.bput(data, 23 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].palette, 6, 7);
                BitHandler.bput(data, 24 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].respawn, 0, 1);
                BitHandler.bput(data, 24 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].data4, 2, 17);
                BitHandler.bput(data, 26 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].moveState, 2, 7);
                BitHandler.bput(data, 27 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].lockMsg, 0, 7);
                BitHandler.bput(data, 28 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].health, 0, 11);
                BitHandler.bput(data, 29 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].dudeDeaf ? 1 : 0, 4, 4);
                BitHandler.bput(data, 29 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].dudeAmbush ? 1 : 0, 5, 5);
                BitHandler.bput(data, 29 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].dudeGuard ? 1 : 0, 6, 6);
                BitHandler.bput(data, 29 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].dudeFlag4 ? 1 : 0, 7, 7);
                BitHandler.bput(data, 30 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].target, 0, 15);
                BitHandler.bput(data, 32 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].targetX, 0, 31);
                BitHandler.bput(data, 36 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].targetY, 0, 31);
                BitHandler.bput(data, 40 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].targetZ, 0, 31);
                BitHandler.bput(data, 44 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].burnTime, 0, 15);
                BitHandler.bput(data, 46 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].burnSource, 0, 15);
                BitHandler.bput(data, 48 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].height, 0, 15);
                BitHandler.bput(data, 50 + nXSprite * 56, DB.xsprite[Engine.sprite[i3].extra].stateTimer, 0, 15);
                BitHandler.bput(data, 52 + nXSprite * 56, 0, 0, 31);
                ++nXSprite;
            }
            ++i3;
        }
        fil.writeBytes(data, nXSprite * 56);
        data = new byte[Engine.numwalls * XWALL.sizeof];
        int nXWall = 0;
        int i4 = 0;
        while (i4 < Engine.numwalls) {
            if (Engine.wall[i4].extra > 0) {
                BitHandler.bput(data, 0 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].reference, 0, 13);
                BitHandler.bput(data, 1 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].state, 6, 6);
                BitHandler.bput(data, 1 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].busy, 7, 23);
                BitHandler.bput(data, 4 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].data, 0, 15);
                BitHandler.bput(data, 6 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].txID, 0, 9);
                BitHandler.bput(data, 8 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].rxID, 0, 9);
                BitHandler.bput(data, 9 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].command, 2, 9);
                BitHandler.bput(data, 10 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].triggerOn ? 1 : 0, 2, 2);
                BitHandler.bput(data, 10 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].triggerOff ? 1 : 0, 3, 3);
                BitHandler.bput(data, 10 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].busyTime, 4, 15);
                BitHandler.bput(data, 12 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].waitTime, 0, 11);
                BitHandler.bput(data, 13 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].restState, 4, 4);
                BitHandler.bput(data, 13 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].interruptable ? 1 : 0, 5, 5);
                BitHandler.bput(data, 13 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].panAlways ? 1 : 0, 6, 6);
                BitHandler.bput(data, 13 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].panXVel, 7, 14);
                BitHandler.bput(data, 14 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].panYVel, 7, 14);
                BitHandler.bput(data, 15 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].decoupled ? 1 : 0, 7, 7);
                BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].triggerOnce ? 1 : 0, 0, 0);
                BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].isTriggered ? 1 : 0, 1, 1);
                BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].key, 2, 4);
                BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].triggerPush ? 1 : 0, 5, 5);
                BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].triggerVector ? 1 : 0, 6, 6);
                BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].triggerReserved ? 1 : 0, 7, 7);
                BitHandler.bput(data, 17 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].xpanFrac, 0, 7);
                BitHandler.bput(data, 18 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].ypanFrac, 0, 7);
                BitHandler.bput(data, 19 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].locked, 2, 2);
                BitHandler.bput(data, 19 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i4].extra].dudeLockout ? 1 : 0, 3, 3);
                ++nXWall;
            }
            ++i4;
        }
        fil.writeBytes(data, nXWall * XWALL.sizeof);
        data = new byte[Engine.numsectors * XSECTOR.sizeof];
        int nXSector = 0;
        int i5 = 0;
        while (i5 < Engine.numsectors) {
            if (Engine.sector[i5].extra > 0) {
                BitHandler.bput(data, 0 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].reference, 0, 13);
                BitHandler.bput(data, 1 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].state, 6, 6);
                BitHandler.bput(data, 1 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].busy, 7, 23);
                BitHandler.bput(data, 4 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].data, 0, 15);
                BitHandler.bput(data, 6 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].txID, 0, 9);
                BitHandler.bput(data, 7 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].waveTime[1], 2, 3);
                BitHandler.bput(data, 7 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].waveTime[0], 5, 6);
                BitHandler.bput(data, 8 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].rxID, 0, 9);
                BitHandler.bput(data, 9 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].command, 2, 9);
                BitHandler.bput(data, 10 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].triggerOn ? 1 : 0, 2, 2);
                BitHandler.bput(data, 10 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].triggerOff ? 1 : 0, 3, 3);
                BitHandler.bput(data, 10 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].busyTime[1], 4, 15);
                BitHandler.bput(data, 12 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].waitTime[1], 0, 11);
                BitHandler.bput(data, 13 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].interruptable ? 1 : 0, 5, 5);
                BitHandler.bput(data, 13 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].amplitude, 6, 13);
                BitHandler.bput(data, 14 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].freq, 6, 13);
                BitHandler.bput(data, 15 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].waitFlag[1] ? 1 : 0, 6, 6);
                BitHandler.bput(data, 15 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].waitFlag[0] ? 1 : 0, 7, 7);
                BitHandler.bput(data, 16 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].phase, 0, 7);
                BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].wave, 0, 3);
                BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].shadeAlways ? 1 : 0, 4, 4);
                BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].shadeFloor ? 1 : 0, 5, 5);
                BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].shadeCeiling ? 1 : 0, 6, 6);
                BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].shadeWalls ? 1 : 0, 7, 7);
                BitHandler.bput(data, 18 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].shade, 0, 7);
                BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].panAlways ? 1 : 0, 0, 0);
                BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].panFloor ? 1 : 0, 1, 1);
                BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].panCeiling ? 1 : 0, 2, 2);
                BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Drag ? 1 : 0, 3, 3);
                BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Underwater ? 1 : 0, 4, 4);
                BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Depth, 5, 7);
                BitHandler.bput(data, 20 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].panVel, 0, 7);
                BitHandler.bput(data, 21 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].panAngle, 0, 10);
                BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].wind ? 1 : 0, 3, 3);
                BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].decoupled ? 1 : 0, 4, 4);
                BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].triggerOnce ? 1 : 0, 5, 5);
                BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].isTriggered ? 1 : 0, 6, 6);
                BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Key, 7, 9);
                BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Push ? 1 : 0, 2, 2);
                BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Vector ? 1 : 0, 3, 3);
                BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Reserved ? 1 : 0, 4, 4);
                BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Enter ? 1 : 0, 5, 5);
                BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Exit ? 1 : 0, 6, 6);
                BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Wallpush ? 1 : 0, 7, 7);
                BitHandler.bput(data, 24 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].color ? 1 : 0, 0, 0);
                BitHandler.bput(data, 24 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].busyTime[0], 2, 9);
                BitHandler.bput(data, 25 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].waitTime[0], 6, 13);
                BitHandler.bput(data, 27 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].ceilpal, 4, 7);
                BitHandler.bput(data, 28 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].offCeilZ, 0, 31);
                BitHandler.bput(data, 32 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].onCeilZ, 0, 31);
                BitHandler.bput(data, 36 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].offFloorZ, 0, 31);
                BitHandler.bput(data, 40 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].onFloorZ, 0, 31);
                BitHandler.bput(data, 44 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].marker0, 0, 15);
                BitHandler.bput(data, 46 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].marker1, 0, 15);
                BitHandler.bput(data, 48 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].Crush ? 1 : 0, 0, 0);
                BitHandler.bput(data, 48 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].ceilxpanFrac, 1, 8);
                BitHandler.bput(data, 49 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].ceilypanFrac, 1, 8);
                BitHandler.bput(data, 50 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].floorxpanFrac, 1, 8);
                BitHandler.bput(data, 51 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].damageType, 1, 3);
                BitHandler.bput(data, 51 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].floorpal, 4, 7);
                BitHandler.bput(data, 52 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].floorypanFrac, 0, 7);
                BitHandler.bput(data, 53 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].locked, 0, 0);
                BitHandler.bput(data, 53 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].windVel, 1, 10);
                BitHandler.bput(data, 54 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].windAng, 3, 13);
                BitHandler.bput(data, 55 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].windAlways ? 1 : 0, 6, 6);
                BitHandler.bput(data, 55 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].dudelockout ? 1 : 0, 7, 7);
                BitHandler.bput(data, 56 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].bobTheta, 0, 10);
                BitHandler.bput(data, 57 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].bobZRange, 3, 7);
                BitHandler.bput(data, 58 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].bobSpeed, 0, 11);
                BitHandler.bput(data, 59 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].bobAlways ? 1 : 0, 4, 4);
                BitHandler.bput(data, 59 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].bobFloor ? 1 : 0, 5, 5);
                BitHandler.bput(data, 59 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].bobCeiling ? 1 : 0, 6, 6);
                BitHandler.bput(data, 59 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i5].extra].bobRotate ? 1 : 0, 7, 7);
                ++nXSector;
            }
            ++i5;
        }
        fil.writeBytes(data, nXSector * XSECTOR.sizeof);
        buffer = ByteBuffer.allocate(Engine.numsprites * 12);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i5 = 0;
        while (i5 < Engine.numsprites) {
            buffer.putInt((int)Actor.sprXVel[i5]);
            ++i5;
        }
        i5 = 0;
        while (i5 < Engine.numsprites) {
            buffer.putInt((int)Actor.sprYVel[i5]);
            ++i5;
        }
        i5 = 0;
        while (i5 < Engine.numsprites) {
            buffer.putInt((int)Actor.sprZVel[i5]);
            ++i5;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeInt(DB.gSkyCount);
        fil.writeByte(Globals.gFogMode ? 1 : 0);
    }

    public static void MySave100(FileResource fil, String pName, int nSaveGameSlot) {
        fil.writeByte(Globals.pGameInfo.nGameType);
        fil.writeByte(Globals.pGameInfo.nDifficulty);
        fil.writeInt(Globals.pGameInfo.nEpisode);
        fil.writeInt(Globals.pGameInfo.nLevel);
        fil.writeBytes(Globals.pGameInfo.zLevelName.toCharArray(), 144);
        if (Globals.pGameInfo.zLevelSong != null) {
            fil.writeBytes(Globals.pGameInfo.zLevelSong.toCharArray(), 144);
        } else {
            fil.writeBytes(new byte[144], 144);
        }
        fil.writeInt(Globals.pGameInfo.nTrackNumber);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeShort(nSaveGameSlot);
        fil.writeInt(0);
        fil.writeInt((int)Globals.pGameInfo.uMapCRC);
        fil.writeByte(Globals.pGameInfo.nMonsterSettings);
        fil.writeInt(Globals.pGameInfo.uGameFlags);
        fil.writeInt(Globals.pGameInfo.uNetGameFlags);
        fil.writeByte(Globals.pGameInfo.nWeaponSettings);
        fil.writeByte(Globals.pGameInfo.nItemSettings);
        fil.writeByte(Globals.pGameInfo.nRespawnSettings);
        fil.writeByte(Globals.pGameInfo.nTeamSettings);
        fil.writeInt(Globals.pGameInfo.nMonsterRespawnTime);
        fil.writeInt(Globals.pGameInfo.nWeaponRespawnTime);
        fil.writeInt(Globals.pGameInfo.nItemRespawnTime);
        fil.writeInt(Globals.pGameInfo.nSpecialRespawnTime);
        fil.writeInt(Globals.gFrameClock);
        fil.writeInt(Globals.gTicks);
        fil.writeInt(Globals.gFrame);
        fil.writeInt(Engine.totalclock);
        fil.writeByte(Main.game.gPaused ? 1 : 0);
        fil.writeByte(0);
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 8192) {
            buffer.putInt((int)Trigger.kwall[i].x);
            buffer.putInt((int)Trigger.kwall[i].y);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 12);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Globals.kMaxSprites) {
            buffer.putInt((int)Trigger.ksprite[i].x);
            buffer.putInt((int)Trigger.ksprite[i].y);
            buffer.putInt((int)Trigger.ksprite[i].z);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Globals.kMaxSectors) {
            buffer.putInt(Trigger.secFloorZ[i]);
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            buffer.putInt(Trigger.secCeilZ[i]);
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            buffer.putInt((int)Actor.floorVel[i]);
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            buffer.putInt((int)Actor.ceilingVel[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.pHitInfo.hitsect);
        fil.writeShort(Engine.pHitInfo.hitwall);
        fil.writeShort(Engine.pHitInfo.hitsprite);
        fil.writeInt(Engine.pHitInfo.hitx);
        fil.writeInt(Engine.pHitInfo.hity);
        fil.writeInt(Engine.pHitInfo.hitz);
        fil.writeByte(Main.mUserFlag == Main.UserFlag.UserMap ? 1 : 0);
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i <= 1024) {
            buffer.putShort(DB.nStatSize[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        byte[] data = new byte[114688];
        int i2 = 0;
        while (i2 < 2048) {
            if (DB.xsprite[i2] != null) {
                BitHandler.bput(data, 0 + i2 * 56, DB.xsprite[i2].reference, 0, 13);
                BitHandler.bput(data, 1 + i2 * 56, DB.xsprite[i2].state, 6, 6);
                BitHandler.bput(data, 1 + i2 * 56, DB.xsprite[i2].busy, 7, 23);
                BitHandler.bput(data, 4 + i2 * 56, DB.xsprite[i2].txID, 0, 9);
                BitHandler.bput(data, 5 + i2 * 56, DB.xsprite[i2].rxID, 2, 11);
                BitHandler.bput(data, 6 + i2 * 56, DB.xsprite[i2].command, 4, 11);
                BitHandler.bput(data, 7 + i2 * 56, DB.xsprite[i2].triggerOn ? 1 : 0, 4, 4);
                BitHandler.bput(data, 7 + i2 * 56, DB.xsprite[i2].triggerOff ? 1 : 0, 5, 5);
                BitHandler.bput(data, 7 + i2 * 56, DB.xsprite[i2].wave, 6, 7);
                BitHandler.bput(data, 8 + i2 * 56, DB.xsprite[i2].busyTime, 0, 11);
                BitHandler.bput(data, 9 + i2 * 56, DB.xsprite[i2].waitTime, 4, 15);
                BitHandler.bput(data, 11 + i2 * 56, DB.xsprite[i2].restState, 0, 0);
                BitHandler.bput(data, 11 + i2 * 56, DB.xsprite[i2].Interrutable ? 1 : 0, 1, 1);
                BitHandler.bput(data, 11 + i2 * 56, DB.xsprite[i2].respawnPending, 4, 6);
                BitHandler.bput(data, 11 + i2 * 56, DB.xsprite[i2].lT ? 1 : 0, 7, 7);
                BitHandler.bput(data, 12 + i2 * 56, DB.xsprite[i2].dropMsg, 0, 7);
                BitHandler.bput(data, 13 + i2 * 56, DB.xsprite[i2].Decoupled ? 1 : 0, 0, 0);
                BitHandler.bput(data, 13 + i2 * 56, DB.xsprite[i2].triggerOnce ? 1 : 0, 1, 1);
                BitHandler.bput(data, 13 + i2 * 56, DB.xsprite[i2].isTriggered ? 1 : 0, 2, 2);
                BitHandler.bput(data, 13 + i2 * 56, DB.xsprite[i2].key, 3, 5);
                BitHandler.bput(data, 13 + i2 * 56, DB.xsprite[i2].Push ? 1 : 0, 6, 6);
                BitHandler.bput(data, 13 + i2 * 56, DB.xsprite[i2].Vector ? 1 : 0, 7, 7);
                BitHandler.bput(data, 14 + i2 * 56, DB.xsprite[i2].Impact ? 1 : 0, 0, 0);
                BitHandler.bput(data, 14 + i2 * 56, DB.xsprite[i2].Pickup ? 1 : 0, 1, 1);
                BitHandler.bput(data, 14 + i2 * 56, DB.xsprite[i2].Touch ? 1 : 0, 2, 2);
                BitHandler.bput(data, 14 + i2 * 56, DB.xsprite[i2].Sight ? 1 : 0, 3, 3);
                BitHandler.bput(data, 14 + i2 * 56, DB.xsprite[i2].Proximity ? 1 : 0, 4, 4);
                BitHandler.bput(data, 14 + i2 * 56, DB.xsprite[i2].l1, 7, 7);
                BitHandler.bput(data, 15 + i2 * 56, DB.xsprite[i2].l2, 0, 0);
                BitHandler.bput(data, 15 + i2 * 56, DB.xsprite[i2].l3, 1, 1);
                BitHandler.bput(data, 15 + i2 * 56, DB.xsprite[i2].l4, 2, 2);
                BitHandler.bput(data, 15 + i2 * 56, DB.xsprite[i2].l5, 3, 3);
                BitHandler.bput(data, 15 + i2 * 56, DB.xsprite[i2].lS ? 1 : 0, 4, 4);
                BitHandler.bput(data, 15 + i2 * 56, DB.xsprite[i2].lB ? 1 : 0, 5, 5);
                BitHandler.bput(data, 15 + i2 * 56, DB.xsprite[i2].lC ? 1 : 0, 6, 6);
                BitHandler.bput(data, 15 + i2 * 56, DB.xsprite[i2].DudeLockout ? 1 : 0, 7, 7);
                BitHandler.bput(data, 16 + i2 * 56, DB.xsprite[i2].data1, 0, 15);
                BitHandler.bput(data, 18 + i2 * 56, DB.xsprite[i2].data2, 0, 15);
                BitHandler.bput(data, 20 + i2 * 56, DB.xsprite[i2].data3, 0, 15);
                BitHandler.bput(data, 22 + i2 * 56, DB.xsprite[i2].goalAng, 0, 10);
                BitHandler.bput(data, 23 + i2 * 56, DB.xsprite[i2].dodgeDir, 3, 4);
                BitHandler.bput(data, 23 + i2 * 56, DB.xsprite[i2].Locked, 5, 5);
                BitHandler.bput(data, 23 + i2 * 56, DB.xsprite[i2].palette, 6, 7);
                BitHandler.bput(data, 24 + i2 * 56, DB.xsprite[i2].respawn, 0, 1);
                BitHandler.bput(data, 24 + i2 * 56, DB.xsprite[i2].data4, 2, 17);
                BitHandler.bput(data, 26 + i2 * 56, DB.xsprite[i2].moveState, 2, 7);
                BitHandler.bput(data, 27 + i2 * 56, DB.xsprite[i2].lockMsg, 0, 7);
                BitHandler.bput(data, 28 + i2 * 56, DB.xsprite[i2].health, 0, 11);
                BitHandler.bput(data, 29 + i2 * 56, DB.xsprite[i2].dudeDeaf ? 1 : 0, 4, 4);
                BitHandler.bput(data, 29 + i2 * 56, DB.xsprite[i2].dudeAmbush ? 1 : 0, 5, 5);
                BitHandler.bput(data, 29 + i2 * 56, DB.xsprite[i2].dudeGuard ? 1 : 0, 6, 6);
                BitHandler.bput(data, 29 + i2 * 56, DB.xsprite[i2].dudeFlag4 ? 1 : 0, 7, 7);
                BitHandler.bput(data, 30 + i2 * 56, DB.xsprite[i2].target, 0, 15);
                BitHandler.bput(data, 32 + i2 * 56, DB.xsprite[i2].targetX, 0, 31);
                BitHandler.bput(data, 36 + i2 * 56, DB.xsprite[i2].targetY, 0, 31);
                BitHandler.bput(data, 40 + i2 * 56, DB.xsprite[i2].targetZ, 0, 31);
                BitHandler.bput(data, 44 + i2 * 56, DB.xsprite[i2].burnTime, 0, 15);
                BitHandler.bput(data, 46 + i2 * 56, DB.xsprite[i2].burnSource, 0, 15);
                BitHandler.bput(data, 48 + i2 * 56, DB.xsprite[i2].height, 0, 15);
                BitHandler.bput(data, 50 + i2 * 56, DB.xsprite[i2].stateTimer, 0, 15);
                BitHandler.bput(data, 52 + i2 * 56, 0, 0, 31);
            }
            ++i2;
        }
        fil.writeBytes(data, data.length);
        data = new byte[512 * XWALL.sizeof];
        i2 = 0;
        while (i2 < 512) {
            if (DB.xwall[i2] != null) {
                BitHandler.bput(data, 0 + i2 * XWALL.sizeof, DB.xwall[i2].reference, 0, 13);
                BitHandler.bput(data, 1 + i2 * XWALL.sizeof, DB.xwall[i2].state, 6, 6);
                BitHandler.bput(data, 1 + i2 * XWALL.sizeof, DB.xwall[i2].busy, 7, 23);
                BitHandler.bput(data, 4 + i2 * XWALL.sizeof, DB.xwall[i2].data, 0, 15);
                BitHandler.bput(data, 6 + i2 * XWALL.sizeof, DB.xwall[i2].txID, 0, 9);
                BitHandler.bput(data, 8 + i2 * XWALL.sizeof, DB.xwall[i2].rxID, 0, 9);
                BitHandler.bput(data, 9 + i2 * XWALL.sizeof, DB.xwall[i2].command, 2, 9);
                BitHandler.bput(data, 10 + i2 * XWALL.sizeof, DB.xwall[i2].triggerOn ? 1 : 0, 2, 2);
                BitHandler.bput(data, 10 + i2 * XWALL.sizeof, DB.xwall[i2].triggerOff ? 1 : 0, 3, 3);
                BitHandler.bput(data, 10 + i2 * XWALL.sizeof, DB.xwall[i2].busyTime, 4, 15);
                BitHandler.bput(data, 12 + i2 * XWALL.sizeof, DB.xwall[i2].waitTime, 0, 11);
                BitHandler.bput(data, 13 + i2 * XWALL.sizeof, DB.xwall[i2].restState, 4, 4);
                BitHandler.bput(data, 13 + i2 * XWALL.sizeof, DB.xwall[i2].interruptable ? 1 : 0, 5, 5);
                BitHandler.bput(data, 13 + i2 * XWALL.sizeof, DB.xwall[i2].panAlways ? 1 : 0, 6, 6);
                BitHandler.bput(data, 13 + i2 * XWALL.sizeof, DB.xwall[i2].panXVel, 7, 14);
                BitHandler.bput(data, 14 + i2 * XWALL.sizeof, DB.xwall[i2].panYVel, 7, 14);
                BitHandler.bput(data, 15 + i2 * XWALL.sizeof, DB.xwall[i2].decoupled ? 1 : 0, 7, 7);
                BitHandler.bput(data, 16 + i2 * XWALL.sizeof, DB.xwall[i2].triggerOnce ? 1 : 0, 0, 0);
                BitHandler.bput(data, 16 + i2 * XWALL.sizeof, DB.xwall[i2].isTriggered ? 1 : 0, 1, 1);
                BitHandler.bput(data, 16 + i2 * XWALL.sizeof, DB.xwall[i2].key, 2, 4);
                BitHandler.bput(data, 16 + i2 * XWALL.sizeof, DB.xwall[i2].triggerPush ? 1 : 0, 5, 5);
                BitHandler.bput(data, 16 + i2 * XWALL.sizeof, DB.xwall[i2].triggerVector ? 1 : 0, 6, 6);
                BitHandler.bput(data, 16 + i2 * XWALL.sizeof, DB.xwall[i2].triggerReserved ? 1 : 0, 7, 7);
                BitHandler.bput(data, 17 + i2 * XWALL.sizeof, DB.xwall[i2].xpanFrac, 0, 7);
                BitHandler.bput(data, 18 + i2 * XWALL.sizeof, DB.xwall[i2].ypanFrac, 0, 7);
                BitHandler.bput(data, 19 + i2 * XWALL.sizeof, DB.xwall[i2].locked, 2, 2);
                BitHandler.bput(data, 19 + i2 * XWALL.sizeof, DB.xwall[i2].dudeLockout ? 1 : 0, 3, 3);
            }
            ++i2;
        }
        fil.writeBytes(data, data.length);
        data = new byte[512 * XSECTOR.sizeof];
        i2 = 0;
        while (i2 < 512) {
            if (DB.xsector[i2] != null) {
                BitHandler.bput(data, 0 + i2 * XSECTOR.sizeof, DB.xsector[i2].reference, 0, 13);
                BitHandler.bput(data, 1 + i2 * XSECTOR.sizeof, DB.xsector[i2].state, 6, 6);
                BitHandler.bput(data, 1 + i2 * XSECTOR.sizeof, DB.xsector[i2].busy, 7, 23);
                BitHandler.bput(data, 4 + i2 * XSECTOR.sizeof, DB.xsector[i2].data, 0, 15);
                BitHandler.bput(data, 6 + i2 * XSECTOR.sizeof, DB.xsector[i2].txID, 0, 9);
                BitHandler.bput(data, 7 + i2 * XSECTOR.sizeof, DB.xsector[i2].waveTime[1], 2, 3);
                BitHandler.bput(data, 7 + i2 * XSECTOR.sizeof, DB.xsector[i2].waveTime[0], 5, 6);
                BitHandler.bput(data, 8 + i2 * XSECTOR.sizeof, DB.xsector[i2].rxID, 0, 9);
                BitHandler.bput(data, 9 + i2 * XSECTOR.sizeof, DB.xsector[i2].command, 2, 9);
                BitHandler.bput(data, 10 + i2 * XSECTOR.sizeof, DB.xsector[i2].triggerOn ? 1 : 0, 2, 2);
                BitHandler.bput(data, 10 + i2 * XSECTOR.sizeof, DB.xsector[i2].triggerOff ? 1 : 0, 3, 3);
                BitHandler.bput(data, 10 + i2 * XSECTOR.sizeof, DB.xsector[i2].busyTime[1], 4, 15);
                BitHandler.bput(data, 12 + i2 * XSECTOR.sizeof, DB.xsector[i2].waitTime[1], 0, 11);
                BitHandler.bput(data, 13 + i2 * XSECTOR.sizeof, DB.xsector[i2].interruptable ? 1 : 0, 5, 5);
                BitHandler.bput(data, 13 + i2 * XSECTOR.sizeof, DB.xsector[i2].amplitude, 6, 13);
                BitHandler.bput(data, 14 + i2 * XSECTOR.sizeof, DB.xsector[i2].freq, 6, 13);
                BitHandler.bput(data, 15 + i2 * XSECTOR.sizeof, DB.xsector[i2].waitFlag[1] ? 1 : 0, 6, 6);
                BitHandler.bput(data, 15 + i2 * XSECTOR.sizeof, DB.xsector[i2].waitFlag[0] ? 1 : 0, 7, 7);
                BitHandler.bput(data, 16 + i2 * XSECTOR.sizeof, DB.xsector[i2].phase, 0, 7);
                BitHandler.bput(data, 17 + i2 * XSECTOR.sizeof, DB.xsector[i2].wave, 0, 3);
                BitHandler.bput(data, 17 + i2 * XSECTOR.sizeof, DB.xsector[i2].shadeAlways ? 1 : 0, 4, 4);
                BitHandler.bput(data, 17 + i2 * XSECTOR.sizeof, DB.xsector[i2].shadeFloor ? 1 : 0, 5, 5);
                BitHandler.bput(data, 17 + i2 * XSECTOR.sizeof, DB.xsector[i2].shadeCeiling ? 1 : 0, 6, 6);
                BitHandler.bput(data, 17 + i2 * XSECTOR.sizeof, DB.xsector[i2].shadeWalls ? 1 : 0, 7, 7);
                BitHandler.bput(data, 18 + i2 * XSECTOR.sizeof, DB.xsector[i2].shade, 0, 7);
                BitHandler.bput(data, 19 + i2 * XSECTOR.sizeof, DB.xsector[i2].panAlways ? 1 : 0, 0, 0);
                BitHandler.bput(data, 19 + i2 * XSECTOR.sizeof, DB.xsector[i2].panFloor ? 1 : 0, 1, 1);
                BitHandler.bput(data, 19 + i2 * XSECTOR.sizeof, DB.xsector[i2].panCeiling ? 1 : 0, 2, 2);
                BitHandler.bput(data, 19 + i2 * XSECTOR.sizeof, DB.xsector[i2].Drag ? 1 : 0, 3, 3);
                BitHandler.bput(data, 19 + i2 * XSECTOR.sizeof, DB.xsector[i2].Underwater ? 1 : 0, 4, 4);
                BitHandler.bput(data, 19 + i2 * XSECTOR.sizeof, DB.xsector[i2].Depth, 5, 7);
                BitHandler.bput(data, 20 + i2 * XSECTOR.sizeof, DB.xsector[i2].panVel, 0, 7);
                BitHandler.bput(data, 21 + i2 * XSECTOR.sizeof, DB.xsector[i2].panAngle, 0, 10);
                BitHandler.bput(data, 22 + i2 * XSECTOR.sizeof, DB.xsector[i2].wind ? 1 : 0, 3, 3);
                BitHandler.bput(data, 22 + i2 * XSECTOR.sizeof, DB.xsector[i2].decoupled ? 1 : 0, 4, 4);
                BitHandler.bput(data, 22 + i2 * XSECTOR.sizeof, DB.xsector[i2].triggerOnce ? 1 : 0, 5, 5);
                BitHandler.bput(data, 22 + i2 * XSECTOR.sizeof, DB.xsector[i2].isTriggered ? 1 : 0, 6, 6);
                BitHandler.bput(data, 22 + i2 * XSECTOR.sizeof, DB.xsector[i2].Key, 7, 9);
                BitHandler.bput(data, 23 + i2 * XSECTOR.sizeof, DB.xsector[i2].Push ? 1 : 0, 2, 2);
                BitHandler.bput(data, 23 + i2 * XSECTOR.sizeof, DB.xsector[i2].Vector ? 1 : 0, 3, 3);
                BitHandler.bput(data, 23 + i2 * XSECTOR.sizeof, DB.xsector[i2].Reserved ? 1 : 0, 4, 4);
                BitHandler.bput(data, 23 + i2 * XSECTOR.sizeof, DB.xsector[i2].Enter ? 1 : 0, 5, 5);
                BitHandler.bput(data, 23 + i2 * XSECTOR.sizeof, DB.xsector[i2].Exit ? 1 : 0, 6, 6);
                BitHandler.bput(data, 23 + i2 * XSECTOR.sizeof, DB.xsector[i2].Wallpush ? 1 : 0, 7, 7);
                BitHandler.bput(data, 24 + i2 * XSECTOR.sizeof, DB.xsector[i2].color ? 1 : 0, 0, 0);
                BitHandler.bput(data, 24 + i2 * XSECTOR.sizeof, DB.xsector[i2].busyTime[0], 2, 9);
                BitHandler.bput(data, 25 + i2 * XSECTOR.sizeof, DB.xsector[i2].waitTime[0], 6, 13);
                BitHandler.bput(data, 27 + i2 * XSECTOR.sizeof, DB.xsector[i2].ceilpal, 4, 7);
                BitHandler.bput(data, 28 + i2 * XSECTOR.sizeof, DB.xsector[i2].offCeilZ, 0, 31);
                BitHandler.bput(data, 32 + i2 * XSECTOR.sizeof, DB.xsector[i2].onCeilZ, 0, 31);
                BitHandler.bput(data, 36 + i2 * XSECTOR.sizeof, DB.xsector[i2].offFloorZ, 0, 31);
                BitHandler.bput(data, 40 + i2 * XSECTOR.sizeof, DB.xsector[i2].onFloorZ, 0, 31);
                BitHandler.bput(data, 44 + i2 * XSECTOR.sizeof, DB.xsector[i2].marker0, 0, 15);
                BitHandler.bput(data, 46 + i2 * XSECTOR.sizeof, DB.xsector[i2].marker1, 0, 15);
                BitHandler.bput(data, 48 + i2 * XSECTOR.sizeof, DB.xsector[i2].Crush ? 1 : 0, 0, 0);
                BitHandler.bput(data, 48 + i2 * XSECTOR.sizeof, DB.xsector[i2].ceilxpanFrac, 1, 8);
                BitHandler.bput(data, 49 + i2 * XSECTOR.sizeof, DB.xsector[i2].ceilypanFrac, 1, 8);
                BitHandler.bput(data, 50 + i2 * XSECTOR.sizeof, DB.xsector[i2].floorxpanFrac, 1, 8);
                BitHandler.bput(data, 51 + i2 * XSECTOR.sizeof, DB.xsector[i2].damageType, 1, 3);
                BitHandler.bput(data, 51 + i2 * XSECTOR.sizeof, DB.xsector[i2].floorpal, 4, 7);
                BitHandler.bput(data, 52 + i2 * XSECTOR.sizeof, DB.xsector[i2].floorypanFrac, 0, 7);
                BitHandler.bput(data, 53 + i2 * XSECTOR.sizeof, DB.xsector[i2].locked, 0, 0);
                BitHandler.bput(data, 53 + i2 * XSECTOR.sizeof, DB.xsector[i2].windVel, 1, 10);
                BitHandler.bput(data, 54 + i2 * XSECTOR.sizeof, DB.xsector[i2].windAng, 3, 13);
                BitHandler.bput(data, 55 + i2 * XSECTOR.sizeof, DB.xsector[i2].windAlways ? 1 : 0, 6, 6);
                BitHandler.bput(data, 55 + i2 * XSECTOR.sizeof, DB.xsector[i2].dudelockout ? 1 : 0, 7, 7);
                BitHandler.bput(data, 56 + i2 * XSECTOR.sizeof, DB.xsector[i2].bobTheta, 0, 10);
                BitHandler.bput(data, 57 + i2 * XSECTOR.sizeof, DB.xsector[i2].bobZRange, 3, 7);
                BitHandler.bput(data, 58 + i2 * XSECTOR.sizeof, DB.xsector[i2].bobSpeed, 0, 11);
                BitHandler.bput(data, 59 + i2 * XSECTOR.sizeof, DB.xsector[i2].bobAlways ? 1 : 0, 4, 4);
                BitHandler.bput(data, 59 + i2 * XSECTOR.sizeof, DB.xsector[i2].bobFloor ? 1 : 0, 5, 5);
                BitHandler.bput(data, 59 + i2 * XSECTOR.sizeof, DB.xsector[i2].bobCeiling ? 1 : 0, 6, 6);
                BitHandler.bput(data, 59 + i2 * XSECTOR.sizeof, DB.xsector[i2].bobRotate ? 1 : 0, 7, 7);
            }
            ++i2;
        }
        fil.writeBytes(data, data.length);
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 12);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            buffer.putInt((int)Actor.sprXVel[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            buffer.putInt((int)Actor.sprYVel[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            buffer.putInt((int)Actor.sprZVel[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(4096);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < 2048) {
            buffer.putShort((short)DB.nextXSprite[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < 512) {
            buffer.putShort((short)DB.nextXWall[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < 512) {
            buffer.putShort((short)DB.nextXSector[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeInt(DB.gSkyCount);
        fil.writeByte(Globals.gFogMode ? 1 : 0);
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 40);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < Globals.kMaxSectors) {
            if (Engine.sector[i2] != null) {
                buffer.putShort(Engine.sector[i2].wallptr);
                buffer.putShort(Engine.sector[i2].wallnum);
                buffer.putInt(Engine.sector[i2].ceilingz);
                buffer.putInt(Engine.sector[i2].floorz);
                buffer.putShort(Engine.sector[i2].ceilingstat);
                buffer.putShort(Engine.sector[i2].floorstat);
                buffer.putShort(Engine.sector[i2].ceilingpicnum);
                buffer.putShort(Engine.sector[i2].ceilingheinum);
                buffer.put(Engine.sector[i2].ceilingshade);
                buffer.put((byte)Engine.sector[i2].ceilingpal);
                buffer.put((byte)Engine.sector[i2].ceilingxpanning);
                buffer.put((byte)Engine.sector[i2].ceilingypanning);
                buffer.putShort(Engine.sector[i2].floorpicnum);
                buffer.putShort(Engine.sector[i2].floorheinum);
                buffer.put(Engine.sector[i2].floorshade);
                buffer.put((byte)Engine.sector[i2].floorpal);
                buffer.put((byte)Engine.sector[i2].floorxpanning);
                buffer.put((byte)Engine.sector[i2].floorypanning);
                buffer.put((byte)Engine.sector[i2].visibility);
                buffer.put((byte)Engine.sector[i2].filler);
                buffer.putShort(Engine.sector[i2].lotag);
                buffer.putShort(Engine.sector[i2].hitag);
                buffer.putShort(Engine.sector[i2].extra);
            }
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(262144);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < 8192) {
            if (Engine.wall[i2] != null) {
                buffer.putInt(Engine.wall[i2].x);
                buffer.putInt(Engine.wall[i2].y);
                buffer.putShort(Engine.wall[i2].point2);
                buffer.putShort(Engine.wall[i2].nextwall);
                buffer.putShort(Engine.wall[i2].nextsector);
                buffer.putShort(Engine.wall[i2].cstat);
                buffer.putShort(Engine.wall[i2].picnum);
                buffer.putShort(Engine.wall[i2].overpicnum);
                buffer.put(Engine.wall[i2].shade);
                buffer.put((byte)Engine.wall[i2].pal);
                buffer.put((byte)Engine.wall[i2].xrepeat);
                buffer.put((byte)Engine.wall[i2].yrepeat);
                buffer.put((byte)Engine.wall[i2].xpanning);
                buffer.put((byte)Engine.wall[i2].ypanning);
                buffer.putShort(Engine.wall[i2].lotag);
                buffer.putShort(Engine.wall[i2].hitag);
                buffer.putShort(Engine.wall[i2].extra);
            }
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 44);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            buffer.putInt(Engine.sprite[i2].x);
            buffer.putInt(Engine.sprite[i2].y);
            buffer.putInt(Engine.sprite[i2].z);
            buffer.putShort(Engine.sprite[i2].cstat);
            buffer.putShort(Engine.sprite[i2].picnum);
            buffer.put(Engine.sprite[i2].shade);
            buffer.put((byte)Engine.sprite[i2].pal);
            buffer.put((byte)Engine.sprite[i2].clipdist);
            buffer.put((byte)Engine.sprite[i2].detail);
            buffer.put((byte)Engine.sprite[i2].xrepeat);
            buffer.put((byte)Engine.sprite[i2].yrepeat);
            buffer.put((byte)Engine.sprite[i2].xoffset);
            buffer.put((byte)Engine.sprite[i2].yoffset);
            buffer.putShort(Engine.sprite[i2].sectnum);
            buffer.putShort(Engine.sprite[i2].statnum);
            buffer.putShort(Engine.sprite[i2].ang);
            buffer.putShort(Engine.sprite[i2].owner);
            buffer.putShort(Engine.sprite[i2].xvel);
            buffer.putShort(Engine.sprite[i2].yvel);
            buffer.putShort(Engine.sprite[i2].zvel);
            buffer.putShort(Engine.sprite[i2].lotag);
            buffer.putShort(Engine.sprite[i2].hitag);
            buffer.putShort(Engine.sprite[i2].extra);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.numsectors);
        fil.writeShort(Engine.numwalls);
        fil.writeInt(Gameutils.bseed);
        fil.writeByte(0);
        fil.writeByte(Engine.showinvisibility ? 1 : 0);
        fil.writeInt(0);
        fil.writeInt(Engine.parallaxyscale);
        fil.writeInt(Engine.visibility);
        fil.writeInt(Engine.parallaxvisibility);
        buffer = ByteBuffer.allocate(512);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < 256) {
            buffer.putShort(Engine.pskyoff[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.pskybits);
        buffer = ByteBuffer.allocate((Globals.kMaxSectors + 1) * 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 <= Globals.kMaxSectors) {
            buffer.putShort(Engine.headspritesect[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 <= 1024) {
            buffer.putShort(Engine.headspritestat[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            buffer.putShort(Engine.prevspritesect[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            buffer.putShort(Engine.prevspritestat[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            buffer.putShort(Engine.nextspritesect[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            buffer.putShort(Engine.nextspritestat[i2]);
            ++i2;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeBytes(Engine.show2dsector, Engine.show2dsector.length);
        fil.writeBytes(Engine.show2dwall, 1024);
        fil.writeBytes(Engine.show2dsprite, Engine.show2dsprite.length);
        fil.writeByte(Engine.automapping);
        fil.writeBytes(Engine.gotpic, 512);
        fil.writeBytes(Engine.gotsector, Engine.gotsector.length);
    }

    public static void DudesSave(FileResource fil) {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 2048) {
            buffer.putInt(Ai.cumulDamage[i]);
            ++i;
        }
        i = 0;
        while (i < 2048) {
            buffer.putInt(Ai.gDudeSlope[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void WarpSave(FileResource fil) {
        ByteBuffer buffer = ByteBuffer.allocate(128);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 8) {
            buffer.putInt((int)Warp.gStartZone[i].x);
            buffer.putInt((int)Warp.gStartZone[i].y);
            buffer.putInt((int)Warp.gStartZone[i].z);
            buffer.putShort(Warp.gStartZone[i].sector);
            buffer.putShort(Warp.gStartZone[i].angle);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Globals.kMaxSectors) {
            buffer.putShort((short)Warp.gUpperLink[i]);
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            buffer.putShort((short)Warp.gLowerLink[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void MirrorSave(FileResource fil) {
        fil.writeInt(Mirror.mirrorcnt);
        fil.writeInt(Mirror.MirrorSector);
        ByteBuffer buffer = ByteBuffer.allocate(384);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 16) {
            buffer.putShort((short)Mirror.MirrorType[i]);
            buffer.putShort((short)0);
            buffer.putInt(Mirror.MirrorLower[i]);
            buffer.putInt(Mirror.MirrorX[i]);
            buffer.putInt(Mirror.MirrorY[i]);
            buffer.putInt(Mirror.MirrorZ[i]);
            buffer.putInt(Mirror.MirrorUpper[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < 4) {
            buffer.putInt(Mirror.MirrorWall[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void SeqSave(FileResource fil) {
        ByteBuffer buffer = ByteBuffer.allocate(20480);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 512) {
            buffer.put(SeqHandling.siWall[i].getBytes());
            ++i;
        }
        i = 0;
        while (i < 512) {
            buffer.put(SeqHandling.siMasked[i].getBytes());
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(20480);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < 512) {
            buffer.put(SeqHandling.siCeiling[i].getBytes());
            ++i;
        }
        i = 0;
        while (i < 512) {
            buffer.put(SeqHandling.siFloor[i].getBytes());
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(40960);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < 2048) {
            buffer.put(SeqHandling.siSprite[i].getBytes());
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(SeqHandling.kMaxSequences * 3);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < SeqHandling.kMaxSequences) {
            SeqInst pInst = SeqHandling.activeList.getInst(i);
            if (pInst instanceof WallInst) {
                buffer.put((byte)0);
            } else if (pInst instanceof MaskedWallInst) {
                buffer.put((byte)4);
            } else if (pInst instanceof FloorInst) {
                buffer.put((byte)2);
            } else if (pInst instanceof CeilingInst) {
                buffer.put((byte)1);
            } else if (pInst instanceof SpriteInst) {
                buffer.put((byte)3);
            } else {
                buffer.put((byte)-1);
            }
            buffer.putShort(SeqHandling.activeList.getIndex(i));
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(SeqHandling.activeList.getSize());
    }

    public static void EventSave(FileResource fil) {
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(0);
        buffer.putInt(0);
        int i = 0;
        while (i < 1023) {
            if (i < EVENT.eventQ.getSize()) {
                PriorityItem item = EVENT.eventQ.getItem(i);
                buffer.putInt((int)item.priority);
                buffer.putInt(item.event);
            } else {
                buffer.putInt(0);
                buffer.putInt(0);
            }
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeInt(EVENT.eventQ.getSize());
        buffer = ByteBuffer.allocate(16384);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < 4096) {
            buffer.putInt(EVENT.getEvent(EVENT.rxBucket[i].index, EVENT.rxBucket[i].type, 0, 0));
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i <= 1024) {
            buffer.putShort(EVENT.bucketHead[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void TriggersSave(FileResource fil) {
        fil.writeInt(Trigger.gBusyCount);
        ByteBuffer buffer = ByteBuffer.allocate(1664);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 128) {
            buffer.putInt(Trigger.gBusy[i].nIndex);
            buffer.putInt(Trigger.gBusy[i].nDelta);
            buffer.putInt(Trigger.gBusy[i].nBusy);
            buffer.put((byte)Trigger.gBusy[i].busyProc);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Globals.kMaxSectors) {
            buffer.putInt(Trigger.secPath[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void PlayersSave(FileResource fil, int nVersion) {
        int i = 0;
        while (i < 8) {
            fil.writeInt(Globals.nTeamCount[i]);
            ++i;
        }
        fil.writeInt(Mmulti.numplayers);
        i = 0;
        while (i < 8) {
            fil.writeByte(Main.game.net.gProfile[i].autoaim ? 1 : 0);
            if (nVersion >= 302) {
                fil.writeByte(Main.game.net.gProfile[i].slopetilt ? 1 : 0);
            }
            fil.writeByte(Main.game.net.gProfile[i].skill);
            fil.writeBytes(Main.game.net.gProfile[i].name.toCharArray(), 15);
            ++i;
        }
        i = 0;
        while (i < 8) {
            fil.writeInt(0);
            fil.writeInt(0);
            fil.writeInt(0);
            byte[] input = Globals.gPlayer[i].pInput.getBytes(nVersion);
            fil.writeBytes(input, input.length);
            byte[] data = Globals.gPlayer[i].getBytes(nVersion);
            fil.writeBytes(data, data.length);
            ++i;
        }
    }

    public static void ActorsSave(FileResource fil) {
        ByteBuffer buffer = ByteBuffer.allocate(24576);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 2048) {
            buffer.putInt(Actor.gSpriteHit[i].moveHit);
            buffer.putInt(Actor.gSpriteHit[i].ceilHit);
            buffer.putInt(Actor.gSpriteHit[i].floorHit);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Globals.kMaxSectors) {
            buffer.putShort((short)Actor.gSectorExp[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < 512) {
            buffer.putShort((short)Actor.gWallExp[i]);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(Actor.gPostCount);
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        i = 0;
        while (i < Globals.kMaxSprites) {
            buffer.putShort(Actor.gPost[i].nSprite);
            buffer.putShort(Actor.gPost[i].nStatus);
            ++i;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void UnkSave(FileResource fil) {
        fil.writeShort(0);
    }

    public static void GameInfoSave(FileResource fil, String pName, int nSaveGameSlot) {
        fil.writeInt(LEVELS.gNextMap);
        fil.writeShort(0);
        fil.writeByte(Globals.pGameInfo.nGameType);
        fil.writeByte(Globals.pGameInfo.nDifficulty);
        fil.writeInt(Globals.pGameInfo.nEpisode);
        fil.writeInt(Globals.pGameInfo.nLevel);
        fil.writeBytes(Globals.pGameInfo.zLevelName.toCharArray(), 144);
        if (Globals.pGameInfo.zLevelSong != null) {
            fil.writeBytes(Globals.pGameInfo.zLevelSong.toCharArray(), 144);
        } else {
            fil.writeBytes(new byte[144], 144);
        }
        fil.writeInt(Globals.pGameInfo.nTrackNumber);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeShort(nSaveGameSlot);
        fil.writeInt(0);
        fil.writeInt((int)Globals.pGameInfo.uMapCRC);
        fil.writeByte(Globals.pGameInfo.nMonsterSettings);
        fil.writeInt(Globals.pGameInfo.uGameFlags);
        fil.writeInt(Globals.pGameInfo.uNetGameFlags);
        fil.writeByte(Globals.pGameInfo.nWeaponSettings);
        fil.writeByte(Globals.pGameInfo.nItemSettings);
        fil.writeByte(Globals.pGameInfo.nRespawnSettings);
        fil.writeByte(Globals.pGameInfo.nTeamSettings);
        fil.writeInt(Globals.pGameInfo.nMonsterRespawnTime);
        fil.writeInt(Globals.pGameInfo.nWeaponRespawnTime);
        fil.writeInt(Globals.pGameInfo.nItemRespawnTime);
        fil.writeInt(Globals.pGameInfo.nSpecialRespawnTime);
        fil.writeByte(0);
        fil.writeByte(0);
    }

    public static void StatsSave(FileResource fil) {
        fil.writeInt(LEVELS.totalSecrets);
        fil.writeInt(LEVELS.foundSecret);
        fil.writeInt(LEVELS.superSecrets);
        fil.writeInt(LEVELS.totalKills);
        fil.writeInt(LEVELS.kills);
    }

    public static void ScreenSave(FileResource fil) {
        fil.writeInt(123);
        fil.writeBytes(new byte[256], 256);
        fil.writeShort(0);
        fil.writeShort(0);
        fil.writeInt(0);
        fil.writeInt(View.deliriumTilt);
        fil.writeInt(View.deliriumTurn);
        fil.writeInt(View.deliriumPitch);
    }

    public static void quicksave() {
        if (Mmulti.numplayers > 1 || Globals.kFakeMultiplayer) {
            return;
        }
        if (Globals.gMe.pXsprite.health != 0) {
            gQuickSaving = true;
        }
    }

    public static boolean checkfile(Resource bb) {
        int saveHeader = LOADSAVE.checkSave(bb);
        int nVersion = saveHeader & 0xFFFF;
        if (nVersion < 300) {
            Console.Println("Dos saved game found, version: " + nVersion);
        }
        if (nVersion != 302 && nVersion != 277 && nVersion != 256) {
            return false;
        }
        return loader.load(bb, nVersion);
    }

    public static boolean canLoad(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            int nVersion = LOADSAVE.checkSave(fil) & 0xFFFF;
            if (nVersion != 302 && nVersion >= 300) {
                final BloodIniFile addon = loader.LoadGDXHeader(fil);
                if (LOADSAVE.loader.safeGameInfo.nLevel <= 16 && LOADSAVE.loader.safeGameInfo.nEpisode < 6 && LOADSAVE.loader.safeGameInfo.nDifficulty >= 0 && LOADSAVE.loader.safeGameInfo.nDifficulty < 5 && !LOADSAVE.loader.gForceMap) {
                    MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[17];
                    menu.setRunnable(new Runnable(){

                        @Override
                        public void run() {
                            int nEpisode = loader.safeGameInfo.nEpisode;
                            int nLevel = loader.safeGameInfo.nLevel;
                            int nSkill = loader.safeGameInfo.nDifficulty;
                            Main.gGameScreen.newgame(false, addon, nEpisode, nLevel, nSkill, nSkill, nSkill, false);
                        }
                    });
                    Main.game.menu.mOpen(menu, -1);
                }
            }
            fil.close();
            return nVersion == 302;
        }
        return false;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        final String loadname = Main.game.pSavemgr.getLast();
        if (loadname != null && LOADSAVE.canLoad(loadname)) {
            Main.game.changeScreen(Main.gLoadingScreen.setTitle(loadname));
            Main.gLoadingScreen.init(new Runnable(){

                @Override
                public void run() {
                    if (!LOADSAVE.loadgame(loadname)) {
                        Main.game.setPrevScreen();
                        Main.game.pNet.ready2send = true;
                    }
                }
            });
        }
    }

    public static int lsReadLoadData(String filename) {
        FileResource file = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (file != null) {
            BloodTile pic = Main.engine.getTile(SaveManager.Screenshot);
            if (pic.data == null) {
                Main.engine.allocatepermanenttile(SaveManager.Screenshot, 320, 200);
            }
            int nVersion = LOADSAVE.checkSave(file) & 0xFFFF;
            lsInf.clear();
            switch (nVersion) {
                case 302: {
                    file.seek(10L, Resource.Whence.Set);
                    LOADSAVE.lsInf.date = Main.game.date.getDate(file.readLong());
                    file.seek(34L, Resource.Whence.Set);
                    lsInf.read(file);
                    if (file.remaining() <= 64000) {
                        file.close();
                        return -1;
                    }
                    file.read(pic.data, 0, 64000);
                    byte gUserEpisode = file.readByte();
                    if (gUserEpisode == 1) {
                        String ininame;
                        byte[] buf = new byte[144];
                        file.read(buf, 0, 144);
                        String fullname = new String(buf).trim();
                        int filenameIndex = -1;
                        filenameIndex = fullname.indexOf(":");
                        if (filenameIndex != -1) {
                            String ext = FileUtils.getExtension(fullname.substring(0, filenameIndex));
                            ininame = String.valueOf(ext) + ":" + Main.game.getFilename(fullname.substring(filenameIndex + 1));
                        } else {
                            ininame = Main.game.getFilename(fullname);
                        }
                        if (!ininame.isEmpty()) {
                            LOADSAVE.lsInf.iniName = "File: " + ininame;
                        }
                    }
                    int nEnemyDamage = file.readByte() + 1;
                    int nEnemyQuantity = file.readByte() + 1;
                    int nDifficulty = file.readByte() + 1;
                    boolean nPitchforkOnly = file.readBoolean();
                    if (LOADSAVE.lsInf.skill != nEnemyDamage || LOADSAVE.lsInf.skill != nEnemyQuantity || LOADSAVE.lsInf.skill != nDifficulty || nPitchforkOnly) {
                        LOADSAVE.lsInf.skill = 6;
                    }
                    lsInf.update();
                    Main.engine.invalidatetile(SaveManager.Screenshot, 0, -1);
                    file.close();
                    return 1;
                }
                case 256: {
                    file.seek(1L, Resource.Whence.Set);
                    lsInf.read(file);
                    file.close();
                    return -1;
                }
            }
            file.seek(11L, Resource.Whence.Set);
            if (nVersion >= 300) {
                LOADSAVE.lsInf.info = "Incompatible ver. " + nVersion + " != " + 302;
            } else {
                lsInf.read(file);
            }
            file.close();
            return -1;
        }
        lsInf.clear();
        return -1;
    }

    public static void LoadGameInfo() {
        Globals.pGameInfo.copy(LOADSAVE.loader.safeGameInfo);
    }

    public static int checkSave(Resource bb) {
        String signature = bb.readString(4);
        if (signature == null || !signature.equals(savsign)) {
            Console.Println("Old saved game found");
            return 256;
        }
        short nVersion = bb.readShort();
        int nBuild = bb.readInt();
        return nVersion | nBuild << 16;
    }

    public static boolean loadgame(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            Console.Println("debug: start loadgame()", Console.OSDTEXT_BLUE);
            boolean status = LOADSAVE.checkfile(fil);
            fil.close();
            if (status) {
                LOADSAVE.load();
                if (lastload == null || lastload.isEmpty()) {
                    lastload = filename;
                }
                if (loader.getMessage() != null) {
                    View.viewSetMessage(loader.getMessage(), -1);
                }
                return true;
            }
            View.viewSetMessage("Incompatible version of saved game found!", -1);
            return false;
        }
        View.viewSetMessage("Can't access to file or file not found!", -1);
        return false;
    }

    public static boolean load() {
        SOUND.sndStopAllSamples();
        SOUND.sfxKillAll3DSounds();
        SOUND.ambStopAll();
        SeqHandling.seqKillAll();
        View.resetQuotes();
        DB.dbInit();
        Trigger.trInitStructs();
        Actor.actInitStruct();
        LOADSAVE.LoadGDXBlock();
        LOADSAVE.MyLoad();
        LOADSAVE.DudesLoad();
        LOADSAVE.WarpLoad();
        LOADSAVE.MirrorLoad();
        LOADSAVE.SeqLoad();
        LOADSAVE.EventLoad();
        LOADSAVE.TriggersLoad();
        LOADSAVE.PlayersLoad();
        LOADSAVE.ActorsLoad();
        LOADSAVE.GameInfoLoad();
        LOADSAVE.StatsLoad();
        LOADSAVE.ScreenLoad();
        LOADSAVE.LoadUserEpisodeInfo();
        Globals.cheatsOn = LOADSAVE.loader.cheatsOn;
        Globals.gInfiniteAmmo = LOADSAVE.loader.gInfiniteAmmo;
        Mirror.InitMirrorTiles();
        LEVELS.loadMapInfo(Globals.pGameInfo.nEpisode, Globals.pGameInfo.nLevel);
        DB.gVisibility = Engine.visibility;
        if (Main.mUserFlag == Main.UserFlag.UserMap || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel] == null || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Title == null) {
            LEVELS.gUserMapInfo.MapName = LEVELS.gUserMapInfo.Title = String.valueOf(Globals.pGameInfo.zLevelName) + ".map";
            Globals.boardfilename = LEVELS.gUserMapInfo.Title;
            LEVELS.gUserMapInfo.Song = null;
            LEVELS.gUserMapInfo.Track = 0;
        } else {
            Globals.boardfilename = LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Title;
        }
        if (!Main.game.isCurrentScreen(Main.gGameScreen) && !Main.game.isCurrentScreen(Main.gDemoScreen)) {
            Screen.scrLoadPLUs();
        }
        SECTORFX.InitSectorFX();
        ((BloodNetwork)Main.game.pNet).PredictReset();
        Main.gPrecacheScreen.init(false, new Runnable(){

            @Override
            public void run() {
                SOUND.ambPrepare();
                SOUND.sndPlayMusic();
                View.viewSetMessage("Game loaded", -1);
                Globals.gTicks = 0;
                Globals.gFrame = 0;
                Screen.scrReset();
                View.gViewPos = 0;
                View.gViewMode = 3;
                Engine.totalclock = 0;
                Main.game.gPaused = false;
                Main.game.changeScreen(Main.gGameScreen);
                Main.game.pNet.ResetTimers();
                Main.game.pNet.WaitForAllPlayers(0);
                Main.game.pNet.ready2send = true;
                Main.game.nNetMode = BuildGame.NetMode.Single;
                BuildGdx.audio.getSound().setReverb(false, 0.0f);
                View.PaletteView = 0;
                Screen.scrSetPalette(View.PaletteView);
                if (PLAYER.powerupCheck(Globals.gMe, 18) != 0) {
                    BuildGdx.audio.getSound().setReverb(true, 0.2f);
                }
                if (PLAYER.powerupCheck(Globals.gMe, 24) != 0) {
                    BuildGdx.audio.getSound().setReverb(true, 0.4f);
                }
                Main.game.pInput.resetMousePos();
                System.gc();
                Console.Println("debug: end loadgame()", Console.OSDTEXT_BLUE);
            }
        });
        Main.game.changeScreen(Main.gPrecacheScreen);
        return true;
    }

    public static void LoadGDXBlock() {
        Globals.pGameInfo.nEnemyDamage = LOADSAVE.loader.safeGameInfo.nEnemyDamage;
        Globals.pGameInfo.nEnemyQuantity = LOADSAVE.loader.safeGameInfo.nEnemyQuantity;
        Globals.pGameInfo.nDifficulty = LOADSAVE.loader.safeGameInfo.nDifficulty;
        Globals.pGameInfo.nPitchforkOnly = LOADSAVE.loader.safeGameInfo.nPitchforkOnly;
        Globals.gInfiniteAmmo = LOADSAVE.loader.gInfiniteAmmo;
    }

    public static void MyLoad() {
        LOADSAVE.LoadGameInfo();
        Engine.numsectors = LOADSAVE.loader.numsectors;
        Engine.numwalls = LOADSAVE.loader.numwalls;
        Engine.numsprites = LOADSAVE.loader.numsprites;
        int i = 0;
        while (i < Engine.numsectors) {
            if (Engine.sector[i] == null) {
                Engine.sector[i] = new SECTOR();
            }
            Engine.sector[i].set(LOADSAVE.loader.sector[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.numwalls) {
            if (Engine.wall[i] == null) {
                Engine.wall[i] = new WALL();
            }
            Engine.wall[i].set(LOADSAVE.loader.wall[i]);
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            Engine.sprite[i].set(LOADSAVE.loader.sprite[i]);
            ++i;
        }
        Gameutils.bseed = LOADSAVE.loader.randomseed;
        Engine.showinvisibility = LOADSAVE.loader.showinvisibility;
        Engine.parallaxyscale = LOADSAVE.loader.parallaxyscale;
        Engine.visibility = LOADSAVE.loader.visibility;
        Engine.parallaxvisibility = LOADSAVE.loader.parallaxvisibility;
        i = 0;
        while (i < 256) {
            Engine.pskyoff[i] = LOADSAVE.loader.pskyoff[i];
            ++i;
        }
        Engine.pskybits = LOADSAVE.loader.pskybits;
        Arrays.fill(Engine.zeropskyoff, (short)0);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        i = 0;
        while (i <= Globals.kMaxSectors) {
            Engine.headspritesect[i] = LOADSAVE.loader.headspritesect[i];
            ++i;
        }
        i = 0;
        while (i <= 1024) {
            Engine.headspritestat[i] = LOADSAVE.loader.headspritestat[i];
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            Engine.prevspritesect[i] = LOADSAVE.loader.prevspritesect[i];
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            Engine.prevspritestat[i] = LOADSAVE.loader.prevspritestat[i];
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            Engine.nextspritesect[i] = LOADSAVE.loader.nextspritesect[i];
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            Engine.nextspritestat[i] = LOADSAVE.loader.nextspritestat[i];
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors + 7 >> 3) {
            Engine.show2dsector[i] = LOADSAVE.loader.show2dsector[i];
            ++i;
        }
        i = 0;
        while (i < 1024) {
            Engine.show2dwall[i] = LOADSAVE.loader.show2dwall[i];
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites + 7 >> 3) {
            Engine.show2dsprite[i] = LOADSAVE.loader.show2dsprite[i];
            ++i;
        }
        Engine.automapping = LOADSAVE.loader.automapping;
        i = 0;
        while (i < Globals.kMaxTiles + 7 >> 3) {
            Engine.gotpic[i] = LOADSAVE.loader.gotpic[i];
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors + 7 >> 3) {
            Engine.gotsector[i] = LOADSAVE.loader.gotsector[i];
            ++i;
        }
        Globals.gFrameClock = LOADSAVE.loader.gFrameClock;
        Globals.gTicks = LOADSAVE.loader.gTicks;
        Globals.gFrame = LOADSAVE.loader.gFrame;
        Engine.totalclock = LOADSAVE.loader.gGameClock;
        Main.game.gPaused = LOADSAVE.loader.gPaused;
        i = 0;
        while (i < LOADSAVE.loader.kwall.length) {
            Trigger.kwall[i].set(LOADSAVE.loader.kwall[i]);
            ++i;
        }
        i = 0;
        while (i < LOADSAVE.loader.ksprite.length) {
            Trigger.ksprite[i].set(LOADSAVE.loader.ksprite[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.numsectors) {
            Trigger.secFloorZ[i] = LOADSAVE.loader.secFloorZ[i];
            ++i;
        }
        i = 0;
        while (i < Engine.numsectors) {
            Trigger.secCeilZ[i] = LOADSAVE.loader.secCeilZ[i];
            ++i;
        }
        i = 0;
        while (i < Engine.numsectors) {
            Actor.floorVel[i] = LOADSAVE.loader.floorVel[i];
            ++i;
        }
        i = 0;
        while (i < Engine.numsectors) {
            Actor.ceilingVel[i] = LOADSAVE.loader.ceilingVel[i];
            ++i;
        }
        Engine.pHitInfo.hitsect = LOADSAVE.loader.safeHitInfo.hitsect;
        Engine.pHitInfo.hitwall = LOADSAVE.loader.safeHitInfo.hitwall;
        Engine.pHitInfo.hitsprite = LOADSAVE.loader.safeHitInfo.hitsprite;
        Engine.pHitInfo.hitx = LOADSAVE.loader.safeHitInfo.hitx;
        Engine.pHitInfo.hity = LOADSAVE.loader.safeHitInfo.hity;
        Engine.pHitInfo.hitz = LOADSAVE.loader.safeHitInfo.hitz;
        Main.mUserFlag = Main.UserFlag.None;
        if (LOADSAVE.loader.gForceMap) {
            Main.mUserFlag = Main.UserFlag.UserMap;
        }
        i = 0;
        while (i <= 1024) {
            DB.nStatSize[i] = LOADSAVE.loader.nStatSize[i];
            ++i;
        }
        i = 0;
        while (i < 2048) {
            DB.nextXSprite[i] = LOADSAVE.loader.nextXSprite[i];
            ++i;
        }
        i = 0;
        while (i < 512) {
            DB.nextXWall[i] = LOADSAVE.loader.nextXWall[i];
            ++i;
        }
        i = 0;
        while (i < 512) {
            DB.nextXSector[i] = LOADSAVE.loader.nextXSector[i];
            ++i;
        }
        i = 0;
        while (i < 2048) {
            DB.xsprite[i].copy(LOADSAVE.loader.xsprite[i]);
            ++i;
        }
        i = 0;
        while (i < 512) {
            DB.xwall[i].copy(LOADSAVE.loader.xwall[i]);
            ++i;
        }
        i = 0;
        while (i < 512) {
            DB.xsector[i].copy(LOADSAVE.loader.xsector[i]);
            ++i;
        }
        System.arraycopy(LOADSAVE.loader.sprXVel, 0, Actor.sprXVel, 0, Globals.kMaxSprites);
        System.arraycopy(LOADSAVE.loader.sprYVel, 0, Actor.sprYVel, 0, Globals.kMaxSprites);
        System.arraycopy(LOADSAVE.loader.sprZVel, 0, Actor.sprZVel, 0, Globals.kMaxSprites);
        DB.gSkyCount = LOADSAVE.loader.gSkyCount;
        Globals.gFogMode = LOADSAVE.loader.gFogMode;
        Globals.gNoClip = LOADSAVE.loader.gNoClip;
        Globals.gFullMap = LOADSAVE.loader.gFullMap;
    }

    public static void DudesLoad() {
        Arrays.fill(Ai.cumulDamage, 0);
        int i = 0;
        while (i < 2048) {
            Ai.gDudeSlope[i] = LOADSAVE.loader.gDudeSlope[i];
            ++i;
        }
    }

    public static void WarpLoad() {
        int i = 0;
        while (i < 8) {
            Warp.gStartZone[i].x = LOADSAVE.loader.gStartZone[i].x;
            Warp.gStartZone[i].y = LOADSAVE.loader.gStartZone[i].y;
            Warp.gStartZone[i].z = LOADSAVE.loader.gStartZone[i].z;
            Warp.gStartZone[i].sector = LOADSAVE.loader.gStartZone[i].sector;
            Warp.gStartZone[i].angle = LOADSAVE.loader.gStartZone[i].angle;
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            Warp.gUpperLink[i] = LOADSAVE.loader.gUpperLink[i];
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            Warp.gLowerLink[i] = LOADSAVE.loader.gLowerLink[i];
            ++i;
        }
    }

    public static void MirrorLoad() {
        Mirror.mirrorcnt = LOADSAVE.loader.mirrorcnt;
        Mirror.MirrorSector = LOADSAVE.loader.MirrorSector;
        int i = 0;
        while (i < 16) {
            Mirror.MirrorType[i] = LOADSAVE.loader.MirrorType[i];
            Mirror.MirrorLower[i] = LOADSAVE.loader.MirrorLower[i];
            Mirror.MirrorX[i] = LOADSAVE.loader.MirrorX[i];
            Mirror.MirrorY[i] = LOADSAVE.loader.MirrorY[i];
            Mirror.MirrorZ[i] = LOADSAVE.loader.MirrorZ[i];
            Mirror.MirrorUpper[i] = LOADSAVE.loader.MirrorUpper[i];
            ++i;
        }
        i = 0;
        while (i < 4) {
            Mirror.MirrorWall[i] = LOADSAVE.loader.MirrorWall[i];
            ++i;
        }
        Mirror.initMirrorWall();
    }

    public static void SeqLoad() {
        int i = 0;
        while (i < 512) {
            SeqHandling.siWall[i].copy(LOADSAVE.loader.siWall[i]);
            ++i;
        }
        i = 0;
        while (i < 512) {
            SeqHandling.siMasked[i].copy(LOADSAVE.loader.siMasked[i]);
            ++i;
        }
        i = 0;
        while (i < 512) {
            SeqHandling.siCeiling[i].copy(LOADSAVE.loader.siCeiling[i]);
            ++i;
        }
        i = 0;
        while (i < 512) {
            SeqHandling.siFloor[i].copy(LOADSAVE.loader.siFloor[i]);
            ++i;
        }
        i = 0;
        while (i < 2048) {
            SeqHandling.siSprite[i].copy(LOADSAVE.loader.siSprite[i]);
            ++i;
        }
        SeqHandling.activeList.set(LOADSAVE.loader.actListType, LOADSAVE.loader.actListIndex, LOADSAVE.loader.activeCount);
    }

    public static void EventLoad() {
        int i;
        if (EVENT.eventQ == null || EVENT.eventQ instanceof BPriorityQueue) {
            if (EVENT.gdxEventQ == null) {
                EVENT.gdxEventQ = new JPriorityQueue(1024);
            }
            EVENT.eventQ = EVENT.gdxEventQ;
            i = 0;
            while (i < 4096) {
                if (EVENT.rxBucket[i] == null) {
                    EVENT.rxBucket[i] = new RXBUCKET();
                } else {
                    EVENT.rxBucket[i].flush();
                }
                ++i;
            }
        }
        EVENT.eventQ.flush();
        i = 0;
        while (i <= LOADSAVE.loader.fNodeCount) {
            EVENT.eventQ.Insert(LOADSAVE.loader.qEventPriority[i], LOADSAVE.loader.qEventEvent[i]);
            ++i;
        }
        i = 0;
        while (i < 4096) {
            EVENT.rxBucket[i].index = LOADSAVE.loader.rxBucketIndex[i];
            EVENT.rxBucket[i].type = LOADSAVE.loader.rxBucketType[i];
            ++i;
        }
        i = 0;
        while (i <= 1024) {
            EVENT.bucketHead[i] = LOADSAVE.loader.bucketHead[i];
            ++i;
        }
    }

    public static void TriggersLoad() {
        Trigger.gBusyCount = LOADSAVE.loader.gBusyCount;
        int i = 0;
        while (i < 128) {
            Trigger.gBusy[i].nIndex = LOADSAVE.loader.gBusy[i].nIndex;
            Trigger.gBusy[i].nDelta = LOADSAVE.loader.gBusy[i].nDelta;
            Trigger.gBusy[i].nBusy = LOADSAVE.loader.gBusy[i].nBusy;
            Trigger.gBusy[i].busyProc = LOADSAVE.loader.gBusy[i].busyProc;
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            Trigger.secPath[i] = LOADSAVE.loader.secPath[i];
            ++i;
        }
    }

    public static void PlayersLoad() {
        int i = 0;
        while (i < 8) {
            Globals.nTeamCount[i] = LOADSAVE.loader.nTeamCount[i];
            ++i;
        }
        Mmulti.numplayers = (short)LOADSAVE.loader.gNetPlayers;
        i = 0;
        while (i < Mmulti.numplayers) {
            Mmulti.connectpoint2[i] = LOADSAVE.loader.connectpoint2[i];
            ++i;
        }
        i = 0;
        while (i < 8) {
            if (LOADSAVE.loader.autoaim[i] != -1) {
                boolean bl = Main.game.net.gProfile[i].autoaim = LOADSAVE.loader.autoaim[i] == 1;
            }
            if (LOADSAVE.loader.slopetilt[i] != -1) {
                boolean bl = Main.game.net.gProfile[i].slopetilt = LOADSAVE.loader.slopetilt[i] == 1;
            }
            if (LOADSAVE.loader.skill[i] != -1) {
                Main.game.net.gProfile[i].skill = LOADSAVE.loader.skill[i];
            }
            if (LOADSAVE.loader.name[i] != null) {
                Main.game.net.gProfile[i].name = LOADSAVE.loader.name[i];
            }
            ++i;
        }
        i = 0;
        while (i < 8) {
            LOADSAVE.loader.safePlayer[i].pInput.Copy(Globals.gPlayer[i].pInput);
            Globals.gPlayer[i].copy(LOADSAVE.loader.safePlayer[i]);
            ++i;
        }
        i = 0;
        while (i < Mmulti.numplayers) {
            Globals.gPlayer[i].pSprite = Engine.sprite[Globals.gPlayer[i].nSprite];
            Globals.gPlayer[i].pXsprite = DB.xsprite[Globals.gPlayer[i].pSprite.extra];
            Globals.gPlayer[i].pDudeInfo = DudeInfo.dudeInfo[Globals.gPlayer[i].pSprite.lotag - 200];
            ++i;
        }
        View.gViewIndex = Mmulti.myconnectindex;
    }

    public static void ActorsLoad() {
        int i = 0;
        while (i < Globals.kMaxSectors) {
            Actor.gSectorExp[i] = LOADSAVE.loader.gSectorExp[i];
            ++i;
        }
        i = 0;
        while (i < 512) {
            Actor.gWallExp[i] = LOADSAVE.loader.gWallExp[i];
            ++i;
        }
        Actor.gPostCount = LOADSAVE.loader.gPostCount;
        Actor.actInit(true, DEMO.IsOriginalDemo());
        int p = 0;
        while (p < Mmulti.numplayers) {
            PLAYER.playerSetRace(Globals.gPlayer[p], Globals.gPlayer[p].nLifeMode);
            Globals.gPlayer[p].ang = Globals.gPlayer[p].pSprite.ang;
            ++p;
        }
    }

    public static void GameInfoLoad() {
        LEVELS.gNextMap = LOADSAVE.loader.gNextMap;
        LOADSAVE.LoadGameInfo();
    }

    public static void StatsLoad() {
        LEVELS.totalSecrets = LOADSAVE.loader.totalSecrets;
        LEVELS.foundSecret = LOADSAVE.loader.foundSecret;
        LEVELS.superSecrets = LOADSAVE.loader.superSecrets;
        LEVELS.totalKills = LOADSAVE.loader.totalKills;
        LEVELS.kills = LOADSAVE.loader.kills;
    }

    public static void ScreenLoad() {
        View.deliriumTilt = LOADSAVE.loader.deliriumTilt;
        View.deliriumTurn = LOADSAVE.loader.deliriumTurn;
        View.deliriumPitch = LOADSAVE.loader.deliriumPitch;
    }

    public static void LoadUserEpisodeInfo() {
        if (LOADSAVE.loader.gUserEpisode) {
            Main.mUserFlag = Main.UserFlag.Addon;
        }
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            BloodIniFile ini = LOADSAVE.loader.addon;
            LEVELS.getEpisodeInfo(LEVELS.gUserEpisodeInfo, ini);
            LEVELS.checkEpisodeResources(ini);
        } else {
            LEVELS.resetEpisodeResources(true);
        }
    }
}

