/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.PriorityQueue;

import java.util.PriorityQueue;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PriorityQueue.IPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.PriorityItem;

public class JPriorityQueue
extends PriorityQueue<PriorityItem>
implements IPriorityQueue {
    private static final long serialVersionUID = 1L;
    private int kPQueueSize;
    private PriorityItem[] qList;

    public JPriorityQueue(int size) {
        super(size);
        this.kPQueueSize = size;
        this.qList = new PriorityItem[size];
        int i = 0;
        while (i < size) {
            this.qList[i] = new PriorityItem(0L, 0);
            ++i;
        }
    }

    @Override
    public void flush() {
        this.clear();
        int i = 0;
        while (i < this.qList.length) {
            this.qList[i].isFree = true;
            ++i;
        }
    }

    @Override
    public void Insert(long time, int event) {
        if (this.size() >= this.kPQueueSize) {
            Main.game.dassert("fNodeCount < kPQueueSize");
        }
        int fNodeCount = 0;
        while (!this.qList[fNodeCount].isFree) {
            ++fNodeCount;
        }
        this.qList[fNodeCount].priority = time;
        this.qList[fNodeCount].event = event;
        this.qList[fNodeCount].isFree = false;
        this.add(this.qList[fNodeCount]);
    }

    @Override
    public int Remove() {
        PriorityItem item = (PriorityItem)this.remove();
        item.isFree = true;
        return item.event;
    }

    @Override
    public void checkList(int nIndex, int nType) {
        int i = 0;
        Object[] priorityList = this.toArray();
        while (i < this.size()) {
            PriorityItem item = (PriorityItem)priorityList[i];
            if (nIndex == EVENT.getIndex(item.event) && nType == EVENT.getType(item.event)) {
                item.isFree = true;
                this.remove(item);
                priorityList = this.toArray();
                continue;
            }
            ++i;
        }
    }

    @Override
    public void checkList(int nIndex, int nType, int funcId) {
        int i = 0;
        Object[] priorityList = this.toArray();
        while (i < this.size()) {
            PriorityItem item = (PriorityItem)priorityList[i];
            if (nIndex == EVENT.getIndex(item.event) && nType == EVENT.getType(item.event) && funcId == EVENT.getFuncID(item.event)) {
                item.isFree = true;
                this.remove(item);
                priorityList = this.toArray();
                continue;
            }
            ++i;
        }
    }

    @Override
    public boolean Check(long time) {
        return this.size() > 0 && time >= ((PriorityItem)this.element()).priority;
    }

    @Override
    public PriorityItem getItem(int i) {
        return (PriorityItem)this.toArray()[i];
    }

    @Override
    public int getSize() {
        return this.size();
    }
}

