/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqType;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.ScreenAdapters.PrecacheAdapter;
import ru.m210projects.Build.Types.SPRITE;

public class PrecacheScreen
extends PrecacheAdapter {
    private Main app;

    public PrecacheScreen(Main game) {
        super(game);
        this.app = game;
        this.addQueue("Preload sounds...", new Runnable(){

            @Override
            public void run() {
                SOUND.sndPreloadSounds();
            }
        });
        this.addQueue("Preload floor and ceiling tiles...", new Runnable(){

            @Override
            public void run() {
                int nSkyTile = -1;
                int i = 0;
                while (i < Engine.numsectors) {
                    Tile.tilePreloadTile(Engine.sector[i].floorpicnum);
                    Tile.tilePreloadTile(Engine.sector[i].ceilingpicnum);
                    if ((Engine.sector[i].ceilingstat & 1) != 0 && nSkyTile == -1) {
                        nSkyTile = Engine.sector[i].ceilingpicnum;
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
                if (nSkyTile > -1 && nSkyTile < Globals.kMaxTiles) {
                    int j = 1;
                    while (j < DB.gSkyCount) {
                        Tile.tilePreloadTile(nSkyTile + j);
                        ++j;
                    }
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload wall tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numwalls) {
                    Tile.tilePreloadTile(Engine.wall[i].picnum);
                    if (Engine.wall[i].overpicnum >= 0) {
                        Tile.tilePreloadTile(Engine.wall[i].overpicnum);
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload sprite tiles...", new Runnable(){

            @Override
            public void run() {
                int i = DudeInfo.dudeInfo[31].seqStartID;
                while (i <= DudeInfo.dudeInfo[31].seqStartID + 18) {
                    PrecacheScreen.this.SeqPreload(i);
                    ++i;
                }
                i = 0;
                while (i < Globals.kMaxSprites) {
                    if (Engine.sprite[i] != null && Engine.sprite[i].statnum < 1024) {
                        if (Engine.sprite[i].statnum == 6) {
                            PrecacheScreen.this.DudePrecache(Engine.sprite[i]);
                        } else if (Engine.sprite[i].statnum == 4) {
                            PrecacheScreen.this.ThingPrecache(Engine.sprite[i]);
                        }
                        Tile.tilePreloadTile(Engine.sprite[i].picnum);
                    }
                    if (Engine.sprite[i] != null && Engine.sprite[i].statnum != 1024 && Engine.sprite[i].extra > 0) {
                        int weap;
                        int nTile;
                        XSPRITE pXSprite = DB.xsprite[Engine.sprite[i].extra];
                        short nObject = pXSprite.dropMsg;
                        if (nObject >= 100 && nObject < 149) {
                            int item = pXSprite.dropMsg - 100;
                            if (item >= 0 && item < Actor.gItemInfo.length) {
                                nTile = Actor.gItemInfo[item].picnum;
                                Tile.tilePreloadTile(nTile);
                            }
                        } else if (nObject >= 60 && nObject < 81) {
                            int ammo = pXSprite.dropMsg - 60;
                            if (ammo >= 0 && ammo < Actor.gAmmoItemData.length) {
                                nTile = Actor.gAmmoItemData[ammo].picnum;
                                Tile.tilePreloadTile(nTile);
                            }
                        } else if (nObject >= 40 && nObject < 51 && (weap = pXSprite.dropMsg - 40) >= 0 && weap < Actor.gWeaponItemData.length) {
                            nTile = Actor.gWeaponItemData[weap].picnum;
                            Tile.tilePreloadTile(nTile);
                        }
                        if (pXSprite.key > 0 && pXSprite.key < 7) {
                            int nTile2 = Actor.gItemInfo[pXSprite.key - 1].picnum;
                            Tile.tilePreloadTile(nTile2);
                        }
                    }
                    ++i;
                }
                Tile.tilePreloadTile(Actor.gWeaponItemData[1].picnum);
                Tile.tilePreloadTile(Actor.gWeaponItemData[2].picnum);
                Tile.tilePreloadTile(Actor.gAmmoItemData[7].picnum);
                Tile.tilePreloadTile(Actor.gAmmoItemData[9].picnum);
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload qav animation...", new Runnable(){

            @Override
            public void run() {
                int kEnd = 126;
                if (VERSION.GAMEVER == 0) {
                    kEnd = 118;
                }
                int i = 0;
                while (i < kEnd) {
                    if (PLAYER.weaponQAVs[i] != null) {
                        PLAYER.weaponQAVs[i].Preload();
                    }
                    ++i;
                }
                if (!VERSION.SHAREWARE) {
                    View.viewHandAnim.pQAV.Preload();
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload effects...", new Runnable(){

            @Override
            public void run() {
                PrecacheScreen.this.SeqPreload(3);
                PrecacheScreen.this.SeqPreload(4);
                PrecacheScreen.this.SeqPreload(5);
                PrecacheScreen.this.SeqPreload(9);
                PrecacheScreen.this.SeqPreload(55);
                PrecacheScreen.this.SeqPreload(56);
                PrecacheScreen.this.SeqPreload(11);
                PrecacheScreen.this.SeqPreload(30);
                PrecacheScreen.this.SeqPreload(0);
                PrecacheScreen.this.SeqPreload(1);
                PrecacheScreen.this.SeqPreload(60);
                PrecacheScreen.this.SeqPreload(61);
                PrecacheScreen.this.SeqPreload(62);
                PrecacheScreen.this.SeqPreload(63);
                PrecacheScreen.this.SeqPreload(64);
                PrecacheScreen.this.SeqPreload(65);
                PrecacheScreen.this.SeqPreload(66);
                PrecacheScreen.this.SeqPreload(67);
                PrecacheScreen.this.SeqPreload(44);
                PrecacheScreen.this.SeqPreload(45);
                PrecacheScreen.this.SeqPreload(46);
                PrecacheScreen.this.SeqPreload(49);
                PrecacheScreen.this.SeqPreload(50);
                PrecacheScreen.this.SeqPreload(51);
                PrecacheScreen.this.SeqPreload(52);
                PrecacheScreen.this.SeqPreload(57);
                PrecacheScreen.this.SeqPreload(58);
                PrecacheScreen.this.SeqPreload(59);
                PrecacheScreen.this.SeqPreload(7);
                PrecacheScreen.this.SeqPreload(8);
                Console.Println("Preload effects");
                int i = 0;
                while (i < 57) {
                    Tile.tilePreloadTile(Actor.gEffectInfo[i].picnum);
                    ++i;
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload projectiles...", new Runnable(){

            @Override
            public void run() {
                Tile.tilePreloadTile(Actor.thingInfo[27].picnum);
                Tile.tilePreloadTile(Actor.thingInfo[28].picnum);
                Tile.tilePreloadTile(Actor.thingInfo[18].picnum);
                Tile.tilePreloadTile(Actor.thingInfo[19].picnum);
                Tile.tilePreloadTile(Actor.thingInfo[20].picnum);
                Tile.tilePreloadTile(Actor.thingInfo[1].picnum);
                Tile.tilePreloadTile(Actor.thingInfo[2].picnum);
                Tile.tilePreloadTile(Actor.gMissileData[1].picnum);
                Tile.tilePreloadTile(Actor.gMissileData[2].picnum);
                Tile.tilePreloadTile(Actor.gMissileData[6].picnum);
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload other tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.MAXTILES) {
                    if (((PrecacheScreen)PrecacheScreen.this).engine.getTile((int)i).data == null) {
                        PrecacheScreen.this.engine.loadtile(i);
                    }
                    ++i;
                }
            }
        });
    }

    @Override
    public void draw(String title, int index) {
        if (Globals.kGameCrash) {
            this.app.rMenu.run();
            return;
        }
        View.viewShowLoadingTile();
        this.engine.rotatesprite(0xA00000, 0x140000, 65536, 0, 2038, -128, 0, 78, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        this.app.getFont(1).drawText(160, 13, Strings.loading, -128, 0, BuildFont.TextAlign.Center, 2, false);
        this.app.getFont(3).drawText(160, 134, Strings.wait, -128, 0, BuildFont.TextAlign.Center, 2, false);
        String mapname = Main.gGameScreen.getTitle();
        if (mapname != null) {
            this.app.getFont(1).drawText(160, 60, mapname, -128, 0, BuildFont.TextAlign.Center, 2, true);
        }
        this.app.getFont(3).drawText(160, 92, title, -128, 0, BuildFont.TextAlign.Center, 2, false);
    }

    private void SeqPreload(int nSeqID) {
        SeqType pSeq = SeqType.getInstance(nSeqID);
        if (pSeq != null) {
            pSeq.Preload();
        }
    }

    private void DudePrecache(SPRITE pSprite) {
        int type = pSprite.lotag - 200;
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID);
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 1);
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 2);
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 3);
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 5);
        switch (pSprite.lotag) {
            case 218: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                break;
            }
            case 250: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 10);
                break;
            }
            case 206: 
            case 207: 
            case 212: 
            case 219: 
            case 220: 
            case 227: 
            case 228: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                break;
            }
            case 201: 
            case 202: 
            case 247: 
            case 248: 
            case 249: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 3);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 13);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 14);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 15);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 17);
                this.SeqPreload(4099);
                this.SeqPreload(4111);
                this.SeqPreload(4112);
                break;
            }
            case 245: {
                this.SeqPreload(12551);
            }
            case 210: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
            }
            case 208: 
            case 209: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                break;
            }
            case 217: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 10);
                break;
            }
            case 251: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                this.SeqPreload(2576);
            }
            case 211: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
            }
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 229: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                break;
            }
            case 204: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 10);
                break;
            }
            case 203: 
            case 205: 
            case 244: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 11);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 13);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 14);
                if (pSprite.lotag == 205) {
                    this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                    this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 12);
                }
                if (pSprite.lotag != 244) break;
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 10);
            }
        }
    }

    private void ThingPrecache(SPRITE pSprite) {
        switch (pSprite.lotag) {
            case 406: 
            case 407: {
                this.SeqPreload(12);
                break;
            }
            case 410: {
                this.SeqPreload(15);
                break;
            }
            case 411: {
                this.SeqPreload(21);
                break;
            }
            case 412: {
                this.SeqPreload(25);
                this.SeqPreload(26);
                break;
            }
            case 413: {
                this.SeqPreload(38);
                this.SeqPreload(40);
                this.SeqPreload(28);
                break;
            }
        }
    }
}

