/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Seq;

import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.SeqType;

public class ActiveList {
    private int size;
    private Node[] list;

    public ActiveList(int size) {
        this.list = new Node[size];
        int i = 0;
        while (i < size) {
            this.list[i] = new Node();
            ++i;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public int remove(SeqInst type) {
        int i = this.getPointer(type);
        if (i == -1) {
            return -1;
        }
        this.remove(i);
        return i;
    }

    public void remove(int num) {
        --this.size;
        this.list[num].set(this.list[this.size]);
    }

    public boolean add(SeqInst type, int index) {
        if (this.size >= this.list.length) {
            return false;
        }
        this.list[this.size].set(type, index);
        ++this.size;
        return true;
    }

    protected int getPointer(SeqInst type) {
        int i = 0;
        while (i < this.size) {
            if (this.list[i].equals(type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getSize() {
        return this.size;
    }

    public SeqInst getInst(int num) {
        return this.list[num].inst;
    }

    public short getIndex(int num) {
        return this.list[num].index;
    }

    public short getIndex(SeqInst pInst) {
        int i = this.getPointer(pInst);
        if (i != -1) {
            return this.list[i].index;
        }
        return -1;
    }

    public void set(byte[] types, short[] indexes, int size) {
        this.size = size;
        int i = 0;
        while (i < this.list.length) {
            this.list[i].inst = i < size ? SeqHandling.GetInstance(types[i], indexes[i]) : null;
            this.list[i].index = indexes[i];
            ++i;
        }
        i = 0;
        while (i < size) {
            SeqInst pInst = SeqHandling.GetInstance(types[i], indexes[i]);
            if (pInst.isPlaying) {
                SeqType pSequence;
                pInst.pSequence = pSequence = SeqType.getInstance(pInst.nSeqID);
            }
            ++i;
        }
    }

    protected class Node {
        private SeqInst inst;
        private short index;

        protected Node() {
        }

        public boolean equals(SeqInst type) {
            return this.inst == type;
        }

        public void set(SeqInst type, int index) {
            this.inst = type;
            this.index = (short)index;
        }

        public void set(Node src) {
            this.inst = src.inst;
            this.index = src.index;
        }
    }
}

