/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import java.nio.ByteBuffer;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public abstract class Board {
    protected int SETSPRITEZ = 0;
    protected final int mapversion;
    protected int numsectors;
    protected int numwalls;
    protected int numsprites;
    protected final short[] headspritesect;
    protected final short[] headspritestat;
    protected final short[] prevspritesect;
    protected final short[] prevspritestat;
    protected final short[] nextspritesect;
    protected final short[] nextspritestat;
    protected final SECTOR[] sector = new SECTOR[this.getMaxSectors()];
    protected final WALL[] wall = new WALL[this.getMaxWalls()];
    protected final SPRITE[] sprite = new SPRITE[this.getMaxSprites()];
    protected BuildPos dapos;
    protected final String name;
    protected final ByteBuffer buffer;
    protected final SlopeZ zofslope;

    protected abstract int sqrt(int var1);

    protected abstract boolean load(Resource var1);

    protected abstract int getMaxSprites();

    protected abstract int getMaxSectors();

    protected abstract int getMaxWalls();

    public Board(String filename) throws Exception {
        this(filename, BuildGdx.cache.open(filename, 0));
    }

    public Board(String name, Resource bb) throws Exception {
        this.headspritesect = new short[this.getMaxSectors() + 1];
        this.headspritestat = new short[1025];
        this.prevspritesect = new short[this.getMaxSprites()];
        this.prevspritestat = new short[this.getMaxSprites()];
        this.nextspritesect = new short[this.getMaxSprites()];
        this.nextspritestat = new short[this.getMaxSprites()];
        this.zofslope = new SlopeZ();
        this.dapos = new BuildPos();
        this.initspritelists();
        this.name = name;
        this.mapversion = bb.readInt();
        this.buffer = this.load(bb) ? this.initmapbuffer() : null;
    }

    protected void initspritelists() {
        Arrays.fill(this.headspritesect, (short)-1);
        this.headspritesect[this.getMaxSectors()] = 0;
        int i = 0;
        while (i < this.getMaxSprites()) {
            this.sprite[i] = new SPRITE();
            this.prevspritesect[i] = (short)(i - 1);
            this.nextspritesect[i] = (short)(i + 1);
            this.sprite[i].sectnum = (short)this.getMaxSectors();
            ++i;
        }
        this.prevspritesect[0] = -1;
        this.nextspritesect[this.getMaxSprites() - 1] = -1;
        Arrays.fill(this.headspritestat, (short)-1);
        this.headspritestat[1024] = 0;
        i = 0;
        while (i < this.getMaxSprites()) {
            this.prevspritestat[i] = (short)(i - 1);
            this.nextspritestat[i] = (short)(i + 1);
            this.sprite[i].statnum = (short)1024;
            ++i;
        }
        this.prevspritestat[0] = -1;
        this.nextspritestat[this.getMaxSprites() - 1] = -1;
    }

    protected ByteBuffer initmapbuffer() {
        int size = 20 + (2 + this.numwalls * 32) + (2 + this.numsectors * 40) + (2 + this.getMaxSprites() * 44) + 2 * (this.getMaxSectors() + 1) + 2050 + 8 * this.getMaxSprites();
        return ByteBuffer.allocate(size);
    }

    public int insertspritesect(short sectnum) {
        if (sectnum >= this.getMaxSectors() || this.headspritesect[this.getMaxSectors()] == -1) {
            return -1;
        }
        short blanktouse = this.headspritesect[this.getMaxSectors()];
        this.headspritesect[this.getMaxSectors()] = this.nextspritesect[blanktouse];
        if (this.headspritesect[this.getMaxSectors()] >= 0) {
            this.prevspritesect[this.headspritesect[this.getMaxSectors()]] = -1;
        }
        this.prevspritesect[blanktouse] = -1;
        this.nextspritesect[blanktouse] = this.headspritesect[sectnum];
        if (this.headspritesect[sectnum] >= 0) {
            this.prevspritesect[this.headspritesect[sectnum]] = blanktouse;
        }
        this.headspritesect[sectnum] = blanktouse;
        this.sprite[blanktouse].sectnum = sectnum;
        return blanktouse;
    }

    public int insertspritestat(short newstatnum) {
        if (newstatnum >= 1024 || this.headspritestat[1024] == -1) {
            return -1;
        }
        short blanktouse = this.headspritestat[1024];
        this.headspritestat[1024] = this.nextspritestat[blanktouse];
        if (this.headspritestat[1024] >= 0) {
            this.prevspritestat[this.headspritestat[1024]] = -1;
        }
        this.prevspritestat[blanktouse] = -1;
        this.nextspritestat[blanktouse] = this.headspritestat[newstatnum];
        if (this.headspritestat[newstatnum] >= 0) {
            this.prevspritestat[this.headspritestat[newstatnum]] = blanktouse;
        }
        this.headspritestat[newstatnum] = blanktouse;
        this.sprite[blanktouse].statnum = newstatnum;
        return blanktouse;
    }

    public int insertsprite(short sectnum, short statnum) {
        this.insertspritestat(statnum);
        return this.insertspritesect(sectnum);
    }

    public boolean deletesprite(short spritenum) {
        this.deletespritestat(spritenum);
        return this.deletespritesect(spritenum);
    }

    public boolean changespritesect(short spritenum, short newsectnum) {
        if (newsectnum < 0 || newsectnum > this.getMaxSectors()) {
            return false;
        }
        if (this.sprite[spritenum].sectnum == newsectnum) {
            return true;
        }
        if (this.sprite[spritenum].sectnum == this.getMaxSectors()) {
            return false;
        }
        if (!this.deletespritesect(spritenum)) {
            return false;
        }
        this.insertspritesect(newsectnum);
        return true;
    }

    public boolean changespritestat(short spritenum, short newstatnum) {
        if (newstatnum < 0 || newstatnum > 1024) {
            return false;
        }
        if (this.sprite[spritenum].statnum == newstatnum) {
            return true;
        }
        if (this.sprite[spritenum].statnum == 1024) {
            return false;
        }
        if (!this.deletespritestat(spritenum)) {
            return false;
        }
        this.insertspritestat(newstatnum);
        return true;
    }

    public boolean deletespritesect(short spritenum) {
        if (this.sprite[spritenum].sectnum == this.getMaxSectors()) {
            return false;
        }
        if (this.headspritesect[this.sprite[spritenum].sectnum] == spritenum) {
            this.headspritesect[this.sprite[spritenum].sectnum] = this.nextspritesect[spritenum];
        }
        if (this.prevspritesect[spritenum] >= 0) {
            this.nextspritesect[this.prevspritesect[spritenum]] = this.nextspritesect[spritenum];
        }
        if (this.nextspritesect[spritenum] >= 0) {
            this.prevspritesect[this.nextspritesect[spritenum]] = this.prevspritesect[spritenum];
        }
        if (this.headspritesect[this.getMaxSectors()] >= 0) {
            this.prevspritesect[this.headspritesect[this.getMaxSectors()]] = spritenum;
        }
        this.prevspritesect[spritenum] = -1;
        this.nextspritesect[spritenum] = this.headspritesect[this.getMaxSectors()];
        this.headspritesect[this.getMaxSectors()] = spritenum;
        this.sprite[spritenum].sectnum = (short)this.getMaxSectors();
        return true;
    }

    public boolean deletespritestat(short spritenum) {
        if (this.sprite[spritenum].statnum == 1024) {
            return false;
        }
        if (this.headspritestat[this.sprite[spritenum].statnum] == spritenum) {
            this.headspritestat[this.sprite[spritenum].statnum] = this.nextspritestat[spritenum];
        }
        if (this.prevspritestat[spritenum] >= 0) {
            this.nextspritestat[this.prevspritestat[spritenum]] = this.nextspritestat[spritenum];
        }
        if (this.nextspritestat[spritenum] >= 0) {
            this.prevspritestat[this.nextspritestat[spritenum]] = this.prevspritestat[spritenum];
        }
        if (this.headspritestat[1024] >= 0) {
            this.prevspritestat[this.headspritestat[1024]] = spritenum;
        }
        this.prevspritestat[spritenum] = -1;
        this.nextspritestat[spritenum] = this.headspritestat[1024];
        this.headspritestat[1024] = spritenum;
        this.sprite[spritenum].statnum = (short)1024;
        return true;
    }

    public boolean setsprite(short spritenum, int newx, int newy, int newz) {
        this.sprite[spritenum].x = newx;
        this.sprite[spritenum].y = newy;
        this.sprite[spritenum].z = newz;
        short tempsectnum = this.sprite[spritenum].sectnum;
        tempsectnum = this.SETSPRITEZ == 1 ? this.updatesectorz(newx, newy, newz, tempsectnum) : this.updatesector(newx, newy, tempsectnum);
        if (tempsectnum < 0) {
            return false;
        }
        if (tempsectnum != this.sprite[spritenum].sectnum) {
            this.changespritesect(spritenum, tempsectnum);
        }
        return true;
    }

    public void dragpoint(short pointhighlight, int dax, int day) {
        this.wall[pointhighlight].x = dax;
        this.wall[pointhighlight].y = day;
        int cnt = this.getMaxWalls();
        short tempshort = pointhighlight;
        block0: do {
            if (this.wall[tempshort].nextwall >= 0) {
                tempshort = this.wall[this.wall[tempshort].nextwall].point2;
                this.wall[tempshort].x = dax;
                this.wall[tempshort].y = day;
                continue;
            }
            tempshort = pointhighlight;
            while (this.wall[this.lastwall((int)tempshort)].nextwall >= 0) {
                tempshort = this.wall[this.lastwall((int)tempshort)].nextwall;
                this.wall[tempshort].x = dax;
                this.wall[tempshort].y = day;
                if (tempshort != pointhighlight && --cnt > 0) continue;
                break block0;
            }
            break;
        } while (tempshort != pointhighlight && --cnt > 0);
    }

    public void alignceilslope(short dasect, int x, int y, int z) {
        WALL wal = this.wall[this.sector[dasect].wallptr];
        int dax = this.wall[wal.point2].x - wal.x;
        int day = this.wall[wal.point2].y - wal.y;
        int i = (y - wal.y) * dax - (x - wal.x) * day;
        if (i == 0) {
            return;
        }
        this.sector[dasect].ceilingheinum = (short)Pragmas.scale(z - this.sector[dasect].ceilingz << 8, this.sqrt(dax * dax + day * day), i);
        this.sector[dasect].ceilingstat = this.sector[dasect].ceilingheinum == 0 ? (short)(this.sector[dasect].ceilingstat & 0xFFFFFFFD) : (short)(this.sector[dasect].ceilingstat | 2);
    }

    public void alignflorslope(short dasect, int x, int y, int z) {
        WALL wal = this.wall[this.sector[dasect].wallptr];
        int dax = this.wall[wal.point2].x - wal.x;
        int day = this.wall[wal.point2].y - wal.y;
        int i = (y - wal.y) * dax - (x - wal.x) * day;
        if (i == 0) {
            return;
        }
        this.sector[dasect].floorheinum = (short)Pragmas.scale(z - this.sector[dasect].floorz << 8, this.sqrt(dax * dax + day * day), i);
        this.sector[dasect].floorstat = this.sector[dasect].floorheinum == 0 ? (short)(this.sector[dasect].floorstat & 0xFFFFFFFD) : (short)(this.sector[dasect].floorstat | 2);
    }

    public int getceilzofslope(short sectnum, int dax, int day) {
        if (sectnum == -1 || this.sector[sectnum] == null) {
            return 0;
        }
        if ((this.sector[sectnum].ceilingstat & 2) == 0) {
            return this.sector[sectnum].ceilingz;
        }
        WALL wal = this.wall[this.sector[sectnum].wallptr];
        int dx = this.wall[wal.point2].x - wal.x;
        int dy = this.wall[wal.point2].y - wal.y;
        int i = this.sqrt(dx * dx + dy * dy) << 5;
        if (i == 0) {
            return this.sector[sectnum].ceilingz;
        }
        long j = Pragmas.dmulscale(dx, day - wal.y, -dy, dax - wal.x, 3);
        return this.sector[sectnum].ceilingz + Pragmas.scale(this.sector[sectnum].ceilingheinum, j, i);
    }

    public int getflorzofslope(short sectnum, int dax, int day) {
        if (sectnum == -1 || this.sector[sectnum] == null) {
            return 0;
        }
        if ((this.sector[sectnum].floorstat & 2) == 0) {
            return this.sector[sectnum].floorz;
        }
        WALL wal = this.wall[this.sector[sectnum].wallptr];
        int dx = this.wall[wal.point2].x - wal.x;
        int dy = this.wall[wal.point2].y - wal.y;
        int i = this.sqrt(dx * dx + dy * dy) << 5;
        if (i == 0) {
            return this.sector[sectnum].floorz;
        }
        long j = Pragmas.dmulscale(dx, day - wal.y, -dy, dax - wal.x, 3);
        return this.sector[sectnum].floorz + Pragmas.scale(this.sector[sectnum].floorheinum, j, i);
    }

    public short updatesector(int x, int y, short sectnum) {
        if (this.inside(x, y, sectnum) == 1) {
            return sectnum;
        }
        if (sectnum >= 0 && sectnum < this.numsectors) {
            short wallid = this.sector[sectnum].wallptr;
            int j = this.sector[sectnum].wallnum;
            if (wallid < 0) {
                return -1;
            }
            while (wallid < this.getMaxWalls()) {
                WALL wal = this.wall[wallid];
                if (wal == null) {
                    wallid = (short)(wallid + 1);
                    --j;
                } else {
                    short i = wal.nextsector;
                    if (i >= 0 && this.inside(x, y, i) == 1) {
                        return i;
                    }
                    wallid = (short)(wallid + 1);
                    --j;
                }
                if (j != 0) continue;
            }
        }
        short i = (short)(this.numsectors - 1);
        while (i >= 0) {
            if (this.inside(x, y, i) == 1) {
                return i;
            }
            i = (short)(i - 1);
        }
        return -1;
    }

    public short updatesectorz(int x, int y, int z, short sectnum) {
        SlopeZ zs = this.getzsofslope(sectnum, x, y);
        if (z >= zs.getCeiling() && z <= zs.getFloor() && this.inside(x, y, sectnum) != 0) {
            return sectnum;
        }
        if (sectnum >= 0 && sectnum < this.numsectors) {
            if (this.sector[sectnum] == null) {
                return -1;
            }
            short wallid = this.sector[sectnum].wallptr;
            int j = this.sector[sectnum].wallnum;
            while (wallid < this.getMaxWalls()) {
                WALL wal = this.wall[wallid];
                if (wal == null) {
                    wallid = (short)(wallid + 1);
                    --j;
                } else {
                    short i = wal.nextsector;
                    if (i >= 0 && z >= (zs = this.getzsofslope(i, x, y)).getCeiling() && z <= zs.getFloor() && this.inside(x, y, i) == 1) {
                        return i;
                    }
                    wallid = (short)(wallid + 1);
                    --j;
                }
                if (j != 0) continue;
            }
        }
        short i = (short)(this.numsectors - 1);
        while (i >= 0) {
            zs = this.getzsofslope(i, x, y);
            if (z >= zs.getCeiling() && z <= zs.getFloor() && this.inside(x, y, i) == 1) {
                return i;
            }
            i = (short)(i - 1);
        }
        return -1;
    }

    public int inside(int x, int y, short sectnum) {
        if (sectnum < 0 || sectnum >= this.numsectors) {
            return -1;
        }
        int cnt = 0;
        int wallid = this.sector[sectnum].wallptr;
        if (wallid < 0) {
            return -1;
        }
        int i = this.sector[sectnum].wallnum;
        do {
            WALL wal;
            if ((wal = this.wall[wallid]) == null || wal.point2 < 0 || this.wall[wal.point2] == null) {
                return -1;
            }
            int y1 = wal.y - y;
            int y2 = this.wall[wal.point2].y - y;
            if ((y1 ^ y2) < 0) {
                int x1 = wal.x - x;
                int x2 = this.wall[wal.point2].x - x;
                cnt = (x1 ^ x2) >= 0 ? (cnt ^= x1) : (cnt ^= x1 * y2 - x2 * y1 ^ y2);
            }
            ++wallid;
        } while (--i != 0);
        return cnt >>> 31;
    }

    public SlopeZ getzsofslope(short sectnum, int dax, int day) {
        if (sectnum == -1 || this.sector[sectnum] == null) {
            return null;
        }
        SECTOR sec = this.sector[sectnum];
        if (sec == null) {
            return null;
        }
        int floorz = sec.floorz;
        int ceilingz = sec.ceilingz;
        this.zofslope.setFloor(floorz);
        this.zofslope.setCeiling(ceilingz);
        if (((sec.ceilingstat | sec.floorstat) & 2) != 0) {
            WALL wal = this.wall[sec.wallptr];
            WALL wal2 = this.wall[wal.point2];
            int dx = wal2.x - wal.x;
            int dy = wal2.y - wal.y;
            int i = this.sqrt(dx * dx + dy * dy) << 5;
            if (i == 0) {
                return this.zofslope;
            }
            long j = Pragmas.dmulscale(dx, day - wal.y, -dy, dax - wal.x, 3);
            if ((sec.ceilingstat & 2) != 0) {
                ceilingz += Pragmas.scale(sec.ceilingheinum, j, i);
            }
            if ((sec.floorstat & 2) != 0) {
                floorz += Pragmas.scale(sec.floorheinum, j, i);
            }
        }
        this.zofslope.setFloor(floorz);
        this.zofslope.setCeiling(ceilingz);
        return this.zofslope;
    }

    public int lastwall(int point) {
        if (point > 0 && this.wall[point - 1].point2 == point) {
            return point - 1;
        }
        int i = point;
        int cnt = this.getMaxWalls();
        do {
            short j;
            if ((j = this.wall[i].point2) == point) {
                return i;
            }
            i = j;
        } while (--cnt > 0);
        return point;
    }

    public int sectorofwall(short theline) {
        int gap;
        if (theline < 0 || theline >= this.numwalls) {
            return -1;
        }
        int i = this.wall[theline].nextwall;
        if (i >= 0) {
            return this.wall[i].nextsector;
        }
        i = gap = this.numsectors >> 1;
        while (gap > 1) {
            gap >>= 1;
            if (this.sector[i].wallptr < theline) {
                i += gap;
                continue;
            }
            i -= gap;
        }
        while (this.sector[i].wallptr > theline) {
            --i;
        }
        while (this.sector[i].wallptr + this.sector[i].wallnum <= theline) {
            ++i;
        }
        return i;
    }

    public SPRITE getSprite(int num) {
        return this.sprite[num];
    }

    public SECTOR getSector(int num) {
        return this.sector[num];
    }

    public WALL getWall(int num) {
        return this.wall[num];
    }

    public short headspritesect(short sectnum) {
        return this.headspritesect[sectnum];
    }

    public short headspritestat(short statnum) {
        return this.headspritestat[statnum];
    }

    public short nextspritesect(short spritenum) {
        return this.nextspritesect[spritenum];
    }

    public short nextspritestat(short spritenum) {
        return this.nextspritestat[spritenum];
    }

    public byte[] getBytes() {
        this.buffer.clear();
        this.buffer.putInt(this.mapversion);
        this.buffer.putInt(this.dapos.x);
        this.buffer.putInt(this.dapos.y);
        this.buffer.putInt(this.dapos.z);
        this.buffer.putShort(this.dapos.ang);
        this.buffer.putShort(this.dapos.sectnum);
        this.buffer.putShort((short)this.numwalls);
        int w = 0;
        while (w < this.numwalls) {
            this.buffer.put(this.wall[w].getBytes());
            ++w;
        }
        this.buffer.putShort((short)this.numsectors);
        int s = 0;
        while (s < this.numsectors) {
            this.buffer.put(this.sector[s].getBytes());
            ++s;
        }
        this.buffer.putShort((short)this.numsprites);
        int i = 0;
        while (i < this.getMaxSprites()) {
            this.buffer.put(this.sprite[i].getBytes());
            ++i;
        }
        i = 0;
        while (i <= this.getMaxSectors()) {
            this.buffer.putShort(this.headspritesect[i]);
            ++i;
        }
        i = 0;
        while (i <= 1024) {
            this.buffer.putShort(this.headspritestat[i]);
            ++i;
        }
        i = 0;
        while (i < this.getMaxSprites()) {
            this.buffer.putShort(this.prevspritesect[i]);
            this.buffer.putShort(this.prevspritestat[i]);
            this.buffer.putShort(this.nextspritesect[i]);
            this.buffer.putShort(this.nextspritestat[i]);
            ++i;
        }
        return this.buffer.array();
    }

    public String getName() {
        return this.name;
    }

    public static class SlopeZ {
        public int floorz;
        public int ceilingz;

        public void setFloor(int value) {
            this.floorz = value;
        }

        public void setCeiling(int value) {
            this.ceilingz = value;
        }

        public int getFloor() {
            return this.floorz;
        }

        public int getCeiling() {
            return this.ceilingz;
        }
    }
}

