/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.io.EOFException;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Strhandler;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class FileResource
implements Resource {
    private static Unsafe unsafe;
    private static byte[] tmpbuf;
    private RandomAccessFile raf;
    private Mode mode;
    private String ext;
    private MappedByteBuffer fbuf;

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        tmpbuf = new byte[1024];
    }

    protected FileResource open(File file, Mode mode) {
        this.mode = mode;
        try {
            switch (mode) {
                case Read: {
                    this.raf = new RandomAccessFile(file, "r");
                    try {
                        FileChannel ch = this.raf.getChannel();
                        this.fbuf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, this.raf.length());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.handle(file);
                    return this;
                }
                case Write: {
                    this.raf = new RandomAccessFile(file, "rw");
                    this.raf.setLength(0L);
                    this.handle(file);
                    return this;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void handle(File file) {
        String filename = Strhandler.toLowerCase(file.getName());
        this.ext = filename.substring(filename.lastIndexOf(46) + 1);
    }

    public String getPath() {
        if (this.isClosed()) {
            return null;
        }
        try {
            Field path = this.raf.getClass().getDeclaredField("path");
            path.setAccessible(true);
            return (String)path.get(this.raf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public boolean isClosed() {
        return this.raf == null;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            if (this.fbuf != null) {
                this.free(this.fbuf);
                this.fbuf = null;
            }
            this.raf.close();
            this.raf = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void free(MappedByteBuffer bb) {
        try {
            if (BuildGdx.app.getPlatform() != BuildApplication.Platform.Android && BuildGdx.app.getVersion() < 9) {
                Cleaner cleaner = ((DirectBuffer)((Object)bb)).cleaner();
                Method invokeCleaner = cleaner.getClass().getDeclaredMethod("clean", new Class[0]);
                invokeCleaner.setAccessible(true);
                invokeCleaner.invoke((Object)cleaner, new Object[0]);
            } else {
                Method invokeCleaner = Unsafe.class.getMethod("invokeCleaner", ByteBuffer.class);
                invokeCleaner.invoke((Object)unsafe, bb);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int seek(long offset, Resource.Whence whence) {
        int var = -1;
        if (this.isClosed()) {
            return var;
        }
        try {
            if (whence == Resource.Whence.Set) {
                if (offset < 0L) {
                    return -1;
                }
            } else if (whence == Resource.Whence.Current) {
                offset += (long)this.position();
            } else if (whence == Resource.Whence.End) {
                offset += (long)this.size();
            }
            if (this.fbuf != null) {
                this.fbuf.position((int)offset);
                return this.position();
            } else {
                this.raf.getChannel().position(offset);
            }
            return this.position();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return var;
    }

    @Override
    public int read(byte[] buf, int offset, int len) {
        int var = -1;
        if (this.isClosed()) {
            return var;
        }
        try {
            if (this.fbuf != null) {
                if (this.fbuf.remaining() >= len) {
                    this.fbuf.get(buf, offset, len);
                    var = len;
                } else if (this.fbuf.remaining() > 0) {
                    len = this.fbuf.remaining();
                    this.fbuf.get(buf, offset, len);
                    var = len;
                }
            } else {
                var = this.raf.read(buf, offset, len);
            }
        }
        catch (EOFException e) {
            return -1;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read file \r\n" + e.getMessage());
        }
        return var;
    }

    @Override
    public int read(byte[] buf) {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(ByteBuffer bb, int offset, int len) {
        try {
            int var = -1;
            bb.position(offset);
            int p = 0;
            while (len > 0) {
                if (this.fbuf != null) {
                    var = Math.min(len, tmpbuf.length);
                    if (var > this.fbuf.remaining()) {
                        return p;
                    }
                    this.fbuf.get(tmpbuf, 0, var);
                } else {
                    var = this.raf.read(tmpbuf, 0, Math.min(len, tmpbuf.length));
                    if (var == -1) {
                        return p;
                    }
                }
                bb.put(tmpbuf, 0, var);
                len -= var;
                p += var;
            }
            return p;
        }
        catch (EOFException e) {
            return -1;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read file \r\n" + e.getMessage());
        }
    }

    @Override
    public String readString(int len) {
        byte[] data = len < tmpbuf.length ? tmpbuf : new byte[len];
        if (this.read(data, 0, len) != len) {
            return null;
        }
        return new String(data, 0, len);
    }

    @Override
    public Integer readInt() {
        if (this.read(tmpbuf, 0, 4) == 4) {
            return ((tmpbuf[3] & 0xFF) << 24) + ((tmpbuf[2] & 0xFF) << 16) + ((tmpbuf[1] & 0xFF) << 8) + (tmpbuf[0] & 0xFF);
        }
        return null;
    }

    @Override
    public Long readLong() {
        if (this.read(tmpbuf, 0, 8) == 8) {
            return (((long)tmpbuf[7] & 0xFFL) << 56) + (((long)tmpbuf[6] & 0xFFL) << 48) + (((long)tmpbuf[5] & 0xFFL) << 40) + (((long)tmpbuf[4] & 0xFFL) << 32) + (((long)tmpbuf[3] & 0xFFL) << 24) + (((long)tmpbuf[2] & 0xFFL) << 16) + (((long)tmpbuf[1] & 0xFFL) << 8) + ((long)tmpbuf[0] & 0xFFL);
        }
        return null;
    }

    @Override
    public Float readFloat() {
        Integer i = this.readInt();
        if (i != null) {
            return Float.valueOf(Float.intBitsToFloat(i));
        }
        return null;
    }

    @Override
    public Short readShort() {
        if (this.read(tmpbuf, 0, 2) == 2) {
            return (short)(((tmpbuf[1] & 0xFF) << 8) + (tmpbuf[0] & 0xFF));
        }
        return null;
    }

    @Override
    public Byte readByte() {
        if (this.isClosed()) {
            return null;
        }
        try {
            if (this.fbuf != null) {
                return this.fbuf.get();
            }
            return this.raf.readByte();
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read file \r\n" + e.getMessage());
        }
    }

    @Override
    public Boolean readBoolean() {
        Byte var = this.readByte();
        if (var != null) {
            if (var == 1) {
                return true;
            }
            return false;
        }
        return null;
    }

    protected ByteBuffer readBuffer(int len) {
        MappedByteBuffer out = null;
        if (this.isClosed()) {
            return null;
        }
        try {
            FileChannel ch = this.raf.getChannel();
            long pos = ch.position();
            out = ch.map(FileChannel.MapMode.READ_ONLY, pos, len);
            ch.position(pos + (long)len);
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read file \r\n" + e.getMessage());
        }
        return out;
    }

    public int writeBytes(Object array) {
        int len = 0;
        if (array instanceof byte[]) {
            len = ((byte[])array).length;
        } else if (array instanceof ByteBuffer) {
            len = ((ByteBuffer)array).capacity();
        } else if (array instanceof short[]) {
            len = ((short[])array).length;
        } else if (array instanceof int[]) {
            len = ((int[])array).length;
        } else if (array instanceof char[]) {
            len = ((char[])array).length;
        } else if (array instanceof String) {
            len = ((String)array).getBytes().length;
        } else {
            throw new UnsupportedOperationException("Couldn't write to file. \r\n + Not implemented!");
        }
        if (len != 0) {
            return this.writeBytes(array, len);
        }
        return -1;
    }

    public int writeBytes(Object obj, int len) {
        int var = -1;
        if (this.isClosed() || this.getMode() != Mode.Write) {
            return var;
        }
        try {
            byte[] data = null;
            if (obj instanceof Byte) {
                int rem = len;
                while (rem > 0) {
                    int l = Math.min(rem, tmpbuf.length);
                    Gameutils.fill(tmpbuf, 0, l, ((Byte)obj).byteValue());
                    this.raf.write(tmpbuf, 0, l);
                    rem -= l;
                }
                return len;
            }
            if (obj instanceof byte[]) {
                data = (byte[])obj;
            } else if (obj instanceof char[]) {
                data = new byte[len];
                char[] src = (char[])obj;
                int i = 0;
                while (i < Math.min(len, src.length)) {
                    data[i] = (byte)src[i];
                    ++i;
                }
            } else if (obj instanceof ByteBuffer) {
                ByteBuffer buf = (ByteBuffer)obj;
                buf.rewind();
                if (!buf.isDirect()) {
                    data = buf.array();
                } else {
                    data = new byte[Math.min(len, buf.capacity())];
                    buf.get(data);
                }
            } else if (obj instanceof short[]) {
                var = 0;
                short[] shortArr = (short[])obj;
                len = Math.min(len, shortArr.length);
                int i = 0;
                while (i < len) {
                    var += this.writeShort(shortArr[i]);
                    ++i;
                }
            } else if (obj instanceof int[]) {
                var = 0;
                int[] intArr = (int[])obj;
                len = Math.min(len, intArr.length);
                int i = 0;
                while (i < len) {
                    var += this.writeInt(intArr[i]);
                    ++i;
                }
            } else if (obj instanceof String) {
                data = ((String)obj).getBytes();
            } else {
                throw new UnsupportedOperationException("Couldn't write to file. \r\n + Not implemented!");
            }
            if (data != null) {
                len = Math.min(len, data.length);
                this.raf.write(data, 0, len);
                var = len;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't write to file \r\n" + e.getMessage());
        }
        return var;
    }

    public int writeByte(int value) {
        int var = -1;
        if (this.isClosed() || this.getMode() != Mode.Write) {
            return var;
        }
        FileResource.tmpbuf[0] = (byte)value;
        try {
            this.raf.write(tmpbuf, 0, 1);
            var = 1;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't write to file \r\n" + e.getMessage());
        }
        return var;
    }

    public int writeShort(int value) {
        int var = -1;
        if (this.isClosed() || this.getMode() != Mode.Write) {
            return var;
        }
        FileResource.tmpbuf[0] = (byte)(value >>> 0 & 0xFF);
        FileResource.tmpbuf[1] = (byte)(value >>> 8 & 0xFF);
        try {
            this.raf.write(tmpbuf, 0, 2);
            var = 2;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't write to file \r\n" + e.getMessage());
        }
        return var;
    }

    public int writeInt(int value) {
        int var = -1;
        if (this.isClosed() || this.getMode() != Mode.Write) {
            return var;
        }
        FileResource.tmpbuf[0] = (byte)(value >>> 0 & 0xFF);
        FileResource.tmpbuf[1] = (byte)(value >>> 8 & 0xFF);
        FileResource.tmpbuf[2] = (byte)(value >>> 16 & 0xFF);
        FileResource.tmpbuf[3] = (byte)(value >>> 24 & 0xFF);
        try {
            this.raf.write(tmpbuf, 0, 4);
            var = 4;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't write to file \r\n" + e.getMessage());
        }
        return var;
    }

    @Override
    public int size() {
        int var = -1;
        if (this.isClosed()) {
            return var;
        }
        try {
            var = this.fbuf != null ? this.fbuf.capacity() : (int)this.raf.length();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return var;
    }

    @Override
    public int position() {
        int var = -1;
        if (this.isClosed()) {
            return var;
        }
        try {
            var = this.fbuf != null ? this.fbuf.position() : (int)this.raf.getChannel().position();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return var;
    }

    @Override
    public void toMemory() {
    }

    @Override
    public byte[] getBytes() {
        byte[] data;
        int size = this.size();
        if (size > 0 && this.read(data = new byte[size]) != -1) {
            return data;
        }
        return null;
    }

    @Override
    public Group getParent() {
        return null;
    }

    @Override
    public String getExtension() {
        return this.ext;
    }

    @Override
    public int remaining() {
        return this.size() - this.position();
    }

    @Override
    public boolean hasRemaining() {
        return this.position() < this.size();
    }

    @Override
    public String getFullName() {
        return FileUtils.getFullName(this.getPath());
    }

    public static enum Mode {
        Read,
        Write;

    }
}

