/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Loader;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Audio.SoundData;
import ru.m210projects.Build.Types.LittleEndian;

public class WAVLoader
extends SoundData {
    public WAVLoader(byte[] data) throws Exception {
        if (data.length <= 44) {
            throw new Exception("Wrong file size");
        }
        this.getInfo(data);
        this.data = ByteBuffer.allocateDirect(data.length - 44);
        this.data.put(data, 44, this.data.capacity());
        this.data.rewind();
    }

    private void getInfo(byte[] data) throws Exception {
        int ptr = 0;
        int riff_id = LittleEndian.getInt(data, ptr);
        ptr += 4;
        if (riff_id != 1179011410) {
            throw new Exception("RIFF header not found");
        }
        int format = LittleEndian.getInt(data, ptr += 4);
        ptr += 4;
        if (format != 1163280727) {
            throw new Exception("Invalid wave file header");
        }
        int fmt_id = LittleEndian.getInt(data, ptr);
        ptr += 4;
        if (fmt_id != 544501094) {
            throw new Exception("Invalid wave file header");
        }
        int pcm_id = LittleEndian.getInt(data, ptr);
        ptr += 4;
        if (pcm_id != 16) {
            throw new Exception("WAV files must be PCM: " + pcm_id);
        }
        this.channels = LittleEndian.getShort(data, ptr += 2);
        ptr += 2;
        if (this.channels != 1 && this.channels != 2) {
            throw new Exception("WAV files must have 1 or 2 channels: " + this.channels);
        }
        this.rate = LittleEndian.getInt(data, ptr);
        ptr += 4;
        ptr += 4;
        this.bits = LittleEndian.getShort(data, ptr += 2);
    }
}

