/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Net.WaifUPnp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.LinkedList;
import ru.m210projects.Build.Net.WaifUPnp.Gateway;

abstract class GatewayFinder {
    private static final String[] SEARCH_MESSAGES;
    private LinkedList<GatewayListener> listeners = new LinkedList();

    static {
        LinkedList<String> m = new LinkedList<String>();
        String[] stringArray = new String[]{"urn:schemas-upnp-org:device:InternetGatewayDevice:1", "urn:schemas-upnp-org:service:WANIPConnection:1", "urn:schemas-upnp-org:service:WANPPPConnection:1"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            m.add("M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1900\r\nST: " + type + "\r\nMAN: \"ssdp:discover\"\r\nMX: 2\r\n\r\n");
            ++n2;
        }
        SEARCH_MESSAGES = m.toArray(new String[0]);
    }

    public GatewayFinder() {
        Inet4Address[] inet4AddressArray = GatewayFinder.getLocalIPs();
        int n = inet4AddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Inet4Address ip = inet4AddressArray[n2];
            String[] stringArray = SEARCH_MESSAGES;
            int n3 = SEARCH_MESSAGES.length;
            int n4 = 0;
            while (n4 < n3) {
                String req = stringArray[n4];
                GatewayListener l = new GatewayListener(ip, req);
                l.start();
                this.listeners.add(l);
                ++n4;
            }
            ++n2;
        }
    }

    public boolean isSearching() {
        for (GatewayListener l : this.listeners) {
            if (!l.isAlive()) continue;
            return true;
        }
        return false;
    }

    public abstract void gatewayFound(Gateway var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Inet4Address[] getLocalIPs() {
        LinkedList<Inet4Address> ret = new LinkedList<Inet4Address>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            block4: while (true) {
                if (!ifaces.hasMoreElements()) {
                    return ret.toArray(new Inet4Address[0]);
                }
                try {
                    Enumeration<InetAddress> addrs;
                    NetworkInterface iface = ifaces.nextElement();
                    if (!iface.isUp() || iface.isLoopback() || iface.isVirtual() || iface.isPointToPoint() || (addrs = iface.getInetAddresses()) == null) continue;
                    while (true) {
                        if (!addrs.hasMoreElements()) continue block4;
                        InetAddress addr = addrs.nextElement();
                        if (!(addr instanceof Inet4Address)) continue;
                        ret.add((Inet4Address)addr);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret.toArray(new Inet4Address[0]);
    }

    private class GatewayListener
    extends Thread {
        private Inet4Address ip;
        private String req;

        public GatewayListener(Inet4Address ip, String req) {
            this.setName("WaifUPnP - Gateway Listener");
            this.ip = ip;
            this.req = req;
        }

        @Override
        public void run() {
            try {
                byte[] req = this.req.getBytes();
                DatagramSocket s = new DatagramSocket(new InetSocketAddress(this.ip, 0));
                s.send(new DatagramPacket(req, req.length, new InetSocketAddress("239.255.255.250", 1900)));
                s.setSoTimeout(3000);
                try {
                    while (true) {
                        DatagramPacket recv = new DatagramPacket(new byte[1536], 1536);
                        s.receive(recv);
                        Gateway gw = new Gateway(recv.getData(), this.ip);
                        GatewayFinder.this.gatewayFound(gw);
                    }
                }
                catch (SocketTimeoutException t) {}
                finally {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

