/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Tile;

public class BuildFont {
    public byte[] atlas;
    public static final int nSpace = -2;
    protected int nHeight;
    protected int nScale;
    protected int nFlags;
    protected BuildChar[] charInfo;
    protected final Engine draw;

    protected BuildFont(Engine draw) {
        this.draw = draw;
        this.charInfo = new BuildChar[256];
        int i = 0;
        while (i < 256) {
            this.charInfo[i] = new BuildChar();
            ++i;
        }
    }

    protected BuildFont(Engine draw, int nHeigth, int nScale, int nFlags) {
        this.draw = draw;
        this.nHeight = nHeigth;
        this.nScale = nScale;
        this.nFlags = nFlags;
        this.charInfo = new BuildChar[256];
        int i = 0;
        while (i < 256) {
            this.charInfo[i] = new BuildChar();
            ++i;
        }
    }

    protected void addChar(char ch, int nTile, int nWidth, int nScale, int xOffset, int yOffset) {
        this.charInfo[ch].nTile = nTile;
        this.charInfo[ch].xOffset = (short)xOffset;
        this.charInfo[ch].yOffset = (short)yOffset;
        this.charInfo[ch].nWidth = (short)nWidth;
    }

    public int getTile(int ch) {
        if (!this.charBounds(ch)) {
            return -1;
        }
        return this.charInfo[ch].nTile;
    }

    public int getWidth(char ch) {
        if (!this.charBounds(ch)) {
            return 0;
        }
        return this.charInfo[ch].nWidth;
    }

    public int getWidth(char[] text) {
        int width = 0;
        if (text != null) {
            int pos = 0;
            while (pos < text.length && text[pos] != '\u0000') {
                if (!this.charBounds(text[pos])) {
                    ++pos;
                    continue;
                }
                width += this.charInfo[text[pos++]].nWidth;
            }
        }
        return width;
    }

    public int getWidth(String text) {
        return this.getWidth(Strhandler.toCharArray(text));
    }

    public int getHeight() {
        return this.nHeight;
    }

    public int drawChar(int x, int y, char ch, int shade, int pal, int nBits, boolean shadow) {
        Tile pic;
        if (!this.charBounds(ch) || this.charInfo[ch].nTile == -1) {
            return 0;
        }
        if (this.charInfo[ch].nTile != -2 && (pic = this.draw.getTile(this.charInfo[ch].nTile)) != null && pic.hasSize()) {
            if (shadow) {
                this.draw.rotatesprite(x + this.charInfo[ch].xOffset + 1 << 16, y + this.charInfo[ch].yOffset + 1 << 16, this.nScale, 0, this.charInfo[ch].nTile, 127, 0, this.nFlags | nBits, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            this.draw.rotatesprite(x + this.charInfo[ch].xOffset << 16, y + this.charInfo[ch].yOffset << 16, this.nScale, 0, this.charInfo[ch].nTile, shade, pal, this.nFlags | nBits, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        return this.charInfo[ch].nWidth;
    }

    public int drawText(int x, int y, String text, int shade, int pal, TextAlign textAlign, int nBits, boolean shadow) {
        if (text == null) {
            return 0;
        }
        return this.drawText(x, y, Strhandler.toCharArray(text), shade, pal, textAlign, nBits, shadow);
    }

    public int drawText(int x, int y, char[] text, int shade, int pal, TextAlign textAlign, int nBits, boolean shadow) {
        if (text == null) {
            return 0;
        }
        if (textAlign != TextAlign.Left) {
            int nWidth = this.getWidth(text);
            if (textAlign == TextAlign.Center) {
                nWidth >>= 1;
            }
            x -= nWidth;
        }
        int alignx = 0;
        int i = 0;
        while (i < text.length && text[i] != '\u0000') {
            if (this.charBounds(text[i])) {
                alignx += this.drawChar(x + alignx, y, text[i], shade, pal, nBits, shadow);
            }
            ++i;
        }
        return alignx;
    }

    public int getWidth(char ch, int scale) {
        int zoom = Pragmas.mulscale(65536L, Pragmas.mulscale(scale, this.nScale, 16), 16);
        return Pragmas.scale(this.getWidth(ch), zoom, this.nScale);
    }

    public int getWidth(char[] text, int scale) {
        int zoom = Pragmas.mulscale(65536L, Pragmas.mulscale(scale, this.nScale, 16), 16);
        return Pragmas.scale(this.getWidth(text), zoom, this.nScale);
    }

    public int getWidth(String text, int scale) {
        return this.getWidth(Strhandler.toCharArray(text), scale);
    }

    public int getHeight(int scale) {
        int zoom = Pragmas.mulscale(65536L, Pragmas.mulscale(scale, this.nScale, 16), 16);
        return Pragmas.scale(this.getHeight(), zoom, this.nScale);
    }

    public int drawChar(int x, int y, char ch, int scale, int shade, int pal, int nBits, boolean shadow) {
        Tile pic;
        if (!this.charBounds(ch) || this.charInfo[ch].nTile == -1) {
            return 0;
        }
        int zoom = Pragmas.mulscale(65536L, Pragmas.mulscale(scale, this.nScale, 16), 16);
        if (this.charInfo[ch].nTile != -2 && (pic = this.draw.getTile(this.charInfo[ch].nTile)) != null && pic.hasSize()) {
            if (shadow) {
                this.draw.rotatesprite(x + this.charInfo[ch].xOffset + 1 << 16, y + this.charInfo[ch].yOffset + 1 << 16, zoom, 0, this.charInfo[ch].nTile, 127, 0, this.nFlags | nBits, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            this.draw.rotatesprite(x + this.charInfo[ch].xOffset << 16, y + this.charInfo[ch].yOffset << 16, zoom, 0, this.charInfo[ch].nTile, shade, pal, this.nFlags | nBits, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        return Pragmas.scale(this.charInfo[ch].nWidth, zoom, this.nScale);
    }

    public int drawText(int x, int y, char[] text, int scale, int shade, int pal, TextAlign textAlign, int nBits, boolean shadow) {
        if (text == null) {
            return 0;
        }
        if (textAlign != TextAlign.Left) {
            int nWidth = this.getWidth(text, scale);
            if (textAlign == TextAlign.Center) {
                nWidth >>= 1;
            }
            x -= nWidth;
        }
        int alignx = 0;
        int i = 0;
        while (i < text.length && text[i] != '\u0000') {
            if (this.charBounds(text[i])) {
                alignx += this.drawChar(x + alignx, y, text[i], scale, shade, pal, nBits, shadow);
            }
            ++i;
        }
        return alignx;
    }

    public int drawText(int x, int y, String text, int scale, int shade, int pal, TextAlign textAlign, int nBits, boolean shadow) {
        if (text == null) {
            return 0;
        }
        return this.drawText(x, y, Strhandler.toCharArray(text), scale, shade, pal, textAlign, nBits, shadow);
    }

    public boolean charBounds(int ch) {
        return ch >= 0 && ch < 256;
    }

    protected class BuildChar {
        public int nTile = -1;
        public short nWidth;
        public short xOffset;
        public short yOffset;

        protected BuildChar() {
        }
    }

    public static enum TextAlign {
        Left,
        Center,
        Right;

    }
}

