/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildMessage;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.OSDCOMMAND;
import ru.m210projects.Build.OnSceenDisplay.OSDCVARFUNC;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.MemLog;

public class InitScreen
extends ScreenAdapter {
    private int frames;
    private BuildEngine engine;
    private BuildFactory factory;
    private Thread thread;
    private BuildGame game;
    private boolean gameInitialized;
    private boolean disposing;

    @Override
    public void show() {
        this.frames = 0;
        Console.fullscreen(true);
        this.gameInitialized = false;
        this.disposing = false;
    }

    @Override
    public void hide() {
        Console.fullscreen(false);
    }

    private void ConsoleInit() {
        Console.RegisterCvar(new OSDCOMMAND("memusage", "mem usage / total", new OSDCVARFUNC(){

            @Override
            public void execute() {
                Console.Println("Memory used: " + MemLog.used() + " / " + MemLog.total() + " mb");
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("net_bufferjitter", "net_bufferjitter", new OSDCVARFUNC(){

            @Override
            public void execute() {
                Console.Println("bufferjitter: " + ((InitScreen)InitScreen.this).game.pNet.bufferJitter);
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("deb_filelist", "deb_filelist", new OSDCVARFUNC(){

            @Override
            public void execute() {
                for (Group g : BuildGdx.cache.getGroupList()) {
                    Console.Println("group: " + g.name);
                    for (GroupResource res : g.getList()) {
                        Console.Println("\t   file: " + res.getFullName());
                    }
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("quit", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                ((InitScreen)InitScreen.this).game.gExit = true;
            }
        }));
    }

    public InitScreen(final BuildGame game) {
        this.game = game;
        this.factory = game.getFactory();
        Console.SetLogFile(String.valueOf(game.appname) + ".log");
        Console.Println("BUILD engine by Ken Silverman (http://www.advsys.net/ken) \r\n" + game.appname + " " + game.sversion + "(BuildGdx v" + "20.072" + ") by [M210\u00ae] (http://m210.duke4.net)");
        Console.Println("Current date " + game.date.getLaunchDate());
        String osver = System.getProperty("os.version");
        String jrever = System.getProperty("java.version");
        Console.Println("Running on " + game.OS + " (version " + osver + ")");
        Console.Println("\t with JRE version: " + jrever + "\r\n");
        Console.Println("Initializing resource archives");
        int i = 0;
        while (i < this.factory.resources.length) {
            try {
                BuildGdx.cache.add(this.factory.resources[i]);
            }
            catch (Exception e) {
                BuildGdx.message.show("Init error!", "Resource initialization error! \r\n" + e.getMessage(), BuildMessage.MessageType.Info);
                System.exit(1);
                return;
            }
            ++i;
        }
        try {
            Console.Println("Initializing Build 3D engine");
            this.engine = game.pEngine = this.factory.engine();
        }
        catch (Exception e) {
            BuildGdx.message.show("Build Engine Initialization Error!", "There was a problem initialising the Build engine: \r\n" + e.getMessage(), BuildMessage.MessageType.Info);
            System.exit(1);
            return;
        }
        game.pInt = new Interpolation();
        game.pSavemgr = new SaveManager();
        Console.setFunction(this.factory.console());
        if (this.engine.loadpics() == 0) {
            BuildGdx.message.show("Build Engine Initialization Error!", "ART files not found " + new File(String.valueOf(Compat.Path.Game.getPath()) + this.engine.tilesPath).getAbsolutePath(), BuildMessage.MessageType.Info);
            System.exit(1);
            return;
        }
        BuildConfig cfg = game.pCfg;
        game.pFonts = this.factory.fonts();
        BuildSettings.init(this.engine, cfg);
        GLSettings.init(this.engine, cfg);
        this.engine.setrendermode(this.factory.renderer(cfg.renderType));
        if (!this.engine.setgamemode(cfg.fullscreen, cfg.ScreenWidth, cfg.ScreenHeight)) {
            cfg.fullscreen = 0;
        }
        Engine.fullscreen = cfg.fullscreen;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        BuildConfig cfg = game.pCfg;
                        cfg.InitKeymap();
                        if (!cfg.isInited) {
                            cfg.isInited = cfg.InitConfig(!cfg.isExist());
                        }
                        game.pNet = InitScreen.this.factory.net();
                        game.pInput = InitScreen.this.factory.input(BuildGdx.controllers.init());
                        game.pSlider = InitScreen.this.factory.slider();
                        game.pMenu = InitScreen.this.factory.menus();
                        game.baseDef = InitScreen.this.factory.getBaseDef(InitScreen.this.engine);
                        Mmulti.uninitmultiplayer();
                        cfg.snddrv = BuildGdx.audio.checkNum(BuildAudio.Driver.Sound, cfg.snddrv);
                        cfg.middrv = BuildGdx.audio.checkNum(BuildAudio.Driver.Music, cfg.middrv);
                        BuildGdx.audio.setDriver(BuildAudio.Driver.Sound, cfg.snddrv);
                        BuildGdx.audio.setDriver(BuildAudio.Driver.Music, cfg.middrv);
                        int consolekey = BuildConfig.GameKeys.Show_Console.getNum();
                        if (consolekey != -1) {
                            Console.setCaptureKey(cfg.primarykeys[consolekey], 0);
                            Console.setCaptureKey(cfg.secondkeys[consolekey], 1);
                            Console.setCaptureKey(cfg.mousekeys[consolekey], 2);
                            Console.setCaptureKey(cfg.gpadkeys[consolekey], 3);
                        }
                        BuildSettings.usenewaspect.set(cfg.widescreen == 1);
                        BuildSettings.fov.set(cfg.gFov);
                        BuildSettings.fpsLimit.set(cfg.fpslimit);
                        InitScreen.this.gameInitialized = game.init();
                        InitScreen.this.ConsoleInit();
                    }
                    catch (OutOfMemoryError me) {
                        System.gc();
                        me.printStackTrace();
                        String message = "Memory used: [ " + MemLog.used() + " / " + MemLog.total() + " mb ] \r\nPlease, increase the java's heap size.";
                        Console.Println(message, Console.OSDTEXT_RED);
                        BuildGdx.message.show("OutOfMemory!", message, BuildMessage.MessageType.Info);
                        System.exit(1);
                    }
                    catch (FileNotFoundException fe) {
                        fe.printStackTrace();
                        String message = fe.getMessage();
                        Console.Println(message, Console.OSDTEXT_RED);
                        BuildGdx.message.show("File not found!", message, BuildMessage.MessageType.Info);
                        System.exit(1);
                    }
                    catch (Throwable e) {
                        if (InitScreen.this.disposing) break block6;
                        game.ThrowError("InitScreen error", e);
                        System.exit(1);
                    }
                }
            }
        });
        this.thread.setName("InitEngine thread");
        this.thread.setDaemon(true);
    }

    public void start() {
        if (this.thread != null) {
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = Engine.lock;
        synchronized (object) {
            this.disposing = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(float delta) {
        Object object = Engine.lock;
        synchronized (object) {
            if (!this.disposing) {
                this.engine.clearview(0);
                this.factory.drawInitScreen();
                if (this.frames++ > 3 && !this.thread.isAlive()) {
                    if (this.gameInitialized) {
                        this.game.show();
                    } else {
                        this.game.GameMessage("InitScreen unknown error!");
                        BuildGdx.app.exit();
                    }
                }
                this.engine.nextpage();
            }
        }
    }
}

