/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.NumberUtils;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Types.GL10;

public class GdxBatch {
    private Mesh mesh;
    final float[] vertices;
    int idx = 0;
    GLTexture lastTexture = null;
    float invTexWidth = 0.0f;
    float invTexHeight = 0.0f;
    boolean drawing = false;
    private final Matrix4 projectionMatrix = new Matrix4();
    private boolean blendingDisabled = false;
    private int blendSrcFunc = 770;
    private int blendDstFunc = 771;
    private int blendSrcFuncAlpha = 770;
    private int blendDstFuncAlpha = 771;
    private final ShaderProgram shader;
    private ShaderProgram customShader = null;
    private boolean ownsShader;
    float color = Color.WHITE_FLOAT_BITS;
    public int maxSpritesInBatch = 0;
    private float[] currClipBounds = new float[4];
    private float[] lastClipBounds = new float[4];

    public GdxBatch() {
        this(32, null);
    }

    public GdxBatch(int size, ShaderProgram defaultShader) {
        if (size > 8191) {
            throw new IllegalArgumentException("Can't have more than 8191 sprites per batch: " + size);
        }
        this.mesh = new Mesh(false, size * 4, size * 6, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.projectionMatrix.setToOrtho(0.0f, BuildGdx.graphics.getWidth() - 1, BuildGdx.graphics.getHeight() - 1, 0.0f, 0.0f, 1.0f);
        int VERTEX_SIZE = 5;
        int SPRITE_SIZE = 4 * VERTEX_SIZE;
        this.vertices = new float[size * SPRITE_SIZE];
        int len = size * 6;
        short[] indices = new short[len];
        short j = 0;
        int i = 0;
        while (i < len) {
            indices[i] = j;
            indices[i + 1] = (short)(j + 1);
            indices[i + 2] = (short)(j + 2);
            indices[i + 3] = (short)(j + 2);
            indices[i + 4] = (short)(j + 3);
            indices[i + 5] = j;
            i += 6;
            j = (short)(j + 4);
        }
        this.mesh.setIndices(indices);
        if (defaultShader == null) {
            this.shader = GdxBatch.createDefaultShader();
            this.ownsShader = true;
        } else {
            this.shader = defaultShader;
        }
    }

    public static ShaderProgram createDefaultShader() {
        String vertexShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n";
        String fragmentShader = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying LOWP vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\n\nuniform float cx1;\nuniform float cy1;\nuniform float cx2;\nuniform float cy2;\n\nvoid main()\n{\n\t//rotatesprite clipping\n\tif( gl_FragCoord.x < cx1 || gl_FragCoord.x > cx2 + 1.0\n\t\t|| gl_FragCoord.y > cy1 || gl_FragCoord.y < cy2 - 1.0 ) \n\t\tdiscard;\n\tgl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}\n";
        ShaderProgram shader = new ShaderProgram(vertexShader, fragmentShader);
        if (!shader.isCompiled()) {
            throw new IllegalArgumentException("Error compiling shader: " + shader.getLog());
        }
        return shader;
    }

    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("GdxBatch.end must be called before begin.");
        }
        BuildGdx.gl.glDepthMask(false);
        if (this.customShader != null) {
            this.customShader.begin();
        } else {
            this.shader.begin();
        }
        this.setupMatrices();
        this.drawing = true;
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("GdxBatch.begin must be called before end.");
        }
        if (this.idx > 0) {
            this.flush();
        }
        this.lastTexture = null;
        this.drawing = false;
        GL10 gl = BuildGdx.gl;
        gl.glDepthMask(true);
        if (this.isBlendingEnabled()) {
            gl.glDisable(3042);
        }
        if (this.customShader != null) {
            this.customShader.end();
        } else {
            this.shader.end();
        }
    }

    public void setColor(float r, float g, float b, float a) {
        int intBits = (int)(255.0f * a) << 24 | (int)(255.0f * b) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        this.color = NumberUtils.intToFloatColor(intBits);
    }

    public void draw(GLTexture tex, int sx, int sy, int sizx, int sizy, int xoffset, int yoffset, int angle, int z, int dastat, int cx1, int cy1, int cx2, int cy2) {
        this.draw(tex, sx, sy, sizx, sizy, xoffset, yoffset, 0.0f, 0.0f, sizx, sizy, angle, z, dastat, cx1, cy1, cx2, cy2);
    }

    public void draw(GLTexture tex, int sx, int sy, int sizx, int sizy, int xoffset, int yoffset, float srcX, float srcY, float srcWidth, float srcHeight, int angle, int z, int dastat, int cx1, int cy1, int cx2, int cy2) {
        float v2;
        float v;
        float y3;
        float x3;
        float y2;
        float x2;
        float y4;
        float x4;
        float y1;
        float x1;
        if (!this.drawing) {
            throw new IllegalStateException("GdxBatch.begin must be called before draw.");
        }
        if (tex != this.lastTexture) {
            this.switchTexture(tex);
        } else if (this.idx == this.vertices.length) {
            this.flush();
        }
        this.currClipBounds[0] = cx1;
        this.currClipBounds[1] = Engine.ydim - cy1;
        this.currClipBounds[2] = cx2;
        this.currClipBounds[3] = Engine.ydim - cy2;
        if (this.currClipBounds[0] != this.lastClipBounds[0] || this.currClipBounds[1] != this.lastClipBounds[1] || this.currClipBounds[2] != this.lastClipBounds[2] || this.currClipBounds[3] != this.lastClipBounds[3]) {
            this.flush();
            this.shader.setUniformf("cx1", this.currClipBounds[0]);
            this.shader.setUniformf("cy1", this.currClipBounds[1]);
            this.shader.setUniformf("cx2", this.currClipBounds[2]);
            this.shader.setUniformf("cy2", this.currClipBounds[3]);
            System.arraycopy(this.currClipBounds, 0, this.lastClipBounds, 0, 4);
        }
        int ourxyaspect = Engine.xyaspect;
        if ((dastat & 2) == 0) {
            if ((dastat & 0x400) == 0 && 4 * Engine.ydim <= 3 * Engine.xdim) {
                ourxyaspect = 54613;
            }
        } else {
            int zoomsc;
            int oxdim;
            int xdim = oxdim = Engine.xdim;
            int ouryxaspect = Engine.yxaspect;
            ourxyaspect = Engine.xyaspect;
            int normxofs = sx - 0xA00000;
            int normyofs = sy - 0x640000;
            if ((dastat & 0x400) == 0 && 4 * Engine.ydim <= 3 * xdim) {
                xdim = 4 * Engine.ydim / 3;
                ouryxaspect = 78643;
                ourxyaspect = 54613;
            }
            if ((dastat & 8) == 0) {
                int twice_midcx = cx1 + cx2 + 2;
                int scaledxofs = Pragmas.scale(normxofs, Pragmas.scale(Engine.xdimen, xdim, oxdim), 320L);
                int xbord = 0;
                if ((dastat & 0x300) != 0) {
                    xbord = Pragmas.scale(oxdim - xdim, twice_midcx, oxdim);
                    if ((dastat & 0x200) == 0) {
                        xbord = -xbord;
                    }
                }
                sx = (twice_midcx + xbord << 15) + scaledxofs;
                zoomsc = Engine.xdimenscale;
                sy = (cy1 + cy2 + 2 << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            } else {
                sx = (xdim << 15) + Pragmas.scale(normxofs, xdim, 320L);
                if ((dastat & 0x200) != 0) {
                    sx += oxdim - xdim << 16;
                } else if ((dastat & 0x100) == 0) {
                    sx += oxdim - xdim << 15;
                }
                zoomsc = Pragmas.scale(xdim, ouryxaspect, 320L);
                sy = (Engine.ydim << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            }
            z = Pragmas.mulscale(z, zoomsc, 16);
        }
        float aspectFix = (dastat & 2) != 0 || (dastat & 8) == 0 ? (float)ourxyaspect / 65536.0f : 1.0f;
        float scale = (float)z / 65536.0f;
        float xoffs = (float)xoffset * scale;
        float yoffs = (float)yoffset * scale;
        float width = scale * (float)sizx;
        float height = scale * (float)sizy;
        float[] vertices = this.vertices;
        float OriginX = (float)sx / 65536.0f;
        float OriginY = (float)sy / 65536.0f;
        if (angle != 0) {
            float rotation = 360.0f * (float)angle / 2048.0f;
            float cos = MathUtils.cosDeg(rotation);
            float sin = MathUtils.sinDeg(rotation);
            x1 = OriginX + (sin * yoffs - cos * xoffs) * aspectFix;
            y1 = OriginY - xoffs * sin - yoffs * cos;
            x4 = x1 + width * cos * aspectFix;
            y4 = y1 + width * sin;
            x2 = x1 - height * sin * aspectFix;
            y2 = y1 + height * cos;
            x3 = x2 + (x4 - x1);
            y3 = y2 + (y4 - y1);
        } else {
            x1 = x2 = OriginX - xoffs * aspectFix;
            y1 = y4 = OriginY - yoffs;
            x3 = x4 = x1 + width * aspectFix;
            y2 = y3 = y1 + height;
        }
        float u = srcX * this.invTexWidth;
        float u2 = (srcX + srcWidth) * this.invTexWidth;
        if ((dastat & 4) == 0) {
            v = srcY * this.invTexHeight;
            v2 = (srcY + srcHeight) * this.invTexHeight;
        } else {
            v = (srcY + srcHeight) * this.invTexHeight;
            v2 = srcY * this.invTexHeight;
        }
        float color = this.color;
        int idx = this.idx;
        vertices[idx + 0] = x1;
        vertices[idx + 1] = y1;
        vertices[idx + 2] = color;
        vertices[idx + 3] = u;
        vertices[idx + 4] = v;
        vertices[idx + 5] = x2;
        vertices[idx + 6] = y2;
        vertices[idx + 7] = color;
        vertices[idx + 8] = u;
        vertices[idx + 9] = v2;
        vertices[idx + 10] = x3;
        vertices[idx + 11] = y3;
        vertices[idx + 12] = color;
        vertices[idx + 13] = u2;
        vertices[idx + 14] = v2;
        vertices[idx + 15] = x4;
        vertices[idx + 16] = y4;
        vertices[idx + 17] = color;
        vertices[idx + 18] = u2;
        vertices[idx + 19] = v;
        this.idx = idx + 20;
    }

    public void flush() {
        if (this.idx == 0) {
            return;
        }
        int spritesInBatch = this.idx / 20;
        if (spritesInBatch > this.maxSpritesInBatch) {
            this.maxSpritesInBatch = spritesInBatch;
        }
        int count = spritesInBatch * 6;
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.idx);
        mesh.getIndicesBuffer().position(0);
        mesh.getIndicesBuffer().limit(count);
        if (this.blendingDisabled) {
            BuildGdx.gl.glDisable(3042);
        } else {
            BuildGdx.gl.glEnable(3042);
            if (this.blendSrcFunc != -1) {
                BuildGdx.gl.glBlendFuncSeparate(this.blendSrcFunc, this.blendDstFunc, this.blendSrcFuncAlpha, this.blendDstFuncAlpha);
            }
        }
        mesh.render(this.customShader != null ? this.customShader : this.shader, 4, 0, count);
        this.idx = 0;
    }

    public void disableBlending() {
        if (this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = true;
    }

    public void enableBlending() {
        if (!this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = false;
    }

    public void setBlendFunction(int srcFunc, int dstFunc) {
        this.setBlendFunctionSeparate(srcFunc, dstFunc, srcFunc, dstFunc);
    }

    public void setBlendFunctionSeparate(int srcFuncColor, int dstFuncColor, int srcFuncAlpha, int dstFuncAlpha) {
        if (this.blendSrcFunc == srcFuncColor && this.blendDstFunc == dstFuncColor && this.blendSrcFuncAlpha == srcFuncAlpha && this.blendDstFuncAlpha == dstFuncAlpha) {
            return;
        }
        this.flush();
        this.blendSrcFunc = srcFuncColor;
        this.blendDstFunc = dstFuncColor;
        this.blendSrcFuncAlpha = srcFuncAlpha;
        this.blendDstFuncAlpha = dstFuncAlpha;
    }

    public void dispose() {
        this.mesh.dispose();
        if (this.ownsShader && this.shader != null) {
            this.shader.dispose();
        }
    }

    private void setupMatrices() {
        if (this.customShader != null) {
            this.customShader.setUniformMatrix("u_projTrans", this.projectionMatrix);
            this.customShader.setUniformi("u_texture", 0);
        } else {
            this.shader.setUniformMatrix("u_projTrans", this.projectionMatrix);
            this.shader.setUniformi("u_texture", 0);
        }
    }

    protected void switchTexture(GLTexture texture) {
        this.flush();
        this.lastTexture = texture;
        this.invTexWidth = 1.0f / (float)texture.getWidth();
        this.invTexHeight = 1.0f / (float)texture.getHeight();
    }

    public void setShader(ShaderProgram shader) {
        if (this.drawing) {
            this.flush();
            if (this.customShader != null) {
                this.customShader.end();
            } else {
                this.shader.end();
            }
        }
        this.customShader = shader;
        if (this.drawing) {
            if (this.customShader != null) {
                this.customShader.begin();
            } else {
                this.shader.begin();
            }
            this.setupMatrices();
        }
    }

    public ShaderProgram getShader() {
        if (this.customShader == null) {
            return this.shader;
        }
        return this.customShader;
    }

    public boolean isBlendingEnabled() {
        return !this.blendingDisabled;
    }

    public boolean isDrawing() {
        return this.drawing;
    }
}

