/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Loader.Model;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Render.GdxRender.GdxOrphoRen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.Types.FadeEffect;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.TileFont;

public class GdxRenderer
implements GLRenderer {
    protected final TextureManager textureCache;
    protected final GdxOrphoRen orphoRen;
    protected GLTile textAtlas;
    protected DefScript defs;
    protected final Engine engine;

    public GdxRenderer(Engine engine) {
        this.engine = engine;
        BuildGdx.app.setFrame(BuildFrame.FrameType.GL);
        this.textureCache = this.newTextureManager(engine);
        this.orphoRen = new GdxOrphoRen(engine, this.textureCache);
    }

    @Override
    public void enableShader(boolean enable) {
        this.textureCache.enableShader(enable);
    }

    @Override
    public void init() {
        this.orphoRen.init();
    }

    @Override
    public void uninit() {
        this.orphoRen.uninit();
    }

    @Override
    public void drawmasks() {
    }

    @Override
    public void drawrooms() {
    }

    @Override
    public void clearview(int dacol) {
        BuildGdx.gl.glClearColor((float)Engine.curpalette.getRed(dacol) / 255.0f, (float)Engine.curpalette.getGreen(dacol) / 255.0f, (float)Engine.curpalette.getBlue(dacol) / 255.0f, 0.0f);
        BuildGdx.gl.glClear(16384);
    }

    @Override
    public void palfade(HashMap<String, FadeEffect> fades) {
    }

    @Override
    public void preload() {
    }

    @Override
    public void precache(int dapicnum, int dapalnum, int datype) {
        if (Engine.palookup[dapalnum] == null && dapalnum < 252) {
            return;
        }
        this.textureCache.bind(dapicnum, dapalnum, 0, 0, (datype & 1) << 2);
    }

    @Override
    public void nextpage() {
        this.orphoRen.nextpage();
        this.engine.faketimerhandler();
    }

    @Override
    public void gltexapplyprops() {
        GLFilter filter = GLSettings.textureFilter.get();
        this.textureCache.setFilter(filter);
        if (this.defs == null) {
            return;
        }
        int anisotropy = GLSettings.textureAnisotropy.get();
        int i = Engine.MAXTILES - 1;
        while (i >= 0) {
            Model m = this.defs.mdInfo.getModel(i);
            if (m != null) {
                Iterator<GLTile[]> it = m.getSkins();
                while (it.hasNext()) {
                    GLTile[] gLTileArray = it.next();
                    int n = gLTileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GLTile tex = gLTileArray[n2];
                        if (tex != null) {
                            this.textureCache.bind(tex);
                            tex.setupTextureFilter(filter, anisotropy);
                        }
                        ++n2;
                    }
                }
            }
            --i;
        }
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        this.orphoRen.rotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2);
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        this.orphoRen.drawmapview(dax, day, zoome, ang);
    }

    @Override
    public void drawoverheadmap(int cposx, int cposy, int czoom, short cang) {
        this.orphoRen.drawoverheadmap(cposx, cposy, czoom, cang);
    }

    @Override
    public void printext(TileFont font, int xpos, int ypos, char[] text, int col, int shade, Renderer.Transparent bit, float scale) {
        this.orphoRen.printext(font, xpos, ypos, text, col, shade, bit, scale);
    }

    @Override
    public void printext(int xpos, int ypos, int col, int backcol, char[] text, int fontsize, float scale) {
        this.orphoRen.printext(xpos, ypos, col, backcol, text, fontsize, scale);
    }

    @Override
    public void gltexinvalidateall(GLRenderer.GLInvalidateFlag ... flags) {
        int i = 0;
        while (i < flags.length) {
            switch (flags[i]) {
                case Uninit: {
                    this.textureCache.uninit();
                    Console.Println("TextureCache uninited!", Console.OSDTEXT_RED);
                    break;
                }
                case SkinsOnly: {
                    break;
                }
                case TexturesOnly: 
                case IndexedTexturesOnly: {
                    break;
                }
                case All: {
                    this.gltexinvalidateall();
                }
            }
            ++i;
        }
    }

    public void gltexinvalidateall() {
        this.textureCache.invalidateall();
    }

    @Override
    public void gltexinvalidate(int dapicnum, int dapalnum, int dameth) {
        this.textureCache.invalidate(dapicnum, dapalnum, this.textureCache.clampingMode(dameth));
    }

    @Override
    public ByteBuffer getFrame(Renderer.PixelFormat format, int xsiz, int ysiz) {
        return null;
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        this.orphoRen.drawline256(x1, y1, x2, y2, col);
    }

    @Override
    public void settiltang(int tilt) {
    }

    @Override
    public void setdrunk(float intensive) {
    }

    @Override
    public float getdrunk() {
        return 0.0f;
    }

    @Override
    public void addSpriteCorr(int snum) {
    }

    @Override
    public void removeSpriteCorr(int snum) {
    }

    @Override
    public void setDefs(DefScript defs) {
        this.textureCache.setTextureInfo(defs != null ? defs.texInfo : null);
        if (this.defs != null) {
            this.gltexinvalidateall();
        }
        this.defs = defs;
    }

    @Override
    public Renderer.RenderType getType() {
        return null;
    }

    @Override
    public void changepalette(byte[] palette) {
    }

    @Override
    public void completemirror() {
    }

    @Override
    public boolean isInited() {
        return false;
    }

    @Override
    public Renderer.PixelFormat getTexFormat() {
        return null;
    }

    public TextureManager newTextureManager(Engine engine) {
        return new TextureManager(engine);
    }

    @Override
    public TextureManager getTextureManager() {
        if (this.textureCache == null) {
            return this.newTextureManager(this.engine);
        }
        return this.textureCache;
    }
}

