/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.GLTileArray;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.TextureHandle.IndexedTexShader;
import ru.m210projects.Build.Render.TextureHandle.IndexedTileData;
import ru.m210projects.Build.Render.TextureHandle.PixmapTileData;
import ru.m210projects.Build.Render.TextureHandle.RGBTileData;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Render.Types.Palette;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.Tile;

public class TextureManager {
    protected final Engine engine;
    private final GLTileArray cache;
    private TextureHDInfo info;
    protected GLTile bindedTile;
    protected IndexedTexShader shader;
    protected int texunits = 33984;
    protected final Color polyColor = new Color();

    public TextureManager(Engine engine) {
        this.engine = engine;
        this.cache = new GLTileArray(Engine.MAXTILES);
        if (GLSettings.usePaletteShader.get().booleanValue()) {
            try {
                this.shader = new IndexedTexShader(this);
                this.shader.changePalette(Engine.curpalette.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                GLSettings.usePaletteShader.set(false);
                this.shader = null;
            }
        }
    }

    public void setTextureInfo(TextureHDInfo info) {
        this.info = info;
    }

    protected GLTile get(int dapicnum, int dapalnum, int skybox, boolean clamping, boolean alpha) {
        Hicreplctyp si;
        Hicreplctyp hicreplctyp = si = GLSettings.useHighTile.get() != false && this.info != null ? this.info.findTexture(dapicnum, dapalnum, skybox) : null;
        if (si == null) {
            if (skybox != 0 || dapalnum >= 252) {
                return null;
            }
            if (this.shader != null) {
                dapalnum = 0;
            }
        }
        GLTile tile = this.cache.get(dapicnum, dapalnum, clamping, skybox);
        if (si != null && tile != null && tile.hicr == null && si.skybox == null) {
            this.cache.dispose(dapicnum);
            tile = null;
        }
        boolean useMipMaps = GLSettings.textureFilter.get().mipmaps;
        if (tile != null) {
            if (tile.isInvalidated()) {
                tile.setInvalidated(false);
                TileData data = this.loadPic(si, dapicnum, dapalnum, clamping, alpha, skybox);
                tile.update(data, useMipMaps);
            }
        } else {
            if (si != null && dapalnum != 0 && this.info.findTexture(dapicnum, 0, skybox) == si && (tile = this.cache.get(dapicnum, 0, clamping, skybox)) != null) {
                return this.bind(tile);
            }
            TileData data = this.loadPic(si, dapicnum, dapalnum, clamping, alpha, skybox);
            if (data == null) {
                return null;
            }
            tile = this.allocTile(data, si, dapicnum, dapalnum, skybox, alpha, useMipMaps);
        }
        if (GLInfo.multisample != 0 && dapalnum >= 252) {
            BuildGdx.gl.glActiveTexture(++this.texunits);
            BuildGdx.gl.glEnable(3553);
        }
        return this.bind(tile);
    }

    public GLTile bind(GLTile tile) {
        if (this.bindedTile == tile) {
            return tile;
        }
        if (this.bindedTile != null && this.shader != null && this.bindedTile.isRequireShader() && !tile.isRequireShader()) {
            this.shader.unbind();
        }
        if (tile.bind() && this.shader != null && tile.isRequireShader() && (this.bindedTile == null || !this.bindedTile.isRequireShader())) {
            this.shader.bind();
        }
        this.bindedTile = tile;
        return tile;
    }

    public GLTile bind(int tilenum, int pal, int shade, int skybox, int method) {
        Tile pic = this.engine.getTile(tilenum);
        GLTile tile = this.get(tilenum, pal, skybox, this.clampingMode(method), this.alphaMode(method));
        if (tile == null) {
            return null;
        }
        if (tile.isRequireShader()) {
            this.getShader().setShaderParams(pal, shade);
            float alpha = 1.0f;
            switch (method & 3) {
                case 2: {
                    alpha = Engine.TRANSLUSCENT1;
                    break;
                }
                case 3: {
                    alpha = Engine.TRANSLUSCENT2;
                }
            }
            if (!pic.isLoaded()) {
                alpha = 0.01f;
            }
            this.getShader().shaderDrawLastIndex((method & 3) == 0 || !this.alphaMode(method));
            this.getShader().shaderTransparent(alpha);
        } else {
            if (tile.isHighTile() && (tile.hicr.xscale != 1.0f || tile.hicr.yscale != 1.0f) && Polymost.Rendering.Skybox.getIndex() == 0) {
                BuildGdx.gl.glMatrixMode(5890);
                BuildGdx.gl.glLoadIdentity();
                BuildGdx.gl.glScalef(tile.hicr.xscale, tile.hicr.yscale, 1.0f);
                BuildGdx.gl.glMatrixMode(5888);
            }
            if (GLInfo.multisample != 0 && GLSettings.useHighTile.get().booleanValue() && Polymost.Rendering.Skybox.getIndex() == 0) {
                GLTile glow;
                GLTile detail;
                if (Console.Geti("r_detailmapping") != 0 && (detail = this.get(tilenum, 255, 0, this.clampingMode(method), this.alphaMode(method))) != null) {
                    detail.setupTextureDetail();
                    BuildGdx.gl.glMatrixMode(5890);
                    BuildGdx.gl.glLoadIdentity();
                    if (detail.isHighTile() && detail.hicr.xscale != 1.0f || detail.hicr.yscale != 1.0f) {
                        BuildGdx.gl.glScalef(detail.hicr.xscale, detail.hicr.yscale, 1.0f);
                    }
                    BuildGdx.gl.glMatrixMode(5888);
                }
                if (Console.Geti("r_glowmapping") != 0 && (glow = this.get(tilenum, 254, 0, this.clampingMode(method), this.alphaMode(method))) != null) {
                    glow.setupTextureGlow();
                }
            }
            Color c = this.getshadefactor(shade, method);
            if (tile.isHighTile() && this.info != null) {
                if (tile.getPal() != pal) {
                    Palette p = this.info.getTints(pal);
                    c.r *= (float)p.r / 255.0f;
                    c.g *= (float)p.g / 255.0f;
                    c.b *= (float)p.b / 255.0f;
                }
                Palette pdetail = this.info.getTints(255);
                if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                    c.r *= (float)pdetail.r / 255.0f;
                    c.g *= (float)pdetail.g / 255.0f;
                    c.b *= (float)pdetail.b / 255.0f;
                }
            }
            if (!pic.isLoaded()) {
                c.a = 0.01f;
            }
            tile.setColor(c.r, c.g, c.b, c.a);
        }
        return tile;
    }

    public void precache(int dapicnum, int dapalnum, boolean clamped) {
        this.get(dapicnum, dapalnum, 0, clamped, true);
    }

    public int getTextureUnits() {
        return this.texunits;
    }

    /*
     * Unable to fully structure code
     */
    public void unbind() {
        if (GLInfo.multisample != 0) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            BuildGdx.gl.glActiveTexture(this.texunits);
            BuildGdx.gl.glMatrixMode(5890);
            BuildGdx.gl.glLoadIdentity();
            BuildGdx.gl.glMatrixMode(5888);
            if (this.texunits > 33984) {
                BuildGdx.gl.glTexEnvf(8960, 34163, 1.0f);
                BuildGdx.gl.glDisable(3553);
            }
            --this.texunits;
lbl11:
            // 2 sources

            ** while (this.texunits >= 33984)
        }
lbl12:
        // 1 sources

        this.texunits = 33984;
    }

    protected TileData loadPic(Hicreplctyp hicr, int dapicnum, int dapalnum, boolean clamping, boolean alpha, int skybox) {
        int expand;
        block4: {
            String fn;
            byte[] data;
            expand = 3;
            if (hicr != null && (data = BuildGdx.cache.getBytes(fn = this.checkResource(hicr, dapicnum, skybox), 0)) != null) {
                try {
                    return new PixmapTileData(new Pixmap(data, 0, data.length), clamping, expand);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (skybox == 0) break block4;
                    return null;
                }
            }
        }
        if (this.shader != null) {
            return new IndexedTileData(this.engine.getTile(dapicnum), clamping, alpha, expand);
        }
        return new RGBTileData(this.engine.getTile(dapicnum), dapalnum, clamping, alpha, expand);
    }

    protected String checkResource(Hicreplctyp hicr, int dapic, int facen) {
        if (hicr == null) {
            return null;
        }
        String fn = null;
        if (facen > 0) {
            if (hicr.skybox == null || facen > 6 || hicr.skybox.face[facen - 1] == null) {
                return null;
            }
            fn = hicr.skybox.face[facen - 1];
        } else {
            fn = hicr.filename;
        }
        if (!BuildGdx.cache.contains(fn, 0)) {
            Console.Print("Hightile[" + dapic + "]: File \"" + fn + "\" not found");
            if (facen > 0) {
                hicr.skybox.ignore = 1;
            } else {
                hicr.ignore = 1;
            }
            return null;
        }
        return fn;
    }

    public Color getshadefactor(int shade, int method) {
        float f;
        float fshade = Math.min(Math.max((float)shade * 1.04f, 0.0f), (float)Engine.numshades);
        this.polyColor.g = this.polyColor.b = (f = ((float)Engine.numshades - fshade) / (float)Engine.numshades);
        this.polyColor.r = this.polyColor.b;
        switch (method & 3) {
            default: {
                this.polyColor.a = 1.0f;
                break;
            }
            case 2: {
                this.polyColor.a = Engine.TRANSLUSCENT1;
                break;
            }
            case 3: {
                this.polyColor.a = Engine.TRANSLUSCENT2;
            }
        }
        return this.polyColor;
    }

    public GLTile newTile(TileData pic, int palnum, boolean useMipMaps) {
        return new GLTile(pic, palnum, useMipMaps);
    }

    protected GLTile allocTile(TileData data, Hicreplctyp si, int dapicnum, int dapalnum, int skybox, boolean alpha, boolean useMipMaps) {
        GLTile tile = this.newTile(data, data.isHighTile() ? si.palnum : dapalnum, useMipMaps);
        if (data.isHighTile()) {
            tile.setHighTile(si);
            tile.setHasAlpha(alpha);
            tile.setSkyboxFace(skybox);
            if (skybox > 0) {
                tile.scalex = (float)tile.getWidth() / 64.0f;
                tile.scaley = (float)tile.getHeight() / 64.0f;
            } else {
                Tile pic = this.engine.getTile(dapicnum);
                if (data instanceof PixmapTileData) {
                    tile.width = ((PixmapTileData)data).getTileWidth();
                    tile.height = ((PixmapTileData)data).getTileHeight();
                }
                int width = tile.getWidth();
                int height = tile.getHeight();
                tile.scalex = (float)width / (float)pic.getWidth();
                tile.scaley = (float)height / (float)pic.getHeight();
            }
        }
        data.dispose();
        this.cache.add(tile, dapicnum);
        return tile;
    }

    public void setFilter(GLFilter filter) {
        int anisotropy = GLSettings.textureAnisotropy.get();
        int i = Engine.MAXTILES - 1;
        while (i >= 0) {
            this.cache.setFilter(i, filter, anisotropy);
            --i;
        }
    }

    public void invalidate(int dapicnum, int dapalnum, boolean clamped) {
        GLTile tile = this.cache.get(dapicnum, dapalnum, clamped, 0);
        if (tile == null) {
            return;
        }
        if (!tile.isHighTile()) {
            tile.setInvalidated(true);
        }
    }

    public void invalidateall() {
        int j = Engine.MAXTILES - 1;
        while (j >= 0) {
            this.cache.invalidate(j);
            --j;
        }
    }

    public IndexedTexShader getShader() {
        return this.shader;
    }

    public boolean clampingMode(int dameth) {
        return (dameth & 4) >> 2 == 1;
    }

    public boolean alphaMode(int dameth) {
        return (dameth & 0x100) == 0;
    }

    public void uninit() {
        Console.Println("TextureCache uninited!", Console.OSDTEXT_RED);
        int i = Engine.MAXTILES - 1;
        while (i >= 0) {
            this.cache.dispose(i);
            --i;
        }
        Engine.pTextfont.uninit();
        Engine.pSmallTextfont.uninit();
    }

    public boolean isUseShader() {
        return this.shader != null && this.bindedTile != null && this.bindedTile.isRequireShader();
    }

    public boolean isUseShader(int dapic) {
        GLTile tile;
        return this.shader != null && (tile = this.cache.get(dapic)) != null && tile.isRequireShader();
    }

    public void enableShader(boolean enable) {
        boolean isChanged = false;
        if (enable) {
            if (this.shader == null) {
                try {
                    this.shader = new IndexedTexShader(this);
                    this.shader.changePalette(Engine.curpalette.getBytes());
                    isChanged = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.shader = null;
                }
            }
        } else if (this.shader != null) {
            this.shader.dispose();
            this.shader = null;
            isChanged = true;
        }
        if (isChanged) {
            this.uninit();
        }
    }
}

