/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.AWT;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.lwjgl.LwjglNativesLoader;
import com.badlogic.gdx.utils.Pool;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildInput;
import ru.m210projects.Build.desktop.AWT.AWTGraphics;
import ru.m210projects.Build.desktop.AWT.AWTMouse;
import ru.m210projects.Build.desktop.AWT.JCanvas;
import ru.m210projects.Build.desktop.AWT.JDisplay;
import ru.m210projects.Build.desktop.AWT.LwjglMouse;
import ru.m210projects.Build.desktop.AWT.MouseInterface;

public class AWTInput
implements BuildInput,
KeyListener {
    Pool<KeyEvent> usedKeyEvents = new Pool<KeyEvent>(16, 1000){

        @Override
        protected KeyEvent newObject() {
            return new KeyEvent();
        }
    };
    protected BuildFrame frame;
    List<KeyEvent> keyEvents = new ArrayList<KeyEvent>();
    int keyCount = 0;
    boolean[] keys = new boolean[256];
    boolean keyJustPressed = false;
    boolean[] justPressedKeys = new boolean[256];
    InputProcessor processor;
    JCanvas canvas;
    MouseInterface mouse;
    long currentEventTimeStamp;

    protected void reset() {
        this.keyJustPressed = false;
        Arrays.fill(this.justPressedKeys, false);
        this.keyCount = 0;
        Arrays.fill(this.keys, false);
        this.mouse.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        if (!this.frame.isActive()) {
            this.reset();
        }
        AWTInput aWTInput = this;
        synchronized (aWTInput) {
            if (this.keyJustPressed) {
                this.keyJustPressed = false;
                Arrays.fill(this.justPressedKeys, false);
            }
            if (this.processor != null) {
                InputProcessor processor = this.processor;
                int len = this.keyEvents.size();
                int i = 0;
                while (i < len) {
                    KeyEvent e = this.keyEvents.get(i);
                    this.currentEventTimeStamp = e.timeStamp;
                    switch (e.type) {
                        case 0: {
                            processor.keyDown(e.keyCode);
                            this.keyJustPressed = true;
                            this.justPressedKeys[e.keyCode] = true;
                            break;
                        }
                        case 1: {
                            processor.keyUp(e.keyCode);
                            break;
                        }
                        case 2: {
                            processor.keyTyped(e.keyChar);
                        }
                    }
                    this.usedKeyEvents.free(e);
                    ++i;
                }
            } else {
                int len = this.keyEvents.size();
                int i = 0;
                while (i < len) {
                    KeyEvent event = this.keyEvents.get(i);
                    if (event.type == 0) {
                        this.keyJustPressed = true;
                        this.justPressedKeys[event.keyCode] = true;
                    }
                    this.usedKeyEvents.free(this.keyEvents.get(i));
                    ++i;
                }
            }
            this.keyEvents.clear();
            long out = this.mouse.processEvents(this.processor);
            if (out != -1L) {
                this.currentEventTimeStamp = out;
            }
        }
    }

    @Override
    public void init(BuildFrame frame) {
        this.frame = frame;
        JDisplay display = ((AWTGraphics)frame.getGraphics()).display;
        if (BuildGdx.app.getPlatform() == BuildApplication.Platform.Windows) {
            try {
                this.mouse = new LwjglMouse(display);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LwjglNativesLoader.load();
        }
        if (this.mouse == null) {
            this.mouse = new AWTMouse(display);
        }
        this.setListeners(display.getCanvas());
    }

    public void setListeners(JCanvas canvas) {
        if (this.canvas != null) {
            canvas.removeKeyListener(this);
        }
        canvas.addKeyListener(this);
        canvas.setFocusTraversalKeysEnabled(false);
        this.canvas = canvas;
    }

    @Override
    public float getAccelerometerX() {
        return 0.0f;
    }

    @Override
    public float getAccelerometerY() {
        return 0.0f;
    }

    @Override
    public float getAccelerometerZ() {
        return 0.0f;
    }

    @Override
    public void getTextInput(final Input.TextInputListener listener, final String title, final String text, final String hint) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel panel = new JPanel(new FlowLayout());
                JPanel textPanel = new JPanel(){
                    private static final long serialVersionUID = -4257888082210622881L;

                    @Override
                    public boolean isOptimizedDrawingEnabled() {
                        return false;
                    }
                };
                textPanel.setLayout(new OverlayLayout(textPanel));
                panel.add(textPanel);
                final JTextField textField = new JTextField(20);
                textField.setText(text);
                textField.setAlignmentX(0.0f);
                textPanel.add(textField);
                final JLabel placeholderLabel = new JLabel(hint);
                placeholderLabel.setForeground(Color.GRAY);
                placeholderLabel.setAlignmentX(0.0f);
                textPanel.add((Component)placeholderLabel, 0);
                textField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent arg0) {
                        this.updated();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent arg0) {
                        this.updated();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent arg0) {
                        this.updated();
                    }

                    private void updated() {
                        if (textField.getText().length() == 0) {
                            placeholderLabel.setVisible(true);
                        } else {
                            placeholderLabel.setVisible(false);
                        }
                    }
                });
                JOptionPane pane = new JOptionPane(panel, 3, 2, null, null, null);
                pane.setInitialValue(null);
                pane.setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
                Border border = textField.getBorder();
                placeholderLabel.setBorder(new EmptyBorder(border.getBorderInsets(textField)));
                JDialog dialog = pane.createDialog(null, title);
                pane.selectInitialValue();
                dialog.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowLostFocus(WindowEvent arg0) {
                    }

                    @Override
                    public void windowGainedFocus(WindowEvent arg0) {
                        textField.requestFocusInWindow();
                    }
                });
                dialog.setVisible(true);
                dialog.dispose();
                Object selectedValue = pane.getValue();
                if (selectedValue != null && selectedValue instanceof Integer && (Integer)selectedValue == 0) {
                    listener.input(textField.getText());
                } else {
                    listener.canceled();
                }
            }
        });
    }

    @Override
    public int getX() {
        return this.mouse.getX();
    }

    @Override
    public int getX(int pointer) {
        if (pointer == 0) {
            return this.getX();
        }
        return 0;
    }

    @Override
    public int getY() {
        return this.mouse.getY();
    }

    @Override
    public int getY(int pointer) {
        if (pointer == 0) {
            return this.getY();
        }
        return 0;
    }

    @Override
    public boolean isKeyPressed(int key) {
        if (key == -1) {
            return this.keyCount > 0;
        }
        if (key < 0 || key > 255) {
            return false;
        }
        return this.keys[key];
    }

    @Override
    public boolean isKeyJustPressed(int key) {
        if (key == -1) {
            return this.keyJustPressed;
        }
        if (key < 0 || key > 255) {
            return false;
        }
        return this.justPressedKeys[key];
    }

    @Override
    public boolean isTouched() {
        return this.mouse.isTouched();
    }

    @Override
    public boolean isTouched(int pointer) {
        if (pointer == 0) {
            return this.isTouched();
        }
        return false;
    }

    @Override
    public void processEvents() {
    }

    @Override
    public void setCatchBackKey(boolean catchBack) {
    }

    @Override
    public boolean isCatchBackKey() {
        return false;
    }

    @Override
    public void setCatchMenuKey(boolean catchMenu) {
    }

    @Override
    public boolean isCatchMenuKey() {
        return false;
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(java.awt.event.KeyEvent e) {
        AWTInput aWTInput = this;
        synchronized (aWTInput) {
            KeyEvent event = this.usedKeyEvents.obtain();
            event.keyChar = '\u0000';
            event.keyCode = AWTInput.translateKeyCode(e);
            event.type = 0;
            event.timeStamp = System.nanoTime();
            this.keyEvents.add(event);
            if (!this.keys[event.keyCode]) {
                ++this.keyCount;
                this.keys[event.keyCode] = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(java.awt.event.KeyEvent e) {
        AWTInput aWTInput = this;
        synchronized (aWTInput) {
            KeyEvent event = this.usedKeyEvents.obtain();
            event.keyChar = '\u0000';
            event.keyCode = AWTInput.translateKeyCode(e);
            event.type = 1;
            event.timeStamp = System.nanoTime();
            this.keyEvents.add(event);
            if (this.keys[event.keyCode]) {
                --this.keyCount;
                this.keys[event.keyCode] = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(java.awt.event.KeyEvent e) {
        AWTInput aWTInput = this;
        synchronized (aWTInput) {
            KeyEvent event = this.usedKeyEvents.obtain();
            event.keyChar = e.getKeyChar();
            event.keyCode = 0;
            event.type = 2;
            event.timeStamp = System.nanoTime();
            this.keyEvents.add(event);
        }
    }

    protected static int translateKeyCode(java.awt.event.KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 106: {
                return 17;
            }
            case 110: {
                return 240;
            }
            case 19: {
                return 237;
            }
            case 20: {
                return 238;
            }
            case 145: {
                return 239;
            }
            case 8: {
                return 67;
            }
            case 37: {
                return 21;
            }
            case 39: {
                return 22;
            }
            case 38: {
                return 19;
            }
            case 40: {
                return 20;
            }
            case 222: {
                return 75;
            }
            case 91: {
                return 71;
            }
            case 93: {
                return 72;
            }
            case 192: {
                return 68;
            }
            case 144: {
                return 78;
            }
            case 61: {
                return 70;
            }
            case 48: {
                return 7;
            }
            case 49: {
                return 8;
            }
            case 50: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 52: {
                return 11;
            }
            case 53: {
                return 12;
            }
            case 54: {
                return 13;
            }
            case 55: {
                return 14;
            }
            case 56: {
                return 15;
            }
            case 57: {
                return 16;
            }
            case 65: {
                return 29;
            }
            case 66: {
                return 30;
            }
            case 67: {
                return 31;
            }
            case 68: {
                return 32;
            }
            case 69: {
                return 33;
            }
            case 70: {
                return 34;
            }
            case 71: {
                return 35;
            }
            case 72: {
                return 36;
            }
            case 73: {
                return 37;
            }
            case 74: {
                return 38;
            }
            case 75: {
                return 39;
            }
            case 76: {
                return 40;
            }
            case 77: {
                return 41;
            }
            case 78: {
                return 42;
            }
            case 79: {
                return 43;
            }
            case 80: {
                return 44;
            }
            case 81: {
                return 45;
            }
            case 82: {
                return 46;
            }
            case 83: {
                return 47;
            }
            case 84: {
                return 48;
            }
            case 85: {
                return 49;
            }
            case 86: {
                return 50;
            }
            case 87: {
                return 51;
            }
            case 88: {
                return 52;
            }
            case 89: {
                return 53;
            }
            case 90: {
                return 54;
            }
            case 18: {
                ke.consume();
                if (ke.getKeyLocation() == 2) {
                    return 57;
                }
                return 58;
            }
            case 92: {
                return 73;
            }
            case 44: {
                return 55;
            }
            case 127: {
                return 112;
            }
            case 10: {
                return 66;
            }
            case 36: {
                return 3;
            }
            case 35: {
                return 132;
            }
            case 34: {
                return 93;
            }
            case 33: {
                return 92;
            }
            case 155: {
                return 133;
            }
            case 45: 
            case 109: {
                return 69;
            }
            case 46: {
                return 56;
            }
            case 107: 
            case 521: {
                return 81;
            }
            case 59: {
                return 74;
            }
            case 16: {
                if (ke.getKeyLocation() == 2) {
                    return 59;
                }
                return 60;
            }
            case 47: 
            case 111: {
                return 76;
            }
            case 32: {
                return 62;
            }
            case 9: {
                return 61;
            }
            case 17: {
                if (ke.getKeyLocation() == 2) {
                    return 129;
                }
                return 130;
            }
            case 27: {
                return 131;
            }
            case 112: {
                return 244;
            }
            case 113: {
                return 245;
            }
            case 114: {
                return 246;
            }
            case 115: {
                return 247;
            }
            case 116: {
                return 248;
            }
            case 117: {
                return 249;
            }
            case 118: {
                return 250;
            }
            case 119: {
                return 251;
            }
            case 120: {
                return 252;
            }
            case 121: {
                return 253;
            }
            case 122: {
                return 254;
            }
            case 123: {
                return 255;
            }
            case 513: {
                return 243;
            }
            case 96: {
                return 144;
            }
            case 97: {
                return 145;
            }
            case 98: {
                return 146;
            }
            case 99: {
                return 147;
            }
            case 100: {
                return 148;
            }
            case 101: {
                return 149;
            }
            case 102: {
                return 150;
            }
            case 103: {
                return 151;
            }
            case 104: {
                return 152;
            }
            case 105: {
                return 153;
            }
        }
        return 0;
    }

    @Override
    public void setInputProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    @Override
    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    @Override
    public void vibrate(int milliseconds) {
    }

    @Override
    public boolean justTouched() {
        return this.mouse.justTouched();
    }

    @Override
    public boolean isButtonPressed(int button) {
        return this.mouse.isButtonPressed(button);
    }

    @Override
    public void vibrate(long[] pattern, int repeat) {
    }

    @Override
    public void cancelVibrate() {
    }

    @Override
    public float getAzimuth() {
        return 0.0f;
    }

    @Override
    public float getPitch() {
        return 0.0f;
    }

    @Override
    public float getRoll() {
        return 0.0f;
    }

    @Override
    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        return peripheral == Input.Peripheral.HardwareKeyboard;
    }

    @Override
    public int getRotation() {
        return 0;
    }

    @Override
    public Input.Orientation getNativeOrientation() {
        return Input.Orientation.Landscape;
    }

    @Override
    public void setCursorCatched(boolean catched) {
        this.mouse.setCursorCatched(catched);
    }

    @Override
    public boolean isCursorCatched() {
        return this.mouse.isCursorCatched();
    }

    @Override
    public int getDeltaX() {
        return this.mouse.getDeltaX();
    }

    @Override
    public int getDeltaX(int pointer) {
        if (pointer == 0) {
            return this.getDeltaX();
        }
        return 0;
    }

    @Override
    public int getDeltaY() {
        return this.mouse.getDeltaY();
    }

    @Override
    public int getDeltaY(int pointer) {
        if (pointer == 0) {
            return this.getDeltaY();
        }
        return 0;
    }

    @Override
    public void setCursorPosition(int x, int y) {
        if (!this.isInsideWindow() || !this.frame.isActive()) {
            return;
        }
        this.mouse.setCursorPosition(x, y);
    }

    @Override
    public long getCurrentEventTime() {
        return this.currentEventTimeStamp;
    }

    @Override
    public void getRotationMatrix(float[] matrix) {
    }

    @Override
    public float getGyroscopeX() {
        return 0.0f;
    }

    @Override
    public float getGyroscopeY() {
        return 0.0f;
    }

    @Override
    public float getGyroscopeZ() {
        return 0.0f;
    }

    @Override
    public void processMessages() {
    }

    @Override
    public boolean cursorHandler() {
        if (this.isInsideWindow() && this.frame.isActive()) {
            this.mouse.showCursor(false);
        } else {
            if (this.frame.isActive()) {
                this.mouse.reset();
            }
            this.mouse.showCursor(true);
        }
        return false;
    }

    @Override
    public int getDWheel() {
        return this.mouse.getDWheel();
    }

    public boolean isInsideWindow() {
        return this.mouse.isInsideWindow();
    }

    @Override
    public int getMaxPointers() {
        return 1;
    }

    @Override
    public float getPressure() {
        return this.getPressure(0);
    }

    @Override
    public float getPressure(int pointer) {
        return this.isTouched(pointer) ? 1 : 0;
    }

    @Override
    public boolean isButtonJustPressed(int button) {
        return this.mouse.isButtonJustPressed(button);
    }

    @Override
    public boolean isCatchKey(int arg0) {
        return false;
    }

    @Override
    public void setCatchKey(int arg0, boolean arg1) {
    }

    @Override
    public void dispose() {
    }

    class KeyEvent {
        static final int KEY_DOWN = 0;
        static final int KEY_UP = 1;
        static final int KEY_TYPED = 2;
        long timeStamp;
        int type;
        int keyCode;
        char keyChar;

        KeyEvent() {
        }
    }

    class TouchEvent {
        static final int TOUCH_DOWN = 0;
        static final int TOUCH_UP = 1;
        static final int TOUCH_DRAGGED = 2;
        static final int TOUCH_MOVED = 3;
        static final int TOUCH_SCROLLED = 4;
        long timeStamp;
        int type;
        int x;
        int y;
        int pointer;
        int button;
        int scrollAmount;

        TouchEvent() {
        }
    }
}

