/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.Controllers;

import com.badlogic.gdx.controllers.ControlType;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.math.Vector2;
import java.lang.reflect.Method;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildController;
import ru.m210projects.Build.Engine;

public class GdxController
implements BuildController {
    private final PovDirection[] directions = new PovDirection[]{PovDirection.north, PovDirection.south, PovDirection.west, PovDirection.east, PovDirection.northWest, PovDirection.northEast, PovDirection.southWest, PovDirection.southEast};
    protected Controller controller;
    protected String controllerName;
    protected boolean[] buttonStatus;
    protected boolean[] hitButton;
    protected int buttonsNum;
    protected int axisNum;
    protected int povNum;
    protected int allButtonsCount;
    protected boolean buttonPressed = false;
    protected Vector2 stickVector = new Vector2();

    public GdxController(int deviceIndex) throws Exception {
        this.controller = Controllers.getControllers().get(deviceIndex);
        Method controlCount = this.controller.getClass().getMethod("getControlCount", ControlType.class);
        controlCount.setAccessible(true);
        this.buttonsNum = (Integer)controlCount.invoke((Object)this.controller, new Object[]{ControlType.button});
        this.axisNum = (Integer)controlCount.invoke((Object)this.controller, new Object[]{ControlType.axis});
        this.povNum = (Integer)controlCount.invoke((Object)this.controller, new Object[]{ControlType.pov});
        this.controllerName = this.controller.getName();
        this.allButtonsCount = this.buttonsNum + this.povNum * 4 + (this.axisNum > 3 ? 2 : 0);
        this.buttonStatus = new boolean[this.allButtonsCount];
        this.hitButton = new boolean[this.allButtonsCount];
    }

    @Override
    public boolean buttonPressed() {
        return this.buttonPressed;
    }

    @Override
    public void resetButtonStatus() {
        Arrays.fill(this.buttonStatus, false);
    }

    @Override
    public boolean buttonPressed(int buttonCode) {
        if (buttonCode >= 0 && buttonCode < this.allButtonsCount) {
            return this.hitButton[buttonCode];
        }
        return false;
    }

    @Override
    public boolean buttonStatusOnce(int buttonCode) {
        if (buttonCode >= 0 && buttonCode < this.allButtonsCount && this.buttonStatus[buttonCode]) {
            this.buttonStatus[buttonCode] = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean buttonStatus(int buttonCode) {
        return buttonCode >= 0 && buttonCode < this.allButtonsCount && this.buttonStatus[buttonCode];
    }

    @Override
    public int getButtonCount() {
        return this.allButtonsCount;
    }

    @Override
    public int getAxisCount() {
        return this.axisNum;
    }

    @Override
    public int getPovCount() {
        return this.povNum;
    }

    @Override
    public Vector2 getStickValue(int aCode1, int aCode2, float deadZone) {
        float lx = this.controller.getAxis(aCode1);
        float ly = this.controller.getAxis(aCode2);
        float mag = (float)Math.sqrt(lx * lx + ly * ly);
        float nlx = lx / mag;
        float nly = ly / mag;
        float nlm = 0.0f;
        if (mag > deadZone) {
            if (mag > 1.0f) {
                mag = 1.0f;
            }
            nlm = (mag -= deadZone) / (1.0f - deadZone);
            float x1 = nlx * nlm;
            float y1 = nly * nlm;
            return this.stickVector.set(x1, y1);
        }
        mag = 0.0f;
        nlm = 0.0f;
        return this.stickVector.set(0.0f, 0.0f);
    }

    @Override
    public String getName() {
        return this.controllerName;
    }

    private void TriggerHandler() {
        if (this.axisNum < 4) {
            return;
        }
        float value = this.controller.getAxis(4);
        int num = this.buttonsNum + 4 * this.povNum;
        if (value >= 0.9f) {
            this.buttonPressed = true;
            if (!this.hitButton[num]) {
                Engine.getInput().setKey(256, 1);
                this.buttonStatus[num] = true;
                this.hitButton[num] = true;
            }
        } else {
            this.buttonStatus[num] = false;
            this.hitButton[num] = false;
        }
        if (value <= -0.9f) {
            this.buttonPressed = true;
            if (!this.hitButton[num + 1]) {
                Engine.getInput().setKey(256, 1);
                this.buttonStatus[num + 1] = true;
                this.hitButton[num + 1] = true;
            }
        } else {
            this.buttonStatus[num + 1] = false;
            this.hitButton[num + 1] = false;
        }
    }

    private void DPADHandler() {
        int i = 0;
        while (i < this.povNum) {
            PovDirection dir = this.controller.getPov(i);
            if (dir != null && dir != PovDirection.center) {
                int num = this.buttonsNum + 4 * i;
                int d = 0;
                while (d < 4) {
                    if (dir == this.directions[d]) {
                        this.buttonPressed = true;
                        if (!this.hitButton[num + d]) {
                            Engine.getInput().setKey(256, 1);
                            this.buttonStatus[num + d] = true;
                            this.hitButton[num + d] = true;
                        }
                    } else {
                        this.buttonStatus[num + d] = false;
                        this.hitButton[num + d] = false;
                    }
                    ++d;
                }
                d = 0;
                while (d < 4) {
                    int fbut = num + d / 2;
                    int sbut = num + 2 + d % 2;
                    if (dir == this.directions[d + 4]) {
                        Engine.getInput().setKey(256, 1);
                        this.buttonStatus[fbut] = true;
                        this.hitButton[fbut] = true;
                        this.buttonStatus[sbut] = true;
                        this.hitButton[sbut] = true;
                    }
                    ++d;
                }
            } else {
                int b = 0;
                while (b < 4) {
                    int num = this.buttonsNum + 4 * i + b;
                    this.buttonStatus[num] = false;
                    this.hitButton[num] = false;
                    ++b;
                }
            }
            ++i;
        }
    }

    @Override
    public void update() {
        this.buttonPressed = false;
        this.DPADHandler();
        this.TriggerHandler();
        int i = 0;
        while (i < this.buttonsNum) {
            if (this.controller.getButton(i)) {
                this.buttonPressed = true;
                if (!this.hitButton[i]) {
                    Engine.getInput().setKey(256, 1);
                    this.buttonStatus[i] = true;
                    this.hitButton[i] = true;
                }
            } else {
                this.buttonStatus[i] = false;
                this.hitButton[i] = false;
            }
            ++i;
        }
    }
}

