/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio;

import com.badlogic.gdx.utils.BufferUtils;
import java.nio.IntBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.Music;
import ru.m210projects.Build.Audio.MusicSource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.desktop.audio.ALAudio;
import ru.m210projects.Build.desktop.audio.ALMusicSource;
import ru.m210projects.Build.desktop.audio.ALSoundDrv;
import ru.m210projects.Build.desktop.audio.Ogg;

public class ALMusicDrv
implements Music {
    private MusicSource music;
    private float musicVolume = 1.0f;
    private boolean inited;
    protected IntBuffer musicBuffers;
    protected final int musicBufferCount = 3;
    private ALSoundDrv drv;
    private ALAudio al;

    public ALMusicDrv(ALSoundDrv drv) {
        this.drv = drv;
        this.al = drv.getALAudio();
    }

    @Override
    public MusicSource newMusic(byte[] data) {
        if (this.drv.noDevice || data == null) {
            return null;
        }
        if (this.music != null) {
            if (this.music.isPlaying()) {
                this.music.stop();
            }
            this.music = null;
        }
        try {
            this.music = new ALMusicSource(new Ogg.Music(this.drv, this.musicBuffers, data));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Console.Println("Can't load ogg file", Console.OSDTEXT_RED);
            return null;
        }
        this.setVolume(this.musicVolume);
        return this.music;
    }

    @Override
    public MusicSource newMusic(String name) {
        if (this.drv.noDevice || !this.inited) {
            return null;
        }
        Resource res = BuildGdx.cache.open(name, 0);
        if (res == null) {
            Console.Println("OpenAL Music: Unable to load " + name, Console.OSDTEXT_RED);
            return null;
        }
        byte[] data = res.getBytes();
        res.close();
        return this.newMusic(data);
    }

    @Override
    public String getName() {
        return "OpenAL Music";
    }

    @Override
    public void dispose() {
        if (this.inited) {
            this.al.alDeleteBuffers(this.musicBuffers);
        }
    }

    @Override
    public synchronized boolean init() {
        if (!this.drv.isInited()) {
            return false;
        }
        this.inited = false;
        this.musicBuffers = BufferUtils.newIntBuffer(3);
        this.al.alGenBuffers(this.musicBuffers);
        if (this.al.alGetError() != 0) {
            Console.Println("OpenAL Music: Unabe to allocate audio buffers.", Console.OSDTEXT_RED);
            return false;
        }
        this.inited = true;
        return true;
    }

    @Override
    public boolean isInited() {
        return this.drv.isInited() && this.inited;
    }

    @Override
    public void update() {
        if (this.music != null) {
            this.music.update();
        }
    }

    @Override
    public void setVolume(float volume) {
        this.musicVolume = volume;
        if (this.music != null) {
            ((ALMusicSource)this.music).setVolume(volume);
        }
    }
}

