/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Screens;

import java.io.FileNotFoundException;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.InvalidVersionException;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.LSP.Animate;
import ru.m210projects.LSP.Config;
import ru.m210projects.LSP.Enemies;
import ru.m210projects.LSP.Factory.LSPInput;
import ru.m210projects.LSP.Factory.LSPMenuHandler;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.LoadSave;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Menus.MenuInterfaceSet;
import ru.m210projects.LSP.Player;
import ru.m210projects.LSP.Quotes;
import ru.m210projects.LSP.Sectors;
import ru.m210projects.LSP.Sounds;
import ru.m210projects.LSP.Sprites;
import ru.m210projects.LSP.Types.DemoFile;
import ru.m210projects.LSP.Types.PlayerStruct;
import ru.m210projects.LSP.View;
import ru.m210projects.LSP.Weapons;

public class GameScreen
extends GameAdapter {
    private int nonsharedtimer;
    public int gNameShowTime;
    public Main game;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        View.FixPalette();
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Globals.gPlayer[i].pInput.Copy(net.gFifoInput[net.gNetFifoTail & 0xFF][i]);
            if ((Globals.gPlayer[i].pInput.bits & 0x20000) != 0) {
                this.game.gPaused = !this.game.gPaused;
                this.sndHandlePause(this.game.gPaused);
            }
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
        Globals.lockclock += 4;
        if ((this.game.gPaused || Globals.recstat != 2 && this != Main.gDemoScreen && (this.game.menu.gShowMenu || Console.IsShown())) && !this.game.menu.isOpened(this.game.menu.mMenus[14])) {
            return;
        }
        if (Globals.recstat == 1 && Globals.rec != null) {
            Globals.rec.record();
        }
        i = Mmulti.connecthead;
        while (i >= 0) {
            Globals.gPlayer[i].UpdatePlayerLoc();
            Player.processinput(i);
            Sprites.checktouchsprite(i);
            i = Mmulti.connectpoint2[i];
        }
        View.MarkSectorSeen(Globals.gPlayer[Mmulti.myconnectindex].sectnum);
        if (Globals.followmode) {
            Globals.followa = (int)((float)Globals.followa + Globals.followang);
            Globals.followx += Globals.followvel * Engine.sintable[2560 - Globals.followa & 0x7FF] >> 10;
            Globals.followy += Globals.followvel * Engine.sintable[1024 - Globals.followa & 0x7FF] >> 10;
            Globals.followx += Globals.followsvel * Engine.sintable[1024 - Globals.followa & 0x7FF] >> 10;
            Globals.followy -= Globals.followsvel * Engine.sintable[2560 - Globals.followa & 0x7FF] >> 10;
        }
        Animate.doanimations(4);
        Sectors.tagcode();
        Sprites.statuslistcode();
        Sounds.updatesounds();
        ++Globals.totalmoves;
    }

    @Override
    public void DrawWorld(float smooth) {
        View.drawscreen(Globals.screenpeek, (int)smooth);
    }

    @Override
    public void DrawHud(float smooth) {
        if (this.pMenu.gShowMenu && !(this.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            return;
        }
        if (Globals.mapnum > 0) {
            if (Globals.gPlayer[Globals.screenpeek].gViewMode != 4 && Globals.gPlayer[Globals.screenpeek].nHealth > 0 && !Player.isonwater(Globals.screenpeek) && Globals.mapnum > 0) {
                Weapons.drawweapons(Globals.screenpeek);
            }
            int yoffs = Pragmas.scale(50L, Main.cfg.gHUDSize, 65536L);
            View.drawbar(10, Engine.ydim - yoffs, Main.cfg.gHUDSize, Mmulti.myconnectindex);
            View.viewDrawStats(10, Engine.ydim - yoffs, Main.cfg.gHUDSize);
        }
        Quotes.viewDisplayMessage();
        if (Globals.gPlayer[Mmulti.myconnectindex].gViewMode != 3) {
            int pos = 25;
            if (Globals.followmode) {
                this.game.getFont(1).drawText(20, pos += Pragmas.scale(25L, Main.cfg.gHUDSize, 65536L), "Follow mode", Main.cfg.gHUDSize, 0, 4, BuildFont.TextAlign.Left, 264, true);
            }
            this.game.getFont(1).drawText(20, pos += Pragmas.scale(25L, Main.cfg.gHUDSize, 65536L), String.valueOf(Globals.book) + "b " + Globals.chapter + "c " + Globals.verse + "v", Main.cfg.gHUDSize, 0, 4, BuildFont.TextAlign.Left, 264, true);
        }
        if (Engine.totalclock < this.gNameShowTime) {
            int transp = 0;
            if (Engine.totalclock > this.gNameShowTime - 20) {
                transp = 1;
            }
            if (Engine.totalclock > this.gNameShowTime - 10) {
                transp = 33;
            }
            if (Main.cfg.showMapInfo != 0 && !this.game.menu.gShowMenu && Globals.mapnum > 0) {
                this.game.getFont(2).drawText(160, 100, String.valueOf(Globals.book) + "b " + Globals.chapter + "c " + Globals.verse + "v", -128, 70, BuildFont.TextAlign.Center, 2 | transp, true);
            }
        }
        if (this.game.gPaused && !this.game.menu.gShowMenu) {
            this.game.getFont(2).drawText(160, 100, "GAME PAUSED", 0, 0, BuildFont.TextAlign.Center, 26, false);
        }
        if (View.nPalDiff != 0 && Main.engine.glrender() != null) {
            Main.engine.showfade();
        }
    }

    @Override
    public void KeyHandler() {
        LSPMenuHandler menu = this.game.menu;
        if (menu.gShowMenu) {
            Main.engine.handleevents();
            menu.mKeyHandler(this.game.pInput, BuildGdx.graphics.getDeltaTime());
            return;
        }
        if (Console.IsShown()) {
            return;
        }
        BuildControls input = this.game.pInput;
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true)) {
            menu.mOpen(menu.mMenus[1], -1);
        }
        if (input.ctrlGetInputKey(Config.LSPKeys.Show_Savemenu, true)) {
            if (this.game.nNetMode == BuildGame.NetMode.Single) {
                Main.gGameScreen.capture(160, 100);
                menu.mOpen(menu.mMenus[4], -1);
            }
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Show_Loadmenu, true)) {
            if (this.game.nNetMode == BuildGame.NetMode.Single) {
                menu.mOpen(menu.mMenus[3], -1);
            }
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Quit, true)) {
            menu.mOpen(menu.mMenus[6], -1);
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Show_Options, true)) {
            menu.mOpen(menu.mMenus[10], -1);
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Quicksave, true)) {
            LoadSave.quicksave();
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Quickload, true)) {
            LoadSave.quickload();
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Show_Sounds, true)) {
            menu.mOpen(menu.mMenus[8], -1);
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Gamma, true)) {
            menu.mOpen(menu.mMenus[11], -1);
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Make_Screenshot, true)) {
            this.makeScreenshot();
        } else if (input.ctrlGetInputKey(Config.LSPKeys.AutoRun, true)) {
            Main.cfg.gAutoRun = !Main.cfg.gAutoRun;
            Quotes.viewSetMessage("Autorun: " + (Main.cfg.gAutoRun ? "ON" : "OFF"));
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Toggle_Crosshair, true)) {
            Main.cfg.gCrosshair = !Main.cfg.gCrosshair;
            Quotes.viewSetMessage("Crosshair: " + (Main.cfg.gCrosshair ? "ON" : "OFF"));
        } else if (input.ctrlGetInputKey(BuildConfig.GameKeys.Mouse_Aiming, true)) {
            Main.cfg.gMouseAim = !Main.cfg.gMouseAim;
            Quotes.viewSetMessage("Mouse aiming: " + (Main.cfg.gMouseAim ? "ON" : "OFF"));
        }
        if (Globals.gPlayer[Mmulti.myconnectindex].gViewMode != 3) {
            int j = Engine.totalclock - this.nonsharedtimer;
            this.nonsharedtimer += j;
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Enlarge_Screen, false)) {
                Globals.gPlayer[Mmulti.myconnectindex].zoom += Pragmas.mulscale(j, Math.max(Globals.gPlayer[Mmulti.myconnectindex].zoom, 256), 6);
            }
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Shrink_Screen, false)) {
                Globals.gPlayer[Mmulti.myconnectindex].zoom -= Pragmas.mulscale(j, Math.max(Globals.gPlayer[Mmulti.myconnectindex].zoom, 256), 6);
            }
            if (Globals.gPlayer[Mmulti.myconnectindex].zoom > 2048) {
                Globals.gPlayer[Mmulti.myconnectindex].zoom = 2048;
            }
            if (Globals.gPlayer[Mmulti.myconnectindex].zoom < 48) {
                Globals.gPlayer[Mmulti.myconnectindex].zoom = 48;
            }
            if (input.ctrlGetInputKey(Config.LSPKeys.Map_Follow_Mode, true)) {
                boolean bl = Globals.followmode = !Globals.followmode;
                if (Globals.followmode) {
                    Globals.followx = Globals.gPlayer[Mmulti.myconnectindex].x;
                    Globals.followy = Globals.gPlayer[Mmulti.myconnectindex].y;
                    Globals.followa = (int)Globals.gPlayer[Mmulti.myconnectindex].ang;
                }
                Quotes.viewSetMessage("Follow mode " + (Globals.followmode ? "ON" : "OFF"));
            }
        }
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Map_Toggle, true)) {
            Globals.gPlayer[Mmulti.myconnectindex].gViewMode = (byte)this.setOverHead(Globals.gPlayer[Mmulti.myconnectindex].gViewMode);
        }
    }

    @Override
    public void PostFrame(BuildNet net) {
        if (LoadSave.gQuickSaving) {
            if (this.captBuffer != null) {
                LoadSave.savegame("[quicksave_" + LoadSave.quickslot + "]", "quicksav" + LoadSave.quickslot + ".sav");
                LoadSave.quickslot ^= 1;
                LoadSave.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (LoadSave.gAutosaveRequest) {
            if (this.captBuffer != null) {
                LoadSave.savegame("[autosave]", "autosave.sav");
                LoadSave.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
    }

    protected void makeScreenshot() {
        String name = "scrxxxx.png";
        name = "scr-map" + Globals.mapnum + "-xxxx.png";
        String filename = this.pEngine.screencapture(name);
        if (filename != null) {
            Quotes.viewSetMessage(String.valueOf(filename) + " saved");
        } else {
            Quotes.viewSetMessage("Screenshot not saved. Access denied!");
        }
    }

    protected int setOverHead(int mode) {
        int out = 0;
        switch (mode) {
            case 3: {
                if (Main.cfg.gOverlayMap != 0) {
                    out = 2;
                    break;
                }
                out = 4;
                break;
            }
            case 2: {
                if (Main.cfg.gOverlayMap == 1) {
                    out = 3;
                    break;
                }
                out = 4;
                break;
            }
            case 4: {
                out = 3;
            }
        }
        return out;
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.gPrecacheScreen.init(false, startboard);
        this.game.changeScreen(Main.gPrecacheScreen);
    }

    @Override
    protected boolean prepareboard(String map) {
        if (this != Main.gDemoScreen && Globals.recstat == 2) {
            Globals.recstat = 0;
        }
        Sounds.stopmusic();
        Sounds.stopallsounds();
        BuildPos pos = null;
        if (Globals.mapnum != -1) {
            GroupResource res = Main.gMapGroup.open(Globals.mapnum, "");
            if (res == null) {
                this.game.GameMessage("Map " + map + " not found!");
                return false;
            }
            try {
                pos = Main.engine.loadboard(res);
            }
            catch (RuntimeException | InvalidVersionException e) {
                this.game.GameMessage(e.getMessage());
                return false;
            }
        }
        try {
            pos = Main.engine.loadboard(map);
        }
        catch (FileNotFoundException | RuntimeException | InvalidVersionException e) {
            this.game.GameMessage(e.getMessage());
            return false;
        }
        int i = Mmulti.connecthead;
        while (i >= 0) {
            PlayerStruct pPlayer = Globals.gPlayer[i];
            if (Globals.mapnum > 1) {
                pPlayer.savePlayersInventory();
            }
            pPlayer.x = pos.x;
            pPlayer.y = pos.y;
            pPlayer.z = pos.z;
            pPlayer.ang = pos.ang;
            pPlayer.osectnum = pPlayer.sectnum = pos.sectnum;
            pPlayer.horiz = 100.0f;
            pPlayer.gViewMode = (byte)3;
            pPlayer.zoom = 768;
            pPlayer.nSprite = (short)-1;
            pPlayer.nWeaponState = 0;
            pPlayer.nBobCount = 0;
            pPlayer.nWeaponSeq = 0;
            pPlayer.nWeapon = Globals.nPlayerFirstWeapon;
            pPlayer.nLastChoosedWeapon = (short)6;
            pPlayer.nLastManaWeapon = (short)13;
            pPlayer.nPlayerStatus = 0;
            pPlayer.word_586FC = 0;
            switch (Globals.nPlayerFirstWeapon) {
                case 18: {
                    pPlayer.nFirstWeaponDamage = 9;
                    pPlayer.nSecondWeaponDamage = 18;
                    break;
                }
                case 19: {
                    pPlayer.nFirstWeaponDamage = 7;
                    pPlayer.nSecondWeaponDamage = 21;
                    break;
                }
                case 20: {
                    pPlayer.nFirstWeaponDamage = 9;
                    pPlayer.nSecondWeaponDamage = 18;
                    break;
                }
                case 21: {
                    pPlayer.nFirstWeaponDamage = 8;
                    pPlayer.nSecondWeaponDamage = 18;
                    break;
                }
                case 22: {
                    pPlayer.nFirstWeaponDamage = 6;
                    pPlayer.nSecondWeaponDamage = 17;
                    break;
                }
                case 23: {
                    pPlayer.nFirstWeaponDamage = 6;
                    pPlayer.nSecondWeaponDamage = 16;
                    break;
                }
                case 24: {
                    pPlayer.nFirstWeaponDamage = pPlayer.nRandDamage1;
                    pPlayer.nSecondWeaponDamage = pPlayer.nRandDamage1 + pPlayer.nRandDamage2;
                    break;
                }
                default: {
                    pPlayer.nFirstWeaponDamage = 9;
                    pPlayer.nSecondWeaponDamage = 16;
                }
            }
            i = Mmulti.connectpoint2[i];
        }
        Engine.globalvisibility = 15;
        Engine.pskyoff[0] = 0;
        Engine.pskyoff[1] = 0;
        Engine.pskyoff[2] = 0;
        Engine.pskyoff[3] = 0;
        Engine.parallaxtype = 0;
        Engine.parallaxyoffs = 256;
        Engine.pskybits = (short)2;
        Globals.totalmoves = 0;
        Globals.nNextMap = 0;
        Quotes.numQuotes = 0;
        i = 0;
        while (i < 16) {
            Globals.waterfountainwall[i] = -1;
            Globals.waterfountaincnt[i] = 0;
            ++i;
        }
        Globals.warpsectorcnt = 0;
        Globals.warpsector2cnt = 0;
        Globals.xpanningsectorcnt = 0;
        Globals.floorpanningcnt = 0;
        Globals.swingcnt = 0;
        Globals.revolvecnt = 0;
        Globals.subwaytrackcnt = 0;
        Globals.dragsectorcnt = 0;
        int k = 0;
        Globals.nKickSprite = -1;
        short i2 = 0;
        while (i2 < Engine.numsectors) {
            int s;
            SECTOR sec = Engine.sector[i2];
            switch (sec.ceilingpicnum) {
                case 250: {
                    sec.ceilingpicnum = (short)252;
                    break;
                }
                case 251: {
                    sec.ceilingpicnum = (short)255;
                    break;
                }
                case 254: {
                    sec.ceilingpicnum = (short)253;
                }
            }
            switch (sec.floorpicnum) {
                case 250: {
                    sec.floorpicnum = (short)252;
                    break;
                }
                case 251: {
                    sec.floorpicnum = (short)255;
                    break;
                }
                case 254: {
                    sec.floorpicnum = (short)253;
                }
            }
            switch (sec.lotag) {
                case 4: 
                case 5: {
                    short s2 = Globals.floorpanningcnt;
                    Globals.floorpanningcnt = (short)(s2 + 1);
                    Globals.floorpanninglist[s2] = i2;
                    break;
                }
                case 10: {
                    short s3 = Globals.warpsectorcnt;
                    Globals.warpsectorcnt = (short)(s3 + 1);
                    Globals.warpsectorlist[s3] = i2;
                    break;
                }
                case 11: {
                    short s4 = Globals.xpanningsectorcnt;
                    Globals.xpanningsectorcnt = (short)(s4 + 1);
                    Globals.xpanningsectorlist[s4] = i2;
                    break;
                }
                case 12: {
                    int dax = Integer.MAX_VALUE;
                    int day = Integer.MAX_VALUE;
                    int dax2 = Integer.MIN_VALUE;
                    int day2 = Integer.MIN_VALUE;
                    int startwall = Engine.sector[i2].wallptr;
                    short endwall = (short)(startwall + Engine.sector[i2].wallnum - 1);
                    int j = startwall;
                    while (j <= endwall) {
                        if (Engine.wall[j].x < dax) {
                            dax = Engine.wall[j].x;
                        }
                        if (Engine.wall[j].y < day) {
                            day = Engine.wall[j].y;
                        }
                        if (Engine.wall[j].x > dax2) {
                            dax2 = Engine.wall[j].x;
                        }
                        if (Engine.wall[j].y > day2) {
                            day2 = Engine.wall[j].y;
                        }
                        if (Engine.wall[j].lotag == 3) {
                            k = j;
                        }
                        ++j;
                    }
                    if (Engine.wall[k].x == dax) {
                        Globals.dragxdir[Globals.dragsectorcnt] = -16;
                    }
                    if (Engine.wall[k].y == day) {
                        Globals.dragydir[Globals.dragsectorcnt] = -16;
                    }
                    if (Engine.wall[k].x == dax2) {
                        Globals.dragxdir[Globals.dragsectorcnt] = 16;
                    }
                    if (Engine.wall[k].y == day2) {
                        Globals.dragydir[Globals.dragsectorcnt] = 16;
                    }
                    short dasector = Engine.wall[startwall].nextsector;
                    Globals.dragx1[Globals.dragsectorcnt] = Integer.MAX_VALUE;
                    Globals.dragy1[Globals.dragsectorcnt] = Integer.MAX_VALUE;
                    Globals.dragx2[Globals.dragsectorcnt] = Integer.MIN_VALUE;
                    Globals.dragy2[Globals.dragsectorcnt] = Integer.MIN_VALUE;
                    startwall = Engine.sector[dasector].wallptr;
                    endwall = (short)(startwall + Engine.sector[dasector].wallnum - 1);
                    j = startwall;
                    while (j <= endwall) {
                        if (Engine.wall[j].x < Globals.dragx1[Globals.dragsectorcnt]) {
                            Globals.dragx1[Globals.dragsectorcnt] = Engine.wall[j].x;
                        }
                        if (Engine.wall[j].y < Globals.dragy1[Globals.dragsectorcnt]) {
                            Globals.dragy1[Globals.dragsectorcnt] = Engine.wall[j].y;
                        }
                        if (Engine.wall[j].x > Globals.dragx2[Globals.dragsectorcnt]) {
                            Globals.dragx2[Globals.dragsectorcnt] = Engine.wall[j].x;
                        }
                        if (Engine.wall[j].y > Globals.dragy2[Globals.dragsectorcnt]) {
                            Globals.dragy2[Globals.dragsectorcnt] = Engine.wall[j].y;
                        }
                        ++j;
                    }
                    short s5 = Globals.dragsectorcnt;
                    Globals.dragx1[s5] = Globals.dragx1[s5] + (Engine.wall[Engine.sector[i2].wallptr].x - dax);
                    short s6 = Globals.dragsectorcnt;
                    Globals.dragy1[s6] = Globals.dragy1[s6] + (Engine.wall[Engine.sector[i2].wallptr].y - day);
                    short s7 = Globals.dragsectorcnt;
                    Globals.dragx2[s7] = Globals.dragx2[s7] - (dax2 - Engine.wall[Engine.sector[i2].wallptr].x);
                    short s8 = Globals.dragsectorcnt;
                    Globals.dragy2[s8] = Globals.dragy2[s8] - (day2 - Engine.wall[Engine.sector[i2].wallptr].y);
                    Globals.dragfloorz[Globals.dragsectorcnt] = Engine.sector[i2].floorz;
                    short s9 = Globals.dragsectorcnt;
                    Globals.dragsectorcnt = (short)(s9 + 1);
                    Globals.dragsectorlist[s9] = i2;
                    Engine.sector[i2].floorstat = (short)(Engine.sector[i2].floorstat | 0x40);
                    break;
                }
                case 13: {
                    int startwall = Engine.sector[i2].wallptr;
                    short endwall = (short)(startwall + Engine.sector[i2].wallnum - 1);
                    int j = startwall;
                    while (j <= endwall) {
                        if (Engine.wall[j].lotag == 4) {
                            k = Engine.wall[Engine.wall[Engine.wall[Engine.wall[j].point2].point2].point2].point2;
                            if (Engine.wall[j].x == Engine.wall[k].x && Engine.wall[j].y == Engine.wall[k].y) {
                                Globals.swingdoor[Globals.swingcnt].wall[0] = j;
                                Globals.swingdoor[Globals.swingcnt].wall[1] = Engine.wall[j].point2;
                                Globals.swingdoor[Globals.swingcnt].wall[2] = Engine.wall[Engine.wall[j].point2].point2;
                                Globals.swingdoor[Globals.swingcnt].wall[3] = Engine.wall[Engine.wall[Engine.wall[j].point2].point2].point2;
                                Globals.swingdoor[Globals.swingcnt].angopen = 1536;
                                Globals.swingdoor[Globals.swingcnt].angclosed = 0;
                                Globals.swingdoor[Globals.swingcnt].angopendir = -1;
                            } else {
                                Globals.swingdoor[Globals.swingcnt].wall[0] = Engine.wall[j].point2;
                                Globals.swingdoor[Globals.swingcnt].wall[1] = j;
                                Globals.swingdoor[Globals.swingcnt].wall[2] = Main.engine.lastwall(j);
                                Globals.swingdoor[Globals.swingcnt].wall[3] = Main.engine.lastwall(Globals.swingdoor[Globals.swingcnt].wall[2]);
                                Globals.swingdoor[Globals.swingcnt].angopen = 512;
                                Globals.swingdoor[Globals.swingcnt].angclosed = 0;
                                Globals.swingdoor[Globals.swingcnt].angopendir = 1;
                            }
                            k = 0;
                            while (k < 4) {
                                Globals.swingdoor[Globals.swingcnt].x[k] = Engine.wall[Globals.swingdoor[Globals.swingcnt].wall[k]].x;
                                Globals.swingdoor[Globals.swingcnt].y[k] = Engine.wall[Globals.swingdoor[Globals.swingcnt].wall[k]].y;
                                ++k;
                            }
                            Globals.swingdoor[Globals.swingcnt].sector = i2;
                            Globals.swingdoor[Globals.swingcnt].ang = Globals.swingdoor[Globals.swingcnt].angclosed;
                            Globals.swingdoor[Globals.swingcnt].anginc = 0;
                            Globals.swingcnt = (short)(Globals.swingcnt + 1);
                        }
                        ++j;
                    }
                    break;
                }
                case 14: {
                    int startwall = Engine.sector[i2].wallptr;
                    short endwall = (short)(startwall + Engine.sector[i2].wallnum - 1);
                    int dax = 0;
                    int day = 0;
                    int j = startwall;
                    while (j <= endwall) {
                        dax += Engine.wall[j].x;
                        day += Engine.wall[j].y;
                        ++j;
                    }
                    Globals.revolvepivotx[Globals.revolvecnt] = dax / (endwall - startwall + 1);
                    Globals.revolvepivoty[Globals.revolvecnt] = day / (endwall - startwall + 1);
                    k = 0;
                    j = startwall;
                    while (j <= endwall) {
                        Globals.revolvex[Globals.revolvecnt][k] = Engine.wall[j].x;
                        Globals.revolvey[Globals.revolvecnt][k] = Engine.wall[j].y;
                        ++k;
                        ++j;
                    }
                    Globals.revolvesector[Globals.revolvecnt] = i2;
                    Globals.revolveang[Globals.revolvecnt] = 0;
                    Globals.revolvecnt = (short)(Globals.revolvecnt + 1);
                    break;
                }
                case 15: {
                    Globals.subwaytracksector[Globals.subwaytrackcnt][0] = i2;
                    Globals.subwaystopcnt[Globals.subwaytrackcnt] = 0;
                    int dax = Integer.MAX_VALUE;
                    int day = Integer.MAX_VALUE;
                    int dax2 = Integer.MIN_VALUE;
                    int day2 = Integer.MIN_VALUE;
                    int startwall = Engine.sector[i2].wallptr;
                    short endwall = (short)(startwall + Engine.sector[i2].wallnum - 1);
                    int j = startwall;
                    while (j <= endwall) {
                        if (Engine.wall[j].x < dax) {
                            dax = Engine.wall[j].x;
                        }
                        if (Engine.wall[j].y < day) {
                            day = Engine.wall[j].y;
                        }
                        if (Engine.wall[j].x > dax2) {
                            dax2 = Engine.wall[j].x;
                        }
                        if (Engine.wall[j].y > day2) {
                            day2 = Engine.wall[j].y;
                        }
                        ++j;
                    }
                    j = startwall;
                    while (j <= endwall) {
                        if (Engine.wall[j].lotag == 5) {
                            if (Engine.wall[j].x > dax && Engine.wall[j].y > day && Engine.wall[j].x < dax2 && Engine.wall[j].y < day2) {
                                Globals.subwayx[Globals.subwaytrackcnt] = Engine.wall[j].x;
                            } else {
                                Globals.subwaystop[Globals.subwaytrackcnt][Globals.subwaystopcnt[Globals.subwaytrackcnt]] = Engine.wall[j].x;
                                short s10 = Globals.subwaytrackcnt;
                                Globals.subwaystopcnt[s10] = Globals.subwaystopcnt[s10] + 1;
                            }
                        }
                        ++j;
                    }
                    j = 1;
                    while (j < Globals.subwaystopcnt[Globals.subwaytrackcnt]) {
                        k = 0;
                        while (k < j) {
                            if (Globals.subwaystop[Globals.subwaytrackcnt][j] < Globals.subwaystop[Globals.subwaytrackcnt][k]) {
                                s = Globals.subwaystop[Globals.subwaytrackcnt][j];
                                Globals.subwaystop[Globals.subwaytrackcnt][j] = Globals.subwaystop[Globals.subwaytrackcnt][k];
                                Globals.subwaystop[Globals.subwaytrackcnt][k] = s;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    Globals.subwaygoalstop[Globals.subwaytrackcnt] = 0;
                    j = 0;
                    while (j < Globals.subwaystopcnt[Globals.subwaytrackcnt]) {
                        if (Math.abs(Globals.subwaystop[Globals.subwaytrackcnt][j] - Globals.subwayx[Globals.subwaytrackcnt]) < Math.abs(Globals.subwaystop[Globals.subwaytrackcnt][Globals.subwaygoalstop[Globals.subwaytrackcnt]] - Globals.subwayx[Globals.subwaytrackcnt])) {
                            Globals.subwaygoalstop[Globals.subwaytrackcnt] = j;
                        }
                        ++j;
                    }
                    Globals.subwaytrackx1[Globals.subwaytrackcnt] = dax;
                    Globals.subwaytracky1[Globals.subwaytrackcnt] = day;
                    Globals.subwaytrackx2[Globals.subwaytrackcnt] = dax2;
                    Globals.subwaytracky2[Globals.subwaytrackcnt] = day2;
                    Globals.subwaynumsectors[Globals.subwaytrackcnt] = 1;
                    j = 0;
                    while (j < Engine.numsectors) {
                        if (j != i2) {
                            startwall = Engine.sector[j].wallptr;
                            if (Engine.wall[startwall].x > Globals.subwaytrackx1[Globals.subwaytrackcnt] && Engine.wall[startwall].y > Globals.subwaytracky1[Globals.subwaytrackcnt] && Engine.wall[startwall].x < Globals.subwaytrackx2[Globals.subwaytrackcnt] && Engine.wall[startwall].y < Globals.subwaytracky2[Globals.subwaytrackcnt]) {
                                if (Engine.sector[j].lotag == 16) {
                                    Engine.sector[j].lotag = (short)17;
                                }
                                if (Engine.sector[j].floorz != Engine.sector[i2].floorz) {
                                    Engine.sector[j].ceilingstat = (short)(Engine.sector[j].ceilingstat | 0x40);
                                    Engine.sector[j].floorstat = (short)(Engine.sector[j].floorstat | 0x40);
                                }
                                Globals.subwaytracksector[Globals.subwaytrackcnt][Globals.subwaynumsectors[Globals.subwaytrackcnt]] = (short)j;
                                short s11 = Globals.subwaytrackcnt;
                                Globals.subwaynumsectors[s11] = (short)(Globals.subwaynumsectors[s11] + 1);
                            }
                        }
                        ++j;
                    }
                    Globals.subwayvel[Globals.subwaytrackcnt] = 64;
                    Globals.subwaypausetime[Globals.subwaytrackcnt] = 2400;
                    Globals.subwaytrackcnt = (short)(Globals.subwaytrackcnt + 1);
                    break;
                }
                case 30: {
                    short s12 = Globals.warpsector2cnt;
                    Globals.warpsector2cnt = (short)(s12 + 1);
                    Globals.warpsector2list[s12] = i2;
                    break;
                }
                case 97: 
                case 98: 
                case 99: {
                    if (!Main.cfg.bShowExit) break;
                    int n = i2 >> 3;
                    Engine.show2dsector[n] = (byte)(Engine.show2dsector[n] | 1 << (i2 & 7));
                }
            }
            s = Engine.headspritesect[i2];
            while (s != -1) {
                if (!Main.engine.getTile(Engine.sprite[s].picnum).hasSize()) {
                    Engine.sprite[s].cstat = (short)(Engine.sprite[s].cstat & 0xFFFFFFFE);
                }
                switch (Engine.sprite[s].picnum) {
                    case 51: {
                        if (Globals.mapnum != 0) break;
                        Globals.nKickSprite = s;
                        break;
                    }
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: {
                        Engine.sprite[s].cstat = (short)(Engine.sprite[s].cstat & 0xFFFFFFCF);
                    }
                    case 601: 
                    case 602: 
                    case 603: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 608: 
                    case 609: 
                    case 700: 
                    case 701: 
                    case 702: 
                    case 703: 
                    case 705: 
                    case 706: 
                    case 707: 
                    case 710: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 720: 
                    case 721: 
                    case 722: 
                    case 723: 
                    case 724: 
                    case 725: 
                    case 727: {
                        Engine.sprite[s].cstat = (short)(Engine.sprite[s].cstat & 0xFFFFFEFE);
                    }
                }
                s = Engine.nextspritesect[s];
            }
            i2 = (short)(i2 + 1);
        }
        Globals.ypanningwallcnt = 0;
        short w = 0;
        while (w < Engine.numwalls) {
            if (Engine.wall[w].lotag == 1) {
                short s = Globals.ypanningwallcnt;
                Globals.ypanningwallcnt = (short)(s + 1);
                Globals.ypanningwalllist[s] = w;
            }
            if ((Engine.wall[w].cstat & 1) != 0 && Engine.wall[w].nextwall != -1) {
                Engine.wall[Engine.wall[w].nextwall].cstat = (short)(Engine.wall[Engine.wall[w].nextwall].cstat | 1);
            }
            if (Globals.mapnum == 0) {
                if (Engine.wall[w].lotag == 121) {
                    Globals.nTrainWall = w;
                } else if (Engine.wall[w].lotag == 124) {
                    Globals.nDiffDoor = w;
                } else if (Engine.wall[w].lotag == 125) {
                    Globals.nDiffDoorBack = w;
                }
            }
            w = (short)(w + 1);
        }
        Globals.bActiveTrain = false;
        Enemies.inienemies();
        if (Globals.recstat == 1) {
            Globals.rec = new DemoFile(100);
        }
        i2 = Mmulti.connecthead;
        while (i2 >= 0) {
            Player.InitPlayer(i2, pos);
            if (Globals.mapnum > 1) {
                Globals.gPlayer[i2].loadPlayersInventory();
            }
            i2 = Mmulti.connectpoint2[i2];
        }
        if (Globals.mapnum == 4 && Engine.sector[82].hitag == 0 && Engine.sector[82].lotag == 20) {
            Engine.sector[82].lotag = (short)21;
        }
        if (Globals.mapnum == 11 && Engine.sector[22].floorz == -2048 && Engine.sector[22].lotag == 2 && Engine.sector[22].hitag == 3) {
            Engine.sector[22].floorz += 4096;
            short spr = Engine.headspritesect[22];
            while (spr != -1) {
                Engine.sprite[spr].z += 4096;
                spr = Engine.nextspritesect[spr];
            }
            Engine.sector[22].lotag = 1;
        }
        if (Globals.mapnum == 21 && Engine.sector[32].ceilingz == Engine.sector[32].floorz && Engine.sector[32].lotag == 8 && Engine.sector[32].hitag == 2) {
            Engine.sector[32].ceilingz -= 8192;
            Engine.sector[32].floorz += 8192;
            Engine.sector[32].hitag = 0;
        }
        if (Globals.mapnum == 32 && Engine.sector[29].floorz == -5120 && Engine.sector[29].lotag == 30) {
            Engine.sector[29].floorz += 8192;
        }
        Quotes.resetQuotes();
        View.GrabPalette();
        Main.engine.srand(17);
        ((LSPInput)this.game.pInput).reset();
        Sounds.startmusic(Globals.maps[Globals.mapnum].music - 1);
        this.gNameShowTime = 500;
        this.game.pNet.ResetTimers();
        System.err.println(map);
        return true;
    }

    public void newgame(int num) {
        if (Globals.recstat == 1 && Globals.rec != null) {
            Globals.rec.close();
        }
        Globals.mapnum = num;
        Main.engine.setTilesPath(num == 0 ? 0 : 1);
        String map = "lev" + num + ".map";
        this.game.nNetMode = BuildGame.NetMode.Single;
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Globals.gPlayer[i].nHealth = (short)160;
            Globals.gPlayer[i].nMana = (short)160;
            Arrays.fill(Globals.gPlayer[i].nAmmo, (short)0);
            Globals.gPlayer[i].nAmmo[1] = 100;
            Globals.gPlayer[i].nAmmo[7] = 1;
            Globals.gPlayer[i].calcRandomVariables();
            i = Mmulti.connectpoint2[i];
        }
        this.updatechapter(Globals.mapnum);
        this.loadboard(map, null).setTitle("Loading " + map);
    }

    private void updatechapter(int map) {
        int mnum = Globals.maps[map].num & 0xFF;
        Globals.book = mnum % 100 % 10;
        Globals.chapter = mnum / 100;
        Globals.verse = mnum % 100 / 10;
        if (this != Main.gDemoScreen) {
            Globals.recstat = Globals.m_recstat;
        }
    }

    public boolean NextMap() {
        byte nextmap = Globals.maps[Globals.mapnum].nextmap[Globals.nNextMap - 1];
        Globals.nNextMap = 0;
        if (nextmap == 99) {
            return true;
        }
        if (nextmap == 0) {
            nextmap = 1;
        }
        this.updatechapter(Globals.mapnum);
        LoadSave.gAutosaveRequest = true;
        this.changemap(nextmap);
        return false;
    }

    public void changemap(int num) {
        Globals.mapnum = num;
        this.updatechapter(Globals.mapnum);
        String map = "lev" + Globals.mapnum + ".map";
        this.loadboard(map, null).setTitle("Loading " + map);
    }

    @Override
    public void sndHandlePause(boolean pause) {
        Sounds.sndHandlePause(pause);
    }
}

