/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;

public class LSPGroup
extends Group {
    private static final byte[] tmp = new byte[1024];
    private Resource file = null;

    public LSPGroup(String filename, int num) throws Exception {
        this.file = BuildGdx.cache.open(filename, 0);
        if (this.file == null) {
            throw new Exception(String.valueOf(filename) + " not found !");
        }
        this.name = filename;
        this.type = Cache1D.PackageType.User;
        int[] offset = new int[num];
        byte[] buf = new byte[num * 4];
        this.file.read(buf);
        ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get(offset);
        int i = 0;
        while (i < num) {
            int siz;
            int len = this.file.size();
            if (i < num - 1) {
                len = offset[i + 1];
            }
            if ((siz = len - offset[i]) > 0 && siz < this.file.size() && offset[i] > 0 && offset[i] < this.file.size()) {
                this.add(new LSPResource(i, offset[i], siz));
            }
            ++i;
        }
        this.numfiles = this.filelist.size();
    }

    public GroupResource open(int fileid) {
        return this.open(fileid, "");
    }

    @Override
    protected boolean open(GroupResource res) {
        if (this.file == null) {
            return false;
        }
        LSPResource gres = (LSPResource)res;
        if (gres != null) {
            gres.pos = 0;
            return true;
        }
        return false;
    }

    @Override
    public int position() {
        if (this.file != null) {
            return this.file.position();
        }
        return -1;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.file != null && !this.file.isClosed()) {
            this.file.close();
        }
        this.file = null;
    }

    private class LSPResource
    extends GroupResource {
        public int offset;
        public int pos;

        public LSPResource(int num, int offset, int size) {
            super(LSPGroup.this);
            this.handleName("file" + num);
            this.size = size;
            this.offset = offset;
            this.fileid = num;
            if (LSPGroup.this.debug) {
                System.out.println("\t" + this.filenamext + ", offset: " + offset + ", size: " + size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            Group group = this.parent;
            synchronized (group) {
                super.flush();
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Group group = this.parent;
            synchronized (group) {
                this.pos = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int seek(long offset, Resource.Whence whence) {
            Group group = this.parent;
            synchronized (group) {
                switch (whence) {
                    case Set: {
                        this.pos = (int)offset;
                        break;
                    }
                    case Current: {
                        this.pos = (int)((long)this.pos + offset);
                        break;
                    }
                    case End: {
                        this.pos = this.size + (int)offset;
                    }
                }
                LSPGroup.this.file.seek(this.offset + this.pos, Resource.Whence.Set);
                return this.pos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf, int offs, int len) {
            Group group = this.parent;
            synchronized (group) {
                block5: {
                    if (this.pos < this.size) break block5;
                    return -1;
                }
                len = Math.min(len, this.size - this.pos);
                int i = this.offset + this.pos;
                int groupfilpos = LSPGroup.this.file.position();
                if (i != groupfilpos) {
                    LSPGroup.this.file.seek(i, Resource.Whence.Set);
                }
                len = LSPGroup.this.file.read(buf, offs, len);
                this.pos += len;
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf) {
            Group group = this.parent;
            synchronized (group) {
                return this.read(buf, 0, buf.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer bb, int offset, int len) {
            Group group = this.parent;
            synchronized (group) {
                int var = -1;
                bb.position(offset);
                int p = 0;
                while (len > 0) {
                    var = this.read(tmp, 0, Math.min(len, tmp.length));
                    if (var == -1) {
                        return p;
                    }
                    bb.put(tmp, 0, var);
                    len -= var;
                    p += var;
                }
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Byte readByte() {
            Group group = this.parent;
            synchronized (group) {
                Byte out;
                int len;
                block7: {
                    block6: {
                        len = 1;
                        if (len <= this.size - this.pos) break block6;
                        return null;
                    }
                    int i = this.offset + this.pos;
                    int groupfilpos = LSPGroup.this.file.position();
                    if (i != groupfilpos) {
                        LSPGroup.this.file.seek(i, Resource.Whence.Set);
                    }
                    if ((out = LSPGroup.this.file.readByte()) != null) break block7;
                    return null;
                }
                this.pos += len;
                return out;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Short readShort() {
            Group group = this.parent;
            synchronized (group) {
                Short out;
                int len;
                block7: {
                    block6: {
                        len = 2;
                        if (len <= this.size - this.pos) break block6;
                        return null;
                    }
                    int i = this.offset + this.pos;
                    int groupfilpos = LSPGroup.this.file.position();
                    if (i != groupfilpos) {
                        LSPGroup.this.file.seek(i, Resource.Whence.Set);
                    }
                    if ((out = LSPGroup.this.file.readShort()) != null) break block7;
                    return null;
                }
                this.pos += len;
                return out;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer readInt() {
            Group group = this.parent;
            synchronized (group) {
                Integer out;
                int len;
                block7: {
                    block6: {
                        len = 4;
                        if (len <= this.size - this.pos) break block6;
                        return null;
                    }
                    int i = this.offset + this.pos;
                    int groupfilpos = LSPGroup.this.file.position();
                    if (i != groupfilpos) {
                        LSPGroup.this.file.seek(i, Resource.Whence.Set);
                    }
                    if ((out = LSPGroup.this.file.readInt()) != null) break block7;
                    return null;
                }
                this.pos += len;
                return out;
            }
        }

        @Override
        public Boolean readBoolean() {
            Byte var = this.readByte();
            if (var != null) {
                if (var == 1) {
                    return true;
                }
                return false;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long readLong() {
            Group group = this.parent;
            synchronized (group) {
                Long out;
                int len;
                block7: {
                    block6: {
                        len = 8;
                        if (len <= this.size - this.pos) break block6;
                        return null;
                    }
                    int i = this.offset + this.pos;
                    int groupfilpos = LSPGroup.this.file.position();
                    if (i != groupfilpos) {
                        LSPGroup.this.file.seek(i, Resource.Whence.Set);
                    }
                    if ((out = LSPGroup.this.file.readLong()) != null) break block7;
                    return null;
                }
                this.pos += len;
                return out;
            }
        }

        @Override
        public Float readFloat() {
            Integer i = this.readInt();
            if (i != null) {
                return Float.valueOf(Float.intBitsToFloat(i));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String readString(int len) {
            Group group = this.parent;
            synchronized (group) {
                byte[] data;
                block4: {
                    data = len < tmp.length ? tmp : new byte[len];
                    if (this.read(data, 0, len) == len) break block4;
                    return null;
                }
                return new String(data, 0, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int position() {
            Group group = this.parent;
            synchronized (group) {
                return this.pos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] getBytes() {
            Group group = this.parent;
            synchronized (group) {
                int size = this.size();
                if (size <= 0) {
                    return null;
                }
                if (LSPGroup.this.file.seek(this.offset, Resource.Whence.Set) == -1) {
                    Console.Println("Error seeking to resource!");
                    return null;
                }
                byte[] data = new byte[size];
                if (LSPGroup.this.file.read(data) == -1) {
                    Console.Println("Error loading resource!");
                    return null;
                }
                return data;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isClosed() {
            Group group = this.parent;
            synchronized (group) {
                if (LSPGroup.this.file != null) {
                    return LSPGroup.this.file.isClosed();
                }
                return true;
            }
        }

        @Override
        public int remaining() {
            return this.size() - this.position();
        }

        @Override
        public boolean hasRemaining() {
            return this.position() < this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toMemory() {
            Group group = this.parent;
            synchronized (group) {
                if (this.buffer == null) {
                    if (LSPGroup.this.file.seek(this.offset, Resource.Whence.Set) == -1) {
                        Console.Println("Error seeking to resource!");
                        return;
                    }
                    this.buffer = ByteBuffer.allocateDirect(this.size);
                    this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                    LSPGroup.this.file.read(this.buffer, 0, this.size);
                }
                this.buffer.rewind();
            }
        }
    }
}

