/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.OnSceenDisplay.OSDFunc;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Powerslave.Factory.PSEngine;
import ru.m210projects.Powerslave.Factory.PSInput;
import ru.m210projects.Powerslave.Factory.PSMenuHandler;
import ru.m210projects.Powerslave.Factory.PSNetwork;
import ru.m210projects.Powerslave.Factory.PSOSDFunc;
import ru.m210projects.Powerslave.Factory.PSPolymost;
import ru.m210projects.Powerslave.Factory.PSSliderDrawable;
import ru.m210projects.Powerslave.Factory.PSSoftware;
import ru.m210projects.Powerslave.Fonts.FontA;
import ru.m210projects.Powerslave.Fonts.GameFont;
import ru.m210projects.Powerslave.Fonts.MenuFont;
import ru.m210projects.Powerslave.Fonts.StandartFont;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;

public class PSFactory
extends BuildFactory {
    private Main app;

    public PSFactory(Main app) {
        super("stuff.dat");
        this.app = app;
    }

    @Override
    public void drawInitScreen() {
        this.app.pEngine.rotatesprite(0, 0, 65536, 0, Globals.BACKGROUND, -128, 0, 26, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public BuildEngine engine() throws Exception {
        Main.engine = new PSEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new PSSoftware(this.app.pEngine);
        }
        return new PSPolymost(this.app.pEngine);
    }

    @Override
    public DefScript getBaseDef(BuildEngine engine) {
        return new DefScript(engine, false);
    }

    @Override
    public BuildControls input(BuildControllers gpmanager) {
        return new PSInput(this.app.pCfg, gpmanager);
    }

    @Override
    public OSDFunc console() {
        return new PSOSDFunc(this.app);
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new PSMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(4){

            @Override
            protected BuildFont init(int i) {
                if (i == 0) {
                    return new GameFont(((PSFactory)PSFactory.this).app.pEngine);
                }
                if (i == 1) {
                    return new MenuFont(((PSFactory)PSFactory.this).app.pEngine);
                }
                if (i == 2) {
                    return new FontA(((PSFactory)PSFactory.this).app.pEngine);
                }
                return new StandartFont(((PSFactory)PSFactory.this).app.pEngine);
            }
        };
    }

    @Override
    public BuildNet net() {
        return new PSNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new PSSliderDrawable();
    }
}

