/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Fonts;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.TileFont;

public class FontA
extends BuildFont {
    private TileFont font;
    private char[] sym = new char[1];

    public FontA(Engine draw) {
        super(draw, 8, 65536, 0);
        this.font = new TileFont(TileFont.FontType.Tilemap, 159, 8, 8, 16, 8);
    }

    @Override
    public int getWidth(char[] text) {
        int width = 0;
        if (text != null) {
            int pos = 0;
            while (pos < text.length && text[pos++] != '\u0000') {
                width += 8;
            }
        }
        return width;
    }

    @Override
    public int drawChar(int x, int y, char ch, int shade, int pal, int nBits, boolean shadow) {
        this.sym[0] = ch;
        this.drawText(x, y, this.sym, 65536, shade, pal, BuildFont.TextAlign.Center, nBits, shadow);
        return (int)((float)this.nScale / 65536.0f * (float)this.font.charsizx);
    }

    @Override
    public int drawText(int x, int y, char[] text, int tscale, int shade, int pal, BuildFont.TextAlign align, int nBits, boolean shadow) {
        if (text == null) {
            return 0;
        }
        float fscale = (float)tscale / (float)this.nScale;
        if ((nBits & 2) != 0) {
            Gameutils.ConvertType type = Gameutils.ConvertType.Normal;
            if ((nBits & 0x100) != 0) {
                type = Gameutils.ConvertType.AlignLeft;
            }
            if ((nBits & 0x200) != 0) {
                type = Gameutils.ConvertType.AlignRight;
            }
            if ((nBits & 0x400) != 0) {
                type = Gameutils.ConvertType.Stretch;
            }
            x = Gameutils.coordsConvertXScaled(x, type);
            y = Gameutils.coordsConvertYScaled(y);
            int xdim = 4 * Engine.ydim / 3;
            fscale = (float)tscale / (float)this.nScale * (float)xdim / 320.0f;
        }
        if (align != BuildFont.TextAlign.Left) {
            int nWidth = this.getWidth(text, tscale);
            if (align == BuildFont.TextAlign.Center) {
                nWidth >>= 1;
            }
            x -= nWidth;
        }
        if (shadow) {
            int offs = (int)(1.0f * fscale);
            this.draw.getrender().printext(this.font, x + offs, y + offs, text, 0, 255, Renderer.Transparent.None, fscale);
        }
        this.draw.getrender().printext(this.font, x, y, text, pal, shade, Renderer.Transparent.None, fscale);
        return 0;
    }
}

