/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Screens;

import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Powerslave.Cinema;
import ru.m210projects.Powerslave.Config;
import ru.m210projects.Powerslave.Energy;
import ru.m210projects.Powerslave.Factory.PSMenuHandler;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.LoadSave;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Menus.MenuInterfaceSet;
import ru.m210projects.Powerslave.Menus.PSMenuUserContent;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sector;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.SpiritHead;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.EpisodeInfo;
import ru.m210projects.Powerslave.Type.Input;
import ru.m210projects.Powerslave.Type.PlayerStruct;
import ru.m210projects.Powerslave.View;
import ru.m210projects.Powerslave.Weapons;

public class GameScreen
extends GameAdapter {
    private Main game;
    private int nonsharedtimer;
    public int gNameShowTime;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
    }

    @Override
    public void show() {
        super.show();
        Globals.bPlayback = false;
        Globals.bInDemo = false;
        Sound.sndPlayMusic();
    }

    protected void UpdateInputs(BuildNet net) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Input src = (Input)net.gFifoInput[net.gNetFifoTail & 0xFF][i];
            Globals.sPlayerInput[i].Copy(src);
            if ((Globals.sPlayerInput[i].bits & 2) != 0) {
                this.game.gPaused = !this.game.gPaused;
                this.sndHandlePause(this.game.gPaused);
            }
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        Palette.FixPalette();
        this.UpdateInputs(net);
        this.nonsharedtimer = Engine.totalclock;
        if (this.game.gPaused || !this.game.isCurrentScreen(Main.gGameScreen) && !this.game.isCurrentScreen(Main.gDemoScreen)) {
            return;
        }
        if (this.game.isCurrentScreen(Main.gGameScreen) && (this.game.menu.gShowMenu || Console.IsShown())) {
            return;
        }
        Sound.UpdateSounds();
        if (Globals.levelnum == 20) {
            --Globals.lCountDown;
            GameScreen.DrawClock();
            if (Globals.nRedTicks != 0 && --Globals.nRedTicks <= 0) {
                GameScreen.DoRedAlert(0);
            }
            --Globals.nButtonColor;
            if (--Globals.nAlarmTicks <= 0) {
                GameScreen.DoRedAlert(1);
            }
            if (Globals.lCountDown <= 0) {
                Cinema.DoFailedFinalScene();
            }
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Globals.PlayerList[i].UpdatePlayerLoc();
            i = Mmulti.connectpoint2[i];
        }
        Light.UndoFlashes();
        Light.DoLights();
        if (Globals.nFreeze != 0) {
            if (Globals.gCurrentEpisode != Globals.gOriginalEpisode) {
                if (Globals.mUserFlag == Main.UserFlag.UserMap) {
                    BuildGdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            Globals.nPlayerLives[0] = 0;
                            GameScreen.this.game.EndGame();
                        }
                    });
                } else {
                    Globals.levelnew = Globals.levelnum + 1;
                }
            } else if (Globals.nFreeze == 1 || Globals.nFreeze == 2) {
                SpiritHead.DoSpiritHead();
                if (Main.cfg.bSubtitles && Globals.nFreeze == 2 && SpiritHead.nHeadStage == 5 && Cinema.nHeight + Cinema.nCrawlY > 0 && Engine.totalclock >= Cinema.nextclock) {
                    Cinema.nextclock = Engine.totalclock + 14;
                    --Cinema.nCrawlY;
                }
            }
        } else {
            RunList.ExecObjects();
            RunList.CleanRunRecs();
        }
        View.MoveStatus();
        Sprites.DoBubbleMachines();
        Object.DoDrips();
        Sector.DoMovingSects();
        Object.DoRegenerates();
        if (Globals.followmode) {
            Globals.followa = (int)((float)Globals.followa + Globals.followang);
            Globals.followx += Globals.followvel * Engine.sintable[2560 - Globals.followa & 0x7FF] >> 10;
            Globals.followy += Globals.followvel * Engine.sintable[1024 - Globals.followa & 0x7FF] >> 10;
            Globals.followx += Globals.followsvel * Engine.sintable[1024 - Globals.followa & 0x7FF] >> 10;
            Globals.followy -= Globals.followsvel * Engine.sintable[2560 - Globals.followa & 0x7FF] >> 10;
        }
        if (Globals.levelnum == 20) {
            Object.DoFinale();
            if (Globals.lCountDown < 1800 && Globals.nDronePitch < 2400 && Globals.lFinaleStart == 0) {
                Globals.nDronePitch += 64;
                Sound.BendAmbientSound();
            }
        }
        if (Globals.totalvel[Globals.nLocalPlayer] != 0) {
            Weapons.bobangle += 56;
            Weapons.bobangle &= 0x7FF;
        } else {
            Weapons.bobangle = 0;
        }
        ++Globals.totalmoves;
        --Globals.moveframes;
        Map.checkNextMap();
    }

    @Override
    public void DrawWorld(float smooth) {
        int fz;
        int cz;
        if (Globals.PlayerList[Globals.nLocalPlayer].spriteId == -1) {
            return;
        }
        SPRITE pPlayer = Engine.sprite[Globals.PlayerList[Globals.nLocalPlayer].spriteId];
        PlayerStruct pp = Globals.PlayerList[0];
        short nSector = -1;
        if (Globals.nSnakeCam >= 0) {
            SPRITE pSnake = Engine.sprite[Snake.SnakeList[Globals.nSnakeCam].nSprite[0]];
            Globals.nCamerax = pSnake.x;
            Globals.nCameray = pSnake.y;
            Globals.nCameraz = pSnake.z;
            Globals.nCameraa = pSnake.ang;
            Globals.nCamerapan = 92.0f;
            nSector = pSnake.sectnum;
            Interpolation.ILoc oldLoc = this.game.pInt.getsprinterpolate(Snake.SnakeList[Globals.nSnakeCam].nSprite[0]);
            if (oldLoc != null) {
                Globals.nCamerax = oldLoc.x + Pragmas.mulscale(Globals.nCamerax - oldLoc.x, (int)smooth, 16);
                Globals.nCameray = oldLoc.y + Pragmas.mulscale(Globals.nCameray - oldLoc.y, (int)smooth, 16);
                Globals.nCameraz = oldLoc.z + Pragmas.mulscale(Globals.nCameraz - oldLoc.z, (int)smooth, 16);
                Globals.nCameraa = oldLoc.ang + Pragmas.mulscale((pSnake.ang - oldLoc.ang + 1024 & 0x7FF) - 1024, (int)smooth, 16);
            }
            Palette.SetGreenPal();
        } else {
            Palette.RestoreGreenPal();
            Globals.nCamerax = pPlayer.x;
            Globals.nCameray = pPlayer.y;
            Globals.nCameraz = pPlayer.z + pp.eyelevel;
            Globals.nCameraa = pp.ang;
            Globals.nCamerapan = pp.horiz;
            nSector = Globals.nPlayerViewSect[Globals.nLocalPlayer];
        }
        if (nSector != -1 && Globals.initsect != -1) {
            Map.UpdateMap();
        }
        if (Globals.bCamera) {
            if (!this.game.menu.gShowMenu && !Console.IsShown() || this.game.isCurrentScreen(Main.gDemoScreen)) {
                Globals.nCamerax = pp.prevView.x + Pragmas.mulscale(Globals.nCamerax - pp.prevView.x, (int)smooth, 16);
                Globals.nCameray = pp.prevView.y + Pragmas.mulscale(Globals.nCameray - pp.prevView.y, (int)smooth, 16);
                Globals.nCameraz = pp.prevView.z + Pragmas.mulscale(Globals.nCameraz - pp.prevView.z, (int)smooth, 16);
                Globals.nCameraa = pp.prevView.ang + (Gameutils.BClampAngle(Globals.nCameraa + 1024.0f - pp.prevView.ang) - 1024.0f) * smooth / 65536.0f;
            }
            Main.engine.clipmove(Globals.nCamerax, Globals.nCameray, Globals.nCameraz, nSector, (int)(-2000.0 * Gameutils.BCosAngle(Globals.nCameraa)), (int)(-2000.0 * Gameutils.BSinAngle(Globals.nCameraa)), 64, 0, 0, 0x1000040);
            Globals.nCamerapan = 92.0f;
            if (Engine.clipmove_sectnum != -1) {
                Globals.nCamerax = Engine.clipmove_x;
                Globals.nCameray = Engine.clipmove_y;
                Globals.nCameraz = Engine.clipmove_z;
                nSector = Engine.clipmove_sectnum;
            }
        } else if (Globals.nSnakeCam == -1) {
            if (!this.game.menu.gShowMenu && !Console.IsShown() || this.game.isCurrentScreen(Main.gDemoScreen)) {
                Globals.nCamerax = pp.prevView.x + Pragmas.mulscale(Globals.nCamerax - pp.prevView.x, (int)smooth, 16);
                Globals.nCameray = pp.prevView.y + Pragmas.mulscale(Globals.nCameray - pp.prevView.y, (int)smooth, 16);
                Globals.nCameraz = pp.prevView.z + Pragmas.mulscale(Globals.nCameraz - pp.prevView.z, (int)smooth, 16);
                Globals.nCameraa = pp.prevView.ang + (Gameutils.BClampAngle(Globals.nCameraa + 1024.0f - pp.prevView.ang) - 1024.0f) * smooth / 65536.0f;
                Globals.nCamerapan = pp.prevView.horiz + (pp.horiz - pp.prevView.horiz) * smooth / 65536.0f;
            }
            if ((Globals.nCameraz += Globals.nQuake[Globals.nLocalPlayer]) > Engine.sector[pPlayer.sectnum].floorz) {
                Globals.nCameraz = Engine.sector[pPlayer.sectnum].floorz;
            }
            Globals.nCameraa += (float)((Globals.nQuake[Globals.nLocalPlayer] >> 7) % 31);
        }
        if ((cz = Engine.sector[nSector].ceilingz + 2048) > Globals.nCameraz) {
            Globals.nCameraz = cz;
        }
        if ((fz = Engine.sector[nSector].floorz - 2048) < Globals.nCameraz) {
            Globals.nCameraz = fz;
        }
        Globals.nCamerapan += 8.0f;
        if (Globals.nFreeze != 0 || View.nOverhead != 2) {
            Main.engine.drawrooms(Globals.nCamerax, Globals.nCameray, Globals.nCameraz, Globals.nCameraa, Globals.nCamerapan, nSector);
            View.analyzesprites((int)smooth);
            Main.engine.drawmasks();
        }
        if (Globals.nFreeze == 0 && View.nOverhead > 0) {
            if (Globals.followmode) {
                Globals.nCamerax = Globals.followx;
                Globals.nCameray = Globals.followy;
                Globals.nCameraa = Globals.followa;
            }
            if (View.nOverhead == 2) {
                Main.engine.clearview(96);
                Main.engine.drawmapview(Globals.nCamerax, Globals.nCameray, View.zoom, (short)Globals.nCameraa);
            }
            Main.engine.drawoverheadmap(Globals.nCamerax, Globals.nCameray, View.zoom, (short)Globals.nCameraa);
            if (Globals.followmode) {
                this.game.getFont(0).drawText(5, 25, "Follow mode", 0, 0, BuildFont.TextAlign.Left, 258, true);
            }
            if (Globals.mUserFlag == Main.UserFlag.UserMap) {
                this.game.getFont(0).drawText(5, 15, "User map: " + Globals.boardfilename, 0, 7, BuildFont.TextAlign.Left, 258, true);
            } else if (Globals.levelnum > 0 && Globals.gCurrentEpisode.gMapInfo.get(Globals.levelnum - 1) != null) {
                this.game.getFont(0).drawText(5, 15, Globals.gCurrentEpisode.gMapInfo.get((int)(Globals.levelnum - 1)).title, 0, 7, BuildFont.TextAlign.Left, 258, true);
            }
        }
        if (Palette.nPalDiff != 0 && Main.engine.glrender() != null) {
            Main.engine.showfade();
        }
    }

    @Override
    public void DrawHud(float smooth) {
        if (this.game.gPaused) {
            this.game.getFont(1).drawText(160, 80, "PAUSE", 65536, 0, 0, BuildFont.TextAlign.Center, 2, true);
        }
        if (Globals.nFreeze != 0) {
            Globals.nSnakeCam = -1;
            if (this.game.pInput.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true) || this.game.pInput.ctrlGetInputKey(BuildConfig.GameKeys.Open, true)) {
                Globals.levelnew = Globals.levelnum + 1;
                return;
            }
            if (Globals.nFreeze == 2) {
                if (SpiritHead.nHeadStage == 4) {
                    short spr = Globals.PlayerList[Globals.nLocalPlayer].spriteId;
                    Engine.sprite[spr].cstat = (short)(Engine.sprite[spr].cstat | 0x8000);
                    short dang = (short)(Globals.nCameraa - (float)Engine.sprite[spr].ang);
                    if (Pragmas.klabs(dang) > 10) {
                        Globals.inita -= dang >> 3;
                        return;
                    }
                    if (Main.cfg.bSubtitles) {
                        if (Globals.levelnum == 1) {
                            Cinema.ReadyCinemaText(1);
                        } else {
                            Cinema.ReadyCinemaText(5);
                        }
                    }
                    SpiritHead.nHeadStage = (short)5;
                } else if (Main.cfg.bSubtitles && !Cinema.AdvanceCinemaText()) {
                    Globals.levelnew = Globals.levelnum + 1;
                }
            }
            return;
        }
        if (Globals.nSnakeCam >= 0) {
            this.game.getFont(0).drawText(160, 5, "S E R P E N T C A M", -128, 0, BuildFont.TextAlign.Center, 2, true);
            return;
        }
        if (View.nOverhead != 2) {
            Weapons.DrawWeapons();
        }
        if (!this.game.menu.gShowMenu || this.game.menu.getCurrentMenu() instanceof MenuInterfaceSet) {
            View.DrawStatus();
            if (this.game.isCurrentScreen(Main.gGameScreen) && Engine.totalclock < this.gNameShowTime) {
                int transp = 0;
                if (Engine.totalclock > this.gNameShowTime - 20) {
                    transp = 1;
                }
                if (Engine.totalclock > this.gNameShowTime - 10) {
                    transp = 33;
                }
                if (Main.cfg.showMapInfo != 0 && !this.game.menu.gShowMenu) {
                    if (Globals.mUserFlag != Main.UserFlag.UserMap && Globals.levelnum > 0) {
                        if (Globals.gCurrentEpisode.gMapInfo.get(Globals.levelnum - 1) != null) {
                            this.game.getFont(1).drawText(160, 100, Globals.gCurrentEpisode.gMapInfo.get((int)(Globals.levelnum - 1)).title, -128, 0, BuildFont.TextAlign.Center, 2 | transp, true);
                        }
                    } else if (Globals.boardfilename != null) {
                        this.game.getFont(1).drawText(160, 100, FileUtils.getFullName(Globals.boardfilename), -128, 0, BuildFont.TextAlign.Center, 2 | transp, true);
                    }
                }
            }
            int y = 155;
            if (Main.cfg.nScreenSize == 0) {
                y = 195;
            }
            View.viewDrawStats(5, y, Main.cfg.gStatSize);
        }
    }

    @Override
    public void PostFrame(BuildNet net) {
        PSMenuHandler menu = this.game.menu;
        if (LoadSave.gAutosaveRequest) {
            if (LoadSave.gClassicMode) {
                if (LoadSave.nSaveName == null) {
                    if (!menu.isOpened(menu.mMenus[4])) {
                        menu.mOpen(menu.mMenus[4], -1);
                    }
                } else if (this.captBuffer != null) {
                    LoadSave.savegame(LoadSave.nSaveName, LoadSave.nSaveFile);
                    LoadSave.gAutosaveRequest = false;
                } else {
                    Main.gGameScreen.capture(160, 100);
                }
            } else if (this.captBuffer != null) {
                LoadSave.savegame("[autosave]", "autosave.sav");
                LoadSave.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (LoadSave.gQuickSaving) {
            if (this.captBuffer != null) {
                LoadSave.savegame("[quicksave_" + LoadSave.quickslot + "]", "quicksav" + LoadSave.quickslot + ".sav");
                LoadSave.quickslot ^= 1;
                LoadSave.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
    }

    @Override
    public void KeyHandler() {
        PSMenuHandler menu = this.game.menu;
        if (menu.gShowMenu) {
            Main.engine.handleevents();
            menu.mKeyHandler(this.game.pInput, BuildGdx.graphics.getDeltaTime());
            return;
        }
        if (Console.IsShown()) {
            return;
        }
        if (Globals.nFreeze != 0) {
            return;
        }
        BuildControls input = this.game.pInput;
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true)) {
            Sound.StopAllSounds();
            menu.mOpen(menu.mMenus[1], -1);
        }
        if (View.nOverhead != 0) {
            int j = Engine.totalclock - this.nonsharedtimer;
            this.nonsharedtimer += j;
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Enlarge_Screen, false)) {
                View.zoom += Pragmas.mulscale(j, Math.max(View.zoom, 256), 6);
            }
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Shrink_Screen, false)) {
                View.zoom -= Pragmas.mulscale(j, Math.max(View.zoom, 256), 6);
            }
            if (View.zoom > 2048) {
                View.zoom = 2048;
            }
            if (View.zoom < 48) {
                View.zoom = 48;
            }
            if (input.ctrlGetInputKey(Config.PsKeys.Map_Follow_Mode, true)) {
                boolean bl = Globals.followmode = !Globals.followmode;
                if (Globals.followmode) {
                    Globals.followx = Globals.initx;
                    Globals.followy = Globals.inity;
                    Globals.followa = Globals.inita;
                }
                View.StatusMessage(500, "Follow mode " + (Globals.followmode ? "ON" : "OFF"), Globals.nLocalPlayer);
            }
        } else {
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Enlarge_Screen, true) && Main.cfg.nScreenSize > 0) {
                Main.cfg.nScreenSize = Gameutils.BClipLow(Main.cfg.nScreenSize - 1, 0);
            }
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Shrink_Screen, true) && Main.cfg.nScreenSize < 2) {
                Main.cfg.nScreenSize = Gameutils.BClipHigh(Main.cfg.nScreenSize + 1, 2);
            }
        }
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Map_Toggle, true)) {
            this.setOverHead(View.nOverhead);
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Show_SaveMenu, true)) {
            if (Mmulti.numplayers > 1 || LoadSave.gClassicMode) {
                return;
            }
            if (Globals.PlayerList[Globals.nLocalPlayer].HealthAmount != 0) {
                Main.gGameScreen.capture(160, 100);
                menu.mOpen(menu.mMenus[4], -1);
            }
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Show_LoadMenu, true)) {
            if (Mmulti.numplayers > 1) {
                return;
            }
            menu.mOpen(menu.mMenus[3], -1);
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Show_SoundSetup, true)) {
            menu.mOpen(menu.mMenus[6], -1);
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Show_Options, true)) {
            menu.mOpen(menu.mMenus[5], -1);
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Quicksave, true)) {
            LoadSave.quicksave();
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Toggle_messages, true)) {
            boolean bl = Main.cfg.gShowMessages = !Main.cfg.gShowMessages;
            if (Main.cfg.gShowMessages) {
                View.StatusMessage(500, "Messages on", Globals.nLocalPlayer);
            }
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Quickload, true)) {
            LoadSave.quickload();
        }
        if (input.ctrlGetInputKey(Config.PsKeys.AutoRun, true)) {
            Main.cfg.gAutoRun = !Main.cfg.gAutoRun;
            View.StatusMessage(500, "Autorun " + (Main.cfg.gAutoRun ? "ON" : "OFF"), Globals.nLocalPlayer);
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Third_View, true)) {
            Globals.bCamera = !Globals.bCamera;
            View.StatusMessage(500, "Third person view " + (Globals.bCamera ? "ON" : "OFF"), Globals.nLocalPlayer);
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Quit, true)) {
            menu.mOpen(menu.mMenus[8], -1);
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Gamma, true)) {
            menu.mOpen(menu.mMenus[7], -1);
        }
        if (input.ctrlGetInputKey(Config.PsKeys.Make_Screenshot, true)) {
            this.makeScreenshot();
        }
    }

    protected void setOverHead(int mode) {
        switch (mode) {
            case 0: {
                if (Main.cfg.gOverlayMap != 0) {
                    View.nOverhead = 1;
                    break;
                }
                View.nOverhead = 2;
                break;
            }
            case 1: {
                if (Main.cfg.gOverlayMap == 1) {
                    View.nOverhead = 0;
                    break;
                }
                View.nOverhead = 2;
                break;
            }
            default: {
                View.nOverhead = 0;
            }
        }
    }

    protected void makeScreenshot() {
        String name = "scrxxxx.png";
        name = Globals.mUserFlag == Main.UserFlag.UserMap ? "scr-" + FileUtils.getFullName(Globals.boardfilename) + "-xxxx.png" : "scr-map" + Globals.levelnum + "-xxxx.png";
        String filename = this.pEngine.screencapture(name);
        if (filename != null) {
            View.StatusMessage(500, String.valueOf(filename) + " saved", Globals.nLocalPlayer);
        } else {
            View.StatusMessage(500, "Screenshot not saved. Access denied!", Globals.nLocalPlayer);
        }
    }

    @Override
    public void sndHandlePause(boolean pause) {
        Sound.sndHandlePause(pause);
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.gPrecacheScreen.init(false, startboard);
        this.game.changeScreen(Main.gPrecacheScreen);
    }

    @Override
    protected boolean prepareboard(String map) {
        if (!Map.LoadLevel(map, Globals.levelnew)) {
            Map.bMapCrash = true;
            return false;
        }
        this.gNameShowTime = 500;
        Sound.StopAllSounds();
        if (!Globals.bPlayback) {
            Sound.StopMusic();
        }
        Globals.levelnew = -1;
        Globals.lastlevel = Globals.levelnum;
        View.nOverhead = 0;
        this.game.gPaused = false;
        Arrays.fill(Engine.show2dsector, (byte)0);
        Arrays.fill(Engine.show2dwall, (byte)0);
        Arrays.fill(Engine.show2dsprite, (byte)0);
        int i = 0;
        while (i < Mmulti.numplayers) {
            Player.SetSavePoint(i, Globals.initx, Globals.inity, Globals.initz, Globals.initsect, Globals.inita);
            Player.RestartPlayer(i);
            Player.InitPlayerKeys(i);
            ++i;
        }
        View.UpdateScreenSize();
        View.InitStatus();
        this.game.pNet.ResetNetwork();
        this.game.pNet.ResetTimers();
        this.game.pNet.ready2send = false;
        Globals.totalmoves = 0;
        Palette.GrabPalette();
        Globals.moveframes = 0;
        View.RefreshStatus();
        System.err.println(map);
        return true;
    }

    public static void DoClockBeep() {
        short i = Engine.headspritestat[407];
        while (i != -1) {
            Sound.PlayFX2(Sound.StaticSound[74], i);
            i = Engine.nextspritestat[i];
        }
    }

    public static void DrawClock() {
        int nCount = Globals.lCountDown / 30;
        if (nCount != Globals.nClockVal) {
            Arrays.fill(Main.engine.loadtile(3603), (byte)-1);
            Globals.nClockVal = nCount;
            GameScreen.DoClockBeep();
            int x = 49;
            while (nCount != 0) {
                int nNumber = 3606 + (nCount & 0xF);
                Tile pic = Main.engine.getTile(nNumber);
                GameScreen.CopyTileToBitmap(nNumber, 3603, x - pic.getWidth() / 2, 32 - pic.getHeight() / 2);
                x -= 15;
                nCount /= 16;
            }
            Main.engine.invalidatetile(3603, -1, -1);
        }
        Energy.DoEnergyTile();
    }

    private static void DoRedAlert(int a1) {
        if (a1 != 0) {
            Globals.nAlarmTicks = 69;
            Globals.nRedTicks = 30;
        }
        short i = Engine.headspritestat[405];
        while (i != -1) {
            if (a1 != 0) {
                Sound.PlayFXAtXYZ(Sound.StaticSound[73], Engine.sprite[i].x, Engine.sprite[i].y, Engine.sprite[i].z, Engine.sprite[i].sectnum);
                Light.AddFlash(Engine.sprite[i].sectnum, Engine.sprite[i].x, Engine.sprite[i].y, Engine.sprite[i].z, 192);
            }
            i = Engine.nextspritestat[i];
        }
    }

    public static void CopyTileToBitmap(int nSource, int nDest, int cx, int cy) {
        Tile src = Main.engine.getTile(nSource);
        if (src.data == null) {
            Main.engine.loadtile(nSource);
        }
        Tile dst = Main.engine.getTile(nDest);
        byte[] pSource = src.data;
        byte[] pDest = dst.data;
        int sptr = 0;
        int dptr = dst.getHeight() * cx + cy;
        int i = 0;
        while (i < src.getWidth()) {
            int j = 0;
            while (j < src.getHeight()) {
                byte col;
                if ((col = pSource[sptr++]) != -1 && dptr + j < pDest.length) {
                    pDest[dptr + j] = col;
                }
                ++j;
            }
            dptr += dst.getHeight();
            ++i;
        }
    }

    public void changemap(int num, Runnable prestart) {
        if (num < 1) {
            return;
        }
        Globals.boardfilename = Globals.gCurrentEpisode.gMapInfo.get((int)(num - 1)).path;
        Globals.levelnew = num;
        String name = "Loading " + Globals.gCurrentEpisode.gMapInfo.get((int)(num - 1)).title;
        this.loadboard(Globals.boardfilename, prestart).setTitle(name);
        this.game.pInput.resetMousePos();
    }

    public void training() {
        this.newgame(Globals.gTrainingEpisode, 1, true);
    }

    public void newgame(java.lang.Object item, int nLevel, boolean classic) {
        Globals.nBestLevel = nLevel - 1;
        Globals.lastlevel = -1;
        View.zoom = 768;
        LoadSave.lastload = null;
        Globals.bCamera = false;
        this.pNet.ready2send = false;
        this.game.nNetMode = BuildGame.NetMode.Single;
        LoadSave.gClassicMode = classic;
        Globals.bPlayback = false;
        Main.UserFlag flag = Main.UserFlag.None;
        if (item instanceof EpisodeInfo) {
            EpisodeInfo game = (EpisodeInfo)item;
            if (!game.equals(Globals.gTrainingEpisode) && !game.equals(Globals.gOriginalEpisode)) {
                if (!PSMenuUserContent.checkEpisodeResources(game)) {
                    return;
                }
                flag = Main.UserFlag.Addon;
                Console.Println("Start user episode: " + game.Title);
            } else {
                PSMenuUserContent.resetEpisodeResources(game);
            }
        } else if (item instanceof FileEntry) {
            flag = Main.UserFlag.UserMap;
            Globals.boardfilename = ((FileEntry)item).getPath();
            Globals.levelnum = 0;
            Globals.levelnew = 0;
            PSMenuUserContent.resetEpisodeResources(null);
            Console.Println("Start user map: " + ((FileEntry)item).getName());
        }
        Globals.mUserFlag = flag;
        Globals.PlayerCount = 0;
        int i = 0;
        while (i < Mmulti.numplayers) {
            int nPlayer = Player.GrabPlayer();
            if (nPlayer == -1) {
                System.err.println("Can't create local player");
                return;
            }
            Player.InitPlayerInventory(nPlayer);
            ++i;
        }
        if (!LoadSave.gClassicMode) {
            Globals.PlayerList[Globals.nLocalPlayer].HealthAmount = (short)800;
            if (Globals.nNetPlayerCount != 0) {
                Globals.PlayerList[Globals.nLocalPlayer].HealthAmount = (short)1600;
            }
        }
        if (Globals.mUserFlag == Main.UserFlag.UserMap) {
            Main.gGameScreen.loadboard(Globals.boardfilename, null).setTitle("Loading " + Globals.boardfilename);
            this.game.pInput.resetMousePos();
        } else if (Globals.gCurrentEpisode != null) {
            if (Globals.gCurrentEpisode.equals(Globals.gOriginalEpisode)) {
                Main.gMap.showMap(nLevel, nLevel, Globals.nBestLevel);
            } else {
                this.changemap(nLevel, null);
            }
        } else {
            this.game.show();
        }
    }

    public boolean isOriginal() {
        return false;
    }
}

