/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sector;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.BubbleMachineStruct;
import ru.m210projects.Powerslave.Type.BubbleStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Sprites {
    public static short[] nBodySprite = new short[50];
    public static int nCurBodyNum;
    public static int nBodyTotal;
    public static short[] nChunkSprite;
    public static short[] nBodyGunSprite;
    public static int nCurChunkNum;
    public static int nCurBodyGunNum;
    public static int nChunkTotal;
    public static int word_96760;
    private static int[] wheresMyMouth;

    static {
        nChunkSprite = new short[75];
        nBodyGunSprite = new short[50];
        wheresMyMouth = new int[4];
    }

    public static void InitChunks() {
        nCurChunkNum = 0;
        Arrays.fill(nChunkSprite, (short)-1);
        Arrays.fill(nBodyGunSprite, (short)-1);
        Arrays.fill(nBodySprite, (short)-1);
        nCurBodyNum = 0;
        nCurBodyGunNum = 0;
        nBodyTotal = 0;
        nChunkTotal = 0;
    }

    public static short GrabBody() {
        short nSprite;
        do {
            nSprite = nBodySprite[nCurBodyNum];
            if (nBodySprite[nCurBodyNum] == -1) {
                Sprites.nBodySprite[Sprites.nCurBodyNum] = nSprite = Main.engine.insertsprite((short)0, (short)899);
                Engine.sprite[nSprite].cstat = Short.MIN_VALUE;
            }
            if (++nCurBodyNum < 50) continue;
            nCurBodyNum = 0;
        } while ((Engine.sprite[nSprite].cstat & 0x101) != 0);
        if (nBodyTotal < 50) {
            ++nBodyTotal;
        }
        Engine.sprite[nSprite].cstat = 0;
        return nSprite;
    }

    public static boolean GrabItem(int nPlayer, int nItem) {
        if (Globals.PlayerList[nPlayer].ItemsAmount[nItem] < 5) {
            int n = nItem;
            Globals.PlayerList[nPlayer].ItemsAmount[n] = (byte)(Globals.PlayerList[nPlayer].ItemsAmount[n] + 1);
            if (Globals.nPlayerItem[nPlayer] < 0 || nItem == Globals.nPlayerItem[nPlayer]) {
                Player.SetPlayerItem(nPlayer, nItem);
            }
            return true;
        }
        return false;
    }

    public static int CheckRadialDamage(int a1) {
        int v13 = 0;
        if (a1 != Globals.nRadialSpr) {
            SPRITE v2 = Engine.sprite[a1];
            if ((v2.cstat & 0x101) != 0) {
                short v3 = v2.statnum;
                SPRITE v4 = Engine.sprite[Globals.nRadialSpr];
                if (v3 < 1024 && v4.statnum < 1024 && (v3 == 100 || a1 != Globals.nRadialOwner)) {
                    int v19;
                    int v5 = v2.x - v4.x >> 8;
                    int v18 = v2.y - v4.y >> 8;
                    int v8 = v2.z - v4.z >> 12;
                    if (Pragmas.klabs(v5) <= Globals.nDamageRadius && Pragmas.klabs(v18) <= Globals.nDamageRadius && Pragmas.klabs(v8) <= Globals.nDamageRadius && (v19 = Main.engine.ksqrt(v5 * v5 + v18 * v18)) < Globals.nDamageRadius) {
                        short oldcstat = v2.cstat;
                        v2.cstat = (short)257;
                        if ((152 - v2.statnum <= 1 || Main.engine.cansee(v4.x, v4.y, v4.z - 512, v4.sectnum, v2.x, v2.y, v2.z - 8192, v2.sectnum)) && (v13 = Globals.nRadialDamage * (Globals.nDamageRadius - v19) / Globals.nDamageRadius) >= 0 && v13 > 20) {
                            short ang = Main.engine.GetMyAngle(v5, v18);
                            v2.xvel = (short)(v2.xvel + (v13 * Engine.sintable[ang + 512 & 0x7FF] >> 3));
                            v2.yvel = (short)(v2.yvel + (v13 * Engine.sintable[ang & 0x7FF] >> 3));
                            v2.zvel = (short)Gameutils.BClipLow(v2.zvel - 24 * v13, -3584);
                        }
                        v2.cstat = oldcstat;
                    }
                }
            }
        }
        return v13;
    }

    public static void DestroyItemAnim(int nItem) {
        if (Engine.sprite[nItem].owner < 0 || Engine.sprite[nItem].owner >= 400) {
            return;
        }
        Anim.DestroyAnim(Engine.sprite[nItem].owner);
    }

    public static void ExplodeScreen(int a1) {
        Engine.sprite[a1].z -= Sprites.GetSpriteHeight(a1) / 2;
        int i = 0;
        while (i < 30) {
            Object.BuildSpark(a1, 0);
            ++i;
        }
        Engine.sprite[a1].cstat = Short.MIN_VALUE;
        Sound.PlayFX2(Sound.StaticSound[78], a1);
    }

    public static short GrabChunkSprite() {
        short nSprite = nChunkSprite[nCurChunkNum];
        if (nSprite == -1) {
            Sprites.nChunkSprite[Sprites.nCurChunkNum] = nSprite = Main.engine.insertsprite((short)0, (short)899);
        } else if (Engine.sprite[nSprite].statnum != 0) {
            System.err.println("too many chunks being used at once!");
            return -1;
        }
        Main.engine.changespritestat(nSprite, 899);
        if (++nCurChunkNum >= 75) {
            nCurChunkNum = 0;
        }
        if (nChunkTotal < 75) {
            ++nChunkTotal;
        }
        Engine.sprite[nSprite].cstat = (short)128;
        return nSprite;
    }

    public static short BuildCreatureChunk(int a0, int a1) {
        short spr = Sprites.GrabChunkSprite();
        boolean v15 = false;
        if (spr != -1) {
            SPRITE v6 = Engine.sprite[spr];
            if ((a0 & 0x4000) != 0) {
                a0 &= 0xFFFFBFFF;
                v15 = true;
            }
            SPRITE v7 = Engine.sprite[a0];
            v6.x = v7.x;
            v6.y = v7.y;
            v6.z = v7.z;
            Main.engine.mychangespritesect(spr, v7.sectnum);
            v6.cstat = (short)128;
            v6.shade = (byte)-12;
            v6.pal = 0;
            v6.xvel = (short)((Random.RandomSize(5) - 16 & 0xFFFF) << 7);
            v6.yvel = (short)((Random.RandomSize(5) - 16 & 0xFFFF) << 7);
            v6.zvel = (short)(-8 * (Random.RandomSize(8) + 512));
            if (v15) {
                v6.xvel = (short)(v6.xvel * 4);
                v6.yvel = (short)(v6.yvel * 4);
                v6.zvel = (short)(v6.zvel * 2);
            }
            v6.xrepeat = (short)64;
            v6.yrepeat = (short)64;
            v6.xoffset = 0;
            v6.yoffset = 0;
            v6.picnum = (short)a1;
            v6.lotag = (short)(RunList.HeadRun() + 1);
            v6.clipdist = 40;
            v6.extra = (short)-1;
            v6.owner = (short)RunList.AddRunRec(v6.lotag - 1, 0xD0000 | spr);
            v6.hitag = (short)RunList.AddRunRec(RunList.NewRun, 0xD0000 | spr);
        }
        return spr;
    }

    public static void FuncCreatureChunk(int a1, int a2, int RunPtr) {
        short spr = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        if ((a1 & 0x7F0000) == 131072) {
            short sectnum = Engine.sprite[spr].sectnum;
            if (Gameutils.isValidSector(sectnum)) {
                Sprites.Gravity(spr);
                Engine.sprite[spr].pal = Engine.sector[sectnum].ceilingpal;
                int hitMove = Main.engine.movesprite(spr, Engine.sprite[spr].xvel << 10, Engine.sprite[spr].yvel << 10, Engine.sprite[spr].zvel, 2560, -2560, 1);
                if (Engine.sprite[spr].z < Engine.sector[sectnum].floorz) {
                    if (hitMove == 0) {
                        return;
                    }
                    if ((hitMove & 0x20000) == 0) {
                        short ang;
                        switch (hitMove & 0x3C000) {
                            default: {
                                return;
                            }
                            case 32768: {
                                ang = Main.engine.GetWallNormal(hitMove & 0x3FFF);
                                break;
                            }
                            case 49152: {
                                if (!Gameutils.isValidSprite(hitMove & 0x3FFF)) {
                                    return;
                                }
                                ang = Engine.sprite[hitMove & 0x3FFF].ang;
                                break;
                            }
                            case 65536: {
                                Engine.sprite[spr].xvel = (short)(Engine.sprite[spr].xvel >> 1);
                                Engine.sprite[spr].yvel = (short)(Engine.sprite[spr].yvel >> 1);
                                Engine.sprite[spr].zvel = -Engine.sprite[spr].zvel;
                                return;
                            }
                        }
                        int v20 = Main.engine.ksqrt((Engine.sprite[spr].yvel >> 10) * (Engine.sprite[spr].yvel >> 10) + (Engine.sprite[spr].xvel >> 10) * (Engine.sprite[spr].xvel >> 10) >> 8) >> 1;
                        Engine.sprite[spr].xvel = (short)(v20 * Engine.sintable[ang + 512 & 0x7FF]);
                        Engine.sprite[spr].yvel = (short)(v20 * Engine.sintable[ang & 0x7FF]);
                        return;
                    }
                    Engine.sprite[spr].cstat = Short.MIN_VALUE;
                } else {
                    Engine.sprite[spr].xvel = 0;
                    Engine.sprite[spr].yvel = 0;
                    Engine.sprite[spr].zvel = 0;
                    Engine.sprite[spr].z = Engine.sector[Engine.sprite[spr].sectnum].floorz;
                }
            }
            RunList.DoSubRunRec(Engine.sprite[spr].owner);
            RunList.FreeRun(Engine.sprite[spr].lotag - 1);
            RunList.SubRunRec(Engine.sprite[spr].hitag);
            Main.engine.changespritestat(spr, 0);
            Engine.sprite[spr].hitag = 0;
            Engine.sprite[spr].lotag = 0;
        }
    }

    public static void Gravity(int nSprite) {
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pSprite.sectnum != 1024 && (Globals.SectFlag[pSprite.sectnum] & 0x2000) != 0) {
            if (pSprite.statnum == 100) {
                if (pSprite.zvel > 0) {
                    pSprite.zvel = (short)(pSprite.zvel - 64);
                    if (pSprite.zvel < 0) {
                        pSprite.zvel = 0;
                        return;
                    }
                } else if (pSprite.zvel < 0) {
                    pSprite.zvel = (short)(pSprite.zvel + 64);
                    if (pSprite.zvel > 0) {
                        pSprite.zvel = 0;
                        return;
                    }
                }
            } else {
                pSprite.zvel = pSprite.zvel <= 1024 ? (short)(pSprite.zvel + 512) : (short)(pSprite.zvel - 64);
            }
        } else {
            pSprite.zvel = (short)(pSprite.zvel + 512);
            pSprite.zvel = (short)Gameutils.BClipHigh((int)pSprite.zvel, 16384);
        }
    }

    public static void DamageEnemy(int nDest, int nSource, int nDamage) {
        int left = Globals.nCreaturesLeft;
        if (nDest != -1 && Engine.sprite[nDest].statnum < 1024 && Engine.sprite[nDest].owner > -1) {
            RunList.SendMessageToRunRec(Engine.sprite[nDest].owner, 0x80000 | nSource & 0xFFFF, 4 * nDamage);
            if (left > Globals.nCreaturesLeft && nSource >= 0 && Engine.sprite[nSource].statnum == 100) {
                short plr;
                short s = plr = Player.GetPlayerFromSprite(nSource);
                Globals.nTauntTimer[s] = (short)(Globals.nTauntTimer[s] - 1);
                if (Globals.nTauntTimer[plr] <= 0) {
                    if ((Globals.SectFlag[Engine.sprite[Globals.PlayerList[plr].spriteId].sectnum] & 0x2000) == 0) {
                        Sound.D3PlayFX(Sound.StaticSound[Random.RandomSize(3) % 5 + 53], Globals.nDoppleSprite[plr] | (plr == Globals.nLocalPlayer ? 24576 : 16384));
                    }
                    Globals.nTauntTimer[plr] = (short)(Random.RandomSize(3) + 3);
                }
            }
        }
    }

    public static void RadialDamageEnemy(int nSprite, int damage, int radius) {
        if (radius != 0) {
            ++word_96760;
            if (Globals.nRadialSpr == -1) {
                Globals.nRadialDamage = 4 * damage;
                Globals.nDamageRadius = radius;
                Globals.nRadialSpr = nSprite;
                Globals.nRadialOwner = Engine.sprite[nSprite].owner;
                RunList.ExplodeSignalRun();
                Globals.nRadialSpr = -1;
                --word_96760;
            }
        }
    }

    public static short GetAngleToSprite(int nSprite1, int nSprite2) {
        if (nSprite1 >= 0 && nSprite2 >= 0) {
            return Main.engine.GetMyAngle(Engine.sprite[nSprite2].x - Engine.sprite[nSprite1].x, Engine.sprite[nSprite2].y - Engine.sprite[nSprite1].y);
        }
        return -1;
    }

    public static int GetSpriteHeight(int num) {
        if (!Gameutils.isValidSprite(num)) {
            return 0;
        }
        return 4 * Engine.sprite[num].yrepeat * Main.engine.getTile(Engine.sprite[num].picnum).getHeight();
    }

    public static void BuildSplash(int nSprite, int sectnum) {
        int v10;
        int v9;
        int v6;
        int v5;
        if (Engine.sprite[nSprite].statnum == 200) {
            v5 = 20;
            v6 = 1;
        } else {
            v5 = Random.RandomWord() % Engine.sprite[nSprite].xrepeat + Engine.sprite[nSprite].xrepeat;
            v6 = 0;
        }
        if ((Globals.SectFlag[sectnum] & 0x4000) != 0) {
            v9 = 43;
            v10 = 4;
        } else {
            v9 = 35;
            v10 = 0;
        }
        short v11 = Anim.AnimList[Anim.BuildAnim((int)-1, (int)v9, (int)0, (int)Engine.sprite[nSprite].x, (int)Engine.sprite[nSprite].y, (int)Engine.sector[sectnum].floorz, (int)sectnum, (int)v5, (int)v10)].nSprite;
        if ((Globals.SectFlag[sectnum] & 0x4000) == 0) {
            Sound.D3PlayFX(Sound.StaticSound[v6] | 0xA00, v11);
        }
    }

    public static int AngleChase(int nSprite, int nTarget, int a3, int a4, int a5) {
        SPRITE pSprite = Engine.sprite[nSprite];
        short nNewAngle = pSprite.ang;
        if (nTarget >= 0) {
            SPRITE pTarget = Engine.sprite[nTarget];
            int zTop = 2 * pTarget.yrepeat * Main.engine.getTile(pTarget.picnum).getHeight();
            int dx = pTarget.x - pSprite.x;
            int dy = pTarget.y - pSprite.y;
            int dz = pTarget.z - pSprite.z;
            int nGoalAngle = Sprites.AngleDelta(pSprite.ang, Main.engine.GetMyAngle(dx, dy), 1024);
            if (Pragmas.klabs(nGoalAngle) > 63 && (a3 /= Pragmas.klabs(nGoalAngle >> 6)) < 5) {
                a3 = 5;
            }
            if (Pragmas.klabs(nGoalAngle) > a5) {
                nGoalAngle = nGoalAngle >= 0 ? a5 : -a5;
            }
            nNewAngle = (short)(pSprite.ang + nGoalAngle & 0x7FF);
            pSprite.zvel = (short)(pSprite.zvel + Sprites.AngleDelta(pSprite.zvel, Main.engine.GetMyAngle(Main.engine.ksqrt(dx * dx + dy * dy), dz - zTop >> 8), 24) & 0x7FF);
        } else {
            pSprite.zvel = 0;
        }
        pSprite.ang = nNewAngle;
        int v28 = Pragmas.klabs(Engine.sintable[pSprite.zvel + 512 & 0x7FF]);
        int xvel = v28 * (a3 * Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 14);
        int yvel = v28 * (a3 * Engine.sintable[pSprite.ang & 0x7FF] >> 14);
        int v31 = Main.engine.ksqrt((xvel >> 8) * (xvel >> 8) + (yvel >> 8) * (yvel >> 8));
        return Main.engine.movesprite((short)nSprite, xvel >> 2, yvel >> 2, (Engine.sintable[a4 & 0x7FF] >> 5) + (v31 * Engine.sintable[pSprite.zvel & 0x7FF] >> 13), 0, 0, pSprite.statnum != 107 ? 1 : 0);
    }

    public static int AngleDelta(int ang1, int ang2, int a3) {
        int dang = ang2 - ang1;
        if (dang >= 0) {
            if (dang > 1024) {
                dang = -(2048 - dang);
            }
        } else if (dang < -1024) {
            dang += 2048;
        }
        if (Pragmas.klabs(dang) > a3) {
            return dang < 0 ? -a3 : a3;
        }
        return dang;
    }

    public static int AngleDiff(int a1, int a2) {
        int result = a2 - a1 & 0x7FF;
        if (result > 1024) {
            result = 2048 - result;
        }
        return result;
    }

    public static int GetUpAngle(int a1, int a2, int a3, int a4) {
        int v5 = Engine.sprite[a3].x - Engine.sprite[a1].x;
        int v6 = Engine.sprite[a3].y - Engine.sprite[a1].y;
        int v14 = Engine.sprite[a3].z + a4 - (Engine.sprite[a1].z + a2);
        int v10 = -(v14 >> 4) - (v14 >> 8);
        return Main.engine.GetMyAngle(Main.engine.ksqrt(v5 * v5 + v6 * v6), v10);
    }

    public static int BelowNear(int nSprite, int lohit) {
        SPRITE v2 = Engine.sprite[nSprite];
        short v11 = v2.sectnum;
        int v3 = 0;
        int v10 = 0;
        if ((lohit & 0xC000) == 49152) {
            v10 = 49152;
            v3 = Engine.sprite[lohit & 0x3FFF].z;
        } else {
            v3 = (Globals.SectDepth[v2.sectnum] & 0xFFFF) + Engine.sector[v2.sectnum].floorz;
            v10 = 131072;
            if (Sector.NearCount > 0) {
                short a2 = Sector.NearSector[0];
                int i = 0;
                while (i < Sector.NearCount) {
                    short j = Sector.NearSector[i];
                    while (j >= 0) {
                        a2 = j;
                        j = Globals.SectBelow[j];
                    }
                    int v7 = (Globals.SectDepth[a2] & 0xFFFF) + Engine.sector[a2].floorz;
                    int v8 = v7 - v2.z;
                    if (v8 < 0 && v8 >= -5120) {
                        v3 = v7;
                        v11 = a2;
                    }
                    ++i;
                }
            }
        }
        if (v3 >= v2.z) {
            v10 = 0;
        } else {
            v2.z = v3;
            Sector.overridesect = v11;
            v2.zvel = 0;
            Globals.bTouchFloor[0] = true;
        }
        return v10;
    }

    public static void BuildNear(int x, int y, int walldist, short sectnum) {
        Sector.NearSector[0] = sectnum;
        Sector.NearCount = 1;
        for (int j = 0; j < Sector.NearCount; ++j) {
            short nWall = Engine.sector[Sector.NearSector[j]].wallptr;
            short nWalls = Engine.sector[Sector.NearSector[j]].wallnum;
            while ((nWalls = (short)(nWalls - 1)) >= 0) {
                short v8 = Engine.wall[nWall].nextsector;
                if (v8 >= 0) {
                    int i = 0;
                    while (i < Sector.NearCount && v8 != Sector.NearSector[i]) {
                        ++i;
                    }
                    if (i >= Sector.NearCount && Main.engine.clipinsidebox(x, y, nWall, walldist) != 0) {
                        Sector.NearSector[Sector.NearCount] = Engine.wall[nWall].nextsector;
                        ++Sector.NearCount;
                    }
                }
                nWall = (short)(nWall + 1);
            }
        }
    }

    public static void InitBubbles() {
        Globals.nMachineCount = 0;
        int i = 0;
        while (i < 200) {
            Globals.nBubblesFree[i] = (byte)i;
            if (Globals.BubbleList[i] != null) {
                Globals.BubbleList[i].nSprite = (short)-1;
            }
            ++i;
        }
        Globals.nFreeCount = 200;
    }

    public static ByteBuffer saveBubbles() {
        int nBubbles = 0;
        int i = 0;
        while (i < 200) {
            if (Globals.BubbleList[i] != null && Globals.BubbleList[i].nSprite != -1) {
                ++nBubbles;
            }
            ++i;
        }
        ByteBuffer bb = ByteBuffer.allocate(204 + nBubbles * 10 + Globals.nMachineCount * 6);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)Globals.nMachineCount);
        bb.putShort((short)Globals.nFreeCount);
        int i2 = 0;
        while (i2 < 200) {
            bb.put(Globals.nBubblesFree[i2]);
            ++i2;
        }
        if (nBubbles != 0) {
            i2 = 0;
            while (i2 < 200) {
                if (Globals.BubbleList[i2] != null && Globals.BubbleList[i2].nSprite != -1) {
                    bb.putShort((short)i2);
                    Globals.BubbleList[i2].save(bb);
                }
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < Globals.nMachineCount) {
            Globals.Machine[i2].save(bb);
            ++i2;
        }
        return bb;
    }

    public static void loadBubbles(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            int i2 = 0;
            while (i2 < 200) {
                if (loader.BubbleList[i2] != null) {
                    loader.BubbleList[i2].nSprite = (short)-1;
                }
                ++i2;
            }
            loader.nMachineCount = bb.readShort().shortValue();
            loader.nFreeCount = bb.readShort().shortValue();
            bb.read(loader.nBubblesFree);
            int nBubbles = 200 - loader.nFreeCount;
            while (nBubbles > 0) {
                i = bb.readShort().shortValue();
                if (loader.BubbleList[i] == null) {
                    loader.BubbleList[i] = new BubbleStruct();
                }
                loader.BubbleList[i].load(bb);
                --nBubbles;
            }
            i = 0;
            while (i < loader.nMachineCount) {
                if (loader.Machine[i] == null) {
                    loader.Machine[i] = new BubbleMachineStruct();
                }
                loader.Machine[i].load(bb);
                ++i;
            }
        } else {
            Globals.nMachineCount = loader.nMachineCount;
            Globals.nFreeCount = loader.nFreeCount;
            System.arraycopy(loader.nBubblesFree, 0, Globals.nBubblesFree, 0, Globals.nBubblesFree.length);
            int i = 0;
            while (i < 200) {
                if (Globals.BubbleList[i] != null) {
                    Globals.BubbleList[i].nSprite = (short)-1;
                }
                if (loader.BubbleList[i] != null && loader.BubbleList[i].nSprite != -1) {
                    if (Globals.BubbleList[i] == null) {
                        Globals.BubbleList[i] = new BubbleStruct();
                    }
                    Globals.BubbleList[i].copy(loader.BubbleList[i]);
                }
                ++i;
            }
            i = 0;
            while (i < loader.nMachineCount) {
                if (Globals.Machine[i] == null) {
                    Globals.Machine[i] = new BubbleMachineStruct();
                }
                Globals.Machine[i].copy(loader.Machine[i]);
                ++i;
            }
        }
    }

    public static void DoBubbleMachines() {
        int i = 0;
        while (i < Globals.nMachineCount) {
            Globals.Machine[i].field_0 = (short)(Globals.Machine[i].field_0 - 1);
            if (Globals.Machine[i].field_0 <= 0) {
                SPRITE spr = Engine.sprite[Globals.Machine[i].field_2];
                Globals.Machine[i].field_0 = (short)(Random.RandomWord() % Globals.Machine[i].field_4 + 30);
                Sprites.BuildBubble(spr.x, spr.y, spr.z, spr.sectnum);
            }
            ++i;
        }
    }

    private static BubbleStruct BuildBubble(int x, int y, int z, int sectnum) {
        int v6 = Random.RandomSize(3);
        if (v6 > 4) {
            v6 -= 4;
        }
        if (Globals.nFreeCount > 0) {
            int nBubble = Globals.nBubblesFree[--Globals.nFreeCount] & 0xFF;
            short spr = Main.engine.insertsprite((short)sectnum, (short)402);
            if (spr < 0 || spr >= Engine.MAXSPRITES) {
                Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
                return null;
            }
            Engine.sprite[spr].x = x;
            Engine.sprite[spr].y = y;
            Engine.sprite[spr].z = z;
            Engine.sprite[spr].cstat = 0;
            Engine.sprite[spr].shade = (byte)-32;
            Engine.sprite[spr].pal = 0;
            Engine.sprite[spr].clipdist = 5;
            Engine.sprite[spr].xrepeat = (short)40;
            Engine.sprite[spr].yrepeat = (short)40;
            Engine.sprite[spr].xoffset = 0;
            Engine.sprite[spr].yoffset = 0;
            Engine.sprite[spr].picnum = 1;
            Engine.sprite[spr].ang = (short)Globals.inita;
            Engine.sprite[spr].xvel = 0;
            Engine.sprite[spr].yvel = 0;
            Engine.sprite[spr].zvel = (short)-1200;
            Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
            Engine.sprite[spr].hitag = 0;
            Engine.sprite[spr].extra = 0;
            if (Globals.BubbleList[nBubble] == null) {
                Globals.BubbleList[nBubble] = new BubbleStruct();
            }
            Globals.BubbleList[nBubble].nSprite = spr;
            Globals.BubbleList[nBubble].field_0 = 0;
            Globals.BubbleList[nBubble].nSeq = (short)(v6 + Seq.SeqOffsets[15]);
            Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x140000 | nBubble);
            Globals.BubbleList[nBubble].field_6 = (short)RunList.AddRunRec(RunList.NewRun, 0x140000 | nBubble);
            return Globals.BubbleList[nBubble];
        }
        return null;
    }

    public static void FuncBubble(int a1, int a2, int RunPtr) {
        short nBubble = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nBubble < 0 || nBubble >= 200) {
            Main.game.ThrowError("Bubble>=0 && Bubble<MAX_BUBBLES");
            return;
        }
        short nSprite = Globals.BubbleList[nBubble].nSprite;
        switch (a1 & 0x7F0000) {
            case 131072: {
                Seq.MoveSequence(nSprite, Globals.BubbleList[nBubble].nSeq, Globals.BubbleList[nBubble].field_0);
                Globals.BubbleList[nBubble].field_0 = (short)(Globals.BubbleList[nBubble].field_0 + 1);
                if (Globals.BubbleList[nBubble].field_0 >= Seq.SeqSize[Globals.BubbleList[nBubble].nSeq]) {
                    Globals.BubbleList[nBubble].field_0 = 0;
                }
                Main.game.pInt.setsprinterpolate(nSprite, Engine.sprite[nSprite]);
                Engine.sprite[nSprite].z += Engine.sprite[nSprite].zvel;
                if (Engine.sprite[nSprite].z <= Engine.sector[Engine.sprite[nSprite].sectnum].ceilingz) {
                    short v13 = Globals.SectAbove[Engine.sprite[nSprite].sectnum];
                    if (Engine.sprite[nSprite].hitag > -1 && v13 != -1) {
                        Anim.BuildAnim(-1, 70, 0, Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sector[v13].floorz, v13, 64, 0);
                    }
                    Sprites.DestroyBubble(nBubble);
                }
                return;
            }
            case 589824: {
                short nObject = (short)(a1 & 0xFFFF);
                Seq.PlotSequence(nObject, Globals.BubbleList[nBubble].nSeq, Globals.BubbleList[nBubble].field_0, 1);
                Engine.tsprite[nObject].owner = (short)-1;
                return;
            }
        }
    }

    public static void DestroyBubble(int a1) {
        short nSprite = Globals.BubbleList[a1].nSprite;
        RunList.DoSubRunRec(Engine.sprite[nSprite].lotag - 1);
        RunList.DoSubRunRec(Engine.sprite[nSprite].owner);
        RunList.SubRunRec(Globals.BubbleList[a1].field_6);
        Main.engine.mydeletesprite(nSprite);
        Globals.BubbleList[a1].nSprite = (short)-1;
        Globals.nBubblesFree[Globals.nFreeCount] = (byte)a1;
        ++Globals.nFreeCount;
    }

    public static int GetBubbleSprite(BubbleStruct pBubble) {
        return pBubble.nSprite;
    }

    public static void DoBubbles(int a1) {
        int spr;
        int[] out = Sprites.WheresMyMouth(a1);
        if (out[3] != -1 && (spr = Sprites.GetBubbleSprite(Sprites.BuildBubble(out[0], out[1], out[2], out[3]))) != -1) {
            Engine.sprite[spr].hitag = (short)a1;
        }
    }

    public static int[] WheresMyMouth(int plr) {
        short nSprite = Globals.PlayerList[plr].spriteId;
        Main.engine.clipmove(Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z - Sprites.GetSpriteHeight(nSprite) >> 1, Engine.sprite[nSprite].sectnum, Engine.sintable[Engine.sprite[nSprite].ang + 512 & 0x7FF] << 7, Engine.sintable[Engine.sprite[nSprite].ang & 0x7FF] << 7, 5120, 1280, 1280, 0x1000040);
        Sprites.wheresMyMouth[0] = Engine.clipmove_x;
        Sprites.wheresMyMouth[1] = Engine.clipmove_y;
        Sprites.wheresMyMouth[2] = Engine.clipmove_z;
        Sprites.wheresMyMouth[3] = Engine.clipmove_sectnum;
        return wheresMyMouth;
    }
}

