/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Redneck.Gamedef;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Menus.DifficultyMenu;
import ru.m210projects.Redneck.Menus.NetworkMenu;
import ru.m210projects.Redneck.Menus.NewAddonMenu;
import ru.m210projects.Redneck.Menus.RRTitle;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.GameInfo;

public class RUserContent
extends BuildMenu {
    public boolean showmain;
    private Main app;
    private MenuFileBrowser list;

    public RUserContent(final Main app) {
        this.app = app;
        RRTitle title = new RRTitle("User Content");
        int width = 240;
        this.list = new MenuFileBrowser(app, app.getFont(0), app.getFont(1), app.getFont(0), 40, 45, width, 1, 14, 2542){

            @Override
            public void init() {
                this.registerExtension("map", 0, 0);
                this.registerExtension("grp", 2, 1);
                this.registerExtension("zip", 2, 1);
                this.registerExtension("con", 2, 1);
            }

            @Override
            public void handleFile(FileEntry fil) {
                if (fil.getExtension().equals("map")) {
                    this.addFile(fil, fil.getName());
                } else if (fil.getExtension().equals("grp") || fil.getExtension().equals("zip")) {
                    RUserContent.this.buildPackage(this, fil);
                }
            }

            @Override
            public void invoke(Object obj) {
                if (obj == null) {
                    return;
                }
                if (obj instanceof FileEntry) {
                    FileEntry fil = (FileEntry)obj;
                    if (fil.getExtension().equals("map")) {
                        RUserContent.this.launchMap(fil);
                    } else if (fil.getExtension().equals("con")) {
                        RUserContent.this.launchEpisode(Globals.episodes.get(fil.getPath()));
                    } else if (fil.getExtension().equals("grp") || fil.getExtension().equals("zip")) {
                        RUserContent.this.launchEpisode(Globals.episodes.get(this.getFileName()));
                    }
                }
            }

            @Override
            public void handleDirectory(DirectoryEntry dir) {
                if (app.menu.gShowMenu) {
                    Sounds.sound(2);
                }
                RUserContent.this.buildAddons(this, dir);
            }

            @Override
            public void drawHeader(int x1, int x2, int y) {
                this.topFont.drawText(x1, y, this.dirs, -32, this.topPal, BuildFont.TextAlign.Left, 2, true);
                this.topFont.drawText(x2, y, this.ffs, -32, this.topPal, BuildFont.TextAlign.Left, 2, true);
            }

            @Override
            public void drawPath(int x, int y) {
                this.brDrawText(this.pathFont, Strhandler.toCharArray(this.path), x, y, -32, this.pathPal, 0, this.x + this.width - 4);
            }
        };
        this.list.topPal = 10;
        this.list.pathPal = 10;
        this.list.listPal = 12;
        this.list.backgroundPal = 4;
        this.addItem(title, false);
        this.addItem(this.list, true);
    }

    private void buildAddons(MenuFileBrowser blist, DirectoryEntry dir) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (FileEntry file : dir.getFiles().values()) {
            if (!file.getExtension().equals("con")) continue;
            this.InitTree(map, Gamedef.preparescript(BuildGdx.compat.getBytes(file)), file.getName());
        }
        for (FileEntry file : dir.getFiles().values()) {
            List<String> list;
            if (!file.getExtension().equals("con") || (list = map.get(file.getName())) == null) continue;
            this.handleList(map, list);
        }
        for (String con : map.keySet()) {
            if (dir == BuildGdx.compat.getDirectory(Compat.Path.Game) && con.equals("game.con")) continue;
            FileEntry fil = dir.checkFile(con);
            GameInfo addon = Globals.episodes.get(fil.getPath());
            if (addon == null) {
                addon = new GameInfo(fil, con);
                addon.init();
                if (!addon.isInited) continue;
                Console.Println("Addon found: " + addon.ConName);
                blist.addFile(fil, con);
                Globals.episodes.put(fil.getPath(), addon);
                continue;
            }
            if (!addon.isInited) continue;
            blist.addFile(fil, con);
        }
        if (this.showmain && dir == BuildGdx.compat.getDirectory(Compat.Path.Game)) {
            String entry = Globals.defGame.getFile().getPath();
            GameInfo addon = Globals.episodes.get(entry);
            if (addon == null) {
                blist.addFile(Globals.defGame.getFile(), entry);
                Globals.episodes.put(entry, Globals.defGame);
            } else {
                blist.addFile(Globals.defGame.getFile(), entry);
            }
        }
    }

    private void buildPackage(MenuFileBrowser blist, FileEntry file) {
        if (file.getParent() == BuildGdx.compat.getDirectory(Compat.Path.Game) && file.getName().equals("redneck.grp")) {
            return;
        }
        try {
            Group res = BuildGdx.cache.isGroup(file.getPath());
            if (res != null) {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                for (GroupResource files : res.getList()) {
                    if (!files.getExtension().equals("con")) continue;
                    this.InitTree(map, Gamedef.preparescript(files.getBytes()), files.getFullName());
                }
                for (GroupResource files : res.getList()) {
                    List<String> list;
                    if (!files.getExtension().equals("con") || (list = map.get(files.getFullName())) == null) continue;
                    this.handleList(map, list);
                }
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    String con = String.valueOf(res.name) + ":" + (String)it.next();
                    GameInfo addon = Globals.episodes.get(con);
                    if (addon == null) {
                        String conName = con.substring(con.indexOf(":") + 1);
                        addon = new GameInfo(res, file, conName);
                        if (addon.isInited) {
                            Console.Println("Found addon: " + con);
                            Globals.episodes.put(con, addon);
                            blist.addFile(file, con);
                            continue;
                        }
                        Console.Print(String.valueOf(con) + " found, but can't be loaded", Console.OSDTEXT_RED);
                        continue;
                    }
                    if (!addon.isInited) continue;
                    blist.addFile(file, con);
                }
                res.dispose();
                res = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void InitTree(HashMap<String, List<String>> map, byte[] buf, String parentName) {
        if (buf == null) {
            return;
        }
        ArrayList<String> list = null;
        int index = -1;
        while ((index = Strhandler.indexOf("include ", buf, index + 1)) != -1) {
            int textptr = index + 7;
            if (list == null) {
                list = new ArrayList<String>();
            }
            while (!Gamedef.isaltok(buf[textptr])) {
                if (++textptr >= buf.length || buf[textptr] == 0) break;
            }
            int i = 0;
            while (textptr + i < buf.length && Gamedef.isaltok(buf[textptr + i])) {
                ++i;
            }
            String name = new String(buf, textptr, i);
            list.add(name.toLowerCase());
        }
        if (list != null) {
            map.put(parentName, list);
        }
    }

    private void handleList(HashMap<String, List<String>> map, List<String> list) {
        block0: for (String child : list) {
            Iterator<String> con = map.keySet().iterator();
            while (con.hasNext()) {
                String name = con.next();
                if (!name.equals(child)) continue;
                List<String> other = map.get(name);
                con.remove();
                if (other == null) continue block0;
                this.handleList(map, other);
                continue block0;
            }
        }
    }

    public boolean mFromNetworkMenu() {
        return this.app.menu.getLastMenu() == this.app.menu.mMenus[11];
    }

    public void setShowMain(boolean show) {
        this.showmain = show;
        if (this.list.getDirectory() == BuildGdx.compat.getDirectory(Compat.Path.Game)) {
            this.list.refreshList();
        }
    }

    private void launchEpisode(GameInfo game) {
        if (game == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            NetworkMenu network = (NetworkMenu)this.app.menu.mMenus[11];
            network.setEpisode(game);
            this.app.menu.mMenuBack();
            return;
        }
        NewAddonMenu next = (NewAddonMenu)this.app.menu.mMenus[14];
        next.setEpisode(game);
        this.app.menu.mOpen(next, -1);
    }

    private void launchMap(FileEntry file) {
        if (file == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            NetworkMenu network = (NetworkMenu)this.app.menu.mMenus[11];
            network.setMap(file);
            this.app.menu.mMenuBack();
            return;
        }
        DifficultyMenu next = (DifficultyMenu)this.app.menu.mMenus[4];
        next.setMap(file);
        this.app.menu.mOpen(next, -1);
    }
}

