/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Types;

import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Redneck.Gamedef;
import ru.m210projects.Redneck.Types.EpisodeInfo;
import ru.m210projects.Redneck.Types.MapInfo;
import ru.m210projects.Redneck.Types.Script;

public class GameInfo {
    public DirectoryEntry resDir;
    public String Title;
    public EpisodeInfo[] episodes;
    public String[] skillnames;
    public int nEpisodes;
    public String ConName;
    private Script ConScr;
    public boolean isInited = false;
    private int nMaps;
    private FileEntry file;
    private boolean pack;
    private int textptr;
    private char[] tempbuf = new char[2048];

    public GameInfo(FileEntry file, String mainCon) {
        this.ConName = mainCon;
        this.Title = mainCon;
        this.resDir = file.getParent();
        this.file = file;
        this.skillnames = new String[5];
        this.episodes = new EpisodeInfo[3];
        this.isInited = false;
    }

    public GameInfo(Group res, FileEntry file, String mainCon) {
        this.ConName = mainCon;
        this.Title = String.valueOf(file.getName()) + ":" + mainCon;
        this.skillnames = new String[5];
        this.episodes = new EpisodeInfo[3];
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.ConName);
            int i = 0;
            while (i < list.size()) {
                this.InitTree(list, res, (String)list.get(i));
                ++i;
            }
            this.nMaps = 0;
            this.nEpisodes = 0;
            i = 0;
            while (i < list.size()) {
                GroupResource fil = res.open((String)list.get(i));
                if (fil != null) {
                    byte[] data = Gamedef.preparescript(fil.getBytes());
                    this.findSkillNames(data);
                    this.findVolumes(data);
                    this.findMaps(data, res);
                    fil.close();
                }
                ++i;
            }
            if (this.nEpisodes != 0 && this.nMaps != 0) {
                this.isInited = true;
            }
            this.checkEpisodes();
            this.pack = true;
            this.file = file;
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.Println("Build addon: " + this.Title + " failed!", Console.OSDTEXT_RED);
            this.isInited = false;
        }
    }

    public FileEntry getFile() {
        return this.file;
    }

    public boolean isPackage() {
        return this.pack;
    }

    public void setPackage(boolean pack) {
        this.pack = pack;
    }

    public void setDirectory(DirectoryEntry resDir) {
        this.resDir = resDir;
    }

    public DirectoryEntry getDirectory() {
        return this.resDir;
    }

    public Script getCON() {
        return this.ConScr;
    }

    public void setCON(Script con) {
        this.ConScr = con;
    }

    public void init() {
        try {
            ArrayList<FileEntry> list = new ArrayList<FileEntry>();
            list.add(this.resDir.checkFile(this.ConName));
            int i = 0;
            while (i < list.size()) {
                this.InitTree(list, (FileEntry)list.get(i));
                ++i;
            }
            this.nMaps = 0;
            this.nEpisodes = 0;
            i = 0;
            while (i < list.size()) {
                FileEntry scriptfile = (FileEntry)list.get(i);
                if (scriptfile != null) {
                    byte[] data = Gamedef.preparescript(BuildGdx.compat.getBytes(scriptfile));
                    this.findSkillNames(data);
                    this.findVolumes(data);
                    this.findMaps(data, null);
                }
                ++i;
            }
            if (this.nEpisodes != 0 && this.nMaps != 0) {
                this.isInited = true;
            }
            this.checkEpisodes();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isInited = false;
        }
    }

    private void checkEpisodes() {
        int sum = 0;
        int e = 0;
        while (e < this.nEpisodes) {
            if (this.episodes[e] != null) {
                if (this.episodes[e].gMapInfo[0] == null) {
                    this.episodes[e].nMaps = 0;
                }
                sum += this.episodes[e].nMaps;
            }
            ++e;
        }
        if (sum == 0) {
            this.isInited = false;
        }
    }

    private void InitTree(List<FileEntry> list, FileEntry confile) {
        if (confile == null) {
            return;
        }
        byte[] buf = Gamedef.preparescript(BuildGdx.compat.getBytes(confile));
        int index = -1;
        while ((index = Strhandler.indexOf("include ", buf, index + 1)) != -1) {
            int textptr = index + 7;
            while (!Gamedef.isaltok(buf[textptr])) {
                if (buf[++textptr] == 0) break;
            }
            int i = 0;
            while (textptr + i < buf.length && Gamedef.isaltok(buf[textptr + i])) {
                ++i;
            }
            String name = new String(buf, textptr, i);
            list.add(this.resDir.checkFile(name));
        }
    }

    private void InitTree(List<String> list, Group res, String filename) {
        GroupResource fil = res.open(filename);
        if (fil != null) {
            byte[] buf = Gamedef.preparescript(fil.getBytes());
            int index = -1;
            while ((index = Strhandler.indexOf("include ", buf, index + 1)) != -1) {
                int textptr = index + 7;
                while (!Gamedef.isaltok(buf[textptr])) {
                    if (buf[++textptr] == 0) break;
                }
                int i = 0;
                while (textptr + i < buf.length && Gamedef.isaltok(buf[textptr + i])) {
                    ++i;
                }
                String name = new String(buf, textptr, i);
                list.add(name);
            }
            fil.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean findVolumes(byte[] buf) {
        index = -1;
        while ((index = Strhandler.indexOf("definevolumename ", buf, index + 1)) != -1) {
            this.textptr = index + 16;
            j = this.transnum(buf);
            if (j != null) ** GOTO lbl8
            continue;
lbl-1000:
            // 1 sources

            {
                ++this.textptr;
lbl8:
                // 2 sources

                ** while (buf[this.textptr] == 32)
            }
lbl9:
            // 1 sources

            i = 0;
            startptr = this.textptr;
            while (buf[this.textptr + i] != 10) {
                ++i;
            }
            this.episodes[j.intValue()] = new EpisodeInfo(new String(buf, startptr, i - 1).toUpperCase());
            this.nEpisodes = Math.max(this.nEpisodes, j + 1);
        }
        return this.nEpisodes != 0;
    }

    /*
     * Unable to fully structure code
     */
    private void findMaps(byte[] buf, Group res) {
        index = -1;
        while ((index = Strhandler.indexOf("definelevelname ", buf, index + 1)) != -1) {
            this.textptr = index + 15;
            epnum = this.transnum(buf);
            if (epnum != null && (mapnum = this.transnum(buf)) != null) ** GOTO lbl8
            continue;
lbl-1000:
            // 1 sources

            {
                ++this.textptr;
lbl8:
                // 2 sources

                ** while (buf[this.textptr] == 32)
            }
lbl9:
            // 1 sources

            i = 0;
            ptr = this.textptr;
            while (buf[this.textptr] != 32 && buf[this.textptr] != 10) {
                ++this.textptr;
                ++i;
            }
            path = FileUtils.getCorrectPath(Strhandler.toLowerCase(new String(buf, ptr, i)));
            mapFound = false;
            mapPath = path;
            if (res == null) {
                mapFile = this.resDir.checkFile(path);
                v0 = mapFound = mapFile != null;
                if (mapFound) {
                    mapPath = mapFile.getPath();
                }
            } else {
                mapFound = res.contains(path);
                mapPath = path;
            }
            if (!mapFound || this.episodes[epnum] == null) continue;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            partime = ((buf[this.textptr + 0] - 48) * 10 + (buf[this.textptr + 1] - 48)) * 26 * 60 + ((buf[this.textptr + 3] - 48) * 10 + (buf[this.textptr + 4] - 48)) * 26;
            this.textptr += 5;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            designertime = ((buf[this.textptr + 0] - 48) * 10 + (buf[this.textptr + 1] - 48)) * 26 * 60 + ((buf[this.textptr + 3] - 48) * 10 + (buf[this.textptr + 4] - 48)) * 26;
            this.textptr += 5;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            i = 0;
            while (buf[this.textptr + i] != 10) {
                ++i;
            }
            title = new String(buf, this.textptr, i - 1);
            this.episodes[epnum.intValue()].gMapInfo[mapnum.intValue()] = new MapInfo(mapPath, title, partime, designertime);
            this.episodes[epnum.intValue()].nMaps = Math.max(this.episodes[epnum.intValue()].nMaps, mapnum + 1);
            ++this.nMaps;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean findSkillNames(byte[] buf) {
        index = -1;
        size = 0;
        while ((index = Strhandler.indexOf("defineskillname ", buf, index + 1)) != -1) {
            this.textptr = index + 15;
            j = this.transnum(buf);
            if (j != null) ** GOTO lbl9
            continue;
lbl-1000:
            // 1 sources

            {
                ++this.textptr;
lbl9:
                // 2 sources

                ** while (buf[this.textptr] == 32)
            }
lbl10:
            // 1 sources

            i = 0;
            while (buf[this.textptr + i] != 10) {
                ++i;
            }
            this.skillnames[j.intValue()] = new String(buf, this.textptr, i - 1).toUpperCase();
            size = Math.max(size, j + 1);
        }
        return size != 0;
    }

    private Integer transnum(byte[] text) {
        while (!Gamedef.isaltok(text[this.textptr])) {
            ++this.textptr;
            if (text[this.textptr] != 0) continue;
            return null;
        }
        int l = 0;
        while (Gamedef.isaltok(text[this.textptr + l])) {
            this.tempbuf[l] = (char)text[this.textptr + l];
            ++l;
        }
        this.tempbuf[l] = '\u0000';
        int i = 0;
        while (i < 147) {
            if (Strhandler.Bstrcmp(Gamedef.label, Gamedef.labelcnt << 6, Gamedef.keyw[i], 0) == 0) {
                ++Gamedef.error;
                Console.Println("  * ERROR! Symbol '" + Gamedef.label[Gamedef.labelcnt << 6] + "' is a key word.");
                this.textptr += l;
            }
            ++i;
        }
        i = 0;
        while (i < Gamedef.labelcnt) {
            if (Strhandler.Bstrcmp(this.tempbuf, 0, Gamedef.label, i << 6) == 0) {
                this.textptr += l;
                return Gamedef.labelcode.get(i);
            }
            ++i;
        }
        if (!Character.isDigit(text[this.textptr]) && text[this.textptr] != 45) {
            Console.Println("  * ERROR! Parameter '" + new String(this.tempbuf, 0, l) + "' is undefined.");
            ++Gamedef.error;
            this.textptr += l;
            return null;
        }
        String number = new String(text, this.textptr, l);
        this.textptr += l;
        return Integer.parseInt(number);
    }
}

