/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Weapon;

public class Hornet {
    private static final Animator InitHornetSting = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.InitHornetSting(SpriteNum) != 0;
        }
    };
    private static final Animator InitHornetCircle = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Hornet.InitHornetCircle(SpriteNum) != 0;
        }
    };
    private static final Decision[] HornetBattle = new Decision[]{new Decision(50, InitHornetCircle), new Decision(798, Ai.InitActorMoveCloser), new Decision(800, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorRunAway)};
    private static final Decision[] HornetOffense = new Decision[]{new Decision(1022, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAlertNoise)};
    private static final Decision[] HornetBroadcast = new Decision[]{new Decision(3, Ai.InitActorAlertNoise), new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] HornetSurprised = new Decision[]{new Decision(100, InitHornetCircle), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] HornetEvasive = new Decision[]{new Decision(20, InitHornetCircle), new Decision(1024, null)};
    private static final Decision[] HornetLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] HornetCloseRange = new Decision[]{new Decision(900, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorReposition)};
    private static final Decision[] HornetTouchTarget = new Decision[]{new Decision(500, InitHornetCircle), new Decision(1024, InitHornetSting)};
    private static final Personality HornetPersonality = new Personality(HornetBattle, HornetOffense, HornetBroadcast, HornetSurprised, HornetEvasive, HornetLostTarget, HornetCloseRange, HornetTouchTarget);
    private static final ATTRIBUTE HornetAttrib;
    public static final int HORNET_RUN_RATE = 7;
    private static final Animator DoHornetMove;
    private static final State[][] s_HornetRun;
    public static final int HORNET_STAND_RATE = 12;
    private static final State[][] s_HornetStand;
    public static final int HORNET_DIE_RATE = 20;
    private static final Animator DoHornetDeath;
    private static final State[] s_HornetDie;
    private static final State[] s_HornetDead;
    private static final Actor_Action_Set HornetActionSet;
    public static final int HORNET_BOB_AMT;
    private static final Animator DoHornetCircle;

    static {
        int[] nArray = new int[10];
        nArray[2] = 120;
        nArray[3] = 120;
        nArray[4] = 122;
        HornetAttrib = new ATTRIBUTE(new short[]{300, 350, 375, 400}, new short[4], 0, nArray);
        DoHornetMove = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Hornet.DoHornetMove(SpriteNum) != 0;
            }
        };
        s_HornetRun = new State[][]{{new State(800, 7, DoHornetMove), new State(801, 7, DoHornetMove)}, {new State(802, 7, DoHornetMove), new State(803, 7, DoHornetMove)}, {new State(804, 7, DoHornetMove), new State(805, 7, DoHornetMove)}, {new State(806, 7, DoHornetMove), new State(807, 7, DoHornetMove)}, {new State(808, 7, DoHornetMove), new State(809, 7, DoHornetMove)}};
        s_HornetStand = new State[][]{{new State(800, 12, DoHornetMove), new State(801, 12, DoHornetMove)}, {new State(802, 12, DoHornetMove), new State(803, 12, DoHornetMove)}, {new State(804, 12, DoHornetMove), new State(805, 12, DoHornetMove)}, {new State(806, 12, DoHornetMove), new State(807, 12, DoHornetMove)}, {new State(808, 12, DoHornetMove), new State(809, 12, DoHornetMove)}};
        DoHornetDeath = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Hornet.DoHornetDeath(SpriteNum) != 0;
            }
        };
        s_HornetDie = new State[]{new State(810, 20, DoHornetDeath).setNext()};
        s_HornetDead = new State[]{new State(811, 20, Actor.DoActorDebris).setNext()};
        HornetActionSet = new Actor_Action_Set(HornetStateGroup.sg_HornetStand, HornetStateGroup.sg_HornetRun, null, null, null, null, null, null, null, null, null, null, HornetStateGroup.sg_HornetDie, null, HornetStateGroup.sg_HornetDead, null, null, null, new short[1], null, new short[1], null, null, null);
        HORNET_BOB_AMT = Gameutils.Z(16);
        DoHornetCircle = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Hornet.DoHornetCircle(SpriteNum) != 0;
            }
        };
    }

    public static void InitHornetStates() {
        HornetStateGroup[] hornetStateGroupArray = HornetStateGroup.values();
        int n = hornetStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            HornetStateGroup sg = hornetStateGroupArray[n2];
            int rot = 0;
            while (rot < sg.group.length) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
    }

    public static int SetupHornet(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 800, s_HornetRun[0][0]);
            u.Health = (short)4;
        }
        Sprites.ChangeState(SpriteNum, s_HornetRun[0][0]);
        u.Attrib = HornetAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_HornetDie[0];
        u.Rot = HornetStateGroup.sg_HornetRun;
        Coolie.EnemyDefaults(SpriteNum, HornetActionSet, HornetPersonality);
        u.Flags |= Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_XFLIP_TOGGLE;
        sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        sp.clipdist = 25;
        u.floor_dist = (short)Gameutils.Z(16);
        u.ceiling_dist = (short)Gameutils.Z(16);
        u.sz = sp.z;
        sp.xrepeat = (short)37;
        sp.yrepeat = (short)32;
        VOC3D voc = Sound.PlaySound(119, sp, 65);
        Sound.Set3DSoundOwner(SpriteNum, voc);
        return 0;
    }

    private static int DoHornetMatchPlayerZ(int SpriteNum) {
        int bound;
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE tsp = Engine.sprite[Gameutils.pUser[SpriteNum].tgt_sp];
        int zdiff = Gameutils.SPRITEp_MID(tsp) - u.sz;
        int zdist = Gameutils.Z(20 + Gameutils.RANDOM_RANGE(200));
        if (Pragmas.klabs(zdiff) > zdist) {
            u.sz = zdiff > 0 ? (u.sz += 6144) : (u.sz -= 1536);
        }
        int loz = u.loz;
        int hiz = u.hiz;
        if (u.lo_sectp != -1 && Sector.SectUser[u.lo_sectp] != null && Sector.SectUser[u.lo_sectp].depth != 0) {
            loz -= Gameutils.Z(Sector.SectUser[u.lo_sectp].depth) - Gameutils.Z(8);
        }
        if (u.sz > (bound = u.lo_sp != -1 ? loz - u.floor_dist : loz - u.floor_dist - HORNET_BOB_AMT)) {
            u.sz = bound;
        }
        if (u.sz < (bound = u.hi_sp != -1 ? hiz + u.ceiling_dist : hiz + u.ceiling_dist + HORNET_BOB_AMT)) {
            u.sz = bound;
        }
        u.sz = Math.min(u.sz, loz - u.floor_dist);
        u.sz = Math.max(u.sz, hiz + u.ceiling_dist);
        u.Counter = (short)(u.Counter + 48 + 12 & 0x7FF);
        sp.z = u.sz + (HORNET_BOB_AMT * Engine.sintable[u.Counter] >> 14);
        bound = u.hiz + u.ceiling_dist + HORNET_BOB_AMT;
        if (sp.z < bound) {
            sp.z = u.sz = bound + HORNET_BOB_AMT;
        }
        return 0;
    }

    private static int InitHornetCircle(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        u.ActorActionFunc = DoHornetCircle;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        Ai.DoActorSetSpeed(SpriteNum, 3);
        sp.xvel = (short)400;
        u.Counter2 = (short)(sp.xvel / 3);
        if (Gameutils.RANDOM_P2(1024) < 512) {
            u.Counter2 = -u.Counter2;
        }
        u.jump_speed = (short)(200 + Gameutils.RANDOM_P2(128));
        if (Pragmas.klabs(u.sz - u.hiz) < Pragmas.klabs(u.sz - u.loz)) {
            u.jump_speed = -u.jump_speed;
        }
        u.WaitTics = (short)((Gameutils.RANDOM_RANGE(3) + 1) * 60);
        u.ActorActionFunc.invoke(SpriteNum);
        return 0;
    }

    private static int DoHornetCircle(int SpriteNum) {
        int ny;
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        sp.ang = Gameutils.NORM_ANGLE(sp.ang + u.Counter2);
        int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = sp.xvel * Engine.sintable[sp.ang] >> 14, 0)) {
            u.Counter2 = -u.Counter2;
            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024);
            nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
            if (!Sprites.move_actor(SpriteNum, nx, ny = sp.xvel * Engine.sintable[sp.ang] >> 14, 0)) {
                Ai.InitActorReposition.invoke(SpriteNum);
                return 0;
            }
        }
        u.sz -= u.jump_speed * 6;
        int bound = u.hiz + u.ceiling_dist + HORNET_BOB_AMT;
        if (u.sz < bound) {
            u.sz = bound;
            Ai.InitActorReposition.invoke(SpriteNum);
            return 0;
        }
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics < 0) {
            Ai.InitActorReposition.invoke(SpriteNum);
            u.WaitTics = 0;
            return 0;
        }
        return 0;
    }

    private static int DoHornetDeath(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            u.loz = u.zclip;
            Actor.DoFall(SpriteNum);
        } else {
            sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
            u.jump_speed = 0;
            u.floor_dist = 0;
            Actor.DoBeginFall(SpriteNum);
            Weapon.DoFindGroundPoint(SpriteNum);
            u.zclip = u.loz;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        int ny = sp.xvel * Engine.sintable[sp.ang] >> 14;
        u.ret = Sprites.move_sprite(SpriteNum, nx, ny, 0, u.ceiling_dist, u.floor_dist, 1, 6);
        if (sp.z >= u.loz) {
            u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_SLIDING);
            sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YFLIP);
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Dead);
            Sound.DeleteNoSoundOwner(SpriteNum);
            return 0;
        }
        return 0;
    }

    public static int DoCheckSwarm(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (Sprites.MoveSkip8 == 0) {
            return 0;
        }
        if (u.tgt_sp == -1) {
            return 0;
        }
        Ai.DoActorPickClosePlayer(SpriteNum);
        if (Gameutils.pUser[u.tgt_sp] == null || Gameutils.pUser[u.tgt_sp].PlayerP == -1) {
            return 0;
        }
        PlayerStr pp = Game.Player[Gameutils.pUser[u.tgt_sp].PlayerP];
        int pdist = Gameutils.DISTANCE(sp.x, sp.y, pp.posx, pp.posy);
        int i = Engine.headspritestat[2];
        while (i != -1) {
            int dist;
            int nexti = Engine.nextspritestat[i];
            SPRITE tsp = Engine.sprite[i];
            USER tu = Gameutils.pUser[i];
            if (tu != null && tsp.hitag == 1008 && tsp.lotag == 2 && (dist = Gameutils.DISTANCE(sp.x, sp.y, tsp.x, tsp.y)) < pdist && u.ID == tu.ID) {
                u.tgt_sp = i;
            }
            i = nexti;
        }
        return 1;
    }

    private static int DoHornetMove(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (sp.hitag == 1008 && sp.lotag == 1) {
            Hornet.DoCheckSwarm(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Hornet.DoHornetMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    public static void HornetSaveable() {
        Saveable.SaveData(InitHornetSting);
        Saveable.SaveData(InitHornetCircle);
        Saveable.SaveData(DoHornetCircle);
        Saveable.SaveData(DoHornetDeath);
        Saveable.SaveData(DoHornetMove);
        Saveable.SaveData(HornetPersonality);
        Saveable.SaveData(HornetAttrib);
        Saveable.SaveData(s_HornetRun);
        Saveable.SaveGroup(HornetStateGroup.sg_HornetRun);
        Saveable.SaveData(s_HornetStand);
        Saveable.SaveGroup(HornetStateGroup.sg_HornetStand);
        Saveable.SaveData(s_HornetDie);
        Saveable.SaveGroup(HornetStateGroup.sg_HornetDie);
        Saveable.SaveData(s_HornetDead);
        Saveable.SaveGroup(HornetStateGroup.sg_HornetDead);
        Saveable.SaveData(HornetActionSet);
    }

    static /* synthetic */ State[][] access$4() {
        return s_HornetStand;
    }

    static /* synthetic */ State[][] access$5() {
        return s_HornetRun;
    }

    static /* synthetic */ State[] access$6() {
        return s_HornetDie;
    }

    static /* synthetic */ State[] access$7() {
        return s_HornetDead;
    }

    public static enum HornetStateGroup implements Sprites.StateGroup
    {
        sg_HornetStand(Hornet.access$4()[0], Hornet.access$4()[1], Hornet.access$4()[2], Hornet.access$4()[3], Hornet.access$4()[4]),
        sg_HornetRun(Hornet.access$5()[0], Hornet.access$5()[1], Hornet.access$5()[2], Hornet.access$5()[3], Hornet.access$5()[4]),
        sg_HornetDie(new State[][]{Hornet.access$6()}),
        sg_HornetDead(new State[][]{Hornet.access$7()});

        private final State[][] group;
        private int index = -1;

        private HornetStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

