/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuJoyList;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuResolutionList;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlotList;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuCorruptGame;
import ru.m210projects.Wang.Menus.MenuDifficulty;
import ru.m210projects.Wang.Menus.MenuGame;
import ru.m210projects.Wang.Menus.MenuInterface;
import ru.m210projects.Wang.Menus.MenuLastLoad;
import ru.m210projects.Wang.Menus.MenuLoad;
import ru.m210projects.Wang.Menus.MenuMain;
import ru.m210projects.Wang.Menus.MenuNewAddon;
import ru.m210projects.Wang.Menus.MenuNewGame;
import ru.m210projects.Wang.Menus.MenuOptions;
import ru.m210projects.Wang.Menus.MenuQuit;
import ru.m210projects.Wang.Menus.MenuSave;
import ru.m210projects.Wang.Menus.MenuSound;
import ru.m210projects.Wang.Menus.Network.MenuMultiplayer;
import ru.m210projects.Wang.Menus.Network.MenuNetwork;
import ru.m210projects.Wang.Sound;

public class WangMenuHandler
extends MenuHandler {
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int NEWGAME = 2;
    public static final int SOUNDSET = 3;
    public static final int DIFFICULTY = 4;
    public static final int OPTIONS = 5;
    public static final int HELP = 6;
    public static final int LOADGAME = 7;
    public static final int SAVEGAME = 8;
    public static final int QUIT = 9;
    public static final int QUITTITLE = 10;
    public static final int NETWORKGAME = 11;
    public static final int MULTIPLAYER = 12;
    public static final int COLORCORR = 13;
    public static final int NEWADDON = 14;
    public static final int USERCONTENT = 15;
    public static final int LASTSAVE = 16;
    public static final int CORRUPTLOAD = 17;
    public static final int pic_yinyang = 2870;
    public BuildMenu[] mMenus;
    private Engine engine;
    private BuildGame app;

    public WangMenuHandler(Main app) {
        app.menu = this;
        this.mMenus = new BuildMenu[19];
        this.engine = app.pEngine;
        this.app = app;
        this.mMenus[4] = new MenuDifficulty(app);
        this.mMenus[2] = new MenuNewGame(app);
        this.mMenus[7] = new MenuLoad(app);
        this.mMenus[8] = new MenuSave(app);
        this.mMenus[9] = new MenuQuit(app, false);
        this.mMenus[10] = new MenuQuit(app, true);
        this.mMenus[3] = new MenuSound(app);
        this.mMenus[5] = new MenuOptions(app);
        this.mMenus[14] = new MenuNewAddon(app);
        this.mMenus[11] = new MenuNetwork(app);
        this.mMenus[12] = new MenuMultiplayer(app);
        this.mMenus[16] = new MenuLastLoad(app);
        this.mMenus[17] = new MenuCorruptGame(app);
        this.mMenus[0] = new MenuMain(app);
        this.mMenus[1] = new MenuGame(app);
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.pMenu.getCurrentMenu() instanceof MenuRendererSettings) && !(this.app.pMenu.getCurrentMenu() instanceof MenuInterface)) {
            int tile = 2324;
            Tile pic = this.engine.getTile(tile);
            float kt = (float)Engine.xdim / (float)Engine.ydim;
            float kv = (float)pic.getWidth() / (float)pic.getHeight();
            float scale = kv >= kt ? (float)(Engine.ydim + 1) / (float)pic.getHeight() : (float)(Engine.xdim + 1) / (float)pic.getWidth();
            this.engine.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 4, 25, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        super.mDrawMenu();
    }

    @Override
    public int getShade(MenuItem item) {
        if (item != null) {
            if (!item.isEnabled()) {
                return 16;
            }
            if (item.font.equals(this.app.getFont(0))) {
                int shade = 8;
                if (item != null && item.isFocused()) {
                    shade = 8 + Pragmas.mulscale(16L, Engine.sintable[32 * Engine.totalclock & 0x7FF], 16);
                }
                return shade;
            }
        }
        return 0;
    }

    @Override
    public int getPal(BuildFont font, MenuItem item) {
        if (item != null && item.font.equals(this.app.getFont(0)) && item.isFocused()) {
            return 24;
        }
        return 16;
    }

    @Override
    public void mPostDraw(MenuItem item) {
        if (item.isFocused()) {
            if (item instanceof MenuSlotList) {
                MenuSlotList list = (MenuSlotList)item;
                if (list.owncursor && list.typing) {
                    int px = list.x + list.width / 2 + list.nListOffset + item.font.getWidth(list.typingBuf);
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    this.engine.rotatesprite(px + 4 << 16, py + 2 << 16, 20000, 0, 2440 + (Engine.totalclock >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
            } else if (item instanceof MenuList) {
                if (item instanceof MenuJoyList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (list.l_nMin < this.app.pCfg.joymap.length && focus >= this.app.pCfg.joymap.length) {
                        ++focus;
                    }
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    this.engine.rotatesprite(px - 6 << 16, py + 3 << 16, 20000, 0, 2440 + (Engine.totalclock >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else if (item instanceof MenuKeyboardList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    this.engine.rotatesprite(px - 6 << 16, py + 3 << 16, 20000, 0, 2440 + (Engine.totalclock >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else if (item instanceof MenuResolutionList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    this.engine.rotatesprite(px + 26 << 16, py + 3 << 16, 20000, 0, 2440 + (Engine.totalclock >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else {
                    MenuList list = (MenuList)item;
                    Tile pic = this.engine.getTile(2870);
                    int scale = 32768;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    int xoff = 0;
                    int yoff = 0;
                    if (item.font.equals(this.app.getFont(1))) {
                        xoff = -(pic.getWidth() / 2) + 10;
                        yoff = 3;
                    }
                    if (item.font.equals(this.app.getFont(2))) {
                        xoff = -(pic.getWidth() / 2) + 10;
                        yoff = 8;
                    }
                    this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, 2870, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
            } else if (!(item instanceof MenuVariants)) {
                int scale = 32768;
                int px = item.x;
                int py = item.y;
                int xoff = 0;
                int yoff = 0;
                Tile pic = this.engine.getTile(2870);
                if (item.font.equals(this.app.getFont(1))) {
                    xoff = -(pic.getWidth() / 2) + 10;
                    yoff = 3;
                }
                if (item.font.equals(this.app.getFont(2))) {
                    xoff = -(pic.getWidth() / 2) + 10;
                    yoff = 8;
                }
                this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, 2870, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
        }
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(65536L, Engine.ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.gMouseCursorSize, 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        this.engine.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        Tile pic = this.engine.getTile(9216);
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        if (this.mCount > 1) {
            int shade = 4 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
            this.engine.rotatesprite(0, Engine.ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, pic.getWidth() - 1, 16), Engine.ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        Tile pic = this.engine.getTile(9216);
        int size = Pragmas.mulscale(pic.getWidth(), zoom, 16);
        int bx = 0;
        int by = Engine.ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16);
        return mx >= bx && mx < bx + size && my >= by && my < by + size;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case Open: {
                if (this.mCount <= 1) break;
                Sound.PlaySound(1, null, 8);
                break;
            }
            case ENTER: {
                Sound.PlaySound(1, null, 8);
                break;
            }
            case UP: 
            case DW: 
            case LEFT: 
            case RIGHT: 
            case PGUP: 
            case PGDW: 
            case HOME: 
            case END: 
            case MCHANGE: {
                Sound.PlaySound(2, null, 8);
                break;
            }
            case Close: {
                if (this.mCount == 1) {
                    Sound.PlaySound(3, null, 8);
                    break;
                }
                Sound.PlaySound(1, null, 8);
                break;
            }
        }
    }
}

