/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.utils.ByteArray;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildMessage;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Wang.Config;
import ru.m210projects.Wang.Enemies.Bunny;
import ru.m210projects.Wang.Enemies.Coolg;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Eel;
import ru.m210projects.Wang.Enemies.GirlNinj;
import ru.m210projects.Wang.Enemies.Goro;
import ru.m210projects.Wang.Enemies.Hornet;
import ru.m210projects.Wang.Enemies.Lava;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Enemies.Ripper2;
import ru.m210projects.Wang.Enemies.Serp;
import ru.m210projects.Wang.Enemies.Skel;
import ru.m210projects.Wang.Enemies.Skull;
import ru.m210projects.Wang.Enemies.Sumo;
import ru.m210projects.Wang.Enemies.Zilla;
import ru.m210projects.Wang.Enemies.Zombie;
import ru.m210projects.Wang.Factory.WangEngine;
import ru.m210projects.Wang.Factory.WangFactory;
import ru.m210projects.Wang.Factory.WangInterpolation;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.LoadSave;
import ru.m210projects.Wang.MiscActr;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Screens.AnmScreen;
import ru.m210projects.Wang.Screens.CreditsScreen;
import ru.m210projects.Wang.Screens.DemoScreen;
import ru.m210projects.Wang.Screens.DisconnectScreen;
import ru.m210projects.Wang.Screens.GameScreen;
import ru.m210projects.Wang.Screens.LoadingScreen;
import ru.m210projects.Wang.Screens.LogoAScreen;
import ru.m210projects.Wang.Screens.MenuScreen;
import ru.m210projects.Wang.Screens.NetScreen;
import ru.m210projects.Wang.Screens.PrecacheScreen;
import ru.m210projects.Wang.Screens.StatisticScreen;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.VoxelScript;
import ru.m210projects.Wang.Weapon;

public class Main
extends BuildGame {
    public static boolean NETTEST = false;
    public static boolean AUTOCOMPARE = false;
    public static final String appdef = "swgdx.def";
    public static Main game;
    public static WangEngine engine;
    public static Config gs;
    public static WangNetwork gNet;
    public WangMenuHandler menu;
    public WangNetwork net;
    public String mainGrp = "sw.grp";
    public WangInterpolation pIntSkip2;
    public WangInterpolation pIntSkip4;
    public static LoadingScreen gLoadingScreen;
    public static GameScreen gGameScreen;
    public static DemoScreen gDemoScreen;
    public static LogoAScreen gLogoScreen;
    public static AnmScreen gAnmScreen;
    public static MenuScreen gMenuScreen;
    public static StatisticScreen gStatisticScreen;
    public static PrecacheScreen gPrecacheScreen;
    public static NetScreen gNetScreen;
    public static DisconnectScreen gDisconnectScreen;
    public static CreditsScreen gCreditsScreen;
    public static boolean kGameCrash;
    public static UserFlag mUserFlag;
    public Runnable rMenu = new Runnable(){

        @Override
        public void run() {
            if (game.getScreen() != gAnmScreen || gAnmScreen.getAnim() != 0) {
                Sound.StopFX();
            }
            Sound.CDAudio_Play(2, true);
            Game.Level = 0;
            Main.this.nNetMode = BuildGame.NetMode.Single;
            WangNetwork.CommPlayers = 1;
            Main.gNet.MultiGameType = WangNetwork.MultiGameTypes.MULTI_GAME_NONE;
            Main.gNet.FakeMultiplayer = false;
            if (!Main.this.menu.gShowMenu) {
                Main.this.menu.mOpen(Main.this.menu.mMenus[0], -1);
            }
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.size() == 0 || Main.gs.gDemoSeq == 0 || !gDemoScreen.showDemo()) {
                Main.this.changeScreen(gMenuScreen);
            }
        }
    };

    static {
        mUserFlag = UserFlag.None;
    }

    public Main(BuildConfig bcfg, String appname, String sversion, boolean isRelease) {
        super(bcfg, appname, sversion, isRelease);
        game = this;
        gs = (Config)bcfg;
        this.pIntSkip2 = new WangInterpolation(){

            @Override
            public int getSkipValue() {
                return Sprites.MoveSkip2 ? 1 : 0;
            }

            @Override
            public int getSkipMax() {
                return 2;
            }
        };
        this.pIntSkip4 = new WangInterpolation(){

            @Override
            public int getSkipValue() {
                return Sprites.MoveSkip4;
            }

            @Override
            public int getSkipMax() {
                return 4;
            }
        };
    }

    public Main(BuildConfig bcfg, String appname, String sversion) {
        this(bcfg, appname, sversion, true);
    }

    @Override
    public BuildFactory getFactory() {
        return new WangFactory(this);
    }

    @Override
    public boolean init() throws Exception {
        Resource kvxres;
        FileEntry filgdx;
        Game.InitGame();
        Player.InitPlayerStates();
        Weapon.InitWeaponStates();
        JWeapon.InitJWeaponStates();
        Sprites.InitSprStates();
        Ninja.InitNinjaStates();
        Zombie.InitZombieStates();
        Ripper2.InitRipper2States();
        Bunny.InitBunnyStates();
        Goro.InitGoroStates();
        Ripper.InitRipperStates();
        MiscActr.InitMiscStates();
        Serp.InitSerpStates();
        Sumo.InitSumoStates();
        Zilla.InitZillaStates();
        GirlNinj.InitGNinjaStates();
        Coolg.InitCoolgStates();
        Coolie.InitCoolieStates();
        Skull.InitSkullStates();
        Skel.InitSkelStates();
        Lava.InitLavaStates();
        Eel.InitEelStates();
        Hornet.InitHornetStates();
        JSector.InitJSectorStructs();
        Sector.InitSectorStructs();
        Saveable.InitSaveable();
        Console.Println("Initializing def-scripts...");
        Gameutils.loadGdxDef(this.baseDef, appdef, "swgdx.dat");
        if (Main.gs.autoloadFolder) {
            Console.Println("Initializing autoload folder");
            DirectoryEntry autoload = BuildGdx.compat.checkDirectory("autoload");
            if (autoload != null) {
                for (FileEntry file : autoload.getFiles().values()) {
                    if (file.getExtension().equals("zip")) {
                        GroupResource def;
                        Group group = BuildGdx.cache.add(file.getPath());
                        if (group == null || (def = group.open(appdef)) == null) continue;
                        this.baseDef.loadScript(file.getName(), def.getBytes());
                        def.close();
                        continue;
                    }
                    if (!file.getExtension().equals("def")) continue;
                    this.baseDef.loadScript(file);
                }
            }
        }
        if ((filgdx = BuildGdx.compat.checkFile(appdef)) != null) {
            this.baseDef.loadScript(filgdx);
        }
        if ((kvxres = BuildGdx.cache.open("swvoxfil.txt", 0)) != null) {
            VoxelScript vox = new VoxelScript(kvxres);
            vox.apply(this.baseDef);
            kvxres.close();
        }
        this.setDefs(this.baseDef);
        LoadSave.FindSaves();
        Sound.InitCDtracks();
        Main.game.pNet.ResetTimers();
        gLoadingScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gLogoScreen = new LogoAScreen(this, 5.0f);
        gAnmScreen = new AnmScreen(this);
        gMenuScreen = new MenuScreen(this);
        gStatisticScreen = new StatisticScreen(this);
        gPrecacheScreen = new PrecacheScreen(this);
        gNetScreen = new NetScreen(this);
        gDisconnectScreen = new DisconnectScreen(this);
        gCreditsScreen = new CreditsScreen(this);
        return true;
    }

    public void MainMenu() {
        this.rMenu.run();
    }

    @Override
    public void show() {
        if (Game.rec != null) {
            Game.rec.close();
        }
        kGameCrash = false;
        if (ResourceHandler.usecustomarts) {
            ResourceHandler.resetEpisodeResources(true);
        }
        this.changeScreen(gLogoScreen.setCallback(new Runnable(){

            @Override
            public void run() {
                if (gAnmScreen.init(0)) {
                    Main.this.changeScreen(gAnmScreen.setCallback(Main.this.rMenu).escSkipping(false));
                } else {
                    Main.this.MainMenu();
                }
            }
        }));
    }

    public void Disconnect() {
        if (Game.rec != null) {
            Game.rec.close();
        }
        this.changeScreen(gDisconnectScreen);
    }

    @Override
    public void dispose() {
        if (Game.rec != null) {
            Game.rec.close();
        }
        super.dispose();
    }

    public void GameCrash(String errorText) {
        BuildGdx.message.show("Error: ", errorText, BuildMessage.MessageType.Info);
        Console.Println("Game error: " + errorText, Console.OSDTEXT_RED);
        kGameCrash = true;
    }

    public void dassert(String msg) {
        if (kGameCrash) {
            return;
        }
        this.ThrowError(msg);
        System.exit(0);
    }

    @Override
    protected byte[] reportData() {
        byte[] out = null;
        String text = "Mapname: " + gGameScreen.getTitle();
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "UserFlag: " + (Object)((Object)mUserFlag);
        text = String.valueOf(text) + "\r\n";
        if (mUserFlag == UserFlag.Addon && Game.currentGame != null) {
            try {
                FileEntry addon = Game.currentGame.getFile();
                text = addon != null && Game.currentGame.isPackage() ? String.valueOf(text) + "Episode filename: " + addon.getPath() : String.valueOf(text) + "Episode filename: " + Game.currentGame.getDirectory().getAbsolutePath();
                text = String.valueOf(text) + "\r\n";
            }
            catch (Exception e) {
                text = String.valueOf(text) + "Episode filename get error \r\n";
            }
        }
        text = String.valueOf(text) + "level " + Game.Level;
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "nDifficulty: " + Game.Skill;
        text = String.valueOf(text) + "\r\n";
        if (Game.Player != null) {
            text = String.valueOf(text) + "PlayerX: " + Game.Player[Mmulti.myconnectindex].posx;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerY: " + Game.Player[Mmulti.myconnectindex].posy;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerZ: " + Game.Player[Mmulti.myconnectindex].posz;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerAng: " + Game.Player[Mmulti.myconnectindex].getAnglef();
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerSect: " + Game.Player[Mmulti.myconnectindex].cursectnum;
            text = String.valueOf(text) + "\r\n";
        }
        if (mUserFlag == UserFlag.UserMap && Game.boardfilename != null) {
            ByteArray array = new ByteArray();
            byte[] data = BuildGdx.cache.getBytes(Game.boardfilename, 0);
            if (data != null) {
                text = String.valueOf(text) + "\r\n<------Start Map data------->\r\n";
                array.addAll(text.getBytes());
                array.addAll(data);
                array.addAll("\r\n<------End Map data------->\r\n".getBytes());
                out = Arrays.copyOf(array.items, array.size);
            }
        } else {
            out = text.getBytes();
        }
        return out;
    }

    public boolean isScreenSaving() {
        Screen scr = this.getScreen();
        if (scr instanceof GameAdapter) {
            return ((GameAdapter)scr).isScreenSaving();
        }
        return false;
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;

    }
}

