/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.util.Arrays;
import ru.m210projects.Build.FileHandle.BufferResource;
import ru.m210projects.Build.FileHandle.Resource;

public class MirrorType {
    public short mirrorwall;
    public short mirrorsector;
    public short camera;
    public short camsprite;
    public short campic;
    public short numspawnspots;
    public short[] spawnspots = new short[4];
    public boolean ismagic;
    public MirrorState mstate;
    public int maxtics;
    public int tics;

    public void reset() {
        this.mirrorwall = (short)-1;
        this.mirrorsector = (short)-1;
        this.camera = (short)-1;
        this.camsprite = (short)-1;
        this.campic = (short)-1;
        this.numspawnspots = (short)-1;
        Arrays.fill(this.spawnspots, (short)-1);
        this.ismagic = false;
        this.mstate = null;
        this.maxtics = -1;
        this.tics = -1;
    }

    public void save(BufferResource fil) {
        fil.writeShort(this.mirrorwall);
        fil.writeShort(this.mirrorsector);
        fil.writeShort(this.camera);
        fil.writeShort(this.camsprite);
        fil.writeShort(this.campic);
        fil.writeShort(this.numspawnspots);
        fil.writeBytes(this.spawnspots);
        fil.writeBoolean(this.ismagic);
        fil.writeByte(this.mstate != null ? this.mstate.ordinal() : -1);
        fil.writeInt(this.maxtics);
        fil.writeInt(this.tics);
    }

    public void load(Resource res) {
        this.mirrorwall = res.readShort();
        this.mirrorsector = res.readShort();
        this.camera = res.readShort();
        this.camsprite = res.readShort();
        this.campic = res.readShort();
        this.numspawnspots = res.readShort();
        int i = 0;
        while (i < 4) {
            this.spawnspots[i] = res.readShort();
            ++i;
        }
        this.ismagic = res.readBoolean();
        i = res.readByte().byteValue();
        this.mstate = i != -1 ? MirrorState.values()[i] : null;
        this.maxtics = res.readInt();
        this.tics = res.readInt();
    }

    public void copy(MirrorType src) {
        this.mirrorwall = src.mirrorwall;
        this.mirrorsector = src.mirrorsector;
        this.camera = src.camera;
        this.camsprite = src.camsprite;
        this.campic = src.campic;
        this.numspawnspots = src.numspawnspots;
        System.arraycopy(src.spawnspots, 0, this.spawnspots, 0, 4);
        this.ismagic = src.ismagic;
        this.mstate = src.mstate;
        this.maxtics = src.maxtics;
        this.tics = src.tics;
    }

    public static enum MirrorState {
        m_normal,
        m_viewon,
        m_pissed;

    }
}

