/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Loader.Voxels.KVXLoader;
import ru.m210projects.Build.Loader.Voxels.Voxel;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Script.Scriptfile;

public class VoxelScript
extends Scriptfile {
    private String[] aVoxelArray = new String[Engine.MAXTILES];

    public VoxelScript(Resource res) {
        super("", res.getBytes());
        this.parse();
    }

    private void parse() {
        while (!this.eof()) {
            int lTile = this.getnumber();
            this.getnumber();
            String filename = this.getstring();
            if (filename == null || !Gameutils.isValidTile(lTile)) continue;
            this.aVoxelArray[lTile] = filename;
        }
    }

    public void apply(DefScript def) {
        int i = 0;
        while (i < Engine.MAXTILES) {
            Resource buffer;
            if (this.aVoxelArray[i] != null && (buffer = BuildGdx.cache.open(this.aVoxelArray[i], 0)) != null) {
                Voxel vox = KVXLoader.load(buffer);
                def.mdInfo.addVoxelInfo(vox, i);
                buffer.close();
            }
            ++i;
        }
    }

    private int getnumber() {
        String txt = this.getstring();
        if (txt == null) {
            return -1;
        }
        txt = txt.replaceAll("[^0-9]", "");
        try {
            return Integer.parseInt(txt);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    protected void preparse(byte[] data, int flen) {
        int numcr = 1;
        int i = 0;
        while (i < flen) {
            boolean cr = false;
            if (data[i] == 13) {
                i += data[i + 1] == 10 ? 1 : 0;
                cr = true;
            } else if (data[i] == 10) {
                i += data[i + 1] == 13 ? 1 : 0;
                cr = true;
            }
            if (cr) {
                ++numcr;
            }
            ++i;
        }
        this.linenum = numcr;
        this.lineoffs = new int[numcr];
        int nflen = 0;
        boolean space = false;
        int cs = 0;
        boolean inquote = false;
        numcr = 0;
        int i2 = 0;
        while (i2 < flen) {
            boolean cr = false;
            if (data[i2] == 13) {
                i2 += data[i2 + 1] == 10 ? 1 : 0;
                cr = true;
            } else if (data[i2] == 10) {
                i2 += data[i2 + 1] == 13 ? 1 : 0;
                cr = true;
            }
            if (cr) {
                this.lineoffs[numcr++] = nflen;
                if (cs == 1) {
                    cs = 0;
                }
                space = true;
            } else if (!(inquote || data[i2] != 32 && data[i2] != 9)) {
                space = true;
            } else {
                if (data[i2] == 35 && cs == 0) {
                    cs = 1;
                }
                if (data[i2] == 47 && data[i2 + 1] == 47 && cs == 0) {
                    cs = 1;
                }
                if (data[i2] == 92 && data[i2 + 1] == 92 && cs == 0) {
                    cs = 1;
                }
                if (data[i2] == 47 && data[i2 + 1] == 42 && cs == 0) {
                    space = true;
                    cs = 2;
                }
                if (data[i2] == 42 && data[i2 + 1] == 47 && cs == 2) {
                    cs = 0;
                    ++i2;
                } else if (cs == 0) {
                    if (space) {
                        data[nflen++] = 0;
                        space = false;
                    }
                    if (data[i2] == 92 && data[i2 + 1] == 34) {
                        ++i2;
                        data[nflen++] = 34;
                    } else if (data[i2] == 34) {
                        inquote ^= true;
                    } else {
                        data[nflen++] = data[i2];
                    }
                }
            }
            ++i2;
        }
        data[nflen++] = 0;
        this.lineoffs[numcr] = nflen;
        data[nflen++] = 0;
        flen = nflen;
        this.textbuf = new String(data);
        this.textptr = 0;
        this.eof = nflen - 1;
    }
}

