/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AIHAND {
    public static AISTATE handIdle;
    public static AISTATE handSearch;
    public static AISTATE handChase;
    public static AISTATE handRecoil;
    public static AISTATE handGoto;
    public static AISTATE handAttack;

    public static void Init() {
        handIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        handSearch = new AISTATE(AISTATEFUNC.Type.search, 6, null, 600, false, true, true, handIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIHAND.thinkSearch(sprite, xsprite);
            }
        };
        handChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIHAND.thinkChase(sprite, xsprite);
            }
        };
        handRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, handSearch);
        handGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 6, null, 1800, false, true, true, handIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIHAND.thinkGoto(sprite, xsprite);
            }
        };
        handAttack = new AISTATE(AISTATEFUNC.Type.other, 7, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIHAND.Attack(nXSprite);
            }
        }, 120, false, false, false, handChase);
    }

    private static void Attack(int nXIndex) {
        SPRITE pTarget;
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        SPRITE pSprite = Engine.sprite[pXSprite.reference];
        if (pXSprite.target != -1 && Gameutils.IsPlayerSprite(pTarget = Engine.sprite[pXSprite.target])) {
            PLAYER pPlayer = Globals.gPlayer[pTarget.lotag - 231];
            if (!pPlayer.handDamage) {
                pPlayer.handDamage = true;
                Actor.actPostSprite(pSprite.xvel, 1024);
            }
        }
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, handSearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, handGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, handSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, handSearch);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                if (dist < 563 && Pragmas.klabs(losAngle) < 85 && Globals.pGameInfo.nGameType == 0) {
                    Ai.aiNewState(pSprite, pXSprite, handAttack);
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, handGoto);
        pXSprite.target = -1;
    }
}

