/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AIZOMBA {
    public static final int kAxeZombieMeleeDist = Gameutils.M2X(2.0);
    public static AISTATE zombieAIdle;
    public static AISTATE zombieAChase;
    public static AISTATE zombieAPonder;
    public static AISTATE zombieAGoto;
    public static AISTATE zombieAHack;
    public static AISTATE zombieASearch;
    public static AISTATE zombieARecoil;
    public static AISTATE zombieARTesla;
    public static AISTATE zombieAFall;
    public static AISTATE zombieAUp;
    public static AISTATE zombieEIdle;
    public static AISTATE zombieEUp;
    public static AISTATE zombieEUp2;
    public static AISTATE zombieSLIdle;
    public static AISTATE zombieSLUP;

    public static void Init() {
        zombieAIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, true, false, true, null){

            @Override
            public void enter(SPRITE sprite, XSPRITE xsprite) {
                xsprite.target = -1;
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        zombieEIdle = new AISTATE(AISTATEFUNC.Type.idle, 12, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        zombieAPonder = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBA.thinkPonder(sprite, xsprite);
            }
        };
        zombieARecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, zombieAPonder);
        zombieARTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, zombieAPonder);
        zombieAUp = new AISTATE(AISTATEFUNC.Type.other, 11, null, 0, false, false, false, zombieAPonder);
        zombieAFall = new AISTATE(AISTATEFUNC.Type.other, 1, null, 360, false, false, false, zombieAUp);
        zombieAHack = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIZOMBA.HackCallback(nXSprite);
            }
        }, 80, false, false, false, zombieAPonder);
        zombieAChase = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBA.thinkChase(sprite, xsprite);
            }
        };
        zombieAGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 1800, false, true, true, zombieAIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBA.thinkGoto(sprite, xsprite);
            }
        };
        zombieASearch = new AISTATE(AISTATEFUNC.Type.search, 8, null, 1800, false, true, true, zombieAIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBA.thinkSearch(sprite, xsprite);
            }
        };
        zombieEUp2 = new AISTATE(AISTATEFUNC.Type.other, 0, null, 1, true, false, false, zombieASearch){

            @Override
            public void enter(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBA.entryEZombie(sprite, xsprite);
            }
        };
        zombieEUp = new AISTATE(AISTATEFUNC.Type.other, 9, null, 180, true, false, false, zombieEUp2){

            @Override
            public void enter(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBA.entryEZombieUp(sprite, xsprite);
            }
        };
        zombieSLIdle = new AISTATE(AISTATEFUNC.Type.idle, 10, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        zombieSLUP = new AISTATE(AISTATEFUNC.Type.other, 11, null, 0, true, false, false, zombieAPonder){

            @Override
            public void enter(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBA.entryEZombie(sprite, xsprite);
            }
        };
    }

    private static void entryEZombie(SPRITE pSprite, XSPRITE pXSprite) {
        pSprite.hitag = (short)(pSprite.hitag | 1);
        pSprite.lotag = (short)203;
    }

    private static void entryEZombieUp(SPRITE pSprite, XSPRITE pXSprite) {
        SOUND.sfxStart3DSound(pSprite, 1100, -1, 0);
        pSprite.ang = Main.engine.getangle(pXSprite.targetX - pSprite.x, pXSprite.targetY - pSprite.y);
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget2(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        long dist = Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < (long)Gameutils.M2X(1.8) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            Ai.aiNewState(pSprite, pXSprite, zombieAGoto);
            return;
        }
        long dist = Main.engine.qdist(dx, dy);
        if (dist <= (long)pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum) && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                if (dist < (long)kAxeZombieMeleeDist && Pragmas.klabs(losAngle) < 85) {
                    Ai.aiNewState(pSprite, pXSprite, zombieAHack);
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, zombieAGoto);
        pXSprite.target = -1;
    }

    private static void thinkPonder(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            Ai.aiNewState(pSprite, pXSprite, zombieAGoto);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum) && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                if (dist < kAxeZombieMeleeDist) {
                    if (Pragmas.klabs(losAngle) < 85) {
                        Ai.aiNewState(pSprite, pXSprite, zombieAHack);
                    }
                    return;
                }
            }
        }
        Ai.aiNewState(pSprite, pXSprite, zombieAChase);
    }

    private static void HackCallback(int nXIndex) {
        SPRITE pTarget;
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        short nAngle = Main.engine.getangle(pXSprite.targetX - pSprite.x, pXSprite.targetY - pSprite.y);
        int nZOffset1 = DudeInfo.dudeInfo[pSprite.lotag - 200].eyeHeight * pSprite.yrepeat << 2;
        int nZOffset2 = 0;
        if (pXSprite.target != -1 && Actor.IsDudeSprite(pTarget = Engine.sprite[pXSprite.target])) {
            nZOffset2 = DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight * pTarget.yrepeat << 2;
        }
        int dx = Trig.Cos(nAngle) >> 16;
        int dy = Trig.Sin(nAngle) >> 16;
        int dz = nZOffset1 - nZOffset2;
        SOUND.sfxStart3DSound(pSprite, 1101, 1, 0);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 10);
    }
}

