/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import java.util.Arrays;
import ru.m210projects.Blood.AI.AIBAT;
import ru.m210projects.Blood.AI.AIBEAST;
import ru.m210projects.Blood.AI.AIBONEEL;
import ru.m210projects.Blood.AI.AIBURN;
import ru.m210projects.Blood.AI.AICALEB;
import ru.m210projects.Blood.AI.AICERBERUS;
import ru.m210projects.Blood.AI.AICULTIST;
import ru.m210projects.Blood.AI.AIGARG;
import ru.m210projects.Blood.AI.AIGHOST;
import ru.m210projects.Blood.AI.AIGILLBEAST;
import ru.m210projects.Blood.AI.AIHAND;
import ru.m210projects.Blood.AI.AIHOUND;
import ru.m210projects.Blood.AI.AIINNOCENT;
import ru.m210projects.Blood.AI.AIPOD;
import ru.m210projects.Blood.AI.AIRAT;
import ru.m210projects.Blood.AI.AISPID;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.AITCHERNOBOG;
import ru.m210projects.Blood.AI.AIUNICULT;
import ru.m210projects.Blood.AI.AIZOMBA;
import ru.m210projects.Blood.AI.AIZOMBF;
import ru.m210projects.Blood.AI.GeneticDude;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.WeaponAim;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;

public class Ai {
    public static final GeneticDude[] pDudes = new GeneticDude[2048];
    public static AISTATE genIdle;
    public static AISTATE genRecoil;
    public static final int LAND = 0;
    public static final int WATER = 1;
    public static final int DUCK = 2;
    public static final int kAIThinkMask = 3;
    public static int[] cumulDamage;
    public static int[] gDudeSlope;
    public static int[] aiTeslaHit;
    public static int[] aiThinkTime;
    public static int[] aiActive;
    public static int[] aiClock;
    public static int[] aiSoundOnce;
    public static Vector3 EnemyAim;

    static {
        AIZOMBA.Init();
        AIRAT.Init();
        AIINNOCENT.Init();
        AIHAND.Init();
        AICULTIST.Init();
        AIZOMBF.Init();
        AIGILLBEAST.Init();
        AIBURN.Init();
        AIGARG.Init();
        AIBAT.Init();
        AISPID.Init();
        AIHOUND.Init();
        AIGHOST.Init();
        AIBONEEL.Init();
        AITCHERNOBOG.Init();
        AIPOD.Init();
        AIBEAST.Init();
        AICALEB.Init();
        AICERBERUS.Init();
        AIUNICULT.Init();
        cumulDamage = new int[2048];
        gDudeSlope = new int[2048];
        aiTeslaHit = new int[Globals.kMaxSprites];
        aiThinkTime = new int[Globals.kMaxSprites];
        aiActive = new int[Globals.kMaxSprites];
        aiClock = new int[Globals.kMaxSprites];
        aiSoundOnce = new int[Globals.kMaxSprites];
        EnemyAim = new Vector3();
    }

    public static void aiNewState(SPRITE pSprite, XSPRITE pXSprite, AISTATE pState) {
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        pXSprite.stateTimer = pState.ticks;
        pXSprite.aiState = pState;
        int seqStartId = pDudeInfo.seqStartID;
        if (pState.seqId >= 0) {
            switch (pSprite.lotag) {
                case 254: 
                case 255: {
                    seqStartId = pXSprite.data2;
                }
            }
            if (!BuildGdx.cache.contains(seqStartId + pState.seqId, "SEQ")) {
                return;
            }
            SeqHandling.seqSpawn(seqStartId + pState.seqId, 3, pSprite.extra, pState.callback);
        }
        if (pState.enter) {
            pState.enter(pSprite, pXSprite);
        }
    }

    public static boolean dudeIsImmune(SPRITE pSprite, int dmgType) {
        if (dmgType < 0 || dmgType > 6) {
            return true;
        }
        if (DudeInfo.dudeInfo[pSprite.lotag - 200].startDamage[dmgType] == 0) {
            return true;
        }
        return pSprite.extra >= 0 && DB.xsprite[pSprite.extra].Locked == 1;
    }

    protected static boolean CanMove(SPRITE pSprite, int nTarget, int ang, int dist) {
        int dx = Pragmas.mulscale(dist, Trig.Cos(ang), 30);
        int dy = Pragmas.mulscale(dist, Trig.Sin(ang), 30);
        int x = pSprite.x;
        int y = pSprite.y;
        int z = pSprite.z;
        Gameutils.HitScan(pSprite, z, Trig.Cos(ang) >> 16, Trig.Sin(ang) >> 16, 0, Engine.pHitInfo, 65537, dist);
        int hitDist = (int)Main.engine.qdist(x - Engine.pHitInfo.hitx, y - Engine.pHitInfo.hity);
        if (hitDist - (pSprite.clipdist << 2) < dist) {
            return Engine.pHitInfo.hitsprite >= 0 && Engine.pHitInfo.hitsprite == nTarget;
        }
        if (!Gameutils.FindSector(x += dx, y += dy, z, pSprite.sectnum)) {
            return false;
        }
        long floorZ = Main.engine.getflorzofslope(Gameutils.foundSector, x, y);
        short nXSector = Engine.sector[Gameutils.foundSector].extra;
        boolean Water = false;
        boolean Underwater = false;
        boolean Depth = false;
        boolean Crusher = false;
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
            if (pXSector.Underwater) {
                Underwater = true;
            }
            if (pXSector.Depth != 0) {
                Depth = true;
            }
            if (Engine.sector[Gameutils.foundSector].lotag == 618 || pXSector.damageType != 0) {
                switch (pSprite.lotag) {
                    case 227: 
                    case 228: {
                        if (Ai.dudeIsImmune(pSprite, pXSector.damageType) && !DEMO.IsOriginalDemo()) break;
                        Crusher = true;
                        break;
                    }
                    default: {
                        Crusher = true;
                    }
                }
            }
        }
        int nUpper = Warp.gUpperLink[Gameutils.foundSector];
        int nLower = Warp.gLowerLink[Gameutils.foundSector];
        if (nUpper >= 0 && (Engine.sprite[nUpper].lotag == 9 || Engine.sprite[nUpper].lotag == 13)) {
            Depth = true;
            Water = true;
        }
        if (nLower >= 0 && (Engine.sprite[nLower].lotag == 10 || Engine.sprite[nLower].lotag == 14)) {
            Depth = true;
        }
        Gameutils.GetSpriteExtents(pSprite);
        switch (pSprite.lotag) {
            case 204: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 220: 
            case 227: 
            case 245: {
                if (Crusher) {
                    return false;
                }
                if (Depth || Underwater) {
                    return false;
                }
                return floorZ - (long)Gameutils.extents_zBot <= (long)Gameutils.M2Z(1.0);
            }
            case 218: {
                if (Water || !Underwater) {
                    return false;
                }
                if (Underwater) {
                    return true;
                }
                return true;
            }
            case 206: 
            case 207: 
            case 219: {
                if (pSprite.clipdist > hitDist) {
                    return false;
                }
                return !Depth;
            }
            case 254: 
            case 255: {
                return (!Crusher || Ai.dudeIsImmune(pSprite, pXSector.damageType)) && (!Water && !Underwater || AIUNICULT.canSwim(pSprite));
            }
        }
        if (Crusher) {
            return false;
        }
        return pXSector != null && pXSector.Depth != 0 || pXSector != null && pXSector.Underwater || floorZ - (long)Gameutils.extents_zBot <= (long)Gameutils.M2Z(1.0);
    }

    protected static void aiChooseDirection(SPRITE pSprite, XSPRITE pXSprite, int ang) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        int dang = (1024 + ang - pSprite.ang & 0x7FF) - 1024;
        int sin = Trig.Sin(pSprite.ang);
        int cos = Trig.Cos(pSprite.ang);
        long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
        int avoidDist = (int)((15L * vel >> 12) - (15L * vel >> 43) >> 1);
        int turnTo = 341;
        if (dang < 0) {
            turnTo = -turnTo;
        }
        pXSprite.goalAng = Ai.CanMove(pSprite, pXSprite.target, pSprite.ang + dang, avoidDist) ? pSprite.ang + dang & 0x7FF : (Ai.CanMove(pSprite, pXSprite.target, pSprite.ang + dang / 2, avoidDist) ? pSprite.ang + dang / 2 & 0x7FF : (Ai.CanMove(pSprite, pXSprite.target, pSprite.ang - dang / 2, avoidDist) ? pSprite.ang - dang / 2 & 0x7FF : (Ai.CanMove(pSprite, pXSprite.target, pSprite.ang + turnTo, avoidDist) ? pSprite.ang + turnTo & 0x7FF : (Ai.CanMove(pSprite, pXSprite.target, pSprite.ang, avoidDist) ? (int)pSprite.ang : (Ai.CanMove(pSprite, pXSprite.target, pSprite.ang - turnTo, avoidDist) ? pSprite.ang - turnTo & 0x7FF : pSprite.ang + 341 & 0x7FF)))));
        int n = pXSprite.dodgeDir = Gameutils.Chance(16384) ? 1 : -1;
        if (!Ai.CanMove(pSprite, pXSprite.target, pSprite.ang + 512 * pXSprite.dodgeDir, 512)) {
            pXSprite.dodgeDir = -pXSprite.dodgeDir;
            if (!Ai.CanMove(pSprite, pXSprite.target, pSprite.ang + 512 * pXSprite.dodgeDir, 512)) {
                pXSprite.dodgeDir = 0;
            }
        }
    }

    protected static void aiMoveForward(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int sin = Trig.Sin(pSprite.ang);
        int cos = Trig.Cos(pSprite.ang);
        int frontSpeed = pDudeInfo.frontSpeed;
        if (pSprite.lotag == 239 && DEMO.IsOriginalDemo()) {
            frontSpeed = 0;
        }
        short s = pSprite.xvel;
        Actor.sprXVel[s] = Actor.sprXVel[s] + (long)Pragmas.mulscale(cos, frontSpeed, 30);
        short s2 = pSprite.xvel;
        Actor.sprYVel[s2] = Actor.sprYVel[s2] + (long)Pragmas.mulscale(sin, frontSpeed, 30);
    }

    protected static void aiMoveTurn(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
    }

    protected static void aiMoveDodge(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (pXSprite.dodgeDir == 0) {
            return;
        }
        long sin = Trig.Sin(pSprite.ang);
        long cos = Trig.Cos(pSprite.ang);
        long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
        long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
        svel = pXSprite.dodgeDir > 0 ? (svel += (long)pDudeInfo.sideSpeed) : (svel -= (long)pDudeInfo.sideSpeed);
        Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
        Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
    }

    public static void aiActivateDude(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        if (pXSprite.state == 0) {
            short nAngle = Main.engine.getangle(pXSprite.targetX - pSprite.x, pXSprite.targetY - pSprite.y);
            Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
            pXSprite.state = 1;
        }
        switch (pSprite.lotag) {
            case 210: {
                Ai.aiActive[pSprite.xvel] = 1;
                Ai.aiThinkTime[pSprite.xvel] = 0;
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIGHOST.ghostSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 1600, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIGHOST.ghostChase);
                break;
            }
            case 201: 
            case 202: 
            case 247: 
            case 248: 
            case 249: {
                Ai.aiActive[pSprite.xvel] = 1;
                if (pXSprite.target == -1) {
                    if (pXSprite.palette != 0 && pXSprite.palette <= 2) {
                        Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[0]);
                    if (!Gameutils.Chance(16384)) break;
                    if (pSprite.lotag == 201) {
                        Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 4008, 1, -1);
                        break;
                    }
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 1008, 1, -1);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    if (pSprite.lotag == 201) {
                        Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 4003, 1, -1);
                    } else {
                        Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 1003, 1, -1);
                    }
                }
                if (pXSprite.palette != 0 && pXSprite.palette <= 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[1]);
                    break;
                }
                if (pSprite.lotag == 201) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistTurn);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[0]);
                break;
            }
            case 254: {
                Ai.aiActive[pSprite.xvel] = 1;
                if (pXSprite.target == -1) {
                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                        Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeSearch[0]);
                    if (!Gameutils.Chance(16384)) break;
                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 0);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 0);
                }
                if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeChase[0]);
                break;
            }
            case 230: {
                pSprite.lotag = (short)201;
                Ai.aiActive[pSprite.xvel] = 1;
                if (pXSprite.target == -1) {
                    if (pXSprite.palette != 0 && pXSprite.palette <= 2) {
                        Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[0]);
                    if (!Gameutils.Chance(16384)) break;
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 4008, 1, -1);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 4008, 1, -1);
                }
                if (pXSprite.palette == 1 || pXSprite.palette == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[2]);
                break;
            }
            case 246: {
                pSprite.lotag = (short)202;
                Ai.aiActive[pSprite.xvel] = 1;
                if (pXSprite.target == -1) {
                    if (pXSprite.palette != 0 && pXSprite.palette <= 2) {
                        Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[0]);
                    if (!Gameutils.Chance(16384)) break;
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 1008, 1, -1);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 1003, 1, -1);
                }
                if (pXSprite.palette == 1 || pXSprite.palette == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[2]);
                break;
            }
            case 240: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[1]);
                break;
            }
            case 255: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[6]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[6]);
                break;
            }
            case 219: {
                Ai.aiActive[pSprite.xvel] = 1;
                Ai.aiThinkTime[pSprite.xvel] = 0;
                if (pSprite.hitag == 0) {
                    pSprite.hitag = (short)9;
                }
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBAT.batSearch);
                    break;
                }
                if (Gameutils.Chance(20480)) {
                    Ai.aiPlaySound(pSprite, 2000, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIBAT.batChase);
                break;
            }
            case 218: {
                Ai.aiActive[pSprite.xvel] = 1;
                Ai.aiThinkTime[pSprite.xvel] = 0;
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBONEEL.boneelSearch);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, 1501, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, 1500, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIBONEEL.boneelChase);
                break;
            }
            case 217: {
                XSECTOR pXSector;
                Ai.aiActive[pSprite.xvel] = 1;
                Ai.aiThinkTime[pSprite.xvel] = 0;
                XSECTOR xSECTOR = pXSector = Engine.sector[pSprite.sectnum].extra > 0 ? DB.xsector[Engine.sector[pSprite.sectnum].extra] : null;
                if (pXSprite.target == -1) {
                    if (pXSector != null && pXSector.Underwater) {
                        Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastSearch[0]);
                    break;
                }
                if (Gameutils.Chance(8192)) {
                    Ai.aiPlaySound(pSprite, 1701, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, 1700, 1, -1);
                }
                if (pXSector != null && pXSector.Underwater) {
                    Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastChase[0]);
                break;
            }
            case 203: {
                Ai.aiThinkTime[pSprite.xvel] = 1;
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieASearch);
                    break;
                }
                if (!Gameutils.Chance(20480)) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieAChase);
                    break;
                }
                Ai.aiPlaySound(pSprite, Gameutils.Random(3) + 1103, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieAChase);
                break;
            }
            case 205: {
                Ai.aiThinkTime[pSprite.xvel] = 1;
                if (pXSprite.aiState != AIZOMBA.zombieEIdle) break;
                Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieEUp);
                break;
            }
            case 244: {
                Ai.aiThinkTime[pSprite.xvel] = 1;
                if (pXSprite.aiState != AIZOMBA.zombieSLIdle) break;
                Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieSLUP);
                break;
            }
            case 204: {
                Ai.aiThinkTime[pSprite.xvel] = 1;
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBF.zombieFSearch);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, 1201, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, 1200, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIZOMBF.zombieFChase);
                break;
            }
            case 241: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[2]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[2]);
                break;
            }
            case 252: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[4]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[4]);
                break;
            }
            case 242: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[3]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[0]);
                break;
            }
            case 206: 
            case 207: {
                Ai.aiActive[pSprite.xvel] = 1;
                Ai.aiThinkTime[pSprite.xvel] = 0;
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIGARG.gargoyleSearch);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGARG.gargoyleChase);
                if (pSprite.lotag == 206) {
                    if (Gameutils.Chance(16384)) {
                        Ai.aiPlaySound(pSprite, 1401, 1, -1);
                        break;
                    }
                    Ai.aiPlaySound(pSprite, 1400, 1, -1);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, 1451, 1, -1);
                    break;
                }
                Ai.aiPlaySound(pSprite, 1450, 1, -1);
                break;
            }
            case 208: 
            case 209: {
                if (DEMO.IsOriginalDemo() || pXSprite.data1 != 1) {
                    if (Gameutils.Chance(16384)) {
                        Ai.aiPlaySound(pSprite, 1401, 1, -1);
                    } else {
                        Ai.aiPlaySound(pSprite, 1400, 1, -1);
                    }
                    if (pSprite.lotag == 208) {
                        Ai.aiNewState(pSprite, pXSprite, AIGARG.statueFChase);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIGARG.statueSChase);
                    break;
                }
                if (pSprite.lotag == 208) {
                    Ai.aiNewState(pSprite, pXSprite, AIGARG.statueFTransformNew);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGARG.statueSTransformNew);
                break;
            }
            case 227: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusSearch[0]);
                    break;
                }
                Ai.aiPlaySound(pSprite, 2300, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusChase[0]);
                break;
            }
            case 228: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusSearch[1]);
                    break;
                }
                Ai.aiPlaySound(pSprite, 2300, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusChase[1]);
                break;
            }
            case 211: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIHOUND.houndSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 1300, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIHOUND.houndChase);
                break;
            }
            case 212: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIHAND.handSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 1900, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIHAND.handChase);
                break;
            }
            case 220: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIRAT.ratSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 2100, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIRAT.ratChase);
                break;
            }
            case 245: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIINNOCENT.innocentSearch);
                    break;
                }
                if (pXSprite.health > 0) {
                    Ai.aiPlaySound(pSprite, Gameutils.BiRandom(6) + 7000, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIINNOCENT.innocentChase);
                break;
            }
            case 229: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AITCHERNOBOG.tchernobogSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, Gameutils.Random(7) + 2350, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AITCHERNOBOG.tchernobogChase);
                break;
            }
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                if (pSprite.lotag == 216) {
                    Ai.aiActive[pSprite.xvel] = 1;
                }
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFF7);
                pSprite.hitag = (short)(pSprite.hitag | 2);
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AISPID.spidSearch);
                    break;
                }
                if (pSprite.lotag != 216) {
                    Ai.aiPlaySound(pSprite, 1800, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(1) + 1853, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AISPID.spidChase);
                break;
            }
            case 250: {
                Ai.aiThinkTime[pSprite.xvel] = 1;
                if (pXSprite.target == -1) {
                    if (pXSprite.palette == 1 || pXSprite.palette == 2) {
                        Ai.aiNewState(pSprite, pXSprite, AICALEB.calebSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AICALEB.calebSearch[0]);
                    break;
                }
                if (pXSprite.palette == 1 || pXSprite.palette == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICALEB.calebChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICALEB.calebChase[0]);
                break;
            }
            case 251: {
                if (pXSprite.target == -1) {
                    if (pXSprite.palette == 1 || pXSprite.palette == 2) {
                        Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastSearch[0]);
                    break;
                }
                Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 9009, 1, -1);
                if (pXSprite.palette == 1 || pXSprite.palette == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastChase[0]);
                break;
            }
            case 221: 
            case 223: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIPOD.podSearch);
                    break;
                }
                if (pSprite.lotag == 223) {
                    Ai.aiPlaySound(pSprite, 2453, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, 2473, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIPOD.podChase);
                break;
            }
            case 222: 
            case 224: {
                if (pXSprite.target == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIPOD.tentacleSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 2503, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIPOD.tentacleChase);
            }
        }
    }

    public static void aiSetTarget(XSPRITE pXSprite, int x, int y, int z) {
        pXSprite.target = -1;
        pXSprite.targetX = x;
        pXSprite.targetY = y;
        pXSprite.targetZ = z;
    }

    public static void aiSetTarget(XSPRITE pXSprite, int nTarget) {
        if (nTarget < 0 || nTarget >= Globals.kMaxSprites) {
            Main.game.dassert("nTarget >= 0 && nTarget < kMaxSprites");
        }
        SPRITE pTarget = Engine.sprite[nTarget];
        if (pTarget.lotag < 200 || pTarget.lotag >= 256) {
            return;
        }
        if (nTarget == Engine.sprite[pXSprite.reference].owner) {
            return;
        }
        DudeInfo pTargetInfo = DudeInfo.dudeInfo[pTarget.lotag - 200];
        pXSprite.target = nTarget;
        pXSprite.targetX = pTarget.x;
        pXSprite.targetY = pTarget.y;
        pXSprite.targetZ = pTarget.z - (pTargetInfo.eyeHeight * pTarget.yrepeat << 2);
    }

    public static int aiDamageSprite(SPRITE pSprite, XSPRITE pXSprite, int nSource, int nDamageType, int nDamage) {
        if (nSource >= Globals.kMaxSprites) {
            Main.game.dassert("nSource < kMaxSprites");
        }
        if (pXSprite.health == 0) {
            return 0;
        }
        pXSprite.health = Gameutils.ClipLow(pXSprite.health - nDamage, 0);
        short s = pSprite.extra;
        cumulDamage[s] = cumulDamage[s] + nDamage;
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (nSource >= 0) {
            if (nSource == pXSprite.reference) {
                return 0;
            }
            if (pXSprite.target == -1) {
                Ai.aiSetTarget(pXSprite, nSource);
                Ai.aiActivateDude(pSprite, pXSprite);
            } else if (nSource != pXSprite.target) {
                int nThresh = nDamage;
                nThresh = Engine.sprite[nSource].lotag == pSprite.lotag ? (nThresh *= pDudeInfo.changeTargetKin) : (nThresh *= pDudeInfo.changeTarget);
                if (Gameutils.Chance(nThresh / 2)) {
                    Ai.aiSetTarget(pXSprite, nSource);
                    Ai.aiActivateDude(pSprite, pXSprite);
                }
            }
            if (nDamageType == 6) {
                Ai.aiTeslaHit[pXSprite.reference] = 1;
            } else if (!DEMO.IsOriginalDemo()) {
                Ai.aiTeslaHit[pXSprite.reference] = 0;
            }
            switch (pSprite.lotag) {
                case 206: {
                    Ai.aiNewState(pSprite, pXSprite, AIGARG.gargoyleChase);
                    break;
                }
                case 240: {
                    if (Gameutils.Chance(8192) && Globals.gFrameClock > aiClock[pSprite.xvel]) {
                        Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 1031, 2, -1);
                        Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
                    }
                    boolean tommyChance = Gameutils.Chance(768);
                    if (pXSprite.palette != 1 && pXSprite.palette != 2) break;
                    pSprite.lotag = tommyChance ? (short)201 : (short)202;
                    pXSprite.burnTime = 0;
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistGoto[1]);
                    break;
                }
                case 255: {
                    if (Gameutils.Chance(8192) && Globals.gFrameClock > aiClock[pSprite.xvel]) {
                        AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 3);
                        Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
                    }
                    if (pXSprite.burnTime <= 0) {
                        pXSprite.burnTime = 2400;
                    }
                    if (!AIUNICULT.spriteIsUnderwater(pSprite, false)) break;
                    pSprite.lotag = (short)254;
                    pXSprite.burnTime = 0;
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeGoto[1]);
                    break;
                }
                case 245: {
                    if (nDamageType != 1 || pXSprite.health > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 361, 0, -1);
                    pSprite.lotag = (short)239;
                    Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                    Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[39].startHealth, DudeInfo.dudeInfo[39].startHealth);
                    if (!DEMO.IsOriginalDemo() && pXSprite.burnTime == 0) {
                        pXSprite.burnTime = 1200;
                    }
                    EVENT.checkEventList(pXSprite.reference, 3, 0);
                    break;
                }
                case 249: {
                    if (pXSprite.health > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 9008, 0, -1);
                    pSprite.lotag = (short)251;
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastTransforming);
                    Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[51].startHealth, DudeInfo.dudeInfo[51].startHealth);
                    break;
                }
                case 250: {
                    if (nDamageType != 1 || pXSprite.health > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 361, 0, -1);
                    if (!DEMO.IsOriginalDemo()) {
                        if (pXSprite.burnTime == 0) {
                            pXSprite.burnTime = 1200;
                        }
                        pSprite.lotag = (short)252;
                        Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[4]);
                        Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[51].startHealth, DudeInfo.dudeInfo[51].startHealth);
                    } else {
                        pSprite.lotag = (short)239;
                        Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                        Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[39].startHealth, DudeInfo.dudeInfo[39].startHealth);
                    }
                    Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
                    EVENT.checkEventList(pXSprite.reference, 3, 0);
                    break;
                }
                case 254: {
                    int chance3;
                    if (nDamageType == 1) {
                        if (pXSprite.health > pDudeInfo.fleeHealth) break;
                        if (EVENT.getNextIncarnation(pXSprite) == null) {
                            AIUNICULT.removeDudeStuff(pSprite);
                            if (pXSprite.data1 >= 459 && pXSprite.data1 < 467) {
                                AIUNICULT.doExplosion(pSprite, pXSprite.data1 - 459);
                            }
                            if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                pXSprite.health = 0;
                                break;
                            }
                            if (!BuildGdx.cache.contains(pXSprite.data2 + 15, "SEQ") && !BuildGdx.cache.contains(pXSprite.data2 + 16, "SEQ") || !BuildGdx.cache.contains(pXSprite.data2 + 3, "SEQ")) break;
                            Ai.aiPlaySound(pSprite, 361, 0, -1);
                            AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 3);
                            pSprite.lotag = (short)255;
                            if (pXSprite.data2 == 11520) {
                                pSprite.pal = (short)12;
                            }
                            Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                            Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[55].startHealth, DudeInfo.dudeInfo[55].startHealth);
                            Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
                            EVENT.checkEventList(pXSprite.reference, 3, 0);
                            break;
                        }
                        Actor.actKillSprite(nSource, pSprite, nDamageType, nDamage);
                        break;
                    }
                    if (AIUNICULT.inDodge(pXSprite.aiState) || !Gameutils.Chance(chance3 = AIUNICULT.getDodgeChance(pSprite)) && !AIUNICULT.inIdle(pXSprite.aiState)) break;
                    if (!AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                        if (!AIUNICULT.canDuck(pSprite) || !AIUNICULT.checkUniCultistSeq(pSprite, 14)) {
                            Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeDodgeDmg[0]);
                        } else {
                            Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeDodgeDmg[2]);
                        }
                        if (!Gameutils.Chance(512)) break;
                        AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 1);
                        break;
                    }
                    if (!AIUNICULT.checkUniCultistSeq(pSprite, 13)) break;
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeDodgeDmg[1]);
                    break;
                }
                case 201: 
                case 202: 
                case 247: 
                case 248: {
                    if (nDamageType == 1) {
                        if (pXSprite.health > pDudeInfo.fleeHealth) break;
                        if (!DEMO.IsOriginalDemo()) {
                            if (pXSprite.palette != 0) {
                                pXSprite.health = 0;
                                break;
                            }
                            if (pXSprite.burnTime == 0) {
                                pXSprite.burnTime = 1200;
                            }
                        }
                        Ai.aiPlaySound(pSprite, 361, 0, -1);
                        Ai.aiPlaySound(pSprite, 1031 + Gameutils.Random(2), 2, -1);
                        pSprite.lotag = (short)240;
                        Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                        Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[40].startHealth, DudeInfo.dudeInfo[40].startHealth);
                        Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
                        EVENT.checkEventList(pXSprite.reference, 3, 0);
                        break;
                    }
                    if (pXSprite.palette == 0) {
                        if (!AICULTIST.checkDudeSeq(pSprite, 14)) {
                            Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistDodge[0]);
                            break;
                        }
                        Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistDodge[2]);
                        break;
                    }
                    if (!AICULTIST.checkDudeSeq(pSprite, 13) || pXSprite.palette != 1 && pXSprite.palette != 2) break;
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistDodge[1]);
                    break;
                }
                case 203: 
                case 205: {
                    if (nDamageType != 1 || pXSprite.health > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 361, 0, -1);
                    Ai.aiPlaySound(pSprite, 1106, 2, -1);
                    pSprite.lotag = (short)241;
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[2]);
                    if (!DEMO.IsOriginalDemo() && pXSprite.burnTime == 0) {
                        pXSprite.burnTime = 1200;
                    }
                    Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[41].startHealth, DudeInfo.dudeInfo[41].startHealth);
                    EVENT.checkEventList(pXSprite.reference, 3, 0);
                    break;
                }
                case 204: {
                    if (nDamageType != 1 || pXSprite.health > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 361, 0, -1);
                    Ai.aiPlaySound(pSprite, 1202, 2, -1);
                    pSprite.lotag = (short)242;
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[3]);
                    if (!DEMO.IsOriginalDemo() && pXSprite.burnTime == 0) {
                        pXSprite.burnTime = 1200;
                    }
                    Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[42].startHealth, DudeInfo.dudeInfo[42].startHealth);
                    EVENT.checkEventList(pXSprite.reference, 3, 0);
                }
            }
        }
        return nDamage;
    }

    protected static void RecoilDude(SPRITE pSprite, XSPRITE pXSprite) {
        boolean chance = Gameutils.Chance(16384);
        if (pSprite.statnum != 6 || !Actor.IsDudeSprite(pSprite)) {
            return;
        }
        switch (pSprite.lotag) {
            case 254: {
                int mass = Actor.getDudeMassBySpriteSize(pSprite);
                int chance4 = AIUNICULT.getRecoilChance(pSprite);
                boolean chance3 = Gameutils.Chance(chance4);
                if (aiTeslaHit[pXSprite.reference] != 0 && (AIUNICULT.inIdle(pXSprite.aiState) || mass < 155 || mass >= 155 && chance3) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 1);
                    if (BuildGdx.cache.contains(pXSprite.data2 + 4, "SEQ")) {
                        AIUNICULT.GDXGenDudeRTesla.next = Gameutils.Chance(chance4 * 2) ? AIUNICULT.GDXGenDudeDodge[0] : AIUNICULT.GDXGenDudeDodgeDmg[0];
                        Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRTesla);
                        break;
                    }
                    if (AIUNICULT.canDuck(pSprite) && (Gameutils.Chance(chance4) || Globals.pGameInfo.nDifficulty == 0)) {
                        Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[2]);
                        break;
                    }
                    if (AIUNICULT.canSwim(pSprite) && AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                        Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[0]);
                    break;
                }
                if (AIUNICULT.inDodge(pXSprite.aiState)) {
                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 1);
                    break;
                }
                if (!chance3 && !AIUNICULT.inIdle(pXSprite.aiState) && !Gameutils.Chance(AIUNICULT.getRecoilChance(pSprite)) && (AIUNICULT.dudeIsMelee(pXSprite) || mass >= 155)) break;
                AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 1);
                if (AIUNICULT.canDuck(pSprite) && (Gameutils.Chance(chance4) || Globals.pGameInfo.nDifficulty == 0)) {
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[2]);
                    break;
                }
                if (AIUNICULT.canSwim(pSprite) && AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[0]);
                break;
            }
            case 201: 
            case 202: 
            case 247: 
            case 248: 
            case 249: {
                if (pSprite.lotag == 201) {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 4013, 2, -1);
                } else {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 1013, 2, -1);
                }
                if (pXSprite.palette == 0 && aiTeslaHit[pXSprite.reference] != 0) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistRTesla);
                    Ai.aiTeslaHit[pXSprite.reference] = 0;
                    return;
                }
                if (pXSprite.palette == 1 || pXSprite.palette == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistRecoil[1]);
                    break;
                }
                if (!chance || chance && Globals.pGameInfo.nDifficulty == 0) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistRecoil[2]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistRecoil[0]);
                break;
            }
            case 240: {
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                break;
            }
            case 255: {
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[6]);
                break;
            }
            case 252: {
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[4]);
                break;
            }
            case 204: {
                Ai.aiPlaySound(pSprite, 1202, 2, -1);
                if (aiTeslaHit[pXSprite.reference] != 0) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBF.zombieFRTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIZOMBF.zombieFRecoil);
                break;
            }
            case 203: 
            case 205: {
                Ai.aiPlaySound(pSprite, 1106, 2, -1);
                if (aiTeslaHit[pXSprite.reference] != 0 && pXSprite.data3 > DudeInfo.dudeInfo[3].startHealth / 3) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieARTesla);
                    break;
                }
                if (pXSprite.data3 <= DudeInfo.dudeInfo[3].startHealth / 3) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieARecoil);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieAFall);
                break;
            }
            case 241: {
                Ai.aiPlaySound(pSprite, 1106, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[2]);
                break;
            }
            case 242: {
                Ai.aiPlaySound(pSprite, 1202, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[3]);
                break;
            }
            case 206: 
            case 207: {
                Ai.aiPlaySound(pSprite, 1402, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIGARG.gargoyleRecoil);
                break;
            }
            case 227: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 2302, 2, -1);
                if (aiTeslaHit[pXSprite.reference] != 0 && pXSprite.data3 > DudeInfo.dudeInfo[3].startHealth / 3) {
                    Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusRTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusRecoil[0]);
                break;
            }
            case 228: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 2302, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusRecoil[1]);
                break;
            }
            case 211: {
                Ai.aiPlaySound(pSprite, 1302, 2, -1);
                if (aiTeslaHit[pXSprite.reference] != 0) {
                    Ai.aiNewState(pSprite, pXSprite, AIHOUND.houndRTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIHOUND.houndRecoil);
                break;
            }
            case 229: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(6) + 2370, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AITCHERNOBOG.tchernobogRecoil);
                break;
            }
            case 212: {
                Ai.aiPlaySound(pSprite, 1902, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIHAND.handRecoil);
                break;
            }
            case 220: {
                Ai.aiPlaySound(pSprite, 2102, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIRAT.ratRecoil);
                break;
            }
            case 219: {
                Ai.aiPlaySound(pSprite, 2002, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIBAT.batRecoil);
                break;
            }
            case 218: {
                Ai.aiPlaySound(pSprite, 1502, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIBONEEL.boneelRecoil);
                break;
            }
            case 217: {
                XSECTOR pXSector = Engine.sector[pSprite.sectnum].extra > 0 ? DB.xsector[Engine.sector[pSprite.sectnum].extra] : null;
                Ai.aiPlaySound(pSprite, 1702, 2, -1);
                if (pXSector != null && pXSector.Underwater) {
                    Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastRecoil[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastRecoil[0]);
                break;
            }
            case 210: {
                Ai.aiPlaySound(pSprite, 1602, 2, -1);
                if (aiTeslaHit[pXSprite.reference] != 0) {
                    Ai.aiNewState(pSprite, pXSprite, AIGHOST.ghostRTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGHOST.ghostRecoil);
                break;
            }
            case 213: 
            case 214: 
            case 215: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(1) + 1802, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AISPID.spidDodge);
                break;
            }
            case 216: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(1) + 1851, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AISPID.spidDodge);
                break;
            }
            case 245: {
                Ai.aiPlaySound(pSprite, Gameutils.BiRandom(2) + 7007, 2, -1);
                if (aiTeslaHit[pXSprite.reference] != 0) {
                    Ai.aiNewState(pSprite, pXSprite, AIINNOCENT.innocentTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIINNOCENT.innocentRecoil);
                break;
            }
            case 250: {
                if (aiTeslaHit[pXSprite.reference] != 0) {
                    Ai.aiNewState(pSprite, pXSprite, AICALEB.calebRTesla);
                    Ai.aiTeslaHit[pXSprite.reference] = 0;
                    return;
                }
                if (pXSprite.palette == 1 || pXSprite.palette == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICALEB.calebRecoil[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICALEB.calebRecoil[0]);
                break;
            }
            case 251: {
                Ai.aiPlaySound(pSprite, Gameutils.BiRandom(2) + 9004, 2, -1);
                if (pXSprite.palette != 1 && pXSprite.palette != 2 && aiTeslaHit[pXSprite.reference] != 0) {
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastRTesla);
                    Ai.aiTeslaHit[pXSprite.reference] = 0;
                    return;
                }
                if (pXSprite.palette == 1 || pXSprite.palette == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastRecoil[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastRecoil[0]);
                break;
            }
            case 221: 
            case 223: {
                Ai.aiNewState(pSprite, pXSprite, AIPOD.podRecoil);
                break;
            }
            case 222: 
            case 224: {
                Ai.aiNewState(pSprite, pXSprite, AIPOD.tentacleRecoil);
                break;
            }
            default: {
                Ai.aiNewState(pSprite, pXSprite, genRecoil);
            }
            case 208: 
            case 209: 
        }
        Ai.aiTeslaHit[pXSprite.reference] = 0;
    }

    protected static void aiPlaySound(SPRITE pSprite, int nSound, int soundonce, int nChannel) {
        if (soundonce != 0) {
            if (soundonce > aiSoundOnce[pSprite.xvel] || Globals.gFrameClock >= aiClock[pSprite.xvel]) {
                SOUND.sfxKill3DSound(pSprite, -1, -1);
                SOUND.sfxStart3DSound(pSprite, nSound, nChannel, 0);
                Ai.aiSoundOnce[pSprite.xvel] = soundonce;
                Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 120;
            }
        } else {
            SOUND.sfxStart3DSound(pSprite, nSound, nChannel, 2);
        }
    }

    protected static void aiThinkTarget(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pSprite.owner != pPlayer.nSprite && pPlayer.pXsprite.health != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int eyeAboveZ;
                int x = pPlayer.pSprite.x;
                int y = pPlayer.pSprite.y;
                int z = pPlayer.pSprite.z;
                short nSector = pPlayer.pSprite.sectnum;
                int dx = x - pSprite.x;
                int dy = y - pSprite.y;
                long dist = Main.engine.qdist(dx, dy);
                if ((dist <= (long)pDudeInfo.seeDist || dist <= (long)pDudeInfo.hearDist) && Main.engine.cansee(x, y, z, nSector, pSprite.x, pSprite.y, pSprite.z - (eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2), pSprite.sectnum)) {
                    short nAngle = Main.engine.getangle(dx, dy);
                    int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
                    if (dist < (long)pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                        Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                    if (dist < (long)pDudeInfo.hearDist) {
                        Ai.aiSetTarget(pXSprite, x, y, z);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    protected static void aiThinkTarget2(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pSprite.owner != pPlayer.nSprite && pPlayer.pXsprite.health != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int eyeAboveZ;
                int x = pPlayer.pSprite.x;
                int y = pPlayer.pSprite.y;
                int z = pPlayer.pSprite.z;
                short nSector = pPlayer.pSprite.sectnum;
                int dx = x - pSprite.x;
                int dy = y - pSprite.y;
                long dist = Main.engine.qdist(dx, dy);
                if ((dist <= (long)pDudeInfo.seeDist || dist <= (long)pDudeInfo.hearDist) && Main.engine.cansee(x, y, z, nSector, pSprite.x, pSprite.y, pSprite.z - (eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2), pSprite.sectnum)) {
                    short nAngle = Main.engine.getangle(dx, dy);
                    int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
                    if (dist < (long)pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                        Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                    if (dist < (long)pDudeInfo.hearDist) {
                        Ai.aiSetTarget(pXSprite, x, y, z);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
        if (pXSprite.state != 0) {
            short nSprite = Engine.headspritestat[6];
            while (nSprite >= 0) {
                int dy;
                int dx;
                long dist;
                SPRITE pTarget = Engine.sprite[nSprite];
                if (pTarget.lotag == 245 && ((dist = Main.engine.qdist(dx = pTarget.x - pSprite.x, dy = pTarget.y - pSprite.y)) <= (long)DudeInfo.dudeInfo[45].seeDist || dist <= (long)DudeInfo.dudeInfo[45].hearDist)) {
                    Ai.aiSetTarget(pXSprite, pTarget.xvel);
                    Ai.aiActivateDude(pSprite, pXSprite);
                    return;
                }
                nSprite = Engine.nextspritestat[nSprite];
            }
        }
    }

    protected static int aiTickHandler(SPRITE pSprite, XSPRITE pXSprite) {
        int ticks = pXSprite.aiState.ticks;
        if (DEMO.IsOriginalDemo()) {
            if (pSprite.lotag == 218 && pXSprite.aiState == AIBONEEL.boneelRecoil) {
                ticks = 0;
            }
            if (pSprite.lotag == 251 && pXSprite.aiState == AIBEAST.beastHack[1]) {
                ticks = 0;
            }
        }
        return ticks;
    }

    public static void aiProcessDudes() {
        short nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            SPRITE pSprite = Engine.sprite[nSprite];
            if ((pSprite.hitag & 0x20) == 0 && Actor.IsDudeSprite(pSprite)) {
                short nXSprite = pSprite.extra;
                XSPRITE pXSprite = DB.xsprite[nXSprite];
                DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
                if (!Gameutils.IsPlayerSprite(pSprite) && pXSprite.health != 0) {
                    pXSprite.stateTimer = Gameutils.ClipLow(pXSprite.stateTimer - Globals.kFrameTicks, 0);
                    if (pXSprite.aiState != null && pXSprite.aiState.move) {
                        pXSprite.aiState.move(pSprite, pXSprite);
                    }
                    if (pXSprite.aiState != null && pXSprite.aiState.think && (Globals.gFrame & 3) == (nSprite & 3)) {
                        pXSprite.aiState.think(pSprite, pXSprite);
                    }
                    if (pXSprite.aiState != null && pXSprite.stateTimer == 0 && pXSprite.aiState.next != null) {
                        if (pXSprite.aiState != null && Ai.aiTickHandler(pSprite, pXSprite) > 0) {
                            Ai.aiNewState(pSprite, pXSprite, pXSprite.aiState.next);
                        } else if (SeqHandling.seqFrame(3, nXSprite) < 0) {
                            Ai.aiNewState(pSprite, pXSprite, pXSprite.aiState.next);
                        }
                    }
                    if (pXSprite.health != 0 && cumulDamage[nXSprite] >= pDudeInfo.hinderDamage << 4) {
                        pXSprite.data3 = (short)cumulDamage[nXSprite];
                        Ai.RecoilDude(pSprite, pXSprite);
                    }
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        Arrays.fill(cumulDamage, 0);
    }

    public static void aiInit(boolean isOriginal) {
        genIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, false, null);
        genRecoil = new AISTATE(AISTATEFUNC.Type.recoil, 5, null, 20, false, false, false, genIdle);
        Arrays.fill(aiThinkTime, 0);
        Arrays.fill(aiActive, 0);
        Arrays.fill(aiSoundOnce, 0);
        Arrays.fill(aiTeslaHit, 0);
        Arrays.fill(aiClock, 0);
        Arrays.fill(cumulDamage, 0);
        Arrays.fill(gDudeSlope, 0);
        Arrays.fill(pDudes, null);
        short nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            SPRITE pDude = Engine.sprite[nSprite];
            Ai.aiInit(pDude, isOriginal);
            nSprite = Engine.nextspritestat[nSprite];
        }
    }

    public static void aiInit(SPRITE pDude, boolean isOriginal) {
        XSPRITE pXDude = DB.xsprite[pDude.extra];
        switch (pDude.lotag) {
            case 254: {
                Ai.aiActive[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AIUNICULT.GDXGenDudeIdle[0]);
                break;
            }
            case 201: 
            case 202: 
            case 247: 
            case 248: 
            case 249: {
                Ai.aiActive[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AICULTIST.cultistIdle[0]);
                break;
            }
            case 230: {
                Ai.aiActive[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AICULTIST.cultistSProne);
                break;
            }
            case 246: {
                Ai.aiActive[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AICULTIST.cultistTProne);
                break;
            }
            case 204: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AIZOMBF.zombieFIdle);
                break;
            }
            case 203: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AIZOMBA.zombieAIdle);
                break;
            }
            case 244: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AIZOMBA.zombieSLIdle);
                break;
            }
            case 205: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AIZOMBA.zombieEIdle);
                break;
            }
            case 206: 
            case 207: {
                Ai.aiActive[pDude.xvel] = 0;
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AIGARG.gargoyleIdle);
                break;
            }
            case 208: 
            case 209: {
                Ai.aiNewState(pDude, pXDude, AIGARG.statueIdle);
                break;
            }
            case 227: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AICERBERUS.cerberusIdle[0]);
                break;
            }
            case 228: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AICERBERUS.cerberusIdle[1]);
                break;
            }
            case 211: {
                Ai.aiNewState(pDude, pXDude, AIHOUND.houndIdle);
                break;
            }
            case 212: {
                Ai.aiNewState(pDude, pXDude, AIHAND.handIdle);
                break;
            }
            case 210: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiActive[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AIGHOST.ghostIdle);
                break;
            }
            case 245: {
                Ai.aiNewState(pDude, pXDude, AIINNOCENT.innocentIdle);
                break;
            }
            case 220: {
                Ai.aiNewState(pDude, pXDude, AIRAT.ratIdle);
                break;
            }
            case 218: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiActive[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AIBONEEL.boneelIdle);
                break;
            }
            case 217: {
                SECTOR pSector = Engine.sector[pDude.sectnum];
                if (isOriginal) {
                    Ai.aiNewState(pDude, pXDude, AIGILLBEAST.gillBeastIdle[0]);
                    break;
                }
                if (pSector.extra > 0 && DB.xsector[pSector.extra].Underwater) {
                    Ai.aiNewState(pDude, pXDude, AIGILLBEAST.gillBeastIdle[1]);
                    break;
                }
                Ai.aiNewState(pDude, pXDude, AIGILLBEAST.gillBeastIdle[0]);
                break;
            }
            case 219: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiActive[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AIBAT.batSleep);
                break;
            }
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiActive[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AISPID.spidIdle);
                break;
            }
            case 229: {
                Ai.aiThinkTime[pDude.xvel] = 0;
                Ai.aiNewState(pDude, pXDude, AITCHERNOBOG.tchernobogIdle);
                break;
            }
            case 250: {
                Ai.aiNewState(pDude, pXDude, AICALEB.calebIdle[0]);
                break;
            }
            case 251: {
                Ai.aiNewState(pDude, pXDude, AIBEAST.beastIdle[0]);
                break;
            }
            case 221: 
            case 223: {
                Ai.aiNewState(pDude, pXDude, AIPOD.podIdle);
                break;
            }
            case 222: 
            case 224: {
                Ai.aiNewState(pDude, pXDude, AIPOD.tentacleIdle);
                break;
            }
            case 239: 
            case 240: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[1]);
                pXDude.burnTime = 1200;
                break;
            }
            case 255: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[6]);
                pXDude.burnTime = 1200;
                break;
            }
            case 241: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[2]);
                pXDude.burnTime = 1200;
                break;
            }
            case 242: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[3]);
                pXDude.burnTime = 1200;
                break;
            }
            case 252: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[4]);
                pXDude.burnTime = 1200;
                break;
            }
            case 253: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[5]);
                pXDude.burnTime = 1200;
                break;
            }
            default: {
                Ai.aiNewState(pDude, pXDude, genIdle);
            }
        }
        Ai.aiSetTarget(pXDude, 0, 0, 0);
        pXDude.stateTimer = 0;
        switch (pDude.lotag) {
            case 205: 
            case 244: {
                pDude.hitag = (short)7;
                break;
            }
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                if (pDude.lotag == 216 && isOriginal) {
                    pDude.hitag = (short)15;
                    break;
                }
                if ((pDude.cstat & 8) != 0) {
                    pDude.hitag = (short)9;
                    break;
                }
                pDude.hitag = (short)15;
                break;
            }
            case 206: 
            case 207: 
            case 210: 
            case 218: 
            case 219: {
                pDude.hitag = (short)9;
                break;
            }
            case 217: {
                XSECTOR pXSector;
                XSECTOR xSECTOR = pXSector = Engine.sector[pDude.sectnum].extra > 0 ? DB.xsector[Engine.sector[pDude.sectnum].extra] : null;
                if (pXSector != null && pXSector.Underwater) {
                    pDude.hitag = (short)9;
                    break;
                }
                pDude.hitag = (short)15;
                break;
            }
            case 225: {
                break;
            }
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: {
                if ((pDude.cstat & 8) != 0) {
                    pDude.hitag = (short)8;
                    break;
                }
            }
            default: {
                pDude.hitag = (short)15;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void UpdateEnemyAim(SPRITE pSprite, int nXSprite, WeaponAim pAimData) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
        x = pSprite.x;
        y = pSprite.y;
        Ai.EnemyAim.x = Trig.Cos(pSprite.ang) >> 16;
        Ai.EnemyAim.y = Trig.Sin(pSprite.ang) >> 16;
        Ai.EnemyAim.z = Ai.gDudeSlope[nXSprite];
        closest = 0x7FFFFFFF;
        nDude = Engine.headspritestat[6];
        while (nDude >= 0) {
            block7: {
                pDude = Engine.sprite[nDude];
                if (pDude == pSprite || (pDude.hitag & 8) == 0) break block7;
                tx = pDude.x;
                ty = pDude.y;
                tz = pDude.z;
                dist = (int)Main.engine.qdist(tx - x, ty - y);
                if (dist == 0 || dist > 10240) break block7;
                if (pAimData.kSeeker != 0) {
                    k = (dist << 12) / pAimData.kSeeker;
                    tx = (int)((long)tx + ((long)k * Actor.sprXVel[nDude] >> 12));
                    ty = (int)((long)ty + ((long)k * Actor.sprYVel[nDude] >> 12));
                    tz = (int)((long)tz + ((long)k * Actor.sprZVel[nDude] >> 8));
                }
                z1 = Pragmas.mulscale(dist, Ai.gDudeSlope[nXSprite], 10) + eyeAboveZ;
                z2 = Pragmas.mulscale(9460L, dist, 10);
                Gameutils.GetSpriteExtents(pDude);
                if (z1 - z2 > Gameutils.extents_zBot || z1 + z2 < Gameutils.extents_zTop || (dist2 = Main.engine.ksqrt(((dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.ang), 30) + x) - tx >> 4) * (dx - tx >> 4) + ((dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.ang), 30) + y) - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) >= closest || Pragmas.klabs(((ang = Main.engine.getangle(tx - x, ty - y)) - pSprite.ang + 1024 & 2047) - 1024) > pAimData.kDudeAngle) break block7;
                dz = pDude.z - pSprite.z;
                if (!Main.engine.cansee(x, y, eyeAboveZ, pSprite.sectnum, tx, ty, tz, pDude.sectnum)) ** GOTO lbl-1000
                closest = dist2;
                Ai.EnemyAim.x = Trig.Cos(ang) >> 16;
                Ai.EnemyAim.y = Trig.Sin(ang) >> 16;
                if (dz < -819 && dz > -2867 || dz < -2867 && dz > -12288) {
                    Ai.EnemyAim.z = Pragmas.divscale(dz, dist, 10) + 9460;
                } else if (dz < -12288) {
                    Ai.EnemyAim.z = Pragmas.divscale(dz, dist, 10) - 7500;
                } else lbl-1000:
                // 2 sources

                {
                    Ai.EnemyAim.z = Pragmas.divscale(dz, dist, 10);
                }
            }
            nDude = Engine.nextspritestat[nDude];
        }
    }
}

