/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.io.FileNotFoundException;
import java.util.Arrays;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Types.BUSY;
import ru.m210projects.Blood.Types.BitHandler;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Blood.Types.GAMEINFO;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.Types.POSTPONE;
import ru.m210projects.Blood.Types.SPRITEHIT;
import ru.m210projects.Blood.Types.Seq.CeilingInst;
import ru.m210projects.Blood.Types.Seq.FloorInst;
import ru.m210projects.Blood.Types.Seq.MaskedWallInst;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.SpriteInst;
import ru.m210projects.Blood.Types.Seq.WallInst;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class SafeLoader {
    public short[] pskyoff = new short[256];
    public short pskybits;
    public int parallaxyscale;
    public short connecthead;
    public short[] connectpoint2 = new short[8];
    public int randomseed;
    public int visibility;
    public int parallaxvisibility;
    public byte automapping;
    public byte[] show2dsector = new byte[Globals.kMaxSectors + 7 >> 3];
    public byte[] show2dwall = new byte[Globals.kMaxWalls + 7 >> 3];
    public byte[] show2dsprite = new byte[Globals.kMaxSprites + 7 >> 3];
    public byte[] gotpic = new byte[Engine.MAXTILES + 7 >> 3];
    public byte[] gotsector = new byte[Globals.kMaxSectors + 7 >> 3];
    public Hitscan safeHitInfo;
    public short numsectors;
    public short numwalls;
    public short numsprites;
    public short[] headspritesect;
    public short[] headspritestat;
    public short[] prevspritesect;
    public short[] prevspritestat;
    public short[] nextspritesect;
    public short[] nextspritestat;
    public SECTOR[] sector = new SECTOR[Globals.kMaxSectors];
    public WALL[] wall = new WALL[Globals.kMaxWalls];
    public SPRITE[] sprite = new SPRITE[Globals.kMaxSprites];
    public Vector2[] kwall = new Vector2[8192];
    public Vector3[] ksprite = new Vector3[Globals.kMaxSprites];
    public int[] secFloorZ = new int[Globals.kMaxSectors];
    public int[] secCeilZ = new int[Globals.kMaxSectors];
    public int[] secPath = new int[Globals.kMaxSectors];
    public long[] sprXVel = new long[Globals.kMaxSprites];
    public long[] sprYVel = new long[Globals.kMaxSprites];
    public long[] sprZVel = new long[Globals.kMaxSprites];
    public long[] floorVel = new long[Globals.kMaxSectors];
    public long[] ceilingVel = new long[Globals.kMaxSectors];
    public short[] nStatSize = new short[1025];
    public XSPRITE[] xsprite = new XSPRITE[2048];
    public XWALL[] xwall = new XWALL[512];
    public XSECTOR[] xsector = new XSECTOR[512];
    public int[] nextXSprite = new int[2048];
    public int[] nextXWall = new int[512];
    public int[] nextXSector = new int[512];
    public GAMEINFO safeGameInfo = new GAMEINFO();
    public boolean showinvisibility;
    public boolean gNoClip;
    public boolean gFogMode;
    public boolean gFullMap;
    public boolean gPaused;
    public boolean gInfiniteAmmo;
    public boolean cheatsOn;
    public int gSkyCount;
    public int gFrameClock;
    public int gTicks;
    public int gFrame;
    public int gGameClock;
    public int[] cumulDamage = new int[2048];
    public int[] gDudeSlope = new int[2048];
    public ZONE[] gStartZone = new ZONE[8];
    public int[] gUpperLink = new int[Globals.kMaxSectors];
    public int[] gLowerLink = new int[Globals.kMaxSectors];
    public int mirrorcnt;
    public int[] MirrorType = new int[16];
    public int[] MirrorX = new int[16];
    public int[] MirrorY = new int[16];
    public int[] MirrorZ = new int[16];
    public int[] MirrorLower = new int[16];
    public int[] MirrorUpper = new int[16];
    public int MirrorSector;
    public int[] MirrorWall = new int[4];
    public SeqInst[] siWall = new SeqInst[512];
    public SeqInst[] siMasked = new SeqInst[512];
    public SeqInst[] siCeiling = new SeqInst[512];
    public SeqInst[] siFloor = new SeqInst[512];
    public SeqInst[] siSprite = new SeqInst[2048];
    public short[] actListIndex = new short[SeqHandling.kMaxSequences];
    public byte[] actListType = new byte[SeqHandling.kMaxSequences];
    public int activeCount;
    public int[] rxBucketIndex = new int[4096];
    public int[] rxBucketType = new int[4096];
    public short[] bucketHead = new short[1025];
    public int[] qEventEvent = new int[1025];
    public int[] qEventPriority = new int[1025];
    public int fNodeCount;
    public int gBusyCount = 0;
    public BUSY[] gBusy = new BUSY[128];
    public int[] nTeamCount = new int[8];
    public int gNetPlayers;
    public byte[] autoaim = new byte[8];
    public byte[] slopetilt = new byte[8];
    public byte[] skill = new byte[8];
    public String[] name = new String[8];
    public PLAYER[] safePlayer = new PLAYER[8];
    public SPRITEHIT[] gSpriteHit = new SPRITEHIT[2048];
    public int[] gWallExp = new int[Globals.kMaxWalls];
    public int[] gSectorExp = new int[Globals.kMaxSectors];
    public byte[] gSpriteExp = new byte[Globals.kMaxSectors + 7 >> 3];
    public POSTPONE[] gPost = new POSTPONE[Globals.kMaxSprites];
    public int gPostCount;
    public int gNextMap;
    public int foundSecret;
    public int totalSecrets;
    public int superSecrets;
    public int totalKills;
    public int kills;
    public int deliriumTilt = 0;
    public int deliriumTurn = 0;
    public int deliriumPitch = 0;
    public boolean gUserEpisode;
    public boolean gForceMap;
    public BloodIniFile addon;
    public String addonFileName;
    private String message;

    public SafeLoader() {
        this.headspritesect = new short[Engine.MAXSECTORS + 1];
        this.headspritestat = new short[1025];
        this.prevspritesect = new short[Engine.MAXSPRITES];
        this.prevspritestat = new short[Engine.MAXSPRITES];
        this.nextspritesect = new short[Engine.MAXSPRITES];
        this.nextspritestat = new short[Engine.MAXSPRITES];
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            this.sprite[i] = new SPRITE();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSECTORS) {
            this.sector[i] = new SECTOR();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxWalls) {
            this.wall[i] = new WALL();
            ++i;
        }
        i = 0;
        while (i < 8192) {
            this.kwall[i] = new Vector2();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            this.ksprite[i] = new Vector3();
            this.gPost[i] = new POSTPONE();
            ++i;
        }
        i = 0;
        while (i < 2048) {
            this.xsprite[i] = new XSPRITE();
            this.gSpriteHit[i] = new SPRITEHIT();
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.xwall[i] = new XWALL();
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.xsector[i] = new XSECTOR();
            ++i;
        }
        i = 0;
        while (i < 8) {
            this.gStartZone[i] = new ZONE();
            this.safePlayer[i] = new PLAYER();
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.siWall[i] = new WallInst();
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.siMasked[i] = new MaskedWallInst();
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.siCeiling[i] = new CeilingInst();
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.siFloor[i] = new FloorInst();
            ++i;
        }
        i = 0;
        while (i < 2048) {
            this.siSprite[i] = new SpriteInst();
            ++i;
        }
        i = 0;
        while (i < 128) {
            this.gBusy[i] = new BUSY();
            ++i;
        }
        this.safeHitInfo = new Hitscan();
    }

    public String getMessage() {
        return this.message;
    }

    public boolean load(Resource bb, int nVersion) {
        this.addon = null;
        this.addonFileName = null;
        this.message = null;
        this.gUserEpisode = false;
        try {
            int i = 0;
            while (i < 8192) {
                this.kwall[i].set(0.0f, 0.0f);
                ++i;
            }
            i = 0;
            while (i < Globals.kMaxSprites) {
                this.ksprite[i].set(0.0f, 0.0f, 0.0f);
                ++i;
            }
            Arrays.fill(this.gotpic, (byte)0);
            i = 0;
            while (i < 8) {
                this.autoaim[i] = -1;
                this.slopetilt[i] = -1;
                this.skill[i] = -1;
                this.name[i] = null;
                ++i;
            }
            if (nVersion == 256) {
                bb.seek(0L, Resource.Whence.Set);
                this.MyLoad100(bb);
                this.DudesLoad(bb);
                this.WarpLoad(bb);
                this.MirrorLoad(bb);
                this.SeqLoad(bb, nVersion);
                this.EventLoad(bb);
                this.TriggersLoad(bb);
                this.PlayersLoad(bb, nVersion);
                this.ActorsLoad(bb);
                bb.readShort();
                this.GameInfoLoad(bb);
                this.StatsLoad(bb);
                this.ScreenLoad(bb);
            } else {
                if (nVersion >= 300) {
                    bb.seek(64043L, Resource.Whence.Set);
                    this.LoadGDXBlock(bb);
                }
                this.MyLoad110(nVersion, bb);
                this.DudesLoad(bb);
                this.cheatsOn = bb.readBoolean();
                this.WarpLoad(bb);
                this.MirrorLoad(bb);
                this.SeqLoad(bb, nVersion);
                this.EventLoad(bb);
                this.TriggersLoad(bb);
                this.PlayersLoad(bb, 277);
                this.ActorsLoad(bb);
                this.GameInfoLoad(bb);
                this.StatsLoad(bb);
                this.ScreenLoad(bb);
            }
            if (this.gUserEpisode) {
                this.addon = LEVELS.levelGetEpisode(this.addonFileName);
                if (this.addon == null) {
                    this.message = "Can't find user episode file: " + this.addonFileName;
                    this.gUserEpisode = false;
                    this.safeGameInfo.nEpisode = 0;
                    this.safeGameInfo.nLevel = 16;
                    this.gForceMap = true;
                }
            }
            if (bb.position() == bb.size()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void MyLoad100(Resource bb) {
        int kMaxTiles = 4096;
        this.LoadGameInfo(bb);
        this.gFrameClock = bb.readInt();
        this.gTicks = bb.readInt();
        this.gFrame = bb.readInt();
        this.gGameClock = bb.readInt();
        this.gPaused = bb.readBoolean();
        bb.readByte();
        int i = 0;
        while (i < 8192) {
            this.kwall[i].x = bb.readInt().intValue();
            this.kwall[i].y = bb.readInt().intValue();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            this.ksprite[i].x = bb.readInt().intValue();
            this.ksprite[i].y = bb.readInt().intValue();
            this.ksprite[i].z = bb.readInt().intValue();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            this.secFloorZ[i] = bb.readInt();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            this.secCeilZ[i] = bb.readInt();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            this.floorVel[i] = bb.readInt().intValue();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            this.ceilingVel[i] = bb.readInt().intValue();
            ++i;
        }
        this.safeHitInfo.hitsect = bb.readShort();
        this.safeHitInfo.hitwall = bb.readShort();
        this.safeHitInfo.hitsprite = bb.readShort();
        this.safeHitInfo.hitx = bb.readInt();
        this.safeHitInfo.hity = bb.readInt();
        this.safeHitInfo.hitz = bb.readInt();
        this.gForceMap = bb.readBoolean();
        i = 0;
        while (i <= 1024) {
            this.nStatSize[i] = bb.readShort();
            ++i;
        }
        byte[] buf = new byte[56];
        int i2 = 0;
        while (i2 < 2048) {
            bb.read(buf);
            this.xsprite[i2].init(buf);
            this.xsprite[i2].reference = BitHandler.bsread(buf, 0, 0, 13);
            ++i2;
        }
        buf = new byte[XWALL.sizeof];
        i2 = 0;
        while (i2 < 512) {
            bb.read(buf);
            this.xwall[i2].init(buf);
            this.xwall[i2].reference = BitHandler.bsread(buf, 0, 0, 13);
            ++i2;
        }
        buf = new byte[XSECTOR.sizeof];
        i2 = 0;
        while (i2 < 512) {
            bb.read(buf);
            this.xsector[i2].init(buf);
            this.xsector[i2].reference = BitHandler.bsread(buf, 0, 0, 13);
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            this.sprXVel[i2] = bb.readInt().intValue();
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            this.sprYVel[i2] = bb.readInt().intValue();
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            this.sprZVel[i2] = bb.readInt().intValue();
            ++i2;
        }
        i2 = 0;
        while (i2 < 2048) {
            this.nextXSprite[i2] = bb.readShort().shortValue();
            ++i2;
        }
        i2 = 0;
        while (i2 < 512) {
            this.nextXWall[i2] = bb.readShort().shortValue();
            ++i2;
        }
        i2 = 0;
        while (i2 < 512) {
            this.nextXSector[i2] = bb.readShort().shortValue();
            ++i2;
        }
        bb.readInt();
        bb.readInt();
        this.gSkyCount = bb.readInt();
        this.gFogMode = bb.readBoolean();
        i2 = 0;
        while (i2 < Globals.kMaxSectors) {
            this.sector[i2].buildSector(bb);
            ++i2;
        }
        i2 = 0;
        while (i2 < 8192) {
            this.wall[i2].buildWall(bb);
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            this.sprite[i2].buildSprite(bb);
            ++i2;
        }
        this.numsectors = bb.readShort();
        this.numwalls = bb.readShort();
        this.randomseed = bb.readInt();
        bb.readByte();
        this.showinvisibility = bb.readBoolean();
        bb.readInt();
        this.parallaxyscale = bb.readInt();
        this.visibility = bb.readInt();
        this.parallaxvisibility = bb.readInt();
        i2 = 0;
        while (i2 < 256) {
            this.pskyoff[i2] = bb.readShort();
            ++i2;
        }
        this.pskybits = bb.readShort();
        i2 = 0;
        while (i2 <= Globals.kMaxSectors) {
            this.headspritesect[i2] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 <= 1024) {
            this.headspritestat[i2] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            this.prevspritesect[i2] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            this.prevspritestat[i2] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            this.nextspritesect[i2] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            this.nextspritestat[i2] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSectors + 7 >> 3) {
            this.show2dsector[i2] = bb.readByte();
            ++i2;
        }
        i2 = 0;
        while (i2 < 1024) {
            this.show2dwall[i2] = bb.readByte();
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSprites + 7 >> 3) {
            this.show2dsprite[i2] = bb.readByte();
            ++i2;
        }
        this.automapping = bb.readByte();
        i2 = 0;
        while (i2 < kMaxTiles + 7 >> 3) {
            this.gotpic[i2] = bb.readByte();
            ++i2;
        }
        i2 = 0;
        while (i2 < Globals.kMaxSectors + 7 >> 3) {
            this.gotsector[i2] = bb.readByte();
            ++i2;
        }
        this.safeGameInfo.nEnemyDamage = this.safeGameInfo.nDifficulty;
        this.safeGameInfo.nEnemyQuantity = this.safeGameInfo.nDifficulty;
        this.safeGameInfo.nPitchforkOnly = false;
        this.gInfiniteAmmo = false;
        this.cheatsOn = false;
    }

    public void MyLoad110(int nVersion, Resource bb) {
        int kMaxTiles = 6144;
        this.LoadGameInfo(bb);
        this.numsectors = bb.readShort();
        this.numwalls = bb.readShort();
        int tmp = bb.readInt();
        this.numsprites = (short)tmp;
        int i = 0;
        while (i < this.numsectors) {
            this.sector[i].buildSector(bb);
            ++i;
        }
        i = 0;
        while (i < this.numwalls) {
            this.wall[i].buildWall(bb);
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            this.sprite[i].buildSprite(bb);
            ++i;
        }
        this.randomseed = bb.readInt();
        bb.readByte();
        this.showinvisibility = bb.readBoolean();
        bb.readInt();
        this.parallaxyscale = bb.readInt();
        this.visibility = bb.readInt();
        this.parallaxvisibility = bb.readInt();
        i = 0;
        while (i < 256) {
            this.pskyoff[i] = bb.readShort();
            ++i;
        }
        this.pskybits = bb.readShort();
        i = 0;
        while (i <= Globals.kMaxSectors) {
            this.headspritesect[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i <= 1024) {
            this.headspritestat[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            this.prevspritesect[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            this.prevspritestat[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            this.nextspritesect[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites) {
            this.nextspritestat[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors + 7 >> 3) {
            this.show2dsector[i] = bb.readByte();
            ++i;
        }
        i = 0;
        while (i < 1024) {
            this.show2dwall[i] = bb.readByte();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSprites + 7 >> 3) {
            this.show2dsprite[i] = bb.readByte();
            ++i;
        }
        this.automapping = bb.readByte();
        i = 0;
        while (i < kMaxTiles + 7 >> 3) {
            this.gotpic[i] = bb.readByte();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors + 7 >> 3) {
            this.gotsector[i] = bb.readByte();
            ++i;
        }
        this.gFrameClock = bb.readInt();
        this.gTicks = bb.readInt();
        this.gFrame = bb.readInt();
        this.gGameClock = bb.readInt();
        this.gPaused = bb.readBoolean();
        bb.readByte();
        i = 0;
        while (i < this.numwalls) {
            this.kwall[i].x = bb.readInt().intValue();
            this.kwall[i].y = bb.readInt().intValue();
            ++i;
        }
        i = 0;
        while (i < this.numsprites) {
            int x = bb.readInt();
            int y = bb.readInt();
            int z = bb.readInt();
            if (i < Globals.kMaxSprites) {
                this.ksprite[i].x = x;
                this.ksprite[i].y = y;
                this.ksprite[i].z = z;
            }
            ++i;
        }
        i = 0;
        while (i < this.numsectors) {
            this.secFloorZ[i] = bb.readInt();
            ++i;
        }
        i = 0;
        while (i < this.numsectors) {
            this.secCeilZ[i] = bb.readInt();
            ++i;
        }
        i = 0;
        while (i < this.numsectors) {
            this.floorVel[i] = bb.readInt().intValue();
            ++i;
        }
        i = 0;
        while (i < this.numsectors) {
            this.ceilingVel[i] = bb.readInt().intValue();
            ++i;
        }
        this.safeHitInfo.hitsect = bb.readShort();
        this.safeHitInfo.hitwall = bb.readShort();
        this.safeHitInfo.hitsprite = bb.readShort();
        this.safeHitInfo.hitx = bb.readInt();
        this.safeHitInfo.hity = bb.readInt();
        this.safeHitInfo.hitz = bb.readInt();
        this.gForceMap = bb.readBoolean();
        bb.readByte();
        bb.readByte();
        byte[] buf = new byte[128];
        bb.read(buf, 0, 128);
        int i2 = 0;
        while (i2 <= 1024) {
            this.nStatSize[i2] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 < 2048) {
            this.nextXSprite[i2] = bb.readShort().shortValue();
            ++i2;
        }
        i2 = 0;
        while (i2 < 512) {
            this.nextXWall[i2] = bb.readShort().shortValue();
            ++i2;
        }
        i2 = 0;
        while (i2 < 512) {
            this.nextXSector[i2] = bb.readShort().shortValue();
            ++i2;
        }
        i2 = 0;
        while (i2 < 2048) {
            this.xsprite[i2].free();
            ++i2;
        }
        buf = new byte[56];
        i2 = 0;
        while (i2 < Globals.kMaxSprites) {
            if (this.sprite[i2].statnum < 1024 && this.sprite[i2].extra > 0) {
                bb.read(buf);
                this.xsprite[this.sprite[i2].extra].init(buf);
                this.xsprite[this.sprite[i2].extra].reference = BitHandler.bsread(buf, 0, 0, 13);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 512) {
            this.xwall[i2].free();
            ++i2;
        }
        buf = new byte[XWALL.sizeof];
        i2 = 0;
        while (i2 < this.numwalls) {
            if (this.wall[i2].extra > 0) {
                bb.read(buf);
                this.xwall[this.wall[i2].extra].init(buf);
                this.xwall[this.wall[i2].extra].reference = BitHandler.bsread(buf, 0, 0, 13);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 512) {
            this.xsector[i2].free();
            ++i2;
        }
        buf = new byte[XSECTOR.sizeof];
        i2 = 0;
        while (i2 < this.numsectors) {
            if (this.sector[i2].extra > 0) {
                bb.read(buf);
                this.xsector[this.sector[i2].extra].init(buf);
                this.xsector[this.sector[i2].extra].reference = BitHandler.bsread(buf, 0, 0, 13);
            }
            ++i2;
        }
        Arrays.fill(this.sprXVel, 0L);
        Arrays.fill(this.sprYVel, 0L);
        Arrays.fill(this.sprZVel, 0L);
        i2 = 0;
        while (i2 < this.numsprites) {
            int xvel = bb.readInt();
            if (i2 < Globals.kMaxSprites) {
                this.sprXVel[i2] = xvel;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numsprites) {
            int yvel = bb.readInt();
            if (i2 < Globals.kMaxSprites) {
                this.sprYVel[i2] = yvel;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numsprites) {
            int zvel = bb.readInt();
            if (i2 < Globals.kMaxSprites) {
                this.sprZVel[i2] = zvel;
            }
            ++i2;
        }
        bb.readInt();
        bb.readInt();
        this.gSkyCount = bb.readInt();
        this.gFogMode = bb.readBoolean();
        if (this.numsprites >= Globals.kMaxSprites) {
            this.numsprites = (short)(Globals.kMaxSprites - 1);
        }
        this.gNoClip = false;
        this.gFullMap = false;
        if (nVersion < 300) {
            this.safeGameInfo.nEnemyDamage = this.safeGameInfo.nDifficulty;
            this.safeGameInfo.nEnemyQuantity = this.safeGameInfo.nDifficulty;
            this.safeGameInfo.nPitchforkOnly = false;
            this.gInfiniteAmmo = false;
        }
    }

    public void LoadGameInfo(Resource bb) {
        this.safeGameInfo.nGameType = bb.readByte() & 0xFF;
        this.safeGameInfo.nDifficulty = bb.readByte() & 0xFF;
        this.safeGameInfo.nEpisode = bb.readInt();
        this.safeGameInfo.nLevel = bb.readInt();
        byte[] buf = new byte[144];
        bb.read(buf);
        String name = new String(buf).trim();
        name = Strhandler.toLowerCase(name);
        if (FileUtils.isExtension(name, "map")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        this.safeGameInfo.zLevelName = name;
        bb.read(buf);
        this.safeGameInfo.zLevelSong = new String(buf).trim();
        this.safeGameInfo.nTrackNumber = bb.readInt();
        buf = new byte[16];
        bb.read(buf);
        bb.read(buf);
        bb.readShort();
        bb.readInt();
        this.safeGameInfo.uMapCRC = bb.readInt().intValue();
        this.safeGameInfo.nMonsterSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.uGameFlags = bb.readInt();
        this.safeGameInfo.uNetGameFlags = bb.readInt();
        this.safeGameInfo.nWeaponSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.nItemSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.nRespawnSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.nTeamSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.nMonsterRespawnTime = bb.readInt();
        this.safeGameInfo.nWeaponRespawnTime = bb.readInt();
        this.safeGameInfo.nItemRespawnTime = bb.readInt();
        this.safeGameInfo.nSpecialRespawnTime = bb.readInt();
    }

    public void DudesLoad(Resource bb) {
        int i = 0;
        while (i < 2048) {
            this.cumulDamage[i] = 0;
            bb.readInt();
            ++i;
        }
        i = 0;
        while (i < 2048) {
            this.gDudeSlope[i] = bb.readInt();
            ++i;
        }
    }

    public void WarpLoad(Resource bb) {
        int i = 0;
        while (i < 8) {
            this.gStartZone[i].x = bb.readInt().intValue();
            this.gStartZone[i].y = bb.readInt().intValue();
            this.gStartZone[i].z = bb.readInt().intValue();
            this.gStartZone[i].sector = bb.readShort();
            this.gStartZone[i].angle = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            this.gUpperLink[i] = bb.readShort().shortValue();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            this.gLowerLink[i] = bb.readShort().shortValue();
            ++i;
        }
    }

    public void MirrorLoad(Resource bb) {
        this.mirrorcnt = bb.readInt();
        this.MirrorSector = bb.readInt();
        int i = 0;
        while (i < 16) {
            this.MirrorType[i] = bb.readShort().shortValue();
            bb.readShort();
            this.MirrorLower[i] = bb.readInt();
            this.MirrorX[i] = bb.readInt();
            this.MirrorY[i] = bb.readInt();
            this.MirrorZ[i] = bb.readInt();
            this.MirrorUpper[i] = bb.readInt();
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.MirrorWall[i] = bb.readInt();
            ++i;
        }
    }

    public void SeqLoad(Resource bb, int nVersion) throws FileNotFoundException {
        int i = 0;
        while (i < 512) {
            this.siWall[i].load(bb);
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.siMasked[i].load(bb);
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.siCeiling[i].load(bb);
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.siFloor[i].load(bb);
            ++i;
        }
        i = 0;
        while (i < 2048) {
            this.siSprite[i].load(bb);
            ++i;
        }
        int len = SeqHandling.kMaxSequences;
        if (nVersion < 302) {
            len = 1024;
        }
        Arrays.fill(this.actListType, (byte)0);
        Arrays.fill(this.actListIndex, (short)0);
        int i2 = 0;
        while (i2 < len) {
            this.actListType[i2] = bb.readByte();
            this.actListIndex[i2] = bb.readShort();
            ++i2;
        }
        this.activeCount = bb.readInt();
        i2 = 0;
        while (i2 < this.activeCount) {
            SeqInst pInst = this.GetInstance(this.actListType[i2], this.actListIndex[i2]);
            if (pInst.isPlaying() && !BuildGdx.cache.contains(pInst.getSeqIndex(), "SEQ")) {
                throw new FileNotFoundException("hSeq != null, id=" + pInst.getSeqIndex() + " \n\rWrong Blood.RFF version or file corrupt!");
            }
            ++i2;
        }
    }

    public SeqInst GetInstance(int type, int nXIndex) {
        switch (type) {
            case 0: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siWall[nXIndex];
            }
            case 1: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siCeiling[nXIndex];
            }
            case 2: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siFloor[nXIndex];
            }
            case 3: {
                if (nXIndex <= 0 || nXIndex >= 2048) {
                    return null;
                }
                return this.siSprite[nXIndex];
            }
            case 4: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siMasked[nXIndex];
            }
        }
        return null;
    }

    public void EventLoad(Resource bb) {
        int i = 0;
        while (i < 1025) {
            this.qEventPriority[i] = bb.readInt();
            this.qEventEvent[i] = bb.readInt();
            ++i;
        }
        this.fNodeCount = bb.readInt();
        i = 0;
        while (i < 4096) {
            int data = bb.readInt();
            this.rxBucketIndex[i] = EVENT.getIndex(data);
            this.rxBucketType[i] = EVENT.getType(data);
            ++i;
        }
        i = 0;
        while (i <= 1024) {
            this.bucketHead[i] = bb.readShort();
            ++i;
        }
    }

    public void TriggersLoad(Resource bb) {
        this.gBusyCount = bb.readInt();
        int i = 0;
        while (i < 128) {
            this.gBusy[i].nIndex = bb.readInt();
            this.gBusy[i].nDelta = bb.readInt();
            this.gBusy[i].nBusy = bb.readInt();
            this.gBusy[i].busyProc = bb.readByte() & 0xFF;
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            this.secPath[i] = bb.readInt();
            ++i;
        }
    }

    public void PlayersLoad(Resource bb, int nVersion) {
        int i = 0;
        while (i < 8) {
            this.nTeamCount[i] = bb.readInt();
            ++i;
        }
        this.gNetPlayers = bb.readInt();
        i = 0;
        while (i < this.gNetPlayers - 1) {
            this.connectpoint2[i] = (short)(i + 1);
            ++i;
        }
        this.connectpoint2[this.gNetPlayers - 1] = -1;
        byte[] plname = new byte[15];
        int i2 = 0;
        while (i2 < 8) {
            this.autoaim[i2] = bb.readByte();
            if (nVersion >= 302) {
                this.slopetilt[i2] = bb.readByte();
            }
            this.skill[i2] = bb.readByte();
            bb.read(plname);
            this.name[i2] = new String(plname).trim();
            ++i2;
        }
        byte[] input = new byte[INPUT.sizeof(nVersion)];
        int i3 = 0;
        while (i3 < 8) {
            bb.readInt();
            bb.readInt();
            bb.readInt();
            bb.read(input);
            this.safePlayer[i3].pInput = new INPUT(input, nVersion);
            this.safePlayer[i3].set(bb, nVersion);
            ++i3;
        }
    }

    public void ActorsLoad(Resource bb) {
        int i = 0;
        while (i < 2048) {
            this.gSpriteHit[i].moveHit = bb.readInt();
            this.gSpriteHit[i].ceilHit = bb.readInt();
            this.gSpriteHit[i].floorHit = bb.readInt();
            ++i;
        }
        i = 0;
        while (i < Globals.kMaxSectors) {
            this.gSectorExp[i] = bb.readShort().shortValue();
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.gWallExp[i] = bb.readShort().shortValue();
            ++i;
        }
        this.gPostCount = bb.readInt();
        i = 0;
        while (i < Globals.kMaxSprites) {
            this.gPost[i].nSprite = bb.readShort();
            this.gPost[i].nStatus = bb.readShort();
            ++i;
        }
    }

    public void GameInfoLoad(Resource bb) {
        this.gNextMap = bb.readInt();
        bb.readShort();
        this.LoadGameInfo(bb);
        bb.readByte();
        bb.readByte();
    }

    public void StatsLoad(Resource bb) {
        this.totalSecrets = bb.readInt();
        this.foundSecret = bb.readInt();
        this.superSecrets = bb.readInt();
        this.totalKills = bb.readInt();
        this.kills = bb.readInt();
    }

    public void ScreenLoad(Resource bb) {
        bb.readInt();
        byte[] buf = new byte[256];
        bb.read(buf);
        bb.readShort();
        bb.readShort();
        bb.readInt();
        this.deliriumTilt = bb.readInt();
        this.deliriumTurn = bb.readInt();
        this.deliriumPitch = bb.readInt();
    }

    public void LoadUserEpisodeInfo(Resource bb) {
        this.gUserEpisode = bb.readBoolean();
        if (this.gUserEpisode) {
            byte[] buf = new byte[144];
            bb.read(buf);
            this.addonFileName = Strhandler.toLowerCase(new String(buf).trim());
        }
    }

    public void LoadGDXBlock(Resource bb) {
        this.LoadUserEpisodeInfo(bb);
        byte[] data = new byte[128];
        bb.read(data);
        int pos = 0;
        this.safeGameInfo.nEnemyDamage = data[pos++];
        this.safeGameInfo.nEnemyQuantity = data[pos++];
        this.safeGameInfo.nDifficulty = data[pos++];
        this.safeGameInfo.nPitchforkOnly = data[pos++] == 1;
        this.gInfiniteAmmo = data[pos++] == 1;
    }

    public BloodIniFile LoadGDXHeader(Resource fil) {
        this.addon = null;
        this.addonFileName = null;
        this.message = null;
        this.gUserEpisode = false;
        this.safeGameInfo.nDifficulty = -1;
        this.safeGameInfo.nEpisode = -1;
        this.safeGameInfo.nLevel = -1;
        try {
            fil.seek(64043L, Resource.Whence.Set);
            this.LoadUserEpisodeInfo(fil);
            fil.seek(128L, Resource.Whence.Current);
            this.LoadGameInfo(fil);
            if (this.gUserEpisode) {
                this.addon = LEVELS.levelGetEpisode(this.addonFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.addon;
    }
}

