/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;

public class Warp {
    public static ZONE[] gStartZone = new ZONE[8];
    public static ZONE[] gStartZoneTeam1 = new ZONE[8];
    public static ZONE[] gStartZoneTeam2 = new ZONE[8];
    public static int[] gUpperLink = new int[Globals.kMaxSectors];
    public static int[] gLowerLink = new int[Globals.kMaxSectors];
    public static boolean gTeamsSpawnUsed = false;
    public static long checkWx;
    public static long checkWy;
    public static long checkWz;
    public static short checkWs;

    public static void InitPlayerStartZones() {
        short nXSprite;
        int nSector = 0;
        while (nSector < Globals.kMaxSectors) {
            Warp.gUpperLink[nSector] = -1;
            Warp.gLowerLink[nSector] = -1;
            ++nSector;
        }
        int team1 = 0;
        int team2 = 0;
        int nSprite = 0;
        while (nSprite < Globals.kMaxSprites) {
            if (Engine.sprite[nSprite].statnum < 1024) {
                SPRITE pSprite = Engine.sprite[nSprite];
                nXSprite = pSprite.extra;
                if (nXSprite > 0) {
                    XSPRITE pXSprite = DB.xsprite[nXSprite];
                    switch (pSprite.lotag) {
                        case 1: {
                            ZONE pZone;
                            if (Globals.pGameInfo.nGameType < 2 && pXSprite.data1 >= 0 && pXSprite.data1 < 8) {
                                pZone = gStartZone[pXSprite.data1];
                                pZone.x = pSprite.x;
                                pZone.y = pSprite.y;
                                pZone.z = pSprite.z;
                                pZone.sector = pSprite.sectnum;
                                pZone.angle = pSprite.ang;
                            }
                            DB.deletesprite((short)nSprite);
                            break;
                        }
                        case 2: {
                            ZONE pZone;
                            if (pXSprite.data1 >= 0 && pXSprite.data1 < 8 && Globals.pGameInfo.nGameType >= 2) {
                                pZone = gStartZone[pXSprite.data1];
                                pZone.x = pSprite.x;
                                pZone.y = pSprite.y;
                                pZone.z = pSprite.z;
                                pZone.sector = pSprite.sectnum;
                                pZone.angle = pSprite.ang;
                                if (Globals.pGameInfo.nGameType == 3) {
                                    if (pXSprite.data2 == 1) {
                                        pZone = gStartZoneTeam1[team1];
                                        pZone.x = pSprite.x;
                                        pZone.y = pSprite.y;
                                        pZone.z = pSprite.z;
                                        pZone.sector = pSprite.sectnum;
                                        pZone.angle = pSprite.ang;
                                        ++team1;
                                    } else if (pXSprite.data2 == 2) {
                                        pZone = gStartZoneTeam2[team2];
                                        pZone.x = pSprite.x;
                                        pZone.y = pSprite.y;
                                        pZone.z = pSprite.z;
                                        pZone.sector = pSprite.sectnum;
                                        pZone.angle = pSprite.ang;
                                        ++team2;
                                    }
                                }
                            }
                            DB.deletesprite((short)nSprite);
                            break;
                        }
                        case 7: {
                            Warp.gUpperLink[pSprite.sectnum] = (short)nSprite;
                            pSprite.cstat = (short)(pSprite.cstat | 0x8800);
                            pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                            break;
                        }
                        case 6: {
                            Warp.gLowerLink[pSprite.sectnum] = (short)nSprite;
                            pSprite.cstat = (short)(pSprite.cstat | 0x8800);
                            pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                            break;
                        }
                        case 9: 
                        case 11: 
                        case 13: {
                            Warp.gUpperLink[pSprite.sectnum] = (short)nSprite;
                            pSprite.cstat = (short)(pSprite.cstat | 0x8800);
                            pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                            pSprite.z = Main.engine.getflorzofslope(pSprite.sectnum, pSprite.x, pSprite.y);
                            break;
                        }
                        case 10: 
                        case 12: 
                        case 14: {
                            Warp.gLowerLink[pSprite.sectnum] = (short)nSprite;
                            pSprite.cstat = (short)(pSprite.cstat | 0x8800);
                            pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                            pSprite.z = Main.engine.getceilzofslope(pSprite.sectnum, pSprite.x, pSprite.y);
                        }
                    }
                }
            }
            ++nSprite;
        }
        if (team1 > 0 || team2 > 0) {
            gTeamsSpawnUsed = true;
            if (team1 < 4 || team2 < 4) {
                Main.game.GameMessage("At least 4 spawn positions for each team is recommended.");
            }
        }
        int nFrom = 0;
        while (nFrom < Globals.kMaxSectors) {
            if (gUpperLink[nFrom] >= 0) {
                SPRITE pFromSprite = Engine.sprite[gUpperLink[nFrom]];
                nXSprite = pFromSprite.extra;
                if (nXSprite <= 0 || nXSprite >= 2048) {
                    Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
                }
                XSPRITE pXSprite = DB.xsprite[nXSprite];
                short nID = pXSprite.data1;
                int nTo = 0;
                while (nTo < Globals.kMaxSectors) {
                    if (gLowerLink[nTo] >= 0) {
                        SPRITE pToSprite = Engine.sprite[gLowerLink[nTo]];
                        nXSprite = pToSprite.extra;
                        if (nXSprite <= 0 || nXSprite >= 2048) {
                            Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
                        }
                        if (DB.xsprite[nXSprite].data1 == nID) {
                            pFromSprite.owner = (short)gLowerLink[nTo];
                            pToSprite.owner = (short)gUpperLink[nFrom];
                        }
                    }
                    ++nTo;
                }
            }
            ++nFrom;
        }
    }

    public static int checkWarping(SPRITE pSprite) {
        int nUpper = gUpperLink[pSprite.sectnum];
        int nLower = gLowerLink[pSprite.sectnum];
        if (nUpper >= 0) {
            SPRITE pUpper = Engine.sprite[nUpper];
            int uz = pUpper.lotag != 7 ? Main.engine.getflorzofslope(pSprite.sectnum, pSprite.x, pSprite.y) : pUpper.z;
            if (uz <= pSprite.z) {
                nLower = Engine.sprite[nUpper].owner;
                if (nLower < 0 || nLower >= Globals.kMaxSprites) {
                    return 0;
                }
                if (Engine.sprite[nLower].sectnum < 0 || Engine.sprite[nLower].sectnum >= Globals.kMaxSectors) {
                    Main.game.dassert("sprite[nLower].sectnum >= 0 && sprite[nLower].sectnum < kMaxSectors");
                }
                DB.changespritesect(pSprite.xvel, Engine.sprite[nLower].sectnum);
                pSprite.x += Engine.sprite[nLower].x - Engine.sprite[nUpper].x;
                pSprite.y += Engine.sprite[nLower].y - Engine.sprite[nUpper].y;
                int lz = Engine.sprite[nLower].lotag == 6 ? Engine.sprite[nLower].z : Main.engine.getceilzofslope(pSprite.sectnum, pSprite.x, pSprite.y);
                pSprite.z += lz - uz;
                Main.game.pInt.clearspriteinterpolate(pSprite.xvel);
                return Engine.sprite[nUpper].lotag;
            }
        }
        if (nLower >= 0) {
            SPRITE pLower = Engine.sprite[nLower];
            int lz = pLower.lotag != 6 ? Main.engine.getceilzofslope(pSprite.sectnum, pSprite.x, pSprite.y) : pLower.z;
            if (lz >= pSprite.z) {
                nUpper = Engine.sprite[nLower].owner;
                if (nUpper < 0 || nUpper >= Globals.kMaxSprites) {
                    return 0;
                }
                if (Engine.sprite[nUpper].sectnum < 0 || Engine.sprite[nUpper].sectnum >= Globals.kMaxSectors) {
                    Main.game.dassert("sprite[nUpper].sectnum >= 0 && sprite[nUpper].sectnum < kMaxSectors");
                }
                DB.changespritesect(pSprite.xvel, Engine.sprite[nUpper].sectnum);
                pSprite.x += Engine.sprite[nUpper].x - Engine.sprite[nLower].x;
                pSprite.y += Engine.sprite[nUpper].y - Engine.sprite[nLower].y;
                int uz = Engine.sprite[nUpper].lotag == 7 ? Engine.sprite[nUpper].z : Main.engine.getflorzofslope(pSprite.sectnum, pSprite.x, pSprite.y);
                pSprite.z += uz - lz;
                Main.game.pInt.clearspriteinterpolate(pSprite.xvel);
                return Engine.sprite[nLower].lotag;
            }
        }
        return 0;
    }

    public static int checkWarping(long x, long y, long z, int nSector) {
        if (nSector != -1) {
            int nUpper = gUpperLink[nSector];
            int nLower = gLowerLink[nSector];
            if (nUpper >= 0) {
                SPRITE pUpper = Engine.sprite[nUpper];
                int uz = pUpper.lotag != 7 ? Main.engine.getflorzofslope((short)nSector, (int)x, (int)y) : pUpper.z;
                if ((long)uz <= z) {
                    if (nLower < 0 || nLower >= Globals.kMaxSprites) {
                        return 0;
                    }
                    if (Engine.sprite[nLower].sectnum < 0 || Engine.sprite[nLower].sectnum >= Globals.kMaxSectors) {
                        Main.game.dassert("sprite[nLower].sectnum >= 0 && sprite[nLower].sectnum < kMaxSectors");
                    }
                    nSector = Engine.sprite[nUpper].sectnum;
                    int lz = Engine.sprite[nLower].lotag == 6 ? Engine.sprite[nLower].z : Main.engine.getceilzofslope((short)nSector, (int)(x += (long)(Engine.sprite[nLower].x - Engine.sprite[nUpper].x)), (int)(y += (long)(Engine.sprite[nLower].y - Engine.sprite[nUpper].y)));
                    checkWx = x;
                    checkWy = y;
                    checkWz = z += (long)(lz - uz);
                    checkWs = (short)nSector;
                    return Engine.sprite[nUpper].lotag;
                }
            }
            if (nLower >= 0) {
                SPRITE pLower = Engine.sprite[nLower];
                int lz = pLower.lotag != 6 ? Main.engine.getceilzofslope((short)nSector, (int)x, (int)y) : pLower.z;
                if ((long)lz >= z) {
                    nUpper = Engine.sprite[nLower].owner;
                    if (nUpper < 0 || nUpper >= Globals.kMaxSprites) {
                        return 0;
                    }
                    if (Engine.sprite[nUpper].sectnum < 0 || Engine.sprite[nUpper].sectnum >= Globals.kMaxSectors) {
                        Main.game.dassert("sprite[nUpper].sectnum >= 0 && sprite[nUpper].sectnum < kMaxSectors");
                    }
                    nSector = Engine.sprite[nUpper].sectnum;
                    int uz = Engine.sprite[nUpper].lotag == 7 ? Engine.sprite[nUpper].z : Main.engine.getflorzofslope((short)nSector, (int)(x += (long)(Engine.sprite[nUpper].x - Engine.sprite[nLower].x)), (int)(y += (long)(Engine.sprite[nUpper].y - Engine.sprite[nLower].y)));
                    checkWx = x;
                    checkWy = y;
                    checkWz = z += (long)(uz - lz);
                    checkWs = (short)nSector;
                    return Engine.sprite[nLower].lotag;
                }
            }
        }
        checkWx = x;
        checkWy = y;
        checkWz = z;
        checkWs = (short)nSector;
        return 0;
    }
}

