/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;

public class BuildMenu {
    public short m_nItems = 0;
    public short m_nFocus = (short)-1;
    public short m_nFirst = (short)-1;
    public MenuItem[] m_pItems;
    public final short nMaxGameMenuItems = (short)32;

    public BuildMenu() {
        this.m_pItems = new MenuItem[32];
    }

    public int addItem(MenuItem pItem, boolean nFirstItem) {
        if (pItem == null) {
            return -1;
        }
        this.m_pItems[this.m_nItems] = pItem;
        pItem.m_pMenu = this;
        if (nFirstItem) {
            this.m_nFirst = this.m_nItems;
            this.m_nFocus = this.m_nItems;
        }
        this.m_nItems = (short)(this.m_nItems + 1);
        return this.m_nItems;
    }

    public int removeItem(MenuItem pItem) {
        if (pItem == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_nItems) {
            if (this.m_pItems[i] == pItem) {
                int pos = i;
                while (pos < this.m_nItems) {
                    MenuItem menuItem = this.m_pItems[pos++] = pos < this.m_nItems ? this.m_pItems[pos] : null;
                }
                this.m_nItems = (short)(this.m_nItems - 1);
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int open(MenuHandler handler, int nItem) {
        if (nItem >= 0 && nItem < 32 && this.mCheckItemsFlags(nItem)) {
            this.m_nFocus = this.m_nFirst = (short)nItem;
        }
        this.mLoadRes(handler, MenuHandler.MenuOpt.Open);
        return 1;
    }

    public boolean mLoadRes(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (this.m_nItems <= 0) {
            return true;
        }
        if (this.m_nFocus >= 0 && this.m_pItems[this.m_nFocus] != null) {
            handler.mSound(this.m_pItems[this.m_nFocus], opt);
        }
        switch (opt) {
            case Open: {
                if (this.m_nFirst >= 0) {
                    this.m_nFocus = this.m_nFirst;
                }
                int i = 0;
                while (i < this.m_nItems) {
                    this.m_pItems[i].open();
                    ++i;
                }
                return false;
            }
            case Close: {
                int i = 0;
                while (i < this.m_nItems) {
                    this.m_pItems[i].close();
                    ++i;
                }
                return false;
            }
        }
        if (this.m_nFocus >= 0 && this.mCheckItemsFlags(this.m_nFocus)) {
            return this.m_pItems[this.m_nFocus].callback(handler, opt);
        }
        return false;
    }

    protected boolean mCheckItemsFlags(int nItem) {
        if (nItem < 0 || nItem >= 32 || this.m_pItems[nItem] == null) {
            return false;
        }
        MenuItem pItem = this.m_pItems[nItem];
        return (pItem.flags & 1) != 0 && (pItem.flags & 2) != 0;
    }

    public boolean mCheckMouseFlag(int nItem) {
        if (nItem < 0 || nItem >= 32 || this.m_pItems[nItem] == null) {
            return false;
        }
        MenuItem pItem = this.m_pItems[nItem];
        return (pItem.flags & 2) != 0;
    }

    public boolean mGetFocusedItem(MenuItem m_pItem) {
        if (this.m_nFocus >= 0 && this.m_nFocus < 32) {
            return m_pItem == this.m_pItems[this.m_nFocus];
        }
        return false;
    }

    public void mDraw(MenuHandler handler) {
        int i = 0;
        while (i < this.m_nItems) {
            if (i == this.m_nFocus || i != this.m_nFocus && (this.m_pItems[i].flags & 8) == 0) {
                this.m_pItems[i].draw(handler);
            }
            ++i;
        }
    }

    public int mNavUp() {
        int nItem;
        do {
            if ((nItem = this.m_nFocus - 1) < 0) {
                nItem += this.m_nItems;
            }
            this.m_nFocus = (short)nItem;
        } while (!this.mCheckItemsFlags(nItem));
        return nItem;
    }

    public int mNavDown() {
        int nItem;
        do {
            if ((nItem = this.m_nFocus + 1) >= this.m_nItems) {
                nItem = 0;
            }
            this.m_nFocus = (short)nItem;
        } while (!this.mCheckItemsFlags(nItem));
        return nItem;
    }

    public boolean mNavigation(MenuHandler.MenuOpt opt) {
        switch (opt) {
            case UP: {
                this.mNavUp();
                return false;
            }
            case DW: {
                this.mNavDown();
                return false;
            }
            case ESC: 
            case RMB: {
                return true;
            }
        }
        return false;
    }
}

