/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuScroller;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;

public abstract class BuildMenuList
extends BuildMenu {
    protected MenuItemList list;
    private BuildGame app;

    public BuildMenuList(BuildGame app, String title, int x, int y, int width, int step, int nShowElements) {
        this.app = app;
        super.addItem(this.getTitle(app, title), false);
        this.list = new MenuItemList(x, y, width, step, nShowElements);
        super.addItem(this.list, true);
    }

    protected void addScroller(MenuScroller scroller) {
        if (scroller != null) {
            super.addItem(scroller, false);
        }
    }

    @Override
    public int addItem(MenuItem pItem, boolean nFirstItem) {
        if (pItem == null) {
            return -1;
        }
        return this.list.addItem(pItem, nFirstItem);
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean mGetFocusedItem(MenuItem m_pItem) {
        if (!super.mGetFocusedItem(m_pItem) && this.list.l_nFocus >= 0 && this.list.l_nFocus < this.list.m_pItems.size()) {
            return m_pItem == this.list.m_pItems.get(this.list.l_nFocus);
        }
        return false;
    }

    @Override
    public boolean mLoadRes(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (this.list.l_nFocus >= 0 && this.list.m_pItems.size() > 0) {
            MenuItem pItem = this.list.m_pItems.get(this.list.l_nFocus);
            if ((pItem.flags & 2) != 0 && (pItem instanceof MenuSlider || pItem instanceof MenuScroller) && this.app.pInput.ctrlKeyPressed(226)) {
                opt = MenuHandler.MenuOpt.LMB;
            }
        }
        if (this.list.l_OldMouseFocus != this.list.l_nFocus) {
            opt = MenuHandler.MenuOpt.MCHANGE;
            this.list.l_OldMouseFocus = this.list.l_nFocus;
        }
        return super.mLoadRes(handler, opt);
    }

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public class MenuItemList
    extends MenuList {
        protected List<MenuItem> m_pItems;
        protected int l_step;
        protected MenuScroller scroller;
        protected int l_OldMouseFocus;

        public MenuItemList(int x, int y, int width, int step, int nShowElements) {
            super(null, null, x, y, width, 0, null, null, nShowElements);
            this.m_pItems = new ArrayList<MenuItem>();
            this.l_step = step;
            this.scroller = null;
            this.l_OldMouseFocus = 0;
        }

        @Override
        public int mFontOffset() {
            return this.l_step;
        }

        public int addItem(final MenuItem pItem, boolean nFirstItem) {
            if (pItem == null) {
                return -1;
            }
            pItem.m_pMenu = BuildMenuList.this;
            this.m_pItems.add(pItem);
            if (nFirstItem) {
                short s = (short)(this.m_pItems.size() - 1);
                this.l_nMin = s;
                this.l_nFocus = s;
            }
            pItem.listener = new MenuItem.FocusListener(){

                @Override
                public boolean isFocused() {
                    return MenuItemList.this.m_pItems.indexOf(pItem) == MenuItemList.this.l_nFocus;
                }
            };
            if (this.scroller == null && this.m_pItems.size() > this.nListItems) {
                this.scroller = new MenuScroller(((BuildMenuList)BuildMenuList.this).app.pSlider, this, this.width + this.x - ((BuildMenuList)BuildMenuList.this).app.pSlider.getScrollerWidth());
                BuildMenuList.this.addScroller(this.scroller);
            }
            this.len = this.m_pItems.size();
            return this.len;
        }

        public int removeItem(MenuItem pItem) {
            if (pItem == null) {
                return -1;
            }
            int i = this.m_pItems.indexOf(pItem);
            if (i != -1 && this.m_pItems.remove(i) == pItem) {
                return i;
            }
            return -1;
        }

        public void clear() {
            this.m_pItems.clear();
            this.len = 0;
            this.l_nMin = 0;
            this.l_nFocus = 0;
            this.l_OldMouseFocus = 0;
            if (this.scroller != null) {
                BuildMenuList.this.removeItem(this.scroller);
                this.scroller = null;
            }
        }

        @Override
        public void draw(MenuHandler handler) {
            if (this.m_pItems.size() > 0) {
                int px = this.x;
                int py = this.y;
                int i = this.l_nMin;
                while (i >= 0 && i < this.l_nMin + this.nListItems && i < this.len) {
                    MenuItem pItem = this.m_pItems.get(i);
                    pItem.x = px;
                    pItem.y = py;
                    pItem.draw(handler);
                    py += this.l_step;
                    ++i;
                }
            }
        }

        @Override
        protected void ListLeft(MenuHandler handler) {
            MenuItem pItem = this.m_pItems.get(this.l_nFocus);
            if ((pItem.flags & 4) != 0) {
                pItem.callback(handler, MenuHandler.MenuOpt.LEFT);
            }
        }

        @Override
        protected void ListRight(MenuHandler handler) {
            MenuItem pItem = this.m_pItems.get(this.l_nFocus);
            if ((pItem.flags & 4) != 0) {
                pItem.callback(handler, MenuHandler.MenuOpt.RIGHT);
            }
        }

        @Override
        protected void ListEscape(MenuHandler handler, MenuHandler.MenuOpt opt) {
            this.l_nMin = 0;
            this.l_nFocus = 0;
        }

        @Override
        protected void ListCallback(MenuHandler handler, MenuHandler.MenuOpt opt) {
            MenuItem pItem = this.m_pItems.get(this.l_nFocus);
            if ((pItem.flags & 4) != 0) {
                pItem.callback(handler, opt);
            }
        }

        @Override
        protected void ListDefault(MenuHandler handler, MenuHandler.MenuOpt opt) {
            this.ListCallback(handler, opt);
        }

        @Override
        public boolean mouseAction(int mx, int my) {
            if (this.len > 0) {
                int i = this.l_nMin;
                while (i >= 0 && i < this.l_nMin + this.nListItems && i < this.len) {
                    MenuItem pItem = this.m_pItems.get(i);
                    if ((pItem.flags & 2) != 0 && pItem.mouseAction(mx, my)) {
                        this.l_OldMouseFocus = this.l_nFocus;
                        this.l_nFocus = i;
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        protected boolean mCheckListItemsFlags(int nItem) {
            if (nItem < 0 || nItem >= this.m_pItems.size() || this.m_pItems.get(nItem) == null) {
                return false;
            }
            MenuItem pItem = this.m_pItems.get(nItem);
            return (pItem.flags & 1) != 0 && (pItem.flags & 2) != 0;
        }

        @Override
        protected void ListUp(MenuHandler handler, int len) {
            do {
                super.ListUp(handler, len);
            } while (!this.mCheckListItemsFlags(this.l_nFocus));
        }

        @Override
        protected void ListDown(MenuHandler handler, int len) {
            do {
                super.ListDown(handler, len);
            } while (!this.mCheckListItemsFlags(this.l_nFocus));
        }

        @Override
        protected void ListEnd(MenuHandler handler, int len) {
            super.ListEnd(handler, len);
            if (!this.mCheckListItemsFlags(this.l_nFocus)) {
                this.ListUp(handler, len);
            }
        }

        @Override
        protected void ListHome(MenuHandler handler) {
            super.ListHome(handler);
            if (!this.mCheckListItemsFlags(this.l_nFocus)) {
                this.ListDown(handler, this.len);
            }
        }

        @Override
        protected void ListPGUp(MenuHandler handler) {
            super.ListPGUp(handler);
            if (!this.mCheckListItemsFlags(this.l_nFocus)) {
                this.ListDown(handler, this.len);
            }
        }

        @Override
        protected void ListPGDown(MenuHandler handler, int len) {
            super.ListPGDown(handler, len);
            if (!this.mCheckListItemsFlags(this.l_nFocus)) {
                this.ListUp(handler, len);
            }
        }
    }
}

