/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.graphics.Pixmap;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Render.TextureHandle.TileData;

public class PixmapTileData
extends TileData {
    private Pixmap pixmap;
    private boolean clamped;
    private int width;
    private int height;

    public PixmapTileData(Pixmap pixmap, boolean clamped, int expflag) {
        this.pixmap = pixmap;
        this.clamped = clamped;
        this.width = pixmap.getWidth();
        this.height = pixmap.getHeight();
        int xsiz = this.width;
        int ysiz = this.height;
        if ((expflag & 1) != 0) {
            xsiz = this.calcSize(this.width);
        }
        if ((expflag & 2) != 0) {
            ysiz = this.calcSize(this.height);
        }
        if (xsiz != this.width || ysiz != this.height) {
            Pixmap npix = new Pixmap(xsiz, ysiz, pixmap.getFormat());
            npix.setFilter(Pixmap.Filter.NearestNeighbour);
            if (!clamped) {
                int x = 0;
                while (x < xsiz) {
                    int y = 0;
                    while (y < ysiz) {
                        npix.drawPixmap(pixmap, x, y);
                        y += this.height;
                    }
                    x += this.width;
                }
            } else {
                npix.drawPixmap(pixmap, 0, 0);
            }
            pixmap.dispose();
            this.pixmap = npix;
        }
    }

    @Override
    public boolean hasAlpha() {
        return this.pixmap.getFormat() == Pixmap.Format.RGBA4444 || this.pixmap.getFormat() == Pixmap.Format.RGBA8888;
    }

    @Override
    public boolean isClamped() {
        return this.clamped;
    }

    public int getTileWidth() {
        return this.width;
    }

    public int getTileHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.pixmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.pixmap.getHeight();
    }

    @Override
    public ByteBuffer getPixels() {
        return this.pixmap.getPixels();
    }

    @Override
    public int getGLType() {
        return this.pixmap.getGLType();
    }

    @Override
    public int getGLInternalFormat() {
        return this.pixmap.getGLInternalFormat();
    }

    @Override
    public int getGLFormat() {
        return this.pixmap.getGLFormat();
    }

    @Override
    public boolean isHighTile() {
        return true;
    }

    @Override
    public TileData.PixelFormat getPixelFormat() {
        return TileData.PixelFormat.Rgb;
    }

    @Override
    public void dispose() {
        this.pixmap.dispose();
    }
}

