/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.TextureBuffer;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.Tile;

public class RGBTileData
extends TileData {
    public final TextureBuffer data;
    public final boolean hasalpha;
    public final int width;
    public final int height;
    public final boolean clamped;

    public RGBTileData(Tile tile, int dapal, boolean clamped, boolean alpha, int expflag) {
        byte[] data = tile.data;
        int tsizx = tile.getWidth();
        int tsizy = tile.getHeight();
        if (data != null && (data.length == 0 || tile.getSize() > data.length)) {
            data = null;
        }
        int xsiz = tsizx;
        int ysiz = tsizy;
        if ((expflag & 1) != 0) {
            xsiz = this.calcSize(tsizx);
        }
        if ((expflag & 2) != 0) {
            ysiz = this.calcSize(tsizy);
        }
        TextureBuffer buffer = RGBTileData.getTmpBuffer(xsiz * ysiz * 4);
        buffer.clear();
        boolean hasalpha = false;
        if (data == null) {
            buffer.putInt(0, 0);
            tsizy = 1;
            tsizx = 1;
            hasalpha = true;
        } else {
            if (alpha) {
                int i = 0;
                while (i < data.length) {
                    if (data[i] == -1) {
                        hasalpha = true;
                        break;
                    }
                    ++i;
                }
            }
            int pix_len = this.getPixelFormat().getLength();
            int dptr = 0;
            int sptr = 0;
            int xoffs = xsiz * pix_len;
            if (clamped) {
                int y = ysiz - 1;
                while (y >= 0) {
                    sptr = y >= tsizy ? 0 : tsizx;
                    dptr = (xsiz * y + (sptr - 1)) * pix_len;
                    int x = sptr;
                    while (x < xsiz) {
                        buffer.putInt(dptr += pix_len, 0);
                        ++x;
                    }
                    --y;
                }
                sptr = 0;
                int i = 0;
                while (i < tsizx * pix_len) {
                    dptr = i;
                    int j = 0;
                    while (j < tsizy) {
                        buffer.putInt(dptr, this.getColor(data[sptr++], dapal, alpha));
                        dptr += xoffs;
                        ++j;
                    }
                    i += pix_len;
                }
                hasalpha = true;
            } else {
                int len = data.length;
                int i = 0;
                while (i < xoffs) {
                    int p = 0;
                    dptr = i;
                    int j = 0;
                    while (j < ysiz) {
                        buffer.putInt(dptr, this.getColor(data[sptr + p++], dapal, alpha));
                        dptr += xoffs;
                        if (p >= tsizy) {
                            p = 0;
                        }
                        ++j;
                    }
                    if ((sptr += tsizy) >= len) {
                        sptr = 0;
                    }
                    i += pix_len;
                }
            }
            if (data != null && hasalpha && !GLSettings.textureFilter.get().retro) {
                this.fixtransparency(buffer, tsizx, tsizy, xsiz, ysiz, clamped);
            }
        }
        this.width = xsiz;
        this.height = ysiz;
        this.hasalpha = hasalpha;
        this.data = buffer;
        this.clamped = clamped;
    }

    @Override
    public int getGLType() {
        return 5121;
    }

    @Override
    public ByteBuffer getPixels() {
        return this.data.getBuffer();
    }

    @Override
    public int getGLInternalFormat() {
        return this.hasalpha ? 6408 : 6407;
    }

    @Override
    public int getGLFormat() {
        return 6408;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public TileData.PixelFormat getPixelFormat() {
        return TileData.PixelFormat.Rgba;
    }

    protected int getColor(int dacol, int dapal, boolean alphaMode) {
        if (alphaMode && (dacol &= 0xFF) == 255) {
            return Engine.curpalette.getRGBA(0, (byte)0);
        }
        if (dacol >= Engine.palookup[dapal].length) {
            return 0;
        }
        dacol = Engine.palookup[dapal][dacol] & 0xFF;
        return Engine.curpalette.getRGBA(dacol, (byte)-1);
    }

    protected void fixtransparency(TextureBuffer dapic, int daxsiz, int daysiz, int daxsiz2, int daysiz2, boolean clamping) {
        int dox = daxsiz2 - 1;
        int doy = daysiz2 - 1;
        if (clamping) {
            dox = Math.min(dox, daxsiz);
            doy = Math.min(doy, daysiz);
        } else {
            daxsiz = daxsiz2;
            daysiz = daysiz2;
        }
        --daxsiz;
        --daysiz;
        int y = doy;
        while (y >= 0) {
            int wpptr = y * daxsiz2 + dox;
            int x = dox;
            while (x >= 0) {
                block15: {
                    int wp = wpptr << 2;
                    if (dapic.get(wp + 3) == 0) {
                        int rgb;
                        int j = 0;
                        int b = 0;
                        int g = 0;
                        int r = 0;
                        int index = wp - 4;
                        if (x > 0 && dapic.get(index + 3) != 0) {
                            r += dapic.get(index + 0) & 0xFF;
                            g += dapic.get(index + 1) & 0xFF;
                            b += dapic.get(index + 2) & 0xFF;
                            ++j;
                        }
                        index = wp + 4;
                        if (x < daxsiz && dapic.get(index + 3) != 0) {
                            r += dapic.get(index + 0) & 0xFF;
                            g += dapic.get(index + 1) & 0xFF;
                            b += dapic.get(index + 2) & 0xFF;
                            ++j;
                        }
                        index = wp - (daxsiz2 << 2);
                        if (y > 0 && dapic.get(index + 3) != 0) {
                            r += dapic.get(index + 0) & 0xFF;
                            g += dapic.get(index + 1) & 0xFF;
                            b += dapic.get(index + 2) & 0xFF;
                            ++j;
                        }
                        index = wp + (daxsiz2 << 2);
                        if (y < daysiz && dapic.get(index + 3) != 0) {
                            r += dapic.get(index + 0) & 0xFF;
                            g += dapic.get(index + 1) & 0xFF;
                            b += dapic.get(index + 2) & 0xFF;
                            ++j;
                        }
                        switch (j) {
                            case 0: 
                            case 1: {
                                rgb = ((dapic.get(wp + 3) & 0xFF) << 24) + (b << 16) + (g << 8) + (r << 0);
                                break;
                            }
                            case 2: {
                                rgb = ((dapic.get(wp + 3) & 0xFF) << 24) + (b + 1 >> 1 << 16) + (g + 1 >> 1 << 8) + (r + 1 >> 1 << 0);
                                break;
                            }
                            case 3: {
                                rgb = ((dapic.get(wp + 3) & 0xFF) << 24) + (b * 85 + 128 >> 8 << 16) + (g * 85 + 128 >> 8 << 8) + (r * 85 + 128 >> 8 << 0);
                                break;
                            }
                            case 4: {
                                rgb = ((dapic.get(wp + 3) & 0xFF) << 24) + (b + 2 >> 2 << 16) + (g + 2 >> 2 << 8) + (r + 2 >> 2 << 0);
                                break;
                            }
                            default: {
                                break block15;
                            }
                        }
                        dapic.putInt(wp, rgb);
                    }
                }
                --x;
                --wpptr;
            }
            --y;
        }
    }

    @Override
    public boolean hasAlpha() {
        return this.hasalpha;
    }

    @Override
    public boolean isClamped() {
        return this.clamped;
    }

    @Override
    public boolean isHighTile() {
        return false;
    }
}

