/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Types;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Render.Types.TextureBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class FastTextureBuffer
implements TextureBuffer {
    protected ByteBuffer bb;
    protected Unsafe unsafe;
    protected long BYTE_ARRAY_BASE_OFFSET;
    protected long address;
    protected int position;

    public FastTextureBuffer(int size) throws Exception {
        this.bb = ByteBuffer.allocateDirect(size).order(ByteOrder.LITTLE_ENDIAN);
        this.init();
    }

    protected void init() throws Exception {
        Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafe.setAccessible(true);
        this.unsafe = (Unsafe)theUnsafe.get(null);
        this.BYTE_ARRAY_BASE_OFFSET = this.unsafe.arrayBaseOffset(byte[].class);
        this.address = ((DirectBuffer)((Object)this.bb)).address();
        this.position = 0;
    }

    @Override
    public byte get(int i) {
        return this.unsafe.getByte(null, this.getAddress(i));
    }

    @Override
    public int getInt(int i) {
        return this.unsafe.getInt(null, this.getAddress(i));
    }

    @Override
    public void putBytes(byte[] src, int srcPos, int length) {
        this.unsafe.copyMemory(src, this.BYTE_ARRAY_BASE_OFFSET + (long)srcPos, null, this.getAddress(this.nextIndex(length)), length);
    }

    @Override
    public void put(int offset, byte value) {
        this.unsafe.putByte(null, this.getAddress(offset), value);
    }

    @Override
    public void putInt(int offset, int value) {
        this.unsafe.putInt(null, this.getAddress(offset), value);
    }

    @Override
    public void fill(int offset, int length, byte value) {
        this.unsafe.setMemory(this.getAddress(offset), length, value);
    }

    @Override
    public void clear() {
        this.position = 0;
        this.bb.clear();
    }

    @Override
    public ByteBuffer getBuffer() {
        this.position = 0;
        this.bb.rewind();
        return this.bb;
    }

    protected long getAddress(int offset) {
        return this.address + (long)offset;
    }

    protected int nextIndex(int nb) {
        int p = this.position;
        this.position += nb;
        return p;
    }
}

