/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Loader.MDModel;
import ru.m210projects.Build.Loader.Model;
import ru.m210projects.Build.Loader.Voxels.VOXModel;
import ru.m210projects.Build.Loader.Voxels.Voxel;
import ru.m210projects.Build.Render.Types.Hudtyp;
import ru.m210projects.Build.Render.Types.Tile2model;

public class ModelInfo {
    private Tile2model[] cache = new Tile2model[Engine.MAXTILES];
    private Hudtyp[][] hudInfo = new Hudtyp[2][Engine.MAXTILES];
    private Spritesmooth[] spritesmooth = new Spritesmooth[Engine.MAXSPRITES + 256];

    public ModelInfo() {
        int i = 0;
        while (i < this.spritesmooth.length) {
            this.spritesmooth[i] = new Spritesmooth();
            ++i;
        }
    }

    public ModelInfo(ModelInfo src, boolean disposable) {
        int i = 0;
        while (i < this.cache.length) {
            if (src.cache[i] != null) {
                this.cache[i] = src.cache[i].clone(disposable);
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            int j = 0;
            while (j < Engine.MAXTILES) {
                if (src.hudInfo[i] != null && src.hudInfo[i][j] != null) {
                    this.hudInfo[i][j] = src.hudInfo[i][j].clone();
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.spritesmooth.length) {
            this.spritesmooth[i] = new Spritesmooth();
            ++i;
        }
    }

    public Spritesmooth getSmoothParams(int i) {
        return this.spritesmooth[i];
    }

    public Model getModel(int picnum) {
        if (this.cache[picnum] != null) {
            return this.cache[picnum].model;
        }
        return null;
    }

    public Voxel getVoxel(int picnum) {
        if (this.cache[picnum] != null) {
            return this.cache[picnum].voxel;
        }
        return null;
    }

    public VOXModel getVoxModel(int picnum) {
        if (this.cache[picnum] != null && this.cache[picnum].voxel != null) {
            return this.cache[picnum].voxel.model;
        }
        return null;
    }

    public Tile2model getParams(int picnum) {
        if (this.cache[picnum] != null) {
            return this.cache[picnum];
        }
        return null;
    }

    public Hudtyp getHudInfo(int picnum, int flags) {
        if (this.hudInfo[flags >> 2 & 1] != null) {
            return this.hudInfo[flags >> 2 & 1][picnum];
        }
        return null;
    }

    public int addModelInfo(Model md, int picnum, String framename, int skinnum, float smooth) {
        if (picnum >= Engine.MAXTILES) {
            return -2;
        }
        if (framename == null) {
            return -3;
        }
        if (md == null) {
            return -1;
        }
        int i = -3;
        switch (md.mdnum) {
            case 1: {
                i = 0;
                skinnum = 0;
                smooth = 0;
                break;
            }
            case 2: 
            case 3: {
                i = ((MDModel)md).getFrameIndex(framename);
            }
        }
        if (this.cache[picnum] == null) {
            this.cache[picnum] = new Tile2model();
        }
        this.cache[picnum].model = md;
        this.cache[picnum].framenum = i;
        this.cache[picnum].skinnum = skinnum;
        this.cache[picnum].smoothduration = smooth;
        return i;
    }

    public int addVoxelInfo(Voxel md, int picnum) {
        if (picnum >= Engine.MAXTILES) {
            return -2;
        }
        if (md == null) {
            return -1;
        }
        if (this.cache[picnum] == null) {
            this.cache[picnum] = new Tile2model();
        }
        this.cache[picnum].voxel = md;
        return 0;
    }

    public void removeModelInfo(Model md) {
        int i = Engine.MAXTILES - 1;
        while (i >= 0) {
            if (this.cache[i] != null && (this.cache[i].model == md || this.cache[i].voxel != null && this.cache[i].voxel.model == md)) {
                this.cache[i].model = null;
                this.cache[i].voxel = null;
                this.cache[i] = null;
            }
            --i;
        }
    }

    public int addHudInfo(int tilex, double xadd, double yadd, double zadd, short angadd, int flags, int fov) {
        if (tilex >= Engine.MAXTILES) {
            return -2;
        }
        if (this.hudInfo[flags >> 2 & 1] == null || this.hudInfo[flags >> 2 & 1][tilex] == null) {
            this.hudInfo[flags >> 2 & 1][tilex] = new Hudtyp();
        }
        Hudtyp hud = this.hudInfo[flags >> 2 & 1][tilex];
        hud.xadd = (float)xadd;
        hud.yadd = (float)yadd;
        hud.zadd = (float)zadd;
        hud.angadd = (short)(angadd | 0x800);
        hud.flags = (short)flags;
        hud.fov = (short)fov;
        return 0;
    }

    public void dispose() {
        int i = Engine.MAXTILES - 1;
        while (i >= 0) {
            if (this.cache[i] != null && this.cache[i].disposable) {
                if (this.cache[i].model != null) {
                    this.cache[i].model.free();
                    this.cache[i].model = null;
                }
                if (this.cache[i].voxel != null) {
                    if (this.cache[i].voxel.model != null) {
                        this.cache[i].voxel.model.free();
                    }
                    this.cache[i].voxel = null;
                }
                this.cache[i] = null;
            }
            --i;
        }
    }

    public class AnimationInfo {
        public final String framestart;
        public final String frameend;
        public final int fpssc;
        public final int flags;

        public AnimationInfo(String framestart, String frameend, int fpssc, int flags) {
            this.framestart = framestart;
            this.frameend = frameend;
            this.fpssc = fpssc;
            this.flags = flags;
        }
    }

    public class SkinInfo {
        public final String skinfn;
        public final int palnum;
        public final int skinnum;
        public final int surfnum;
        public final double param;
        public final double specpower;
        public final double specfactor;

        public SkinInfo(String skinfn, int palnum, int skinnum, int surfnum, double param, double specpower, double specfactor) {
            this.skinfn = skinfn;
            this.palnum = palnum;
            this.skinnum = skinnum;
            this.surfnum = surfnum;
            this.param = param;
            this.specpower = specpower;
            this.specfactor = specfactor;
        }
    }

    public static class Spritesmooth {
        public float smoothduration;
        public short mdcurframe;
        public short mdoldframe;
        public short mdsmooth;
    }
}

