/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Settings;

import com.badlogic.gdx.graphics.Texture;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.OSDCOMMAND;
import ru.m210projects.Build.OnSceenDisplay.OSDCVARFUNC;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Types.BuildVariable;

public class GLSettings
extends BuildSettings {
    public static GLFilter[] glfiltermodes = new GLFilter[]{new GLFilter("None", Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest), new GLFilter("Bilinear", Texture.TextureFilter.Linear, Texture.TextureFilter.Linear), new GLFilter("Trilinear", Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear)};
    public static BuildVariable<GLFilter> textureFilter;
    public static BuildVariable<Integer> textureAnisotropy;
    public static BuildVariable<Boolean> useHighTile;
    public static BuildVariable<Boolean> useModels;
    public static BuildVariable<Boolean> usePaletteShader;
    public static BuildVariable<Integer> gamma;
    public static BuildVariable<Boolean> animSmoothing;

    public static void init(final Engine engine, final BuildConfig cfg) {
        textureFilter = new BuildVariable<GLFilter>(cfg.glfilter < glfiltermodes.length ? glfiltermodes[cfg.glfilter] : glfiltermodes[0], "Changes the texture filtering settings"){

            @Override
            public void execute(GLFilter value) {
                BuildGdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GLRenderer gl = engine.glrender();
                        if (gl != null) {
                            gl.gltexapplyprops();
                        }
                    }
                });
                int i = 0;
                while (i < glfiltermodes.length) {
                    if (value.equals(glfiltermodes[i])) {
                        cfg.glfilter = i;
                        break;
                    }
                    ++i;
                }
            }

            @Override
            public GLFilter check(Object value) {
                if (value instanceof GLFilter) {
                    return (GLFilter)value;
                }
                return null;
            }
        };
        textureAnisotropy = new BuildVariable<Integer>(Integer.valueOf(1), "Changes the texture anisotropy settings"){

            @Override
            public void execute(final Integer value) {
                BuildGdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GLRenderer gl = engine.glrender();
                        if (gl != null) {
                            gl.gltexapplyprops();
                        }
                        cfg.glanisotropy = value;
                    }
                });
            }

            @Override
            public Integer check(Object value) {
                if (value instanceof Integer) {
                    Integer anisotropy = (Integer)value;
                    if ((double)GLInfo.maxanisotropy > 1.0 && (anisotropy <= 0 || (float)anisotropy.intValue() > GLInfo.maxanisotropy)) {
                        anisotropy = (int)GLInfo.maxanisotropy;
                    }
                    return Engine.pow2long[this.checkAnisotropy(anisotropy)];
                }
                return null;
            }

            int checkAnisotropy(int anisotropy) {
                int anisotropysize = 0;
                int s = anisotropy;
                while (s > 1) {
                    ++anisotropysize;
                    s >>= 1;
                }
                return anisotropysize;
            }
        };
        textureAnisotropy.set(cfg.glanisotropy);
        OSDCOMMAND R_texture = new OSDCOMMAND("r_texturemode", "r_texturemode: " + textureFilter.getDescription(), new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("Current texturing mode is " + GLSettings.textureFilter.get().name);
                    return;
                }
                try {
                    int value = Integer.parseInt(Console.osd_argv[1]);
                    if (textureFilter.set(glfiltermodes[value]) == BuildVariable.RespondType.Success) {
                        Console.Println("Texture filtering mode changed to " + GLSettings.textureFilter.get().name);
                    } else {
                        Console.Println("Texture filtering mode out of range");
                    }
                }
                catch (Exception e) {
                    Console.Println("r_texturemode: Out of range");
                }
            }
        });
        R_texture.setRange(0, 2);
        Console.RegisterCvar(R_texture);
        Console.RegisterCvar(new OSDCOMMAND("r_detailmapping", "r_detailmapping: use detail textures", 1.0f, 0, 1));
        Console.RegisterCvar(new OSDCOMMAND("r_glowmapping", "r_glowmapping: use glow textures", 1.0f, 0, 1));
        useHighTile = new BuildSettings.BooleanVar(true, "Use true color textures from high resolution pack"){

            @Override
            public void execute(Boolean value) {
                BuildGdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GLRenderer gl = engine.glrender();
                        if (gl != null) {
                            gl.gltexinvalidateall(GLRenderer.GLInvalidateFlag.All, GLRenderer.GLInvalidateFlag.Uninit);
                        }
                    }
                });
            }
        };
        useModels = new BuildSettings.BooleanVar(true, "Use md2 / md3 models from high resolution pack");
        usePaletteShader = new BuildSettings.BooleanVar(true, "Use palette emulation"){

            @Override
            public void execute(Boolean value) {
                GLRenderer gl = engine.glrender();
                if (gl != null) {
                    gl.enableShader(value);
                }
                cfg.paletteEmulation = value;
            }
        };
        usePaletteShader.set(cfg.paletteEmulation);
        OSDCOMMAND r_paletteshader = new OSDCOMMAND("r_paletteshader", "r_paletteshader: " + usePaletteShader.get(), new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("r_paletteshader: " + usePaletteShader.get());
                    return;
                }
                try {
                    final int value = Integer.parseInt(Console.osd_argv[1]);
                    BuildGdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            usePaletteShader.set(value == 1);
                            Console.Println("r_paletteshader changed to " + usePaletteShader.get());
                        }
                    });
                }
                catch (Exception e) {
                    Console.Println("r_paletteshader: out of range");
                }
            }
        });
        r_paletteshader.setRange(0, 1);
        Console.RegisterCvar(r_paletteshader);
        animSmoothing = new BuildSettings.BooleanVar(true, "Use  model animation smoothing");
        gamma = new BuildVariable<Integer>(Integer.valueOf((int)((1.0f - cfg.fgamma) * 4096.0f)), "Global gamma"){

            @Override
            protected void execute(Integer value) {
                cfg.fgamma = 1.0f - (float)value.intValue() / 4096.0f;
            }

            @Override
            protected Integer check(Object value) {
                if (value instanceof Integer) {
                    float gamma = (float)((Integer)value).intValue() / 4096.0f;
                    if (engine.glrender() == null || ((Boolean)BuildGdx.graphics.extra(BuildGraphics.Option.GLSetConfiguration, Float.valueOf(1.0f - gamma), Float.valueOf(0.0f), Float.valueOf(1.0f))).booleanValue()) {
                        return (Integer)value;
                    }
                }
                return null;
            }
        };
    }
}

