/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.Types.TextureBuffer;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.TileFont;

public class TextFont
extends TileFont {
    public TextFont() {
        super(TileFont.FontType.Bitmap, Engine.textfont, 8, 8, 16, 16);
        this.sizx = 128;
        this.sizy = 128;
    }

    @Override
    public GLTile getGL(TextureManager textureCache, int col) {
        if (this.atlas == null) {
            this.init();
        }
        return this.atlas;
    }

    private GLTile init() {
        TileFont.TileFontData dat = new TileFont.TileFontData(this.sizx, this.sizy){

            @Override
            public TextureBuffer buildAtlas(TextureBuffer data) {
                int h = 0;
                while (h < 256) {
                    int tptr = h % 16 * 8 + h / 16 * TextFont.this.sizx * 8;
                    int i = 0;
                    while (i < 8) {
                        int j = 0;
                        while (j < 8) {
                            data.put(tptr + j, (Engine.textfont[h * 8 + i] & Engine.pow2char[7 - j]) != 0 ? (byte)-1 : 0);
                            ++j;
                        }
                        tptr += TextFont.this.sizx;
                        ++i;
                    }
                    ++h;
                }
                return data;
            }

            @Override
            public int getGLInternalFormat() {
                return 6406;
            }

            @Override
            public int getGLFormat() {
                return 6406;
            }
        };
        this.atlas = new GLTile(dat, 0, false){

            @Override
            public void delete() {
                super.delete();
                TextFont.this.atlas = null;
            }
        };
        this.atlas.setupTextureFilter(GLSettings.glfiltermodes[0], 1);
        return this.atlas;
    }
}

